/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.menus.TGOpenWithMenu;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.approvedlist.Approved;
import info.textgrid.lab.workflow.approvedlist.Service;
import info.textgrid.lab.workflow.views.ChainView;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import javax.xml.bind.JAXB;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ListOfServices
extends ViewPart {
    private TextGridObjectTableViewer allViewer;
    private TableViewer approvedViewer;
    public final String APPROVED_LIST_KEY = "ApprovedServicesTextGridURI";
    private List<Service> approvedServices;
    private TabFolder folder;
    private TabItem approvedTab;

    public void createPartControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        c.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        c.setLayout((Layout)glp);
        this.folder = new TabFolder(c, 128);
        GridData gf = new GridData(4, 4, true, true);
        this.folder.setLayoutData((Object)gf);
        GridLayout glf = new GridLayout(1, false);
        this.folder.setLayout((Layout)glf);
        Composite approvedComposite = new Composite((Composite)this.folder, 0);
        GridData gdstd = new GridData(4, 4, true, true);
        approvedComposite.setLayoutData((Object)gdstd);
        GridLayout glstd = new GridLayout(1, false);
        approvedComposite.setLayout((Layout)glstd);
        this.approvedTab = new TabItem(this.folder, 0);
        this.approvedTab.setText("Approved Services");
        this.approvedTab.setControl((Control)approvedComposite);
        Composite allServicesComposite = new Composite((Composite)this.folder, 0);
        GridData gdexp = new GridData(4, 4, true, true);
        allServicesComposite.setLayoutData((Object)gdexp);
        GridLayout glexp = new GridLayout(1, false);
        allServicesComposite.setLayout((Layout)glexp);
        TabItem expi = new TabItem(this.folder, 0);
        expi.setText("All Services");
        expi.setControl((Control)allServicesComposite);
        this.approvedViewer = new TableViewer(approvedComposite, 66308);
        this.approvedViewer.getTable().setHeaderVisible(false);
        this.approvedViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.approvedViewer.setLabelProvider((IBaseLabelProvider)new ApprovedServicesLabelProvider());
        GridData gd0 = new GridData(4, 4, true, true);
        this.approvedViewer.getControl().setLayoutData((Object)gd0);
        this.approvedViewer.setSorter((ViewerSorter)new NameSorter());
        boolean foundApproved = this.fillApprovedViewer();
        if (foundApproved) {
            this.getSite().setSelectionProvider((ISelectionProvider)this.approvedViewer);
            this.hookContextMenu(this.approvedViewer);
        } else {
            approvedComposite.dispose();
            this.approvedTab.dispose();
        }
        this.allViewer = new TextGridObjectTableViewer(allServicesComposite, 66308);
        this.allViewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE));
        this.allViewer.getTable().setHeaderVisible(false);
        GridData gd1 = new GridData(4, 4, true, true);
        this.allViewer.getControl().setLayoutData((Object)gd1);
        this.allViewer.setSorter((ViewerSorter)new NameSorter());
        this.refreshViewer();
        this.getSite().setSelectionProvider((ISelectionProvider)this.allViewer);
        this.hookContextMenu((TableViewer)this.allViewer);
        Composite aboveBottomBar = new Composite(c, 4);
        aboveBottomBar.setLayout((Layout)new GridLayout(2, false));
        GridData gd2 = new GridData(4, 2, true, false);
        aboveBottomBar.setLayoutData((Object)gd2);
        GridData gd3b = new GridData(16384, 0x1000000, true, false);
        gd3b.widthHint = 2000;
        Composite bottomBar = new Composite(c, 4);
        bottomBar.setLayout((Layout)new GridLayout(2, false));
        GridData gd4 = new GridData(4, 2, true, false);
        bottomBar.setLayoutData((Object)gd4);
        Button addToChainButton = new Button(bottomBar, 8);
        addToChainButton.setText("Add to workflow");
        addToChainButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListOfServices.this.addToChain();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private boolean fillApprovedViewer() {
        String approvedURIstring;
        block6: {
            ConfClient confClient = ConfClient.getInstance();
            approvedURIstring = confClient.getValue("ApprovedServicesTextGridURI");
            if (approvedURIstring != null && !approvedURIstring.equals("")) break block6;
            Activator.handleProblem(2, new Throwable(), "Workflow: Could not find TextGridObject holding the approved services list!", new Object[0]);
            return false;
        }
        try {
            URI approvedURI = new URI(approvedURIstring);
            TextGridObject listtgo = TextGridObject.getInstance((URI)approvedURI, (boolean)false);
            IFile sf = (IFile)listtgo.getAdapter(IFile.class);
            Approved approvedlist = (Approved)JAXB.unmarshal((InputStream)sf.getContents(true), Approved.class);
            this.approvedServices = approvedlist.getService();
        }
        catch (CrudServiceException e) {
            e.printStackTrace();
            return false;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            Activator.handleProblem(4, e, "Can't ascertain TG-URI.", e);
            return false;
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"Workflow: Could not contact Confserver for Approved Services List location!", (Throwable)e);
            return false;
        }
        this.approvedViewer.setInput(this.approvedServices);
        return true;
    }

    private void refreshViewer() {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setAllProjects(true);
        searchRequest.setQueryMetadata("format:\"text/tg.servicedescription+xml\"");
        this.allViewer.setInput((Object)searchRequest);
    }

    private void addToChain() {
        IStructuredSelection wfss;
        TabItem[] tiarr = this.folder.getSelection();
        System.out.println("Adding one service from the " + tiarr[0].getText() + " tab's list to the workflow");
        TextGridObject serviceTGO = null;
        if (tiarr[0].equals(this.approvedTab)) {
            wfss = (IStructuredSelection)this.approvedViewer.getSelection();
            Service selService = (Service)wfss.getFirstElement();
            if (selService == null) {
                return;
            }
            try {
                serviceTGO = TextGridObject.getInstance((URI)URI.create(selService.getUri()), (boolean)false);
            }
            catch (CrudServiceException e) {
                e.printStackTrace();
            }
        } else {
            wfss = (IStructuredSelection)this.allViewer.getSelection();
            serviceTGO = (TextGridObject)wfss.getFirstElement();
            if (serviceTGO == null) {
                return;
            }
        }
        IViewPart chainView = null;
        try {
            chainView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("info.textgrid.lab.workflow.views.ChainView");
        }
        catch (PartInitException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "View with workflow is not existent", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        if (chainView != null && chainView instanceof ChainView) {
            ChainView cvInstance = (ChainView)chainView;
            cvInstance.addService(serviceTGO);
        }
    }

    private void hookContextMenu(final TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ListOfServices.this.fillContextMenu(manager, viewer);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, TableViewer viewer) {
        MenuManager openWithSubMenu = new MenuManager("Open with...");
        Object firstElement = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (firstElement == null) {
            return;
        }
        IFile iFile = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        openWithSubMenu.add((IContributionItem)new TGOpenWithMenu(this.getSite().getPage(), (IAdaptable)iFile));
        manager.add((IContributionItem)openWithSubMenu);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void hookDoubleClickAction(TableViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.allViewer.getControl().getShell(), (String)"Service List", (String)message);
    }

    public void setFocus() {
        this.allViewer.getControl().setFocus();
    }

    public void dispose() {
    }

    class ApprovedServicesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ApprovedServicesLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (!(obj instanceof Service)) {
                return "unknown class: " + obj.getClass();
            }
            Service s = (Service)obj;
            if (index == 0) {
                return s.getName();
            }
            return "extra column " + index;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

