/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.Messages;
import info.textgrid.lab.core.aggregations.ui.ShowAggregationCompositionPerspectiveHandler;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.menus.OpenObjectService;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditAggregationHandler
extends AbstractHandler {
    private static final String PARAMETER_URI_ID = "info.textgrid.lab.core.aggregations.ui.EditAggregation.parameter.uri";
    private static final String PARAMETER_READONLY_ID = "info.textgrid.lab.core.aggregations.ui.EditAggregation.parameter.readonly";
    final String AGGREGATION = "aggregation";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String parameterURI = null;
        String parameterReadOnly = null;
        TextGridObject tgo = null;
        parameterURI = event.getParameter(PARAMETER_URI_ID);
        parameterReadOnly = event.getParameter(PARAMETER_READONLY_ID);
        if (parameterURI != null) {
            try {
                tgo = TextGridObject.getInstance((URI)new URI(parameterURI), (boolean)false);
            }
            catch (CrudServiceException e) {
                AggregationsUIPlugin.handleError(e, e.getMessage(), parameterURI);
            }
            catch (URISyntaxException e) {
                AggregationsUIPlugin.handleError(e, e.getMessage(), parameterURI);
            }
        } else {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection instanceof IStructuredSelection) {
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                tgo = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
            }
        }
        if (tgo != null) {
            try {
                if (tgo.getContentTypeID().contains("aggregation")) {
                    ShowAggregationCompositionPerspectiveHandler PerspectiveHandler = new ShowAggregationCompositionPerspectiveHandler();
                    PerspectiveHandler.execute(event);
                    OpenObjectService.getInstance().openObject(tgo, 2, Boolean.parseBoolean(parameterReadOnly));
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "info.textgrid.lab.core.aggregations.ui", String.valueOf(Messages.EditAggregationHandler_EM_CouldNotRetrieveContentType) + tgo.toString(), (Throwable)e);
                AggregationsUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }
}

