/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import com.google.common.collect.Iterators;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.ProjectFileException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.AppData;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.bind.JAXB;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class TextGridProjectFile {
    public static final String PROJECT_FILE_TYPE = "text/tg.projectfile+xml";
    private TextGridProject project;
    private TextGridObject projectFileObject;
    private TgProjectFile projectFileData;
    private boolean isNewObject = false;
    public static final String projectFileNS = "http://textgrid.info/namespaces/metadata/projectfile/2008-11-27";
    public static final QName TG_PROJECT_FILE_QNAME = new QName("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "tgProjectFile");
    public static final QName appData = new QName("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "appData");
    public static final QName metadataSectionQName = new QName("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "metadataSection", "ns1");
    public static String basicMetadataSectionNS = "http://textgrid.info/namespaces/metadata/basicMetadata/config/2011-08-10";
    public static final QName basicMetadataSectionQName = new QName("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "basicMetadataSection", "ns1");
    private static OMFactory omFactory = OMAbstractFactory.getOMFactory();
    public static final OMAttribute descriptionChanged = omFactory.createOMAttribute("changed", omFactory.createOMNamespace("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "ns1"), "true");
    public static final QName descriptionChangedQName = new QName("http://textgrid.info/namespaces/metadata/projectfile/2008-11-27", "changed", "ns1");

    public TextGridProjectFile(TextGridProject project) {
        this.project = project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextGridObject getProjectFileObject(boolean create, IProgressMonitor monitor) throws ProjectFileException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Finding project file for {0}", (Object)this), (int)100);
        String pfUri = this.project.getProjectfile();
        if (pfUri == null || pfUri.equals("")) {
            if (!create) return null;
            pfUri = this.createNewProjectFile((IProgressMonitor)progress.newChild(50)).getURI().toString();
            this.isNewObject = true;
        } else {
            this.isNewObject = false;
        }
        try {
            try {
                return TextGridObject.getInstance(new URI(pfUri), true);
            }
            catch (CrudServiceException e) {
                Activator.handleProblem(2, (Throwable)((Object)e), "Warning: returning an offline Projectfile", new Object[0]);
                return TextGridObject.getInstanceOffline(new URI(pfUri));
            }
        }
        catch (URISyntaxException e) {
            throw new ProjectFileException(ProjectFileException.Operation.READING, this.project, e);
        }
    }

    protected TextGridObject createNewProjectFile(IProgressMonitor monitor) throws ProjectFileException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Initializing new project file for {0}", (Object)this), (int)100);
        this.projectFileObject = this.createNewProjectFileObject();
        progress.worked(10);
        TgProjectFile t = this.createProjectFileSkeleton();
        this.saveProjectFile(t, this.projectFileObject, (IProgressMonitor)progress);
        try {
            if (!this.project.setProjectfile(this.projectFileObject.getURI().toString())) {
                throw new RuntimeException("Couldn't set the ProjectFile!");
            }
            System.err.println("Set ProjectFile with PFUri");
        }
        catch (OfflineException e) {
            Activator.handleError(e, "Error TextGridProjectFile.createNewProjectFile()", new Object[0]);
        }
        catch (RemoteException e) {
            Activator.handleError(e, "Error TextGridProjectFile.createNewProjectFile()", new Object[0]);
        }
        catch (AuthenticationFault e) {
            Activator.handleError(e, "Error TextGridProjectFile.createNewProjectFile()", new Object[0]);
        }
        catch (RuntimeException e) {
            Activator.handleError(e, "Error TextGridProjectFile.createNewProjectFile()", new Object[0]);
        }
        return this.projectFileObject;
    }

    protected TextGridObject createNewProjectFileObject() {
        TextGridObject object = TextGridObject.getNewObjectInstance(this.project, TGContentType.getContentType(PROJECT_FILE_TYPE), this.project.getProjectInfo().getName());
        PersonType rightsHolder = RBACSession.getInstance().getPerson();
        object.setItemMetadata(rightsHolder);
        return object;
    }

    protected void saveProjectFile(TgProjectFile projectFile, TextGridObject object, IProgressMonitor monitor) throws ProjectFileException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Saving project file for {0}", (Object)this.project), (int)90);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JAXB.marshal((Object)projectFile, (OutputStream)baos);
            progress.worked(5);
            IFile file = (IFile)object.getAdapter(IFile.class);
            if (file == null) {
                throw new ProjectFileException(ProjectFileException.Operation.SAVING, this.project, null, "Could not convert the TextGridObject for the project file, {0}, to a file. If no previous error message explains this strange incident, please file a bug report.", object);
            }
            file.setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), 1, (IProgressMonitor)progress.newChild(85));
        }
        catch (CoreException e) {
            throw new ProjectFileException(ProjectFileException.Operation.SAVING, this.project, e);
        }
    }

    protected TgProjectFile createProjectFileSkeleton() {
        TgProjectFile projectFile = new TgProjectFile();
        projectFile.setDescription(this.project.getProjectInfo().getDescription());
        return projectFile;
    }

    public boolean setProjectFile(URI uri) {
        block7: {
            TextGridObject object = null;
            object = TextGridObject.getInstance(uri, true);
            try {
                if (object == null || !object.getContentTypeID().equals(PROJECT_FILE_TYPE)) break block7;
                this.projectFileObject = object;
                try {
                    IFile file = (IFile)this.projectFileObject.getAdapter(IFile.class);
                    InputStream inputStream = file.getContents(true);
                    this.projectFileData = (TgProjectFile)JAXB.unmarshal((InputStream)inputStream, TgProjectFile.class);
                }
                catch (Exception e) {
                    throw new ProjectFileException(ProjectFileException.Operation.READING, this.project, e);
                }
                return true;
            }
            catch (CoreException e) {
                try {
                    Activator.handleError(e, "Error TextGridProjectFile.setProjectFile()", new Object[0]);
                }
                catch (CrudServiceException e2) {
                    Activator.handleError((Throwable)((Object)e2), "Error TextGridProjectFile.setProjectFile()", new Object[0]);
                }
            }
        }
        return false;
    }

    public boolean setProjectFile(TextGridObject object) {
        return this.setProjectFile(object.getURI());
    }

    public TgProjectFile getProjectFileData(boolean create, boolean reload, IProgressMonitor monitor) throws ProjectFileException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Loading project file for {0}", (Object)this), (int)100);
        if (this.projectFileObject == null || reload) {
            this.projectFileObject = this.getProjectFileObject(create, (IProgressMonitor)progress.newChild(50));
        } else {
            progress.worked(50);
        }
        if (this.projectFileObject != null && !this.isNewObject) {
            IFile file = null;
            try {
                file = (IFile)this.projectFileObject.getAdapter(IFile.class);
                this.projectFileData = (TgProjectFile)JAXB.unmarshal((InputStream)file.getContents(), TgProjectFile.class);
            }
            catch (Exception e) {
                if (create) {
                    throw new ProjectFileException(ProjectFileException.Operation.CREATING, this.project, e);
                }
                throw new ProjectFileException(ProjectFileException.Operation.READING, this.project, e);
            }
        } else {
            this.projectFileData = this.createProjectFileSkeleton();
        }
        return this.projectFileData;
    }

    public TextGridObject saveProjectFileData(TgProjectFile data, IProgressMonitor monitor) throws ProjectFileException, CrudServiceException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Saving project file for {0}", (Object)this.project), (int)100);
        TextGridObject object = this.getProjectFileObject(false, (IProgressMonitor)progress.newChild(30));
        boolean needsSet = false;
        if (object == null) {
            object = this.createNewProjectFileObject();
            needsSet = true;
        } else {
            object.reloadMetadata(true);
        }
        this.saveProjectFile(data, object, (IProgressMonitor)progress.newChild(60));
        if (needsSet) {
            this.setProjectFile(object);
        }
        progress.worked(10);
        return object;
    }

    public static String getTypeFromFormat(String format) {
        String objectType = "";
        if (format != null && !"".equals(format)) {
            objectType = format.toLowerCase().contains("tg.work+") ? "work" : (format.toLowerCase().contains("tg.edition+") ? "edition" : (format.toLowerCase().contains("tg.collection+") ? "collection" : "item"));
        }
        return objectType;
    }

    public static void setBasicMetadataToNewObject(String project, String type, TextGridObject newObj) {
        try {
            OMElement type_elem;
            TextGridProjectFile projectFile = new TextGridProjectFile(TextGridProject.getProjectInstance(project));
            TgProjectFile projectFileData = projectFile.getProjectFileData(false, true, null);
            OMElement[] appDataChildren = null;
            appDataChildren = TextGridProjectFile.extractAppDataChildren(projectFileData);
            OMElement basicMetadataSection = null;
            if (appDataChildren != null && appDataChildren.length > 0) {
                OMElement[] oMElementArray = appDataChildren;
                int n = appDataChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    OMElement child = oMElementArray[n2];
                    if (child.getQName().equals(basicMetadataSectionQName)) {
                        basicMetadataSection = child;
                        break;
                    }
                    ++n2;
                }
            }
            if (basicMetadataSection != null && (type_elem = basicMetadataSection.getFirstChildWithName(new QName(basicMetadataSectionNS, type))) != null) {
                OMElement basicMetadata = type_elem.getFirstElement();
                TGContentType contentType = newObj.getContentType();
                newObj.setMetadataXML(basicMetadata);
                newObj.setContentType(contentType);
            }
        }
        catch (RemoteException e1) {
            Activator.handleError(e1, "error...", new Object[0]);
        }
        catch (CrudServiceException e1) {
            Activator.handleError((Throwable)((Object)e1), "error...", new Object[0]);
        }
        catch (ProjectDoesNotExistException e1) {
            Activator.handleError(e1, "error...", new Object[0]);
        }
        catch (ProjectFileException e) {
            Activator.handleError((Throwable)((Object)e), "error...", new Object[0]);
        }
        catch (CoreException e) {
            Activator.handleError(e, "error...", new Object[0]);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e, "Error parsing project file: {0}", e.getMessage());
        }
    }

    public static OMElement extractAppDataXML(TgProjectFile projectFile) {
        if (projectFile == null) {
            return null;
        }
        AppData appData = projectFile.getAppData();
        if (appData != null) {
            StringWriter writer = new StringWriter();
            JAXB.marshal((Object)appData, (Writer)writer);
            try {
                OMElement omElement = StringToOM.getOMElement(writer.toString());
                return omElement;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Project file with strange encoding encountered", e);
            }
            catch (XMLStreamException e) {
                throw new IllegalArgumentException("Invalid project file contents", e);
            }
            catch (FactoryConfigurationError e) {
                throw new IllegalStateException("Couldn't configure OM factory!?", e);
            }
        }
        return null;
    }

    public static OMElement[] extractAppDataChildren(TgProjectFile projectFile) {
        OMElement element = TextGridProjectFile.extractAppDataXML(projectFile);
        if (element == null) {
            return null;
        }
        return (OMElement[])Iterators.toArray((Iterator)element.getChildElements(), OMElement.class);
    }
}

