/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.menus;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.locking.LockingService;
import info.textgrid.lab.ui.core.menus.OpenObjectService;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IEvaluationService;

public class TGOpenWithDynamicMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable file;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable<ImageDescriptor, Image> imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            String s1 = ((IEditorDescriptor)arg0).getLabel();
            String s2 = ((IEditorDescriptor)arg1).getLabel();
            return this.collator.compare(s1, s2);
        }
    };

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getFileResource().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getFileResource().getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        TGOpenWithDynamicMenu.this.openEditor(descriptor, false);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private void createOtherMenuItem(final Menu menu) {
        final IFile fileResource = this.getFileResource();
        if (fileResource == null) {
            return;
        }
        new MenuItem(menu, 2);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(IDEWorkbenchMessages.OpenWithMenu_Other);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        IEditorDescriptor editor;
                        EditorSelectionDialog dialog = new EditorSelectionDialog(menu.getShell());
                        dialog.setMessage(NLS.bind((String)IDEWorkbenchMessages.OpenWithMenu_OtherDialogDescription, (Object)fileResource.getName()));
                        if (dialog.open() != 0 || (editor = dialog.getSelectedEditor()) == null) break;
                        TGOpenWithDynamicMenu.this.openEditor(editor, editor.isOpenExternal());
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    public void fill(Menu menu, int index) {
        this.page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEvaluationService evalService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        Object firstElement = ((IStructuredSelection)evalService.getCurrentState().getVariable("activeMenuSelection")).getFirstElement();
        this.file = (IFile)((IAdaptable)firstElement).getAdapter(IFile.class);
        IFile file = this.getFileResource();
        if (file == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = IDE.getDefaultEditor((IFile)file, (boolean)false);
        IEditorDescriptor[] editors = this.registry.getEditors(file.getName());
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        IEditorDescriptor descriptor = this.registry.findEditor("org.eclipse.ui.systemExternalEditor");
        this.createMenuItem(menu, descriptor, preferredEditor);
        descriptor = this.registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
        if (descriptor != null) {
            this.createMenuItem(menu, descriptor, preferredEditor);
        }
        this.createDefaultMenuItem(menu, file);
        this.createOtherMenuItem(menu);
    }

    private IFile getFileResource() {
        if (this.file == null) {
            return null;
        }
        if (this.file instanceof IFile) {
            return (IFile)this.file;
        }
        IResource resource = (IResource)this.file.getAdapter(IResource.class);
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor, boolean openUsingDescriptor) {
        IFile file = this.getFileResource();
        if (file == null) {
            return;
        }
        if (openUsingDescriptor) {
            TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)file, TextGridObject.class);
            OpenObjectService.getInstance().openObject(tgo, 0, false);
        } else {
            String editorId = editor == null ? "org.eclipse.ui.systemExternalEditor" : editor.getId();
            TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)file, TextGridObject.class);
            if (editorId.equals("org.eclipse.ui.DefaultTextEditor") || editorId.equals("org.eclipse.ui.systemExternalEditor")) {
                LockingService lockingService;
                if (editorId.equals("org.eclipse.ui.DefaultTextEditor") && !(lockingService = LockingService.getInstance()).lockObject(tgo, true)) {
                    tgo.setOpenAsReadOnly(true);
                }
                try {
                    ((WorkbenchPage)this.page).openEditor((IEditorInput)new FileEditorInput(file), editorId, true, 3);
                }
                catch (PartInitException e) {
                    DialogUtil.openError((Shell)this.page.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenWithMenu_dialogTitle, (String)e.getMessage(), (PartInitException)e);
                }
                IDE.setDefaultEditor((IFile)file, (String)editorId);
            } else {
                OpenObjectService.getInstance().openObject(tgo, 0, false);
            }
        }
    }

    private void createDefaultMenuItem(Menu menu, final IFile file) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(IDE.getDefaultEditor((IFile)file, (boolean)false) == null);
        menuItem.setText(IDEWorkbenchMessages.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        IDE.setDefaultEditor((IFile)file, null);
                        try {
                            IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
                            TGOpenWithDynamicMenu.this.page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId(), true, 3);
                            break;
                        }
                        catch (PartInitException e) {
                            DialogUtil.openError((Shell)TGOpenWithDynamicMenu.this.page.getWorkbenchWindow().getShell(), (String)IDEWorkbenchMessages.OpenWithMenu_dialogTitle, (String)e.getMessage(), (PartInitException)e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

