/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import com.google.common.base.Joiner;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.TextGridRepositoryItem;
import info.textgrid.lab.ui.core.utils.Activator;
import info.textgrid.lab.ui.core.utils.Messages;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class TGODefaultLabelProvider
extends DecoratingStyledCellLabelProvider
implements ILabelProvider {
    public TGODefaultLabelProvider(boolean usingIcons) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TGOTitleLabelProvider(usingIcons), (ILabelDecorator)PlatformUI.getWorkbench().getDecoratorManager(), null);
    }

    public TGODefaultLabelProvider() {
        this(true);
    }

    public String getToolTipText(Object element) {
        TextGridObject object = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
        if (object != null) {
            try {
                return MessageFormat.format(Messages.TGODefaultLabelProvider_ToolTipText, object.getTitle(), Joiner.on((String)"; ").join((Iterable)object.getAuthors()), object.getProjectInstance().getName(), object.getContentType(false).getDescription(), object.getLastModified().getTime());
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PendingUpdateAdapter) {
            return this.getStyledText(element).toString();
        }
        if (element instanceof TextGridProject) {
            return ((TextGridProject)element).getName();
        }
        if (element instanceof RestrictedTextGridObject) {
            return NLS.bind((String)"{0} ({1})", (Object)"Restricted TextGrid Object", (Object)((RestrictedTextGridObject)element).getURI().toString());
        }
        if (element instanceof TextGridRepositoryItem) {
            return ((TextGridRepositoryItem)element).toString();
        }
        TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
        if (tgo != null) {
            try {
                return tgo.getTitle();
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
            }
        }
        return null;
    }

    protected static class TGOTitleLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler PENDING_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        };
        private final boolean usingIcons;

        public TGOTitleLabelProvider(boolean usingIcons) {
            this.usingIcons = usingIcons;
        }

        public Image getImage(Object element) {
            if (!this.usingIcons) {
                return null;
            }
            if (element instanceof PendingUpdateAdapter) {
                return Activator.getDefault().getImageRegistry().get("loading");
            }
            if (element instanceof RestrictedTextGridObject) {
                return Activator.getDefault().getImageRegistry().get("restricted_object");
            }
            if (element instanceof TextGridRepositoryItem) {
                return Activator.getDefault().getImageRegistry().get("repository");
            }
            try {
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    return textGridObject.getContentType(false).getImage(true);
                }
                TextGridProject project = (TextGridProject)AdapterUtils.getAdapter((Object)element, TextGridProject.class);
                if (project != null) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
            }
            return null;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return new StyledString(Messages.TGODefaultLabelProvider_Pending, PENDING_STYLER);
            }
            try {
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    return new StyledString(textGridObject.getTitle());
                }
                TextGridProject project = (TextGridProject)AdapterUtils.getAdapter((Object)element, TextGridProject.class);
                if (project != null) {
                    return new StyledString(project.getName());
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                return new StyledString(e.getLocalizedMessage(), TextGridObjectTableViewer.ERROR_STYLER);
            }
            IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)AdapterUtils.getAdapter((Object)element, IWorkbenchAdapter.class);
            if (workbenchAdapter != null) {
                return new StyledString(workbenchAdapter.getLabel(element));
            }
            if (element != null) {
                return new StyledString(element.toString());
            }
            return new StyledString();
        }
    }
}

