/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.model;

import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.Messages;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditor;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SectionTreeDropAdapter
extends ViewerDropAdapter {
    TreeViewer viewer;
    AggregationComposerEditor view;

    public SectionTreeDropAdapter(TreeViewer viewer, AggregationComposerEditor view) {
        super((Viewer)viewer);
        this.viewer = viewer;
        this.view = view;
    }

    public boolean performDrop(Object data) {
        Boolean insertFlag = null;
        Object target = this.getCurrentTarget();
        if (target == null) {
            target = this.view.getAggregationRoot();
        }
        if (target instanceof Aggregation) {
            insertFlag = this.insert((Aggregation)target, data, this.getCurrentLocation());
            if (insertFlag.booleanValue()) {
                this.view.setIsChanged(true);
            }
            return insertFlag;
        }
        if (target instanceof TGOentry) {
            int location = this.getCurrentLocation();
            if (location == 3) {
                return false;
            }
            insertFlag = this.insert(target, data, location);
            if (insertFlag.booleanValue()) {
                this.view.setIsChanged(true);
            }
            return insertFlag;
        }
        return false;
    }

    private boolean insert(Object target, Object data, int location) {
        block40: {
            if (target == this.view.getAggregationRoot() && (location == 1 || location == 2)) {
                return false;
            }
            Aggregation moveAggregation = this.dataContainsParent(target, data);
            if (moveAggregation != null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Drag & Drop", (String)(String.valueOf(moveAggregation.getName()) + Messages.SectionTreeDropAdapter_IM_NoMoveInSubAggregation));
                return false;
            }
            if (!(data instanceof IStructuredSelection)) break block40;
            IStructuredSelection selection = (IStructuredSelection)data;
            TGOentry tgoEntry = null;
            this.view.setIsBusy(true);
            for (Object temp : selection) {
                block39: {
                    TGOentry targetEntry;
                    TGOentry entry;
                    block42: {
                        block41: {
                            if (temp instanceof TGOentry) {
                                tgoEntry = (TGOentry)temp;
                                temp = ((TGOentry)temp).isRestrictedTextGridObject() ? ((TGOentry)temp).getRestrictedTgo() : ((TGOentry)temp).getTgo();
                            } else if (temp instanceof TGObjectReference) {
                                temp = AdapterUtils.getAdapter(temp, TextGridObject.class);
                            }
                            if (!(temp instanceof TextGridObject) && !(temp instanceof RestrictedTextGridObject)) break block39;
                            TextGridObject tgo = null;
                            if (temp instanceof TextGridObject) {
                                temp = new TGOentry(((TextGridObject)temp).getURI().toString());
                                tgo = ((TGOentry)temp).getTgo();
                            } else {
                                temp = new TGOentry((RestrictedTextGridObject)temp);
                            }
                            if (!(target instanceof Aggregation)) break block41;
                            Aggregation targetSection = (Aggregation)target;
                            if (targetSection == this.view.getViewerRoot()) {
                                targetSection = this.view.getAggregationRoot();
                            }
                            try {
                                if (tgo.getContentTypeID().contains("aggregation")) {
                                    Aggregation newAggregation = new Aggregation(targetSection, tgo.getTitle(), tgo, this.view.getTargetProject());
                                    this.view.importAggregation(newAggregation, tgo);
                                } else if (temp instanceof TGOentry) {
                                    entry = (TGOentry)temp;
                                    switch (location) {
                                        case 1: {
                                            targetSection.getParent().addBefore(targetSection, entry);
                                            break;
                                        }
                                        case 2: {
                                            targetSection.getParent().addAfter(targetSection, entry);
                                            break;
                                        }
                                        default: {
                                            entry.setParent(targetSection);
                                            targetSection.addChild(entry);
                                            break;
                                        }
                                    }
                                }
                                break block39;
                            }
                            catch (CoreException e) {
                                AggregationsUIPlugin.handleError(e, "SectionTreeDropAdapter Error", new Object[0]);
                            }
                            break block39;
                        }
                        if (!(target instanceof TGOentry)) break block39;
                        targetEntry = (TGOentry)target;
                        if (!(temp instanceof Aggregation)) break block42;
                        Aggregation aggregation = (Aggregation)temp;
                        if (aggregation.equals(targetEntry.getParent()) || targetEntry.getParent().hasParent(aggregation)) {
                            return false;
                        }
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, aggregation);
                                break block39;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, aggregation);
                                break block39;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (temp instanceof TGOentry) {
                        entry = (TGOentry)temp;
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, entry);
                                break;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, entry);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                if (temp instanceof Aggregation) {
                    if (target instanceof Aggregation) {
                        if (location == 1) {
                            ((Aggregation)temp).setParent(((Aggregation)target).getParent());
                            ((Aggregation)target).getParent().addBefore(target, (Aggregation)temp);
                        } else if (location == 2) {
                            ((Aggregation)temp).setParent((Aggregation)target);
                            ((Aggregation)target).addChild((Aggregation)temp);
                        }
                    } else if (target instanceof TGOentry) {
                        TGOentry targetEntry = (TGOentry)target;
                        switch (location) {
                            case 1: {
                                targetEntry.getParent().addBefore(targetEntry, temp);
                                break;
                            }
                            case 2: {
                                targetEntry.getParent().addAfter(targetEntry, temp);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                }
                if (tgoEntry == null) continue;
                tgoEntry.delete();
                tgoEntry = null;
            }
            this.view.getViewer().refresh();
            this.view.setIsBusy(false);
            return true;
        }
        return false;
    }

    public boolean validateDrop(Object target, int op, TransferData type) {
        boolean drop = LocalSelectionTransfer.getTransfer().isSupportedType(type);
        return drop;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        event.feedback = 24;
        if (this.getCurrentLocation() == 1) {
            event.feedback |= 2;
        } else if (this.getCurrentLocation() == 2) {
            event.feedback |= 4;
        } else if (this.getCurrentLocation() == 3) {
            event.feedback |= 1;
        }
    }

    private Aggregation dataContainsParent(Object target, Object data) {
        if (!(target instanceof Aggregation)) {
            return null;
        }
        if (data instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)data;
            ArrayList<Aggregation> parentList = new ArrayList<Aggregation>();
            Aggregation parent = ((Aggregation)target).getParent();
            while (parent != null) {
                parentList.add(parent);
                parent = parent.getParent();
            }
            parentList.add(this.view.getAggregationRoot());
            for (Object temp : selection) {
                if (!parentList.contains(temp)) continue;
                return (Aggregation)temp;
            }
        }
        return null;
    }
}

