package info.textgrid.lab.authn;

import info.textgrid.lab.authn.AuthBrowser.ISIDChangedListener;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.progress.UIJob;

public class AuthNDialog extends TrayDialog {
	AuthBrowser browserComp;
	AuthNDialog thisDialog;
	Button neverAsk;
	ISIDChangedListener sidChangedListener;

	protected AuthNDialog(IShellProvider parentShell) {
		super(parentShell);
		initialize();// parentShell.getShell());
	}

	public AuthNDialog(Shell parentShell) {
		super(parentShell);
		initialize();
	}

	protected void initialize() {
		thisDialog = this;
		sidChangedListener = new ISIDChangedListener() {
			public void sidChanged(final String newSID, final String newEPPN) {
				// do not necessarily need to evaluate e
				if (!RBACSession.getInstance().getSID(false).equals("")) { //$NON-NLS-1$
					new UIJob(Messages.AuthNDialog_ClosingDialog) { 
						@Override
						public IStatus runInUIThread(IProgressMonitor m) {
							thisDialog.destroy(); return Status.OK_STATUS; 
							}

					}.schedule();
				}
			}
		};
		AuthBrowser.addSIDChangedListener(sidChangedListener);
	}

	protected void initialize(Composite parent) {
	}

	protected void destroy() {
		// System.out.println("closing authNdialog (trying)...");
		AuthBrowser.removeSIDChangedListener(sidChangedListener);
		thisDialog.close();
		RBACSession.authDialogIsOpen(false);
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		parent.setLayout(new GridLayout(4, false)); // Extrawurst for neverAsk
		createButton(parent, 127, Messages.AuthNDialog_PasswordResetBtn, false);
		neverAsk = new Button(parent, SWT.CHECK);
		neverAsk.setText(Messages.AuthNDialog_NeverAskCheckbox);
		createButton(parent, 123, Messages.AuthNDialog_BackBtn, false);
		createButton(parent, IDialogConstants.CLOSE_ID,
				IDialogConstants.CLOSE_LABEL, false);
	}

	@Override
	protected void buttonPressed(int buttonId) {
		super.buttonPressed(buttonId);
		if (buttonId == IDialogConstants.CLOSE_ID) {
			if (neverAsk.getSelection()) {
				RBACSession.neverAsk(true);
			}
			this.destroy();
		}
		if (buttonId == 123) {
			boolean success = browserComp.getAuthBrowser().back();
			if (!success) {
				browserComp.resetAuthBrowser();
			}
		}
		if (buttonId == 127) {
			URL pwrurl = null;
			try {
				ConfClient confClient = ConfClient.getInstance();
				String pwrurlString = confClient.getValue("PasswordReset"); //$NON-NLS-1$
				pwrurl = URI.create(pwrurlString).toURL();
				PlatformUI
						.getWorkbench()
						.getBrowserSupport()
						.createBrowser(IWorkbenchBrowserSupport.AS_EXTERNAL,
								"xyz123abc456", "Hallo", "egal") //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
						.openURL(pwrurl);
				MessageBox mb = new MessageBox(PlatformUI.getWorkbench()
						.getActiveWorkbenchWindow().getShell(), SWT.OK
						| SWT.ICON_INFORMATION);
				mb.setText(Messages.AuthNDialog_ResettingPassword);
				mb.setMessage(Messages.AuthNDialog_ResetMessage); 
				mb.open();
			} catch (OfflineException e) {
				OnlineStatus.netAccessFailed(
						Messages.AuthNDialog_CouldNotContactConfserv, e);
			} catch (MalformedURLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (PartInitException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		}
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		browserComp = new AuthBrowser(parent);
		getShell().setText(Messages.AuthNDialog_WayfMessage);
		return browserComp;
	}

}
