/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.menus;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.ui.core.IOpenHandler;
import info.textgrid.lab.ui.core.OpenHandlerContribution;
import info.textgrid.lab.ui.core.handlers.DefaultOpenHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;

public class OpenContributionItem
extends ActionContributionItem
implements IContributionItem {
    public OpenContributionItem(OpenHandlerContribution contribution, TextGridObject textGridObject) {
        super((IAction)new OpenHandlerAction(contribution, textGridObject));
    }

    public static class OpenHandlerAction
    extends Action
    implements IAction {
        private final OpenHandlerContribution contribution;
        private final TextGridObject textGridObject;

        public OpenHandlerAction(OpenHandlerContribution contribution, TextGridObject textGridObject) {
            this.contribution = contribution;
            this.textGridObject = textGridObject;
        }

        public String getText() {
            return this.contribution.getLabel();
        }

        public String getDescription() {
            return this.contribution.getDescription();
        }

        private IOpenHandler getHandler() {
            if (this.contribution.getHandler() == null) {
                return new DefaultOpenHandler(this.contribution);
            }
            return this.contribution.getHandler();
        }

        public void run() {
            IOpenHandler handler = this.getHandler();
            try {
                handler.open(this.textGridObject);
            }
            catch (CoreException e) {
                Activator.handleError((Throwable)e);
            }
        }
    }
}

