/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetData;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetResourceReader;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetTable;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetTableCombinedItem;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetTableItem;
import info.textgrid.lab.xmleditor.multicharbrowser.Messages;
import info.textgrid.lab.xmleditor.multicharbrowser.StreamWriterUtils;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeView;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CustomCharsetDialog
extends Dialog
implements Observer {
    private Shell shell;
    private Group groupContainer;
    private Text textName;
    private Text textCustom;
    private Button closeButton;
    private Button radioBlock;
    private Button radioCustom;
    private Label textNameLabel;
    private Label labelIconDrawingField;
    private Label labelIcon;
    private Combo comboBlock;
    private FileDialog fileSelector;
    private Vector<CustomCharsetData> dataVector;
    private CustomCharsetData currentCharsetData;
    private Menu contextMenu;
    private List charsetList;
    private int previousSelectedListEntry;
    private final int borderOffset = 10;
    private int offsetCorrection = 0;
    private UnicodeView unicodeView;

    public UnicodeView getUnicodeView() {
        return this.unicodeView;
    }

    public void setUnicodeView(UnicodeView unicodeView) {
        this.unicodeView = unicodeView;
    }

    private void calculateOffsetCorrection() {
        if (!Platform.getOS().equals("macosx") && Platform.getOS().equals("win32")) {
            this.offsetCorrection = 4;
        }
    }

    private void createIconControl(Composite parent) {
        FormData formDataIconButton = new FormData();
        formDataIconButton.top = new FormAttachment(0, 10);
        formDataIconButton.left = new FormAttachment(30, 10);
        this.labelIconDrawingField = new Label(parent, 0);
        String imageLocation = this.currentCharsetData.getImageLocation();
        Image image = new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.validateImageLocationPath(imageLocation)).getImageData());
        this.labelIconDrawingField.setToolTipText(this.dataVector.get(this.charsetList.getSelectionIndex()).getImageLocation());
        this.labelIconDrawingField.setImage(image);
        this.labelIconDrawingField.setLayoutData((Object)formDataIconButton);
        this.labelIconDrawingField.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                CustomCharsetDialog.this.fileSelector = new FileDialog(Display.getCurrent().getActiveShell());
                CustomCharsetDialog.this.fileSelector.setText(Messages.CustomCharsetDialog_0);
                CustomCharsetDialog.this.fileSelector.setFilterNames(new String[]{Messages.CustomCharsetDialog_1, Messages.CustomCharsetDialog_2, Messages.CustomCharsetDialog_3});
                CustomCharsetDialog.this.fileSelector.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.*"});
                String dialogResult = CustomCharsetDialog.this.fileSelector.open();
                if (dialogResult != null) {
                    CustomCharsetDialog.this.labelIconDrawingField.setImage(new Image(null, dialogResult));
                    CustomCharsetDialog.this.labelIconDrawingField.setToolTipText(dialogResult);
                    CustomCharsetDialog.this.currentCharsetData.setImageLocation(dialogResult);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                this.mouseDown(e);
            }
        });
    }

    private void createLabelIcon(Composite parent) {
        FormData formDataIconLabel = new FormData();
        formDataIconLabel.top = new FormAttachment(0, 10);
        formDataIconLabel.left = new FormAttachment(0, 10);
        this.labelIcon = new Label(parent, 0);
        this.labelIcon.setText(Messages.CustomCharsetDialog_7);
        this.labelIcon.setLayoutData((Object)formDataIconLabel);
    }

    private void createToolbarEntries(ToolBar toolbar) {
        ToolItem toolItemAddEntry = new ToolItem(toolbar, 2056);
        toolItemAddEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.createNewCharset();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemAddEntry.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "list-add.png")).getImageData()));
        toolItemAddEntry.setToolTipText(Messages.CustomCharsetDialog_9);
        ToolItem toolItemRemoveEntry = new ToolItem(toolbar, 2056);
        toolItemRemoveEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.removeSelectedCharset();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemRemoveEntry.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "list-remove.png")).getImageData()));
        toolItemRemoveEntry.setToolTipText(Messages.CustomCharsetDialog_11);
        new ToolItem(toolbar, 2);
        ToolItem toolItemRefreshEntry = new ToolItem(toolbar, 2056);
        toolItemRefreshEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.refreshCharsetList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemRefreshEntry.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "view-refresh.png")).getImageData()));
        toolItemRefreshEntry.setToolTipText(Messages.CustomCharsetDialog_15);
        new ToolItem(toolbar, 2);
        ToolItem toolItemSaveAsEntry = new ToolItem(toolbar, 2056);
        toolItemSaveAsEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.fileSelector = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                CustomCharsetDialog.this.fileSelector.setText(Messages.CustomCharsetDialog_16);
                CustomCharsetDialog.this.fileSelector.setFilterNames(new String[]{Messages.CustomCharsetDialog_21});
                CustomCharsetDialog.this.fileSelector.setFilterExtensions(new String[]{"*.xml"});
                String dialogResult = CustomCharsetDialog.this.fileSelector.open();
                if (dialogResult != null) {
                    String temp = CustomCharsetResourceReader.customCharsetFilePath;
                    CustomCharsetResourceReader.customCharsetFilePath = dialogResult;
                    CustomCharsetDialog.this.saveChangesInCharset();
                    CustomCharsetResourceReader.customCharsetFilePath = temp;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemSaveAsEntry.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "document-save-as.png")).getImageData()));
        toolItemSaveAsEntry.setToolTipText(String.valueOf(Messages.CustomCharsetDialog_18) + CustomCharsetResourceReader.bundlePath + ")");
        ToolItem toolItemLoadEntry = new ToolItem(toolbar, 2056);
        toolItemLoadEntry.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.fileSelector = new FileDialog(Display.getCurrent().getActiveShell());
                CustomCharsetDialog.this.fileSelector.setText(Messages.CustomCharsetDialog_20);
                CustomCharsetDialog.this.fileSelector.setFilterNames(new String[]{Messages.CustomCharsetDialog_21});
                CustomCharsetDialog.this.fileSelector.setFilterExtensions(new String[]{"*.xml"});
                String dialogResult = CustomCharsetDialog.this.fileSelector.open();
                if (dialogResult != null) {
                    String temp = CustomCharsetResourceReader.customCharsetFilePath;
                    CustomCharsetResourceReader.customCharsetFilePath = dialogResult;
                    CustomCharsetDialog.this.refreshCharsetList();
                    CustomCharsetResourceReader.customCharsetFilePath = temp;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toolItemLoadEntry.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "document-open.png")).getImageData()));
        toolItemLoadEntry.setToolTipText(String.valueOf(Messages.CustomCharsetDialog_26) + CustomCharsetResourceReader.bundlePath + ")");
    }

    private void createTextNameLabel(Composite parent) {
        FormData formDataTextNameLabel = new FormData();
        formDataTextNameLabel.top = new FormAttachment((Control)this.labelIconDrawingField, 10);
        formDataTextNameLabel.left = new FormAttachment(0, 10);
        this.textNameLabel = new Label(parent, 0);
        this.textNameLabel.setText(Messages.CustomCharsetDialog_28);
        this.textNameLabel.setLayoutData((Object)formDataTextNameLabel);
    }

    private void createTextName(Composite parent) {
        this.textName = new Text(parent, 2052);
        FormData formDataTextName = new FormData();
        formDataTextName.top = new FormAttachment((Control)this.labelIconDrawingField, 3 + this.offsetCorrection);
        formDataTextName.left = new FormAttachment(30, 10);
        formDataTextName.right = new FormAttachment(100, -10);
        this.textName.setText(this.currentCharsetData.getName());
        this.textName.setToolTipText(Messages.CustomCharsetDialog_29);
        this.textName.setLayoutData((Object)formDataTextName);
    }

    private void createRadioBlock(Composite parent) {
        FormData formDataRadioBlock = new FormData();
        formDataRadioBlock.top = new FormAttachment((Control)this.textNameLabel, 10);
        formDataRadioBlock.left = new FormAttachment(0, 10);
        this.radioBlock = new Button(parent, 16);
        this.radioBlock.setSelection(true);
        this.radioBlock.setText(Messages.CustomCharsetDialog_30);
        this.radioBlock.setToolTipText(Messages.CustomCharsetDialog_31);
        this.radioBlock.setLayoutData((Object)formDataRadioBlock);
        this.radioBlock.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.textCustom.setEnabled(false);
                CustomCharsetDialog.this.comboBlock.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createComboBlock(Composite parent) {
        FormData formDataComboBlock = new FormData();
        formDataComboBlock.top = new FormAttachment((Control)this.textNameLabel, 10);
        formDataComboBlock.left = new FormAttachment(30, 10);
        formDataComboBlock.right = new FormAttachment(100, -10);
        this.comboBlock = new Combo(parent, 8);
        for (String blockEntry : UnicodeView.getBlockVector()) {
            this.comboBlock.add(blockEntry);
        }
        this.comboBlock.setToolTipText(Messages.CustomCharsetDialog_32);
        this.comboBlock.setLayoutData((Object)formDataComboBlock);
    }

    private void createRadioCustom(Composite parent) {
        FormData formDataRadioCustom = new FormData();
        formDataRadioCustom.top = new FormAttachment((Control)this.radioBlock, 15);
        formDataRadioCustom.left = new FormAttachment(0, 10);
        this.radioCustom = new Button(parent, 16);
        this.radioCustom.setSelection(false);
        this.radioCustom.setText(Messages.CustomCharsetDialog_33);
        this.radioCustom.setToolTipText(Messages.CustomCharsetDialog_34);
        this.radioCustom.setLayoutData((Object)formDataRadioCustom);
        this.radioCustom.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.textCustom.setEnabled(true);
                CustomCharsetDialog.this.comboBlock.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createTextCustom(Composite parent) {
        this.textCustom = new Text(parent, 2052);
        FormData formDataTextCustom = new FormData();
        formDataTextCustom.top = new FormAttachment((Control)this.radioBlock, 10 + this.offsetCorrection);
        formDataTextCustom.left = new FormAttachment(30, 10);
        formDataTextCustom.right = new FormAttachment(100, -10);
        this.textCustom.setToolTipText(Messages.CustomCharsetDialog_35);
        this.textCustom.setLayoutData((Object)formDataTextCustom);
        DropTarget dt = new DropTarget((Control)this.textCustom, 19);
        dt.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dt.addDropListener(new DropTargetListener(){

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                int i = 0;
                int n = event.dataTypes.length;
                while (i < n) {
                    if (TextTransfer.getInstance().isSupportedType(event.dataTypes[i])) {
                        event.currentDataType = event.dataTypes[i];
                    }
                    ++i;
                }
            }
        });
    }

    private void createCloseButton(Composite parent) {
        FormData formDataCloseButton = new FormData();
        formDataCloseButton.right = new FormAttachment(100, -10);
        formDataCloseButton.bottom = new FormAttachment(100, -10);
        this.closeButton = new Button(parent, 8);
        parent.getShell().setDefaultButton(this.closeButton);
        this.closeButton.setText(Messages.CustomCharsetDialog_36);
        this.closeButton.setToolTipText(Messages.CustomCharsetDialog_37);
        this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    CustomCharsetDialog.this.saveChangesInCharset();
                    CustomCharsetDialog.this.closeDialog();
                }
                catch (Throwable e1) {
                    StreamWriterUtils.writeLogError(4, e1.getMessage(), e1);
                }
            }
        });
        this.closeButton.setLayoutData((Object)formDataCloseButton);
    }

    private void handleListSelection() {
        if (this.currentCharsetData != null) {
            if (this.previousSelectedListEntry > this.dataVector.size()) {
                this.previousSelectedListEntry = -1;
            }
            if (this.previousSelectedListEntry >= 0) {
                this.dataVector.set(this.previousSelectedListEntry, this.currentCharsetData);
            }
            this.previousSelectedListEntry = this.charsetList.getSelectionIndex();
            this.currentCharsetData = this.dataVector.get(this.previousSelectedListEntry);
            this.charsetList.setItem(this.charsetList.getSelectionIndex(), this.currentCharsetData.getName());
            this.textName.setText(this.currentCharsetData.getName());
            this.labelIconDrawingField.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.validateImageLocationPath(this.currentCharsetData.getImageLocation())).getImageData()));
            this.labelIconDrawingField.setToolTipText(this.currentCharsetData.getImageLocation());
            if (this.currentCharsetData.isIsBlock()) {
                this.radioBlock.setSelection(true);
                this.radioCustom.setSelection(false);
                this.comboBlock.setEnabled(true);
                this.textCustom.setEnabled(false);
                int i = 0;
                while (i < this.comboBlock.getItemCount()) {
                    if (this.comboBlock.getItem(i).equals(this.currentCharsetData.getUnicodeBlockset())) {
                        this.comboBlock.select(i);
                        this.textCustom.setText("");
                        break;
                    }
                    ++i;
                }
            } else {
                String entryString = "";
                for (CustomCharsetTableItem entryInt : this.currentCharsetData.getCustomCharsetTable().getCustomCharsetTableItem()) {
                    entryString = String.valueOf(entryString) + Integer.toHexString((int)entryInt.point) + ";";
                }
                for (CustomCharsetTableCombinedItem entryCombination : this.currentCharsetData.getCustomCharsetTable().getCustomCharsetTableCombinedItem()) {
                    for (CustomCharsetTableItem entryInt : entryCombination.getCustomCharsetTableItem()) {
                        entryString = String.valueOf(entryString) + Integer.toHexString((int)entryInt.point) + "&";
                    }
                    entryString = String.valueOf(entryString) + ";";
                }
                this.textCustom.setText(entryString);
                this.radioBlock.setSelection(false);
                this.radioCustom.setSelection(true);
                this.comboBlock.setEnabled(false);
                this.comboBlock.setText("");
                this.textCustom.setEnabled(true);
            }
        }
    }

    private void saveChangesInCharset() {
        this.writeChangesToCustomCharsetData();
        this.dataVector.set(this.charsetList.getSelectionIndex(), this.currentCharsetData);
        CustomCharsetResourceReader.writeCustomCharsetsFile(this.dataVector);
        this.charsetList.setItem(this.charsetList.getSelectionIndex(), this.currentCharsetData.getName());
        this.refreshCharsetList();
    }

    private void writeChangesToCustomCharsetData() {
        this.currentCharsetData.setName(this.textName.getText());
        this.charsetList.setItem(this.charsetList.getSelectionIndex(), this.textName.getText());
        String imageLocationString = this.labelIconDrawingField.getToolTipText();
        if (imageLocationString.contains(CustomCharsetResourceReader.bundlePath)) {
            imageLocationString = imageLocationString.replace(CustomCharsetResourceReader.bundlePath, "$Bundle$");
        }
        this.currentCharsetData.setImageLocation(imageLocationString);
        this.currentCharsetData.setIsBlock(this.radioBlock.getSelection());
        if (this.radioBlock.getSelection()) {
            this.currentCharsetData.setUnicodeBlockset(this.comboBlock.getItem(this.comboBlock.getSelectionIndex()).toString());
        } else {
            CustomCharsetTable customCharsetTable = new CustomCharsetTable();
            String[] customCharArrayString = this.textCustom.getText().split(";");
            int i = 0;
            while (i < customCharArrayString.length) {
                if (customCharArrayString[i] != "") {
                    String[] currentSymbolArray = customCharArrayString[i].trim().split("&");
                    if (currentSymbolArray.length <= 1) {
                        CustomCharsetTableItem myItem = new CustomCharsetTableItem();
                        String currentSymbolString = currentSymbolArray[0];
                        int parsedInt = -1;
                        try {
                            parsedInt = Integer.parseInt(currentSymbolString, 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            parsedInt = Integer.parseInt(Integer.toHexString(currentSymbolString.codePointAt(0)), 16);
                        }
                        myItem = this.insertSymbolIntoTableItem(myItem, "" + parsedInt);
                        customCharsetTable.getCustomCharsetTableItem().add(myItem);
                    } else {
                        CustomCharsetTableCombinedItem myCombinedItem = new CustomCharsetTableCombinedItem();
                        String[] stringArray = currentSymbolArray;
                        int n = currentSymbolArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String currentSymbol = stringArray[n2];
                            CustomCharsetTableItem myItem = new CustomCharsetTableItem();
                            myItem = this.insertSymbolIntoTableItem(myItem, "" + Integer.parseInt(currentSymbol, 16));
                            myCombinedItem.getCustomCharsetTableItem().add(myItem);
                            ++n2;
                        }
                        customCharsetTable.getCustomCharsetTableCombinedItem().add(myCombinedItem);
                    }
                }
                ++i;
            }
            this.currentCharsetData.setCustomCharsetTable(customCharsetTable);
        }
    }

    private CustomCharsetTableItem insertSymbolIntoTableItem(CustomCharsetTableItem myItem, String currentSymbol) {
        try {
            int point = -1;
            if (currentSymbol.trim().startsWith("U+") || currentSymbol.trim().startsWith("/u")) {
                currentSymbol = currentSymbol.trim().substring(2);
                point = Integer.parseInt(currentSymbol.trim(), 16);
            } else {
                point = Integer.parseInt(currentSymbol.trim());
            }
            if (point >= 0) {
                myItem.setPoint(point);
            }
        }
        catch (NumberFormatException numberFormatException) {
            myItem.setPoint(currentSymbol.trim().codePointAt(0));
        }
        return myItem;
    }

    private void createNewCharset() {
        CustomCharsetData sample = new CustomCharsetData();
        sample.setName(Messages.CustomCharsetDialog_49);
        sample.setIsBlock(true);
        sample.setImageLocation("");
        sample.setUnicodeBlockset("MUSICAL_SYMBOLS");
        this.dataVector.add(sample);
        this.charsetList.add(sample.getName());
        this.charsetList.select(this.charsetList.getItemCount() - 1);
        try {
            this.writeChangesToCustomCharsetData();
        }
        catch (NullPointerException e) {
            StreamWriterUtils.writeLogError(4, e.toString(), e);
        }
        this.handleListSelection();
    }

    private void removeSelectedCharset() {
        int lastSelectionIndex;
        int i = lastSelectionIndex = this.charsetList.getSelectionIndex();
        while (i < this.dataVector.size() - 1) {
            this.dataVector.setElementAt(this.dataVector.get(i + 1), i);
            ++i;
        }
        this.dataVector.remove(this.dataVector.size() - 1);
        this.charsetList.remove(lastSelectionIndex);
        lastSelectionIndex = Math.max(0, lastSelectionIndex - 1);
        this.charsetList.select(lastSelectionIndex);
        this.previousSelectedListEntry = -1;
        this.writeChangesToCustomCharsetData();
        this.handleListSelection();
    }

    private void refreshCharsetList() {
        this.charsetList.removeAll();
        CustomCharsetResourceReader.loadCustomCharsetsFromFile();
        this.dataVector = CustomCharsetResourceReader.getDataVector();
        for (CustomCharsetData dataEntry : this.dataVector) {
            this.charsetList.add(dataEntry.getName());
        }
        this.charsetList.select(0);
        this.handleListSelection();
    }

    public Control createDialogArea(Composite parent) {
        this.charsetList = new List(parent, 2564);
        CustomCharsetResourceReader.loadCustomCharsetsFromFile();
        this.dataVector = CustomCharsetResourceReader.getDataVector();
        if (this.dataVector.size() == 0) {
            this.createNewCharset();
        }
        FormLayout layoutList = new FormLayout();
        parent.setLayout((Layout)layoutList);
        FormData formDataList = new FormData();
        formDataList.top = new FormAttachment(0, 10);
        formDataList.left = new FormAttachment(0, 10);
        formDataList.right = new FormAttachment(100, -10);
        formDataList.bottom = new FormAttachment(100, -210);
        for (CustomCharsetData dataEntry : this.dataVector) {
            this.charsetList.add(dataEntry.getName());
        }
        this.previousSelectedListEntry = -1;
        this.charsetList.select(0);
        this.currentCharsetData = this.dataVector.get(0);
        this.charsetList.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    CustomCharsetDialog.this.writeChangesToCustomCharsetData();
                }
                CustomCharsetDialog.this.handleListSelection();
                if (e.button == 3) {
                    CustomCharsetDialog.this.contextMenu.setLocation(Display.getCurrent().getCursorLocation());
                    CustomCharsetDialog.this.contextMenu.setVisible(true);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                this.mouseDown(e);
            }
        });
        this.charsetList.setLayoutData((Object)formDataList);
        FormData formDataToolbar = new FormData();
        formDataToolbar.top = new FormAttachment((Control)this.charsetList, 0);
        formDataToolbar.left = new FormAttachment(0, 10);
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        this.createToolbarEntries(toolbar);
        toolbar.setLayoutData((Object)formDataToolbar);
        toolbar.pack();
        FormData formDataGroup = new FormData();
        formDataGroup.top = new FormAttachment((Control)toolbar, 0);
        formDataGroup.left = new FormAttachment(0, 10);
        formDataGroup.right = new FormAttachment(100, -10);
        formDataGroup.bottom = new FormAttachment(100, -50);
        this.groupContainer = new Group(parent, 0);
        this.groupContainer.setText(Messages.CustomCharsetDialog_52);
        this.groupContainer.setLayoutData((Object)formDataGroup);
        this.groupContainer.setLayout((Layout)new FormLayout());
        this.calculateOffsetCorrection();
        this.createLabelIcon((Composite)this.groupContainer);
        this.createIconControl((Composite)this.groupContainer);
        this.createTextNameLabel((Composite)this.groupContainer);
        this.createTextName((Composite)this.groupContainer);
        this.createRadioBlock((Composite)this.groupContainer);
        this.createComboBlock((Composite)this.groupContainer);
        this.createRadioCustom((Composite)this.groupContainer);
        this.createTextCustom((Composite)this.groupContainer);
        this.contextMenu = new Menu((Control)parent);
        MenuItem menuItemRemove = new MenuItem(this.contextMenu, 8);
        menuItemRemove.setText(Messages.CustomCharsetDialog_53);
        menuItemRemove.setImage(new Image(null, ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "list-remove.png")).getImageData()));
        menuItemRemove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CustomCharsetDialog.this.removeSelectedCharset();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.createCloseButton(parent);
        this.handleListSelection();
        return parent;
    }

    public Object open() {
        Shell parent = this.getParent();
        if (this.shell == null) {
            this.shell = new Shell(parent, 2144);
        }
        this.shell.setText(Messages.CustomCharsetDialog_55);
        this.createDialogArea((Composite)this.shell);
        this.shell.setSize(380, 480);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this;
    }

    public void closeDialog() {
        this.getUnicodeView().createCustomCharsetItems(false);
        Display.getCurrent().getActiveShell().dispose();
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public CustomCharsetDialog(Shell parent, int style) {
        super(parent, style);
    }
}

