/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.navigator.Messages;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishError;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishObject;
import info.textgrid.middleware.tgpublish.api.jaxb.PublishWarning;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CopyReportDialog
extends TitleAreaDialog {
    private Text text;
    private List<PublishObject> publishObjects;
    private HashMap<String, HashMap<String, Integer>> allCopyURIs;
    private boolean userAbort;

    public CopyReportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Copy Report");
        this.setMessage(Messages.CopyReportDialog_IM_ProcessInformation, 1);
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)new GridLayout(1, false));
        this.text = new Text(area, 778);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fillReport();
        this.text.setSelection(0, 0);
        return area;
    }

    private void fillReport() {
        String content = "";
        if (this.userAbort) {
            content = Messages.CopyReportDialog_IM_UserAbort;
        }
        int counter = 1;
        if (this.publishObjects != null) {
            for (PublishObject object : this.publishObjects) {
                String line = "";
                String errorLine = "";
                String warningLine = "";
                String title = "";
                HashMap<String, Integer> titleCount = this.allCopyURIs.get(object.uri);
                for (Map.Entry<String, Integer> t : titleCount.entrySet()) {
                    title = t.getKey();
                }
                line = String.valueOf(counter) + ". \t" + title + " (" + object.uri + ");" + " Status:" + object.status.name() + "\n";
                if (object.getErrors().size() > 0) {
                    errorLine = "\tErrors:";
                    for (PublishError publishError : object.getErrors()) {
                        errorLine = String.valueOf(errorLine) + "\n\t" + publishError.getMessage();
                    }
                }
                if (object.getWarnings().size() > 0) {
                    warningLine = "\tErrors:";
                    for (PublishWarning publishWarning : object.getWarnings()) {
                        warningLine = String.valueOf(warningLine) + "\n\t" + publishWarning.getMessage();
                    }
                }
                ++counter;
                content = String.valueOf(content) + line + errorLine + warningLine;
            }
        }
        this.text.setText(content);
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    public void setPublishObjects(List<PublishObject> publishObjects, HashMap<String, HashMap<String, Integer>> allCopyURIs, boolean userAbort) {
        this.publishObjects = publishObjects;
        this.allCopyURIs = allCopyURIs;
        this.userAbort = userAbort;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

