/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.SwitchControlElement;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.dom4j.Element;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SwitchGroup
implements IControl {
    private Composite sectionClient = null;
    private ScrolledForm form = null;
    private String id = null;
    private Element dataElement = null;
    private XLayout xlayout = null;
    private Button switcherBtn = null;
    private ArrayList<IControl> controls = null;
    private SwitchControlElement switchElem = null;
    private boolean active = false;
    private Composite composite = new Composite((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);

    public Composite getComposite() {
        return this.composite;
    }

    public SwitchGroup(String id, Element element) {
        this.id = id;
        this.dataElement = element;
    }

    private SwitchGroup getInstance() {
        return this;
    }

    public void create() {
        this.createRecursive(this.composite);
        this.active = true;
    }

    private void createRecursive(Composite comp) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.createRecursive((Composite)c);
            } else {
                c.setParent(this.sectionClient);
            }
            ++n2;
        }
    }

    public void destroy() {
        this.destroyRecursive(this.sectionClient);
        this.active = false;
    }

    private void destroyRecursive(Composite comp) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.destroyRecursive((Composite)c);
            } else {
                c.setParent(this.composite);
            }
            ++n2;
        }
    }

    public void update(SwitchControlElement elem, ScrolledForm form, Composite sectionClient, XLayout xlayout) {
        this.switchElem = elem;
        this.sectionClient = sectionClient;
        this.form = form;
        this.xlayout = xlayout;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void addControl(IControl control) {
        if (this.controls == null) {
            this.controls = new ArrayList();
        }
        this.controls.add(control);
    }

    public List<Control> getControls() {
        ArrayList<Control> l = new ArrayList<Control>();
        if (this.active) {
            Control[] controlArray = this.sectionClient.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                l.add(c);
                ++n2;
            }
        }
        return l;
    }

    public void addSwitcher(Button switcher) {
        this.switcherBtn = switcher;
        this.switcherBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SwitchGroup.this.switchElem.switchToOtherGroup(SwitchGroup.this.getInstance());
                SwitchGroup.this.xlayout.setModified(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (this.active) {
            for (IControl e : this.controls) {
                e.createOMElement(omFactory, parent, ns, asAttribute);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.controls != null) {
            for (IControl e : this.controls) {
                e.dispose();
            }
            this.controls.clear();
        }
        if (this.switcherBtn != null) {
            this.switcherBtn.dispose();
        }
    }

    @Override
    public boolean validate() {
        if (!this.active) {
            return true;
        }
        boolean valid = true;
        for (IControl e : this.controls) {
            valid &= e.validate();
        }
        return valid;
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        for (IControl c : this.controls) {
            found |= c.setOMElement(root, tg);
        }
        return found;
    }

    @Override
    public void clear() {
        for (IControl c : this.controls) {
            c.clear();
        }
    }
}

