/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.aggregations.ui.views;

import com.google.common.base.Predicate;
import info.textgrid.lab.core.aggregations.ui.AggregationsUIPlugin;
import info.textgrid.lab.core.aggregations.ui.model.Aggregation;
import info.textgrid.lab.core.aggregations.ui.model.IAggregationTypeAdapter;
import info.textgrid.lab.core.aggregations.ui.model.SectionDragListener;
import info.textgrid.lab.core.aggregations.ui.model.SectionTreeDropAdapter;
import info.textgrid.lab.core.aggregations.ui.model.TGOentry;
import info.textgrid.lab.core.aggregations.ui.views.AggregationComposerEditorInput;
import info.textgrid.lab.core.aggregations.ui.views.Messages;
import info.textgrid.lab.core.aggregations.ui.views.SectionContentProvider;
import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.revisions.ui.RevisionSelectDialog;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class AggregationComposerEditor
extends EditorPart {
    private Action addAction;
    private Action revisionAction;
    private Action removeAction;
    private Action renameAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action expandAction;
    private Action collapseAction;
    private Action referToAction;
    private Action referToLatestAction;
    private Action referToRevisionAction;
    private Clipboard clipboard;
    private TreeViewer viewer;
    private SectionTreeDropAdapter dropAdapter;
    private Aggregation viewerRoot;
    private Aggregation aggregationRoot;
    private boolean isChanged;
    private TextGridProject targetProject;
    private TextGridObject loadObject = null;
    private boolean isBusy = false;
    private boolean contentTypeChanged = false;
    private ToolBar toolBar;
    private MetaDataView metaDataView = null;
    public static final TGContentType AGGREGATION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.aggregation+xml");
    public static final TGContentType EDITION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.edition+tg.aggregation+xml");
    public static final TGContentType COLLECTION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.collection+tg.aggregation+xml");
    final DelegatingStyledCellLabelProvider styledLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AggregationLabelProvider());
    private AddAggregationAction[] aggregationActions;

    public void setViewerAndAggregationRoot() {
        if (this.targetProject != null && this.aggregationRoot == null) {
            this.viewerRoot = new Aggregation(null, "InvisibleRootAggregation", null, this.targetProject);
            this.aggregationRoot = new Aggregation(this.viewerRoot, "Aggregation", null, this.targetProject);
        }
    }

    public Aggregation getViewerRoot() {
        return this.viewerRoot;
    }

    private void contributeToActionBars() {
        this.fillLocalToolBar();
    }

    private void fillLocalToolBar() {
        ToolBarManager manager = new ToolBarManager(this.toolBar);
        manager.add((IAction)this.addAction);
        manager.add((IAction)this.removeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.update(true);
    }

    public void createPartControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout glMain = new GridLayout(2, false);
        glMain.verticalSpacing = 0;
        glMain.marginTop = 2;
        mainComposite.setLayout((Layout)glMain);
        this.createUpperControls(mainComposite);
        this.createViewer(mainComposite);
        this.loadAggregation(this.getLoadObject());
        this.setLoadObject(null);
        this.makeActions();
        this.hookContextMenu();
        this.makeToolbarPulldownMenuItems();
        this.contributeToActionBars();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.core.aggregations.ui.AggregationComposerEditor");
    }

    private void createUpperControls(Composite mainComposite) {
        GridData gd = new GridData(4, 128, true, true);
        mainComposite.setLayoutData((Object)gd);
        Composite toolBarComposite = new Composite(mainComposite, 0);
        GridData gdToolbar = new GridData(4, 4, true, false);
        gdToolbar.horizontalSpan = 2;
        toolBarComposite.setLayoutData((Object)gdToolbar);
        this.toolBar = new ToolBar(toolBarComposite, 256);
        Label seperator = new Label(mainComposite, 266);
        seperator.setLayoutData((Object)gdToolbar);
    }

    private void createViewer(Composite mainComposite) {
        Group viewerGroup = new Group(mainComposite, 0);
        viewerGroup.setLayout((Layout)new GridLayout());
        GridData gdViewer = new GridData(4, 4, true, true);
        gdViewer.horizontalSpan = 2;
        viewerGroup.setLayoutData((Object)gdViewer);
        this.viewer = new TreeViewer((Composite)viewerGroup, 770);
        this.viewer.setContentProvider((IContentProvider)new SectionContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.styledLabelProvider);
        this.viewer.setInput((Object)this.viewerRoot);
        this.viewer.getControl().setLayoutData((Object)gdViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        mainComposite.layout();
        int ops = 19;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new SectionDragListener((StructuredViewer)this.viewer));
        transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.dropAdapter = new SectionTreeDropAdapter(this.viewer, this);
        this.viewer.addDropSupport(ops, transfers, (DropTargetListener)this.dropAdapter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AggregationComposerEditor.this.isBusy()) {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                AggregationComposerEditor.this.metaDataView = (MetaDataView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.core.metadataeditor.view");
                if (AggregationComposerEditor.this.metaDataView == null) {
                    return;
                }
                if (!sel.isEmpty()) {
                    if (sel.getFirstElement() instanceof Aggregation) {
                        if (sel.getFirstElement() == AggregationComposerEditor.this.getAggregationRoot()) {
                            AggregationComposerEditor.this.removeAction.setEnabled(false);
                        } else {
                            AggregationComposerEditor.this.removeAction.setEnabled(true);
                            AggregationComposerEditor.this.addAction.setEnabled(true);
                        }
                        Aggregation selectedAggregation = (Aggregation)sel.getFirstElement();
                        if (AggregationComposerEditor.this.metaDataView.getTextGridObject() != selectedAggregation.getObject() || AggregationComposerEditor.this.contentTypeChanged) {
                            AggregationComposerEditor.this.metaDataView.setMetadataInView(selectedAggregation.getObject(), true);
                            AggregationComposerEditor.this.contentTypeChanged = false;
                        }
                    } else {
                        AggregationComposerEditor.this.removeAction.setEnabled(true);
                        AggregationComposerEditor.this.addAction.setEnabled(true);
                    }
                }
            }
        });
        final TreeEditor editor = new TreeEditor(this.viewer.getTree());
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.viewer.getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                try {
                    final TreeItem item = AggregationComposerEditor.this.viewer.getTree().getSelection()[0];
                    if (!(item.getData() instanceof Aggregation)) {
                        return;
                    }
                    AggregationComposerEditor.this.viewer.setSelection(null);
                    final Aggregation aggregation = (Aggregation)item.getData();
                    final Text text = new Text((Composite)AggregationComposerEditor.this.viewer.getTree(), 0);
                    text.setText(item.getText());
                    text.selectAll();
                    text.setFocus();
                    text.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusLost(FocusEvent event) {
                            item.setText(text.getText());
                            text.dispose();
                            AggregationComposerEditor.this.viewer.refresh((Object)aggregation);
                        }
                    });
                    text.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            switch (event.keyCode) {
                                case 13: {
                                    aggregation.getObject().setTitle(text.getText());
                                    aggregation.getObject().notifyMetadataEditor();
                                    AggregationComposerEditor.this.viewer.refresh((Object)aggregation);
                                }
                                case 27: {
                                    text.dispose();
                                    AggregationComposerEditor.this.viewer.refresh((Object)aggregation);
                                }
                            }
                        }
                    });
                    editor.setEditor((Control)text, item);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
        });
    }

    public void hookContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewer.getTree().setMenu(menuManager.createContextMenu((Control)this.viewer.getTree()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager newSubMenu = new MenuManager(Messages.AggregationComposerEditor_Menu_New);
        MenuManager revisionSubMenu = new MenuManager("Revision");
        AddAggregationAction[] addAggregationActionArray = this.getAggregationTypeActions();
        int n = addAggregationActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AddAggregationAction action = addAggregationActionArray[n2];
            newSubMenu.add((IAction)action);
            ++n2;
        }
        menuManager.add((IContributionItem)newSubMenu);
        menuManager.add((IAction)this.renameAction);
        menuManager.add((IAction)this.removeAction);
        revisionSubMenu.add((IAction)this.referToAction);
        revisionSubMenu.add((IAction)this.referToLatestAction);
        revisionSubMenu.add((IAction)this.referToRevisionAction);
        menuManager.add((IContributionItem)revisionSubMenu);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.expandAction);
        menuManager.add((IAction)this.collapseAction);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = AggregationComposerEditor.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TGOentry) {
                    if (((TGOentry)obj).isRestrictedTextGridObject()) {
                        AggregationComposerEditor.this.referToAction.setEnabled(false);
                        AggregationComposerEditor.this.referToLatestAction.setEnabled(false);
                        AggregationComposerEditor.this.referToRevisionAction.setEnabled(false);
                    } else {
                        AggregationComposerEditor.this.referToAction.setEnabled(true);
                        AggregationComposerEditor.this.referToLatestAction.setEnabled(true);
                        AggregationComposerEditor.this.referToRevisionAction.setEnabled(true);
                    }
                }
                if (obj instanceof Aggregation) {
                    AggregationComposerEditor.this.expandAction.setEnabled(true);
                    AggregationComposerEditor.this.collapseAction.setEnabled(true);
                } else {
                    AggregationComposerEditor.this.expandAction.setEnabled(false);
                    AggregationComposerEditor.this.collapseAction.setEnabled(false);
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
    }

    private AddAggregationAction[] getAggregationTypeActions() {
        if (this.aggregationActions == null) {
            Object[] aggregationTypes = TGContentType.getContentTypes((Predicate)new Predicate<TGContentType>(){

                public boolean apply(TGContentType input) {
                    return input.getId().contains("aggregation");
                }
            });
            Arrays.sort(aggregationTypes);
            this.aggregationActions = new AddAggregationAction[aggregationTypes.length];
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("info.textgrid.lab.core.aggregations.ui.aggregationTypeAdapter");
            int i = 0;
            while (i < aggregationTypes.length) {
                this.aggregationActions[i] = new AddAggregationAction((TGContentType)aggregationTypes[i], elements, 0);
                ++i;
            }
        }
        return this.aggregationActions;
    }

    private void makeActions() {
        this.addAction = new Action(Messages.AggregationComposerEditor_NewKindOfAggregation, 4){

            public void run() {
                AggregationComposerEditor.this.addSection(AggregationType.AGGREGATION);
            }
        };
        this.addAction.setMenuCreator(new IMenuCreator(){
            private Menu listMenu;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                if (this.listMenu == null) {
                    this.listMenu = new Menu(parent);
                }
                return this.listMenu;
            }

            public void dispose() {
                if (this.listMenu != null) {
                    this.listMenu.dispose();
                }
            }
        });
        this.addAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("add"));
        this.addAction.setText(Messages.AggregationComposerEditor_NewKindOfAggregation);
        this.addAction.setToolTipText(Messages.AggregationComposerEditor_NewKindOfAggregation);
        this.removeAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.removeItem();
            }
        };
        this.removeAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("delete"));
        this.removeAction.setText(Messages.AggregationComposerEditor_RemoveItem);
        this.removeAction.setToolTipText(Messages.AggregationComposerEditor_RemoveItem);
        this.renameAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.renameItem();
            }
        };
        this.renameAction.setText(Messages.AggregationComposerEditor_RenameItem);
        this.renameAction.setToolTipText(Messages.AggregationComposerEditor_RenameItem);
        this.revisionAction = new Action("Revision", 4){

            public void run() {
            }
        };
        this.revisionAction.setMenuCreator(new IMenuCreator(){
            private Menu listMenu;

            public Menu getMenu(Menu parent) {
                return null;
            }

            public Menu getMenu(Control parent) {
                if (this.listMenu == null) {
                    this.listMenu = new Menu(parent);
                }
                return this.listMenu;
            }

            public void dispose() {
                if (this.listMenu != null) {
                    this.listMenu.dispose();
                }
            }
        });
        this.revisionAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("add"));
        this.revisionAction.setText("Revision");
        this.revisionAction.setToolTipText("Revision");
        this.referToAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.setLatest(false);
            }
        };
        this.referToAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("referto"));
        this.referToAction.setText(Messages.AggregationComposerEditor_ReferToThisVersion);
        this.referToAction.setToolTipText(Messages.AggregationComposerEditor_ReferToThisVersion);
        this.referToLatestAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.setLatest(true);
            }
        };
        this.referToLatestAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("refertolatest"));
        this.referToLatestAction.setText(Messages.AggregationComposerEditor_ReferToLastVersion);
        this.referToLatestAction.setToolTipText(Messages.AggregationComposerEditor_ReferToLastVersion);
        this.referToRevisionAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.selectRevision();
            }
        };
        this.referToRevisionAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("refertoversion"));
        this.referToRevisionAction.setText(Messages.AggregationComposerEditor_ReferToRevisionPoint);
        this.referToRevisionAction.setToolTipText(Messages.AggregationComposerEditor_ReferToRevision);
        this.expandAllAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("expandall"));
        this.expandAllAction.setText(Messages.AggregationComposerEditor_ExpandAll);
        this.expandAllAction.setToolTipText(Messages.AggregationComposerEditor_ExpandAll);
        this.expandAction = new Action(){

            public void run() {
                ISelection selection = AggregationComposerEditor.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                AggregationComposerEditor.this.viewer.expandToLevel(obj, -1);
            }
        };
        this.expandAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("expandall"));
        this.expandAction.setText(Messages.AggregationComposerEditor_ExpandAggregation);
        this.expandAction.setToolTipText(Messages.AggregationComposerEditor_ExpandAggregation);
        this.collapseAllAction = new Action(){

            public void run() {
                AggregationComposerEditor.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("collapseall"));
        this.collapseAllAction.setText(Messages.AggregationComposerEditor_CollapseAll);
        this.collapseAllAction.setToolTipText(Messages.AggregationComposerEditor_CollapseAll);
        this.collapseAction = new Action(){

            public void run() {
                ISelection selection = AggregationComposerEditor.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                AggregationComposerEditor.this.viewer.collapseToLevel(obj, -1);
            }
        };
        this.collapseAction.setImageDescriptor(AggregationsUIPlugin.getDefault().getImageRegistry().getDescriptor("collapseall"));
        this.collapseAction.setText(Messages.AggregationComposerEditor_CollapseAggregation);
        this.collapseAction.setToolTipText(Messages.AggregationComposerEditor_CollapseAggregation);
    }

    private void makeToolbarPulldownMenuItems() {
        IMenuCreator mc = this.addAction.getMenuCreator();
        Menu menu = mc.getMenu((Control)this.toolBar);
        AddAggregationAction[] addAggregationActionArray = this.getAggregationTypeActions();
        int n = addAggregationActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AddAggregationAction action = addAggregationActionArray[n2];
            action.createMenuItem(menu, 8);
            ++n2;
        }
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        }
    }

    protected void addSection(TGContentType contentType, IAggregationTypeAdapter extension) {
        this.setIsBusy(true);
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        Aggregation aggregation = this.aggregationRoot;
        if (obj instanceof Aggregation) {
            aggregation = (Aggregation)obj;
        }
        Aggregation newAggregation = new Aggregation(aggregation, contentType.getDescription(), null, this.getTargetProject());
        newAggregation.getObject().setContentType(contentType);
        if (extension != null) {
            extension.setType(newAggregation);
        }
        this.setIsChanged(true);
        this.viewer.refresh((Object)aggregation.getParent());
        this.setIsBusy(false);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newAggregation), true);
        this.viewer.getTree().notifyListeners(8, new Event());
    }

    @Deprecated
    private void addSection(AggregationType type) {
        this.setIsBusy(true);
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        Aggregation aggregation = this.aggregationRoot;
        if (obj instanceof Aggregation) {
            aggregation = (Aggregation)obj;
        }
        String name = String.valueOf(type.toString().charAt(0)) + type.toString().substring(1, type.toString().length()).toLowerCase();
        Aggregation newAggregation = new Aggregation(aggregation, name, null, this.getTargetProject());
        switch (type) {
            case AGGREGATION: {
                newAggregation.setObjectToItem();
                break;
            }
            case COLLECTION: {
                newAggregation.setObjectToCollection();
                break;
            }
            case EDITION: {
                newAggregation.setObjectToEdition();
            }
        }
        this.setIsChanged(true);
        this.viewer.refresh((Object)aggregation.getParent());
        this.setIsBusy(false);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newAggregation), true);
        this.viewer.getTree().notifyListeners(8, new Event());
    }

    public void save(final SaveType saveType) {
        if (saveType.equals((Object)SaveType.REVISION) && !SearchRequest.isTgoLatestRevision((String)this.getAggregationRoot().getObject().getURI().toString())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AggregationComposerEditor_SaveAggregation, (String)Messages.AggregationComposerEditor_EM_AggregationHasSuccessive);
            return;
        }
        if (saveType.equals((Object)SaveType.STANDARD)) {
            try {
                if (this.getAggregationRoot().getObject().isPublic()) {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AggregationComposerEditor_SaveAggregation, (String)Messages.AggregationComposerEditor_EM_AggregationAlreadyPublished);
                    return;
                }
            }
            catch (CoreException e) {
                AggregationsUIPlugin.handleError(e, Messages.AggregationComposerEditor_EM_ErrorWhenAccessing, this.getAggregationRoot().getObject());
                return;
            }
        }
        try {
            if (!this.getAggregationRoot().getObject().getProjectInstance().equals((Object)this.getTargetProject())) {
                this.setAggregationsToTargetProject(this.getAggregationRoot());
            }
        }
        catch (CoreException e) {
            AggregationsUIPlugin.handleError(e, "Aggregation Composer Error.", new Object[0]);
        }
        Job saveJob = new Job(NLS.bind((String)Messages.AggregationComposerEditor_IM_Saving, (Object)this.getAggregationRoot())){

            protected IStatus run(IProgressMonitor monitor) {
                AggregationComposerEditor.this.setIsBusy(true);
                try {
                    AggregationComposerEditor.this.getAggregationRoot().save(monitor, saveType == SaveType.REVISION);
                }
                catch (XMLStreamException e) {
                    return AggregationsUIPlugin.handleError(e, Messages.AggregationComposerEditor_EM_SerializeAggregation, AggregationComposerEditor.this.viewerRoot);
                }
                catch (CoreException e) {
                    return AggregationsUIPlugin.handleError(e, e.getMessage(), AggregationComposerEditor.this.viewerRoot);
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                super.aboutToRun(event);
                UIJob job = new UIJob(Messages.AggregationComposerEditor_DisableWidgets){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AggregationComposerEditor.this.setWidgetsEnabled(false);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }

            public void done(IJobChangeEvent event) {
                super.done(event);
                UIJob job = new UIJob(Messages.AggregationComposerEditor__ResetComposer){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AggregationComposerEditor.this.setIsChanged(false);
                        AggregationComposerEditor.this.setIsBusy(false);
                        AggregationComposerEditor.this.setWidgetsEnabled(true);
                        TextGridProject.notifyListeners((ITextGridProjectListener.Event)ITextGridProjectListener.Event.CONTENT_CHANGED, (TextGridProject)AggregationComposerEditor.this.targetProject);
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
        });
        saveJob.schedule(1000L);
    }

    private void setWidgetsEnabled(boolean enabled) {
        AddAggregationAction[] addAggregationActionArray = this.getAggregationTypeActions();
        int n = addAggregationActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AddAggregationAction action = addAggregationActionArray[n2];
            action.setEnabled(enabled);
            ++n2;
        }
        this.addAction.setEnabled(enabled);
        this.revisionAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
        this.expandAllAction.setEnabled(enabled);
        this.collapseAllAction.setEnabled(enabled);
        if (!this.viewer.getTree().isDisposed()) {
            this.viewer.getTree().setEnabled(enabled);
        }
    }

    private void removeItem() {
        String message = null;
        ISelection selection = this.viewer.getSelection();
        if (((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Aggregation) {
                Aggregation aggregation = (Aggregation)obj;
                message = aggregation.getChildren().length > 0 ? NLS.bind((String)Messages.AggregationComposerEditor_RemoveWithChildren, (Object)aggregation.getName()) : NLS.bind((String)Messages.AggregationComposerEditor_Remove, (Object)aggregation.getName());
            } else if (obj instanceof TGOentry) {
                TGOentry entry = (TGOentry)obj;
                try {
                    message = NLS.bind((String)Messages.AggregationComposerEditor_Remove, (Object)entry.getTitle());
                }
                catch (CoreException e) {
                    AggregationsUIPlugin.handleError(e, "Aggregation Composer Error.", new Object[0]);
                }
            }
        } else {
            message = NLS.bind((String)Messages.AggregationComposerEditor_RemoveItemWithChildren, (Object)((IStructuredSelection)selection).size());
        }
        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Aggregation Composer", (String)message)) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item instanceof Aggregation) {
                    ((Aggregation)item).delete();
                    this.setIsChanged(true);
                } else if (item instanceof TGOentry) {
                    ((TGOentry)item).delete();
                    this.setIsChanged(true);
                }
                ++n2;
            }
            this.viewer.refresh((Object)this.aggregationRoot);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.aggregationRoot), true);
        }
    }

    private void renameItem() {
        ISelection selection = this.viewer.getSelection();
        if (((IStructuredSelection)selection).size() == 1) {
            this.viewer.getTree().notifyListeners(8, new Event());
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Aggregation Composer", (String)Messages.AggregationComposerEditor_IM_SelectOnlyOneItem);
        }
    }

    private void setLatest(boolean value) {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        if (!sel.isEmpty()) {
            for (Object obj : sel) {
                if (obj instanceof Aggregation) {
                    ((Aggregation)obj).setLatest(value);
                    ((Aggregation)obj).setRevision(null);
                    this.viewer.refresh(obj, true);
                    continue;
                }
                if (!(obj instanceof TGOentry)) continue;
                ((TGOentry)obj).setLatest(value);
                ((TGOentry)obj).setRevision(null);
                this.viewer.refresh(obj, true);
            }
        }
    }

    private void selectRevision() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object obj = sel.getFirstElement();
        if (obj != null) {
            RevisionSelectDialog posDialog = new RevisionSelectDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
            posDialog.refreshDialog(obj);
            posDialog.open();
            this.viewer.refresh(obj, true);
        }
    }

    public TextGridProject getTargetProject() {
        return this.targetProject;
    }

    public void setTargetProject(TextGridProject targetProject) {
        this.targetProject = targetProject;
    }

    public Aggregation getAggregationRoot() {
        return this.aggregationRoot;
    }

    public void loadAggregation(final Object object) {
        if (this.aggregationRoot == null || object == null) {
            return;
        }
        UIJob job = new UIJob(Messages.AggregationComposerEditor_LoadAggregation){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (object instanceof TextGridObject) {
                    AggregationComposerEditor.this.getAggregationRoot().setObject((TextGridObject)object);
                    AggregationComposerEditor.this.adaptPartInformation();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AggregationComposerEditor_FetchingMembers, (Object)((TextGridObject)object)), (int)100);
                    try {
                        if (((TextGridObject)object).getCreated() != null) {
                            AggregationComposerEditor.this.setIsChanged(false);
                            return AggregationComposerEditor.this.fetchAggregation((TextGridObject)object, progress, AggregationComposerEditor.this.getAggregationRoot());
                        }
                        AggregationComposerEditor.this.setIsChanged(true);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.AggregationComposerEditor_EM_AccessingAggregation, (Object)object.toString()), (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                AggregationComposerEditor.this.viewer.refresh();
                AggregationComposerEditor.this.viewer.expandAll();
                AggregationComposerEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)AggregationComposerEditor.this.aggregationRoot), true);
            }
        });
        job.setUser(true);
        job.schedule();
    }

    public void importAggregation(final Aggregation target, final Object object) {
        UIJob job = new UIJob(Messages.AggregationComposerEditor_FetchAggregation){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.AggregationComposerEditor_FetchingMembers, (Object)((TextGridObject)object)), (int)100);
                return AggregationComposerEditor.this.fetchAggregation((TextGridObject)object, progress, target);
            }
        };
        job.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                AggregationComposerEditor.this.viewer.refresh();
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        job.setUser(true);
        job.schedule();
    }

    public IStatus fetchAggregation(TextGridObject aggregation, SubMonitor progress, Aggregation actualRoot) {
        this.setIsBusy(true);
        progress.beginTask(NLS.bind((String)Messages.AggregationComposerEditor_QueryingForChildren, (Object)aggregation), 100);
        SearchRequest searchRequest = new SearchRequest();
        Response response = searchRequest.listAggregation(aggregation.getURI().toString());
        if (progress.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        int hits = response.getResult().size();
        progress.beginTask(NLS.bind((String)Messages.AggregationComposerEditor_AddingMembers, (Object)hits, (Object)aggregation), hits);
        Iterator iter = response.getResult().iterator();
        while (iter.hasNext()) {
            if (progress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object obj = iter.next();
            if (obj instanceof ResultType) {
                ObjectType oType = ((ResultType)obj).getObject();
                try {
                    if (oType.getGeneric().getProvided() != null) {
                        TextGridObject tgo = TextGridObject.getInstance((ObjectType)oType, (boolean)true, (boolean)true);
                        if (tgo.getContentTypeID().contains("aggregation")) {
                            Aggregation newAggregation = new Aggregation(actualRoot, tgo.getTitle(), tgo, this.getTargetProject());
                            this.fetchAggregation(tgo, progress, newAggregation);
                        } else {
                            TGOentry tgoEntry = new TGOentry(tgo.getURI().toString());
                            if (((ResultType)obj).getTextgridUri().contains(".")) {
                                tgoEntry.setLatest(false);
                            }
                            actualRoot.addChild(tgoEntry);
                            tgoEntry.setParent(actualRoot);
                        }
                    } else {
                        TGOentry tgoRestricted = new TGOentry(new RestrictedTextGridObject(oType.getGeneric().getGenerated().getTextgridUri().getValue()));
                        actualRoot.addChild(tgoRestricted);
                        tgoRestricted.setParent(actualRoot);
                    }
                }
                catch (CoreException e) {
                    Status status = new Status(4, "info.textgrid.lab.ui.core", NLS.bind((String)Messages.AggregationComposerEditor_EM_WhileRetrievingObjects, (Object)aggregation.toString()), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
            progress.worked(1);
        }
        this.setIsBusy(false);
        return Status.OK_STATUS;
    }

    public boolean getIsChanged() {
        return this.isChanged;
    }

    public void setIsChanged(boolean isChanged) {
        this.isChanged = isChanged;
        this.firePropertyChange(257);
    }

    private void setAggregationsToTargetProject(Aggregation actualRoot) {
        Object[] children = actualRoot.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Aggregation) {
                try {
                    if (((Aggregation)children[i]).getObject().getCreated() == null) {
                        this.setAggregationsToTargetProject((Aggregation)children[i]);
                    }
                }
                catch (CoreException e) {
                    AggregationsUIPlugin.handleError(e, Messages.AggregationComposerEditor_EM_AggregationContainsNoObject, new Object[0]);
                }
            }
            ++i;
        }
        actualRoot.getObject().setProject(this.getTargetProject());
    }

    public TextGridObject getLoadObject() {
        return this.loadObject;
    }

    public void setLoadObject(TextGridObject loadObject) {
        this.loadObject = loadObject;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public void setIsBusy(boolean value) {
        this.isBusy = value;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void doSave(IProgressMonitor monitor) {
        this.save(SaveType.STANDARD);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TextGridObject tgo = (TextGridObject)input.getAdapter(TextGridObject.class);
        if (tgo != null) {
            AggregationComposerEditorInput aggregationEditorInput = new AggregationComposerEditorInput(tgo);
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(aggregationEditorInput);
            try {
                this.targetProject = tgo.getProjectInstance();
                this.setViewerAndAggregationRoot();
                this.setLoadObject(tgo);
            }
            catch (CoreException e) {
                AggregationsUIPlugin.handleError(e, NLS.bind((String)Messages.AggregationComposerEditor_EM_NoProjectInstance, (Object)this.aggregationRoot.getObject().toString()), new Object[0]);
            }
        } else {
            AggregationsUIPlugin.handleError(new Exception(), Messages.AggregationComposerEditor_EM_NoValidEditorInput, new Object[0]);
        }
    }

    public boolean isDirty() {
        return this.isChanged;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void adaptPartInformation() {
        try {
            this.setPartName(this.aggregationRoot.getName());
            this.setTitleToolTip(String.valueOf(this.aggregationRoot.getName()) + " " + this.aggregationRoot.getObject().getContentType(true).getDescription());
            this.setTitleImage(this.aggregationRoot.getObject().getContentType(true).getImage(false));
        }
        catch (CoreException e) {
            AggregationsUIPlugin.handleError(e, NLS.bind((String)Messages.AggregationComposerEditor_EM_NoContentType, (Object)this.aggregationRoot.getObject().toString()), new Object[0]);
        }
    }

    protected class AddAggregationAction
    extends Action {
        private final TGContentType contentType;
        private IAggregationTypeAdapter extension;

        protected AddAggregationAction(TGContentType contentType, IConfigurationElement[] elements, int style) {
            super(contentType.getDescription(), style);
            this.setImageDescriptor(contentType.getImageDescriptor());
            this.contentType = contentType;
            this.setToolTipText(NLS.bind((String)"Add a new {0}.", (Object)contentType.getDescription()));
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getAttribute("contentType").equals(contentType.getId())) {
                    try {
                        this.extension = (IAggregationTypeAdapter)element.createExecutableExtension("class");
                        this.extension.init(contentType);
                        break;
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.aggregations.ui");
                    }
                }
                ++n2;
            }
        }

        public MenuItem createMenuItem(Menu menu, int style) {
            MenuItem item = new MenuItem(menu, 8);
            item.setImage(this.contentType.getImage(true));
            item.setText(this.contentType.getDescription());
            item.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AddAggregationAction.this.run();
                }
            });
            return item;
        }

        public void run() {
            AggregationComposerEditor.this.addSection(this.contentType, this.extension);
        }
    }

    class AggregationLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        AggregationLabelProvider() {
        }

        public StyledString getStyledText(Object obj) {
            StyledString styledString = new StyledString();
            String decoration = "";
            if (obj instanceof TGOentry) {
                try {
                    styledString.append(((TGOentry)obj).getTitle());
                    if (!((TGOentry)obj).getLatest() && ((TGOentry)obj).getRevision() == null) {
                        decoration = MessageFormat.format(" (Revision {0})", ((TGOentry)obj).getTgo().getRevisionNumber());
                        styledString.append(decoration, StyledString.DECORATIONS_STYLER);
                    } else if (((TGOentry)obj).getRevision() != null) {
                        decoration = MessageFormat.format(" (Revision {0})", ((TGOentry)obj).getRevision().getRevisionNumber());
                        styledString.append(decoration, StyledString.DECORATIONS_STYLER);
                    }
                }
                catch (CoreException e) {
                    AggregationsUIPlugin.handleError(e, Messages.AggregationComposerEditor_EM_TitleRetrieve, obj);
                }
            } else if (obj instanceof Aggregation) {
                styledString.append(((Aggregation)obj).toString());
                if (!((Aggregation)obj).getLatest()) {
                    decoration = MessageFormat.format(" (Revision {0})", ((Aggregation)obj).getObject().getRevisionNumber());
                    styledString.append(decoration, StyledString.DECORATIONS_STYLER);
                } else if (((Aggregation)obj).getRevision() != null) {
                    decoration = MessageFormat.format(" (Revision {0})", ((Aggregation)obj).getRevision().getRevisionNumber());
                    styledString.append(decoration, StyledString.DECORATIONS_STYLER);
                }
            } else {
                styledString.append(obj.toString());
            }
            return styledString;
        }

        public String getText(Object element) {
            return this.getStyledText(element).toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof TGOentry) {
                TGODefaultLabelProvider provider = new TGODefaultLabelProvider();
                if (!((TGOentry)obj).isRestrictedTextGridObject()) {
                    return provider.getImage((Object)((TGOentry)obj).getTgo());
                }
                return provider.getImage((Object)((TGOentry)obj).getRestrictedTgo());
            }
            if (obj instanceof Aggregation) {
                try {
                    String ContentType = ((Aggregation)obj).getObject().getContentTypeID();
                    return TGContentType.getContentType((String)ContentType).getImage(true);
                }
                catch (CoreException coreException) {
                    String imageKey = "IMG_OBJ_ELEMENTS";
                    return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
                }
            }
            String imageKey = "IMG_OBJ_FOLDER";
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }

    private static enum AggregationType {
        AGGREGATION,
        COLLECTION,
        EDITION;

    }

    public static enum SaveType {
        STANDARD,
        REVISION;

    }
}

