/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.navigator.Activator;
import info.textgrid.lab.navigator.Messages;
import info.textgrid.lab.navigator.NaviExpandedElements;
import info.textgrid.lab.navigator.filters.ContentFilter;
import info.textgrid.lab.navigator.filters.ProjectFilter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class NaviView
extends CommonNavigator {
    private Action action1;
    private IMemento memento;
    private static CommonViewer viewer;
    private TextGridObject.ITextGridObjectListener objectListener;
    private ITextGridProjectListener projectListener;
    private TGObjectReference.ITGObjectReferenceListener tgObjectReferenceListener;
    private AuthBrowser.ISIDChangedListener sidChangedListener;
    public static NavigatorSortModi sortModus;
    public static NavigatorSortSequence sortSequence;
    private static Map<TextGridObject, TGObjectReference> objectReferenceRegistry;

    static {
        sortSequence = NavigatorSortSequence.ASCENDING;
        objectReferenceRegistry = new ConcurrentHashMap<TextGridObject, TGObjectReference>();
    }

    public static void refreshNavigator() {
        NaviExpandedElements exElements = NaviExpandedElements.getInstance();
        exElements.setExpandedTreePaths(viewer.getExpandedTreePaths());
        objectReferenceRegistry.clear();
        TextGridProjectRoot.getInstance().reset();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = new CommonViewer(this.getViewSite().getId(), aParent, 268436226);
        this.initListeners((TreeViewer)aViewer);
        aViewer.getNavigatorContentService().restoreState(this.memento);
        aViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                NaviExpandedElements.getInstance().clear();
            }

            public void treeExpanded(TreeExpansionEvent event) {
                NaviExpandedElements.getInstance().clear();
            }
        });
        return aViewer;
    }

    protected IAdaptable getInitialInput() {
        viewer = this.getCommonViewer();
        ICommandService cmdService = (ICommandService)this.getSite().getService(ICommandService.class);
        String modusValue = (String)cmdService.getCommand("info.textgrid.lab.navigator.sortprojectcontent").getState("org.eclipse.ui.commands.radioState").getValue();
        try {
            sortModus = NavigatorSortModi.valueOf(modusValue);
        }
        catch (Exception exception) {
            sortModus = NavigatorSortModi.TITLE;
        }
        String sequenceValue = (String)cmdService.getCommand("info.textgrid.lab.navigator.sequenceorder").getState("org.eclipse.ui.commands.radioState").getValue();
        try {
            sortSequence = NavigatorSortSequence.valueOf(sequenceValue);
        }
        catch (Exception exception) {
            sortSequence = NavigatorSortSequence.ASCENDING;
        }
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x100000E) {
                    NaviView.refreshNavigator();
                }
            }
        });
        this.objectListener = new TextGridObject.ITextGridObjectListener(){

            public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
                TGObjectReference tgoRef = (TGObjectReference)objectReferenceRegistry.get(object);
                if (tgoRef == null && event != TextGridObject.ITextGridObjectListener.Event.CREATED) {
                    return;
                }
                switch (event) {
                    case DELETED: {
                        viewer.remove((Object)tgoRef);
                        objectReferenceRegistry.remove(object);
                        break;
                    }
                    case CREATED: {
                        try {
                            tgoRef = new TGObjectReference(object.getLatestURI(), object);
                            TGObjectReference.notifyListeners((TGObjectReference.ITGObjectReferenceListener.Event)TGObjectReference.ITGObjectReferenceListener.Event.NAVIGATOR_OBJECT_CREATED, (TGObjectReference)tgoRef);
                            if (object.getContentTypeID().equals("text/tg.projectfile+xml")) break;
                            if (!object.getRevisionNumber().equals("") && !object.getRevisionNumber().equals("0") || object.getContentTypeID().contains("aggregation")) {
                                try {
                                    viewer.refresh((Object)TextGridProject.getProjectInstance((String)object.getProject()));
                                    break;
                                }
                                catch (RemoteException e) {
                                    info.textgrid.lab.core.model.Activator.handleProblem((int)4, (Throwable)e, (String)"TextGridProject.getProjectInstance", (Object[])new Object[0]);
                                    break;
                                }
                                catch (ProjectDoesNotExistException projectDoesNotExistException) {
                                    throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format(Messages.NaviView_EM_ProjectDoesNotExist, this, object.getProject())));
                                }
                            }
                            viewer.add((Object)object.getProjectInstance(), (Object)tgoRef);
                        }
                        catch (CoreException e) {
                            info.textgrid.lab.core.model.Activator.handleError((Throwable)e, (String)Messages.NaviView_EM_CouldNotOpenNavigator, (Object[])new Object[]{object});
                        }
                        break;
                    }
                    case METADATA_CHANGED: 
                    case METADATA_SAVED: {
                        viewer.update((Object)tgoRef, null);
                    }
                }
            }
        };
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this.objectListener);
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            public void sidChanged(String newSID, String newEPPN) {
                NaviView.refreshNavigator();
            }
        };
        AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        this.projectListener = new ITextGridProjectListener(){

            public void textGridProjectChanged(ITextGridProjectListener.Event event, TextGridProject project) {
                if (event.equals((Object)ITextGridProjectListener.Event.CONTENT_CHANGED)) {
                    NaviView.refreshNavigator();
                } else if (event.equals((Object)ITextGridProjectListener.Event.NO_CHILDREN_CHECK)) {
                    viewer.setHasChildren((Object)project, false);
                }
            }
        };
        TextGridProject.addListener((ITextGridProjectListener)this.projectListener);
        this.tgObjectReferenceListener = new TGObjectReference.ITGObjectReferenceListener(){

            public void tgObjectReferenceChanged(TGObjectReference.ITGObjectReferenceListener.Event event, TGObjectReference object) {
                if (event.equals((Object)TGObjectReference.ITGObjectReferenceListener.Event.NAVIGATOR_OBJECT_CREATED)) {
                    objectReferenceRegistry.put(object.getTgo(), object);
                }
            }
        };
        TGObjectReference.addListener((TGObjectReference.ITGObjectReferenceListener)this.tgObjectReferenceListener);
        this.setFilters();
        return TextGridProjectRoot.getInstance();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NaviView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getCommonViewer().getControl());
        this.getCommonViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getCommonViewer());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                NaviView.refreshNavigator();
            }
        };
        OnlineStatus.IStatusChangeListener listener = new OnlineStatus.IStatusChangeListener(){

            public void statusChanged(boolean newStatus) {
                NaviView.this.action1.setEnabled(newStatus);
            }
        };
        OnlineStatus.addOnlineStatusChangeListener((OnlineStatus.IStatusChangeListener)listener);
        this.action1.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/resources/refresh.gif"));
        this.action1.setText(Messages.NaviView_Refresh);
        this.action1.setToolTipText(Messages.NaviView_Refresh);
        if (!OnlineStatus.isOnlineWithNotification((String)Messages.NaviView_IM_NeedToBeOnline)) {
            this.action1.setEnabled(false);
        }
    }

    private void hookDoubleClickAction() {
        this.getCommonViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)obj, TextGridObject.class);
                if (tgo != null) {
                    String contentType;
                    try {
                        contentType = tgo.getContentTypeID();
                    }
                    catch (CoreException coreException) {
                        contentType = "";
                    }
                    if (!contentType.contains("aggregation")) {
                        IHandlerService handlerService = (IHandlerService)NaviView.this.getSite().getService(IHandlerService.class);
                        try {
                            handlerService.executeCommand("info.textgrid.lab.ui.core.commands.Open", null);
                        }
                        catch (CommandException e) {
                            info.textgrid.lab.core.model.Activator.handleError((Throwable)e, (String)Messages.NaviView_EM_CouldNotOpenFor, (Object[])new Object[]{event});
                        }
                    }
                }
            }
        });
    }

    public void dispose() {
        AuthBrowser.removeSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        TextGridObject.removeListener((TextGridObject.ITextGridObjectListener)this.objectListener);
        TextGridProject.removeListener((ITextGridProjectListener)this.projectListener);
        super.dispose();
    }

    public ISelection getSelection() {
        return this.getCommonViewer().getSelection();
    }

    public void setSelection(ISelection sel, boolean reveal) {
        this.getCommonViewer().setSelection(sel, reveal);
    }

    public NavigatorSortModi getSortModus() {
        return sortModus;
    }

    public void setSortModus(NavigatorSortModi sortModus) {
        NaviView.sortModus = sortModus;
    }

    public static boolean isExpanded() {
        return viewer.getExpandedElements().length != 0;
    }

    public static void collapseAll() {
        viewer.collapseAll();
    }

    public static TGObjectReference getTGObjectReference(TextGridObject tgo) {
        return objectReferenceRegistry.get(tgo);
    }

    public static CommonViewer getViewer() {
        return viewer;
    }

    private void setFilters() {
        String content = Activator.getPreference("filterProject");
        if (!content.equals("")) {
            viewer.addFilter((ViewerFilter)new ProjectFilter(content));
        }
        if (!(content = Activator.getPreference("filterContentType")).equals("")) {
            viewer.addFilter((ViewerFilter)new ContentFilter(content));
        }
    }

    public static enum NavigatorSortModi {
        MODIFICATION_DATE,
        TITLE,
        TYPE,
        NOSORTING;

    }

    public static enum NavigatorSortSequence {
        ASCENDING,
        DESCENDING;

    }
}

