/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.locking;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.locking.LockingService;
import info.textgrid.lab.ui.core.locking.Messages;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import javax.xml.ws.WebServiceException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class LockingJob
extends Job {
    private final TextGridObject object;
    private final boolean message;
    private final String sid;
    private final TGCrudService crudServiceStub;
    private boolean locked;
    private boolean tryAgain;

    public LockingJob(String name, TextGridObject object, boolean message) {
        super(name);
        this.object = object;
        this.message = message;
        this.sid = RBACSession.getInstance().getSID(false);
        this.crudServiceStub = CrudClientUtilities.getCrudServiceStub();
        this.tryAgain = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            while (true) {
                try {
                    this.locked = this.crudServiceStub.lock(this.sid, "", this.object.getURI().toString());
                    if (!this.locked) {
                        if (this.message) {
                            UIJob uiJob = new UIJob("Locking Problem"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Locking Problem", (String)NLS.bind((String)Messages.LockingJob_IM_NoExclusiveAccess, (Object)LockingJob.this.object.toString()));
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        }
                        LockingService.getInstance().removeJobFromRegistry(this.object);
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (WebServiceException e) {
                    this.tryAgain = true;
                    UIJob uiJob = new UIJob("Locking Problem"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Locking Problem", null, NLS.bind((String)Messages.LockingJob_IM_NoConnection, (Object)LockingJob.this.object.toString()), 3, new String[]{Messages.LockingJob_Retry, Messages.LockingJob_Cancel}, 1);
                            int result = dialog.open();
                            if (result == 0) {
                                return Status.OK_STATUS;
                            }
                            LockingJob.this.tryAgain = false;
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                    try {
                        uiJob.join();
                        continue;
                    }
                    catch (InterruptedException e1) {
                        Activator.handleError(e, e1.getMessage(), this.object);
                        Activator.handleError(e, e.getMessage(), this.object);
                    }
                    if (this.tryAgain) continue;
                    Activator.handleError(e, NLS.bind((String)Messages.LockingJob_IM_PleaseRetry, (Object)this.object), this.object);
                    LockingService.getInstance().removeJobFromRegistry(this.object);
                    return Status.CANCEL_STATUS;
                }
                break;
            }
            this.schedule(1740000L);
        }
        catch (AuthFault e) {
            Activator.handleError(e, e.getMessage(), this.object);
        }
        catch (IoFault e) {
            Activator.handleError(e, e.getMessage(), this.object);
        }
        catch (ObjectNotFoundFault e) {
            Activator.handleError(e, e.getMessage(), this.object);
        }
        return Status.OK_STATUS;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

