/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import info.textgrid.lab.core.importexport.ImportPlugin;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.ui.ImportExportPart;
import info.textgrid.lab.core.importexport.ui.Messages;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ExportPart
extends ImportExportPart {
    protected boolean ignoreNextRootChange;

    @Override
    protected void createTopArea(Composite parent) {
        Composite topArea = new Composite(parent, 0);
        topArea.setLayoutData((Object)new GridData(4, 4, true, false));
        topArea.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(topArea, 64);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label.setText(Messages.ExportPart_Drop_Message);
        this.createRemoveButton(topArea);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getObjectsViewer().addDropSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ExportDropAdapter((Viewer)this.getObjectsViewer()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.core.importexport.ExportEditor");
    }

    public ExportPart() {
        this.setExport(true);
    }

    @Override
    protected Composite createTargetArea(Composite content) {
        Composite targetComposite = new Composite(content, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)targetComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(targetComposite);
        final Text targetText = new Text(targetComposite, 18436);
        targetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        targetText.setMessage(Messages.ExportPart_Target_directory);
        targetText.setEditable(false);
        targetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportPart.this.ignoreNextRootChange = true;
                ExportPart.this.getImportModel().setRoot((IPath)new Path(targetText.getText().trim()));
                ExportPart.this.getObjectsViewer().refresh(true);
            }
        });
        this.getImportModel().addListener(new ImportModel.ModelListener(){

            @Override
            public void rootChanged(ImportModel model, IPath oldRoot) {
                if (ExportPart.this.ignoreNextRootChange) {
                    ExportPart.this.ignoreNextRootChange = false;
                } else if (!targetText.isDisposed()) {
                    targetText.setText(model.getRoot().toOSString());
                }
            }
        });
        Button browseTargetButton = new Button(targetComposite, 8);
        browseTargetButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        browseTargetButton.setText(Messages.ExportPart_Browse);
        browseTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ExportPart.this.getSite().getShell());
                dialog.setMessage(Messages.ExportPart_Target_directory_desc);
                dialog.setText(Messages.ExportPart_Target_directory);
                dialog.setFilterPath(targetText.getText());
                String newPath = dialog.open();
                if (newPath != null) {
                    targetText.setText(newPath);
                }
            }
        });
        return targetComposite;
    }

    @Override
    protected void perform() {
        final ControlEnableState enableState = ControlEnableState.disable((Control)this.getContent());
        Job exportJob = new Job(Messages.ImportExportPart_Exporting){

            protected IStatus run(IProgressMonitor monitor) {
                return ExportPart.this.getImportModel().doExport(monitor);
            }
        };
        exportJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                new UIJob(Messages.ImportExportPart_Import_Done){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        (this).ExportPart.this.resultPage.setInput(event.getResult());
                        enableState.restore();
                        if (ImportPlugin.useNewGUI()) {
                            if (event.getResult().getSeverity() <= 2) {
                                ExportPart.this.setDirty(false);
                            }
                            (this).ExportPart.this.pages.showPage((Control)(this).ExportPart.this.resultPage);
                            ExportPart.this.getNextButton().setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        exportJob.setUser(true);
        exportJob.schedule();
    }

    private final class ExportDropAdapter
    extends ViewerDropAdapter {
        private ExportDropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }

        public boolean performDrop(Object data) {
            System.out.println("Dropped " + data);
            boolean result = false;
            if (data instanceof IStructuredSelection) {
                ExportPart.this.addSelection((IStructuredSelection)data);
                result = true;
            }
            return result;
        }
    }
}

