/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.swtutils;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.progress.IElementCollector;

public class ChunkingElementCollector
implements IElementCollector {
    private IElementCollector target;
    private int chunkSize;
    private ArrayList<Object> cache;

    public ChunkingElementCollector(IElementCollector target, int chunkSize) {
        this.target = target;
        this.chunkSize = chunkSize;
        this.cache = new ArrayList(chunkSize);
    }

    public void add(Object element, IProgressMonitor monitor) {
        this.cache.add(element);
        this.flushCacheIfFull(monitor);
    }

    private void flushCacheIfFull(IProgressMonitor monitor) {
        if (this.cache.size() >= this.chunkSize) {
            this.target.add(this.cache.toArray(), monitor);
            this.cache.clear();
        }
    }

    public void add(Object[] elements, IProgressMonitor monitor) {
        this.flushCacheIfFull(monitor);
        this.target.add(elements, monitor);
    }

    public void done() {
        this.target.add(this.cache.toArray(), null);
        this.cache.clear();
        this.target.done();
    }
}

