/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.form.Form;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.FormValidator;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/x-www-form-urlencoded", "multipart/form-data"})
@Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
@Provider
public class FormEncodingProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private FormValidator validator;
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;
    private String attachmentMaxSize;
    private boolean expectEncoded;

    public void setExpectedEncoded(boolean expect) {
        this.expectEncoded = expect;
    }

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public void setAttachmentMaxSize(String maxSize) {
        this.attachmentMaxSize = maxSize;
    }

    public void setValidator(FormValidator formValidator) {
        this.validator = formValidator;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations, mt);
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try {
            if (mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
                MultipartBody body = AttachmentUtils.getMultipartBody(this.mc);
                if (MultipartBody.class.isAssignableFrom(clazz)) {
                    return body;
                }
                if (Attachment.class.isAssignableFrom(clazz)) {
                    return body.getRootAttachment();
                }
            }
            MultivaluedMap<String, String> params = this.createMap(clazz);
            this.populateMap(params, annotations, is, mt, !this.keepEncoded(annotations));
            this.validateMap(params);
            this.persistParamsOnMessage(params);
            return this.getFormObject(clazz, params);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected boolean keepEncoded(Annotation[] anns) {
        return AnnotationUtils.getAnnotation(anns, Encoded.class) != null || this.expectEncoded;
    }

    protected void persistParamsOnMessage(MultivaluedMap<String, String> params) {
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null) {
            message.put("org.apache.cxf.form_data", params);
        }
    }

    protected MultivaluedMap<String, String> createMap(Class<?> clazz) throws Exception {
        if (clazz == MultivaluedMap.class || clazz == Form.class) {
            return new MetadataMap<String, String>();
        }
        return (MultivaluedMap)clazz.newInstance();
    }

    private Object getFormObject(Class<?> clazz, MultivaluedMap<String, String> params) {
        return Form.class.isAssignableFrom(clazz) ? new Form(params) : params;
    }

    protected void populateMap(MultivaluedMap<String, String> params, Annotation[] anns, InputStream is, MediaType mt, boolean decode) {
        if (mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE)) {
            MultipartBody body = AttachmentUtils.getMultipartBody(this.mc, this.attachmentDir, this.attachmentThreshold, this.attachmentMaxSize);
            FormUtils.populateMapFromMultipart(params, body, decode);
        } else {
            String enc = HttpUtils.getEncoding(mt, "UTF-8");
            FormUtils.populateMapFromString(params, FormUtils.readBody(is, enc), enc, decode, this.mc != null ? this.mc.getHttpServletRequest() : null);
        }
    }

    protected void validateMap(MultivaluedMap<String, String> params) {
        if (this.validator != null) {
            this.validator.validate(params);
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations, mt);
    }

    private boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return MultivaluedMap.class.isAssignableFrom(type) || Form.class.isAssignableFrom(type) || mt.getType().equalsIgnoreCase("multipart") && mt.isCompatible(MediaType.MULTIPART_FORM_DATA_TYPE) && (MultivaluedMap.class.isAssignableFrom(type) || Form.class.isAssignableFrom(type));
    }

    public void writeTo(Object obj, Class<?> c, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        MultivaluedMap map = (MultivaluedMap)(obj instanceof Form ? ((Form)obj).getData() : obj);
        boolean encoded = this.keepEncoded(anns);
        String enc = HttpUtils.getSetEncoding(mt, headers, "UTF-8");
        FormUtils.writeMapToOutputStream((Map<String, List<String>>)map, os, enc, encoded);
    }
}

