/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.dialogs;

import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.search.DeferredTreeContentProvider;
import info.textgrid.lab.ui.core.utils.CheckboxProjectNavigator;
import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class RegardMetadataDialog
extends TrayDialog {
    private static RegardMetadataDialog dialog;
    private CheckboxProjectNavigator projectTree;
    private ArrayList<TextGridProject> regardedProjects = new ArrayList();
    private ArrayList<TextGridProject> projects;
    private int returnCode;

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select Projects");
    }

    protected RegardMetadataDialog(Shell shell) {
        super(shell);
    }

    public static RegardMetadataDialog openFilterDialog(ArrayList<TextGridProject> projects) {
        RegardMetadataDialog d = new RegardMetadataDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        d.setShellStyle(68720);
        d.projects = projects;
        dialog = d;
        d.open();
        return d;
    }

    protected Control createDialogArea(Composite parent) {
        Group projectGroup = new Group(parent, 2048);
        projectGroup.setText("Which project specific metadata should be regarded in the search GUI?");
        GridLayout gl = new GridLayout(1, false);
        if (parent.getLayoutData() instanceof GridData) {
            GridData gdParent = (GridData)parent.getLayoutData();
            gdParent.verticalIndent = 15;
        }
        projectGroup.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 300;
        gd.widthHint = 500;
        projectGroup.setLayoutData((Object)gd);
        this.projectTree = new CheckboxProjectNavigator((Composite)projectGroup);
        this.projectTree.setContentProvider((IContentProvider)new RegardMetadataContentProvider());
        this.projectTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return parent;
    }

    protected void okPressed() {
        Object[] objectArray = this.projectTree.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof TextGridProject) {
                this.regardedProjects.add((TextGridProject)obj);
            }
            ++n2;
        }
        this.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        parent.setLayoutData((Object)gridData);
        Button selectAllButton = this.createButton(parent, 2, "Select All", false);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = RegardMetadataDialog.this.projectTree.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(true);
                    ++n2;
                }
            }
        });
        Button deselectAllButton = this.createButton(parent, 3, "Deselect All", false);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = RegardMetadataDialog.this.projectTree.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    item.setChecked(false);
                    ++n2;
                }
            }
        });
    }

    public void setProjectsChecked() {
        for (TextGridProject project : this.projects) {
            this.projectTree.setChecked((Object)project, true);
        }
    }

    public ArrayList<TextGridProject> getRegardedProjects() {
        return this.regardedProjects;
    }

    class RegardMetadataContentProvider
    extends DeferredTreeContentProvider {
        RegardMetadataContentProvider() {
        }

        public boolean hasChildren(Object element) throws IllegalStateException {
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            super.inputChanged(viewer, oldInput, newInput);
            this.getManager().addUpdateCompleteListener(this.getCompletionJobListener());
        }

        protected IJobChangeListener getCompletionJobListener() {
            return new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        dialog.setProjectsChecked();
                    }
                }
            };
        }
    }
}

