/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import com.google.common.collect.Maps;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.core.model.AbstractResource;
import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ITextGridPermission;
import info.textgrid.lab.core.model.ITextGridProjectListener;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.RBACServiceException;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.model.UserRole2;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.namespaces.middleware.tgauth.AddMemberRequest;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.BooleanResponse;
import info.textgrid.namespaces.middleware.tgauth.CreateProjectRequest;
import info.textgrid.namespaces.middleware.tgauth.CreateProjectResponse;
import info.textgrid.namespaces.middleware.tgauth.DeleteMemberRequest;
import info.textgrid.namespaces.middleware.tgauth.GetLeaderRequest;
import info.textgrid.namespaces.middleware.tgauth.GetProjectDescriptionRequest;
import info.textgrid.namespaces.middleware.tgauth.GetProjectDescriptionResponse;
import info.textgrid.namespaces.middleware.tgauth.GetUserRoleRequest;
import info.textgrid.namespaces.middleware.tgauth.GetUserRoleResponse;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.ProjectInfo;
import info.textgrid.namespaces.middleware.tgauth.RbacFault;
import info.textgrid.namespaces.middleware.tgauth.RolesetResponse;
import info.textgrid.namespaces.middleware.tgauth.SetProjectFileRequest;
import info.textgrid.namespaces.middleware.tgauth.TgAddActiveRoleRequest;
import info.textgrid.namespaces.middleware.tgauth.TgAssignedRolesRequest;
import info.textgrid.namespaces.middleware.tgauth.TgDropActiveRoleRequest;
import info.textgrid.namespaces.middleware.tgauth.UserRole;
import info.textgrid.namespaces.middleware.tgauth.UsersetResponse;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.progress.UIJob;

public class TextGridProject
extends AbstractResource
implements IAdaptable,
ITextGridPermission {
    public static final String TG_STANDARD_ROLE_PROJECTLEADER = "Projektleiter";
    public static final String TG_STANDARD_ROLE_ADMINISTRATOR = "Administrator";
    public static final String TG_STANDARD_ROLE_EDITOR = "Bearbeiter";
    public static final String TG_STANDARD_ROLE_WATCHER = "Beobachter";
    private int permissions = -1;
    private static PortTgextra stub = null;
    private ProjectInfo projectInfo;
    private ArrayList<UserRole2> userRole2Root = null;
    private Boolean iAmLeader = null;
    private final ArrayList<String> leaders = new ArrayList();
    private static ListenerList listeners = new ListenerList();
    private static Map<String, TextGridProject> registry = Maps.newHashMap();

    public void reset() {
        this.permissions = -1;
        this.userRole2Root = null;
        this.iAmLeader = null;
        this.leaders.clear();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextGridProject other = (TextGridProject)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Deprecated
    public static PortTgextra ensureStubIsLoaded() {
        return TextGridProject.getStub();
    }

    public static PortTgextra getStub() {
        if (stub == null) {
            stub = TgAuthClientUtilities.getTgAuthServiceStub();
        }
        return stub;
    }

    public static TextGridProject createNewProject(String name, String description) throws RemoteException {
        String sid = RBACSession.getInstance().getSID(true);
        String loggingParam = logsession.getInstance().getloginfo();
        CreateProjectRequest cprequest = new CreateProjectRequest();
        cprequest.setAuth(sid);
        cprequest.setLog(loggingParam);
        cprequest.setName(name);
        cprequest.setDescription(description);
        CreateProjectResponse cpresponse = null;
        cpresponse = TextGridProject.getStub().createProject(cprequest);
        ProjectInfo resultFromRbac = new ProjectInfo();
        resultFromRbac.setName(name);
        resultFromRbac.setDescription(description);
        resultFromRbac.setId(cpresponse.getProjectId());
        TextGridProject project = new TextGridProject(resultFromRbac);
        try {
            project.addMultiRolesToMember(RBACSession.getInstance().getEPPN(), new String[]{TG_STANDARD_ROLE_EDITOR, TG_STANDARD_ROLE_ADMINISTRATOR});
            project.activateRoleInSession(RBACSession.getInstance().getEPPN(), TG_STANDARD_ROLE_PROJECTLEADER);
        }
        catch (RbacFault rbacFault) {
            Status status = new Status(1, "info.textgrid.lab.core.model", "Did not fully add roles.");
            Activator.getDefault().getLog().log((IStatus)status);
        }
        new UIJob("Resetting project list"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                TextGridProjectRoot.getInstance().resetProjects();
                return Status.OK_STATUS;
            }
        }.schedule();
        TextGridProject.notifyListeners(ITextGridProjectListener.Event.CREATED, project);
        return project;
    }

    public static TextGridProject getProjectInstance(String id) throws RemoteException, ProjectDoesNotExistException, CrudServiceException {
        TextGridProject project = registry.get(id);
        if (project != null) {
            return project;
        }
        project = new TextGridProject(id);
        registry.put(id, project);
        return project;
    }

    public static TextGridProject getProjectInstance(ProjectInfo pi) throws RemoteException, NullPointerException {
        if (pi == null) {
            throw new NullPointerException("Cannot create a project from a null project info record.");
        }
        TextGridProject project = registry.get(pi.getId());
        if (project == null) {
            project = new TextGridProject(pi);
            registry.put(project.getId(), project);
        }
        return project;
    }

    protected TextGridProject(String id) throws ProjectDoesNotExistException, RBACServiceException {
        String sid = RBACSession.getInstance().getSID(false);
        String loggingParam = logsession.getInstance().getloginfo();
        TextGridProject.ensureStubIsLoaded();
        GetProjectDescriptionRequest prequest = new GetProjectDescriptionRequest();
        prequest.setAuth(sid);
        prequest.setLog(loggingParam);
        prequest.setProject(id);
        GetProjectDescriptionResponse presponse = TextGridProject.getStub().getProjectDescription(prequest);
        this.projectInfo = presponse.getProject();
        if (this.projectInfo == null) {
            throw new ProjectDoesNotExistException();
        }
    }

    protected TextGridProject(ProjectInfo pi) throws NullPointerException {
        if (pi == null) {
            throw new NullPointerException("Cannot create a project from an empty project info.");
        }
        this.projectInfo = pi;
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public String getId() {
        return this.projectInfo.getId();
    }

    public String getName() {
        return this.projectInfo.getName();
    }

    public String getDescription() {
        return this.projectInfo.getDescription();
    }

    public String getProjectfile() {
        return this.projectInfo.getFile();
    }

    public boolean setProjectfile(String PfURI) throws OfflineException, RemoteException, AuthenticationFault {
        if (PfURI.matches("^textgrid-newfile")) {
            Activator.handleProblem(2, null, String.valueOf(PfURI) + " is not saved to the Grid yet, cannot register it as Projectfile.", new Object[0]);
            return false;
        }
        String sid = RBACSession.getInstance().getSID(true);
        String loggingParam = logsession.getInstance().getloginfo();
        SetProjectFileRequest spfr = new SetProjectFileRequest();
        spfr.setAuth(sid);
        spfr.setLog(loggingParam);
        spfr.setProject(this.projectInfo.getId());
        spfr.setFile(PfURI);
        this.projectInfo.setFile(PfURI);
        BooleanResponse bo = TextGridProject.getStub().setProjectFile(spfr);
        if (bo.isResult()) {
            this.projectInfo.setFile(PfURI);
        }
        return bo.isResult();
    }

    public void unsetProjectFile() throws OfflineException, RemoteException, AuthenticationFault {
        this.setProjectfile("");
    }

    @Override
    public synchronized int getPermissions() throws CoreException {
        if (this.permissions >= 0) {
            return this.permissions;
        }
        this.permissions = this.retrievePermissions(this.getId());
        return this.permissions;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Boolean addMultiRolesToMember(String ePPN, String[] Roles) throws RemoteException, RbacFault {
        Boolean success = true;
        String[] stringArray = Roles;
        int n = Roles.length;
        int n2 = 0;
        while (n2 < n) {
            String Role = stringArray[n2];
            boolean singleSuccess = this.addRoleMember(ePPN, Role);
            if (!singleSuccess) {
                success = false;
            }
            ++n2;
        }
        return success;
    }

    public Boolean addRoleMember(String ePPN, String Role) throws RemoteException, RbacFault {
        String rbacsid = RBACSession.getInstance().getSID(false);
        AddMemberRequest addmemreq = new AddMemberRequest();
        addmemreq.setAuth(rbacsid);
        addmemreq.setLog("");
        addmemreq.setUsername(ePPN);
        String FQRoleName = String.valueOf(Role) + "," + this.projectInfo.getId() + "," + "Projekt-Teilnehmer";
        addmemreq.setRole(FQRoleName);
        BooleanResponse added = TextGridProject.getStub().addMember(addmemreq);
        if (!added.isResult()) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "There was no exception, but I could not add member " + ePPN + " in project " + this.projectInfo.getId());
            Activator.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    public boolean activateRoleInSession(String ePPN, String Role) throws RemoteException {
        String rbacsid = RBACSession.getInstance().getSID(false);
        String FQRoleName = String.valueOf(Role) + "," + this.projectInfo.getId() + "," + "Projekt-Teilnehmer";
        if (ePPN.equalsIgnoreCase(RBACSession.getInstance().getEPPN())) {
            TgAddActiveRoleRequest addSessionreq = new TgAddActiveRoleRequest();
            addSessionreq.setAuth(rbacsid);
            addSessionreq.setLog("");
            addSessionreq.setRole(FQRoleName);
            BooleanResponse addedToSession = TextGridProject.getStub().tgAddActiveRole(addSessionreq);
            if (!addedToSession.isResult()) {
                Status status = new Status(1, "info.textgrid.lab.core.model", "did not add role " + FQRoleName + " to session for user " + ePPN);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return true;
    }

    public Boolean deleteRole(String eppn, String role) {
        String rbacsid = RBACSession.getInstance().getSID(false);
        DeleteMemberRequest delmemreq = new DeleteMemberRequest();
        delmemreq.setAuth(rbacsid);
        delmemreq.setLog("");
        String FQRoleName = String.valueOf(role) + "," + this.projectInfo.getId() + "," + "Projekt-Teilnehmer";
        delmemreq.setRole(FQRoleName);
        delmemreq.setUsername(eppn);
        try {
            BooleanResponse deleted = TextGridProject.getStub().deleteMember(delmemreq);
            if (delmemreq.getUsername().equalsIgnoreCase(RBACSession.getInstance().getEPPN())) {
                TgDropActiveRoleRequest dropreq = new TgDropActiveRoleRequest();
                dropreq.setAuth(rbacsid);
                dropreq.setLog("");
                dropreq.setRole(FQRoleName);
                BooleanResponse dropped = TextGridProject.getStub().tgDropActiveRole(dropreq);
                if (!dropped.isResult()) {
                    Status status = new Status(4, "info.textgrid.lab.core.model", "could not drop role " + FQRoleName + " from session for user " + eppn);
                    Activator.getDefault().getLog().log((IStatus)status);
                }
            }
            if (!deleted.isResult()) {
                Status status = new Status(4, "info.textgrid.lab.core.model", "There was no exception, but I could not delete role " + FQRoleName + " from user " + eppn);
                Activator.getDefault().getLog().log((IStatus)status);
                return false;
            }
        }
        catch (Exception e2) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "Could not delete role " + FQRoleName + " from user " + eppn, (Throwable)e2);
            Activator.getDefault().getLog().log((IStatus)status);
            return false;
        }
        return true;
    }

    public String[] getAvailableRoles() {
        return new String[]{TG_STANDARD_ROLE_PROJECTLEADER, TG_STANDARD_ROLE_ADMINISTRATOR, TG_STANDARD_ROLE_EDITOR, TG_STANDARD_ROLE_WATCHER};
    }

    public ArrayList<UserRole2> getUserRoles2Offline() {
        return this.userRole2Root;
    }

    public ArrayList<UserRole2> getUserRoles2FromRBAC(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Fetching roles", (int)3);
        this.userRole2Root = new ArrayList();
        GetUserRoleRequest gur = new GetUserRoleRequest();
        gur.setAuth(RBACSession.getInstance().getSID(false));
        gur.setLog("");
        gur.setProject(this.projectInfo.getId());
        try {
            if (!progress.isCanceled()) {
                GetUserRoleResponse uRresponse = TextGridProject.getStub().getUserRole(gur);
                if (uRresponse.getUserRole() == null) {
                    return this.userRole2Root;
                }
                progress.worked(1);
                if (!progress.isCanceled()) {
                    List uRoles = uRresponse.getUserRole();
                    String me = RBACSession.getInstance().getEPPN();
                    boolean foundIAmLeader = false;
                    for (UserRole ur : uRoles) {
                        UserRole2 userNode = new UserRole2(ur.getUsername());
                        for (String r : ur.getRoles()) {
                            userNode.addRole(r);
                            if (!ur.getUsername().equalsIgnoreCase(me) || !r.equalsIgnoreCase(TG_STANDARD_ROLE_PROJECTLEADER)) continue;
                            foundIAmLeader = true;
                        }
                        this.userRole2Root.add(userNode);
                    }
                    this.iAmLeader = foundIAmLeader ? Boolean.TRUE : Boolean.FALSE;
                    progress.worked(2);
                    if (!progress.isCanceled()) {
                        ArrayList<String> users = new ArrayList<String>();
                        for (UserRole uR : uRresponse.getUserRole()) {
                            users.add(uR.getUsername());
                        }
                        RBACSession.getInstance().retrieveDetailsFromRBAC(users);
                        progress.worked(3);
                    }
                }
            }
        }
        catch (Exception e3) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "Could not retrieve users for project " + this.projectInfo.getName() + ", perhaps authenticated user is not Projektleiter?", (Throwable)e3);
            Activator.getDefault().getLog().log((IStatus)status);
            return this.userRole2Root;
        }
        return this.userRole2Root;
    }

    public static String[] filterRolesByProject(RolesetResponse roleset, String projectID) {
        ArrayList<String> rolesInProject = new ArrayList<String>();
        if (roleset != null && roleset.getRole() != null) {
            for (String fqRole : roleset.getRole()) {
                String[] parts = fqRole.split(",");
                if (!projectID.equals(parts[1])) continue;
                rolesInProject.add(parts[0]);
            }
        }
        return rolesInProject.toArray(new String[0]);
    }

    private List<String> getLeadersFromRBAC() {
        GetLeaderRequest gl = new GetLeaderRequest();
        gl.setProject(this.projectInfo.getId());
        gl.setAuth(RBACSession.getInstance().getSID(false));
        gl.setLog("");
        UsersetResponse pls = new UsersetResponse();
        try {
            pls = TextGridProject.getStub().getLeader(gl);
        }
        catch (Exception e4) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "Could not retrieve Project Leaders for project " + this.projectInfo.getId() + this.projectInfo.getName() + " for some reason...", (Throwable)e4);
            Activator.getDefault().getLog().log((IStatus)status);
            return new ArrayList<String>();
        }
        return pls.getUsername();
    }

    public boolean iAmLeader() {
        if (this.iAmLeader != null && !this.leaders.isEmpty()) {
            return this.iAmLeader;
        }
        boolean iAml = false;
        String me = RBACSession.getInstance().getEPPN();
        for (String l : this.getLeadersFromRBAC()) {
            this.leaders.add(l);
            if (!me.equalsIgnoreCase(l)) continue;
            iAml = true;
        }
        this.iAmLeader = iAml;
        return iAml;
    }

    public ArrayList<String> getLeaders() {
        this.iAmLeader();
        return this.leaders;
    }

    public static boolean checkForRole(String projectID, String roleToCheck) {
        try {
            TextGridProject.ensureStubIsLoaded();
        }
        catch (Exception e4) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "Could not contact tgAuth", (Throwable)e4);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        TgAssignedRolesRequest tgar = new TgAssignedRolesRequest();
        tgar.setAuth(RBACSession.getInstance().getSID(false));
        tgar.setLog("");
        tgar.setUsername("");
        RolesetResponse allPossibleRolesOfUser = new RolesetResponse();
        try {
            allPossibleRolesOfUser = TextGridProject.getStub().tgAssignedRoles(tgar);
        }
        catch (Exception e4) {
            Status status = new Status(4, "info.textgrid.lab.core.model", "Could not retrieve roles for this user for some reason...", (Throwable)e4);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        boolean result = false;
        String[] stringArray = TextGridProject.filterRolesByProject(allPossibleRolesOfUser, projectID);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String role = stringArray[n2];
            if (roleToCheck.equalsIgnoreCase(role)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static String findLabelForRBACRole(String role) {
        String label = role.equalsIgnoreCase(TG_STANDARD_ROLE_PROJECTLEADER) ? "Project Manager" : (role.equalsIgnoreCase(TG_STANDARD_ROLE_ADMINISTRATOR) ? "Authority to delete" : (role.equalsIgnoreCase(TG_STANDARD_ROLE_EDITOR) ? "Editor" : (role.equalsIgnoreCase(TG_STANDARD_ROLE_WATCHER) ? "Observer" : role)));
        return label;
    }

    public static void addListener(ITextGridProjectListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(ITextGridProjectListener listener) {
        listeners.remove((Object)listener);
    }

    public static void notifyListeners(final ITextGridProjectListener.Event event, final TextGridProject textGridProject) {
        UIJob job = new UIJob("Notifying TextGridProject listeners"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ITextGridProjectListener)listener).textGridProjectChanged(event, textGridProject);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }
}

