/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class TextGridObjectTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "textgrid-object-transfer-format" + new Long(System.currentTimeMillis()).toString();
    private static final int TYPEID = TextGridObjectTransfer.registerType((String)TYPE_NAME);
    private static final TextGridObjectTransfer INSTANCE = new TextGridObjectTransfer();
    private ISelection copiedSelection;
    private ArrayList<URI> selection;
    private long selectionSetTime;

    protected TextGridObjectTransfer() {
    }

    public static TextGridObjectTransfer getTransfer() {
        return INSTANCE;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public ISelection getCopiedSelection() {
        return this.copiedSelection;
    }

    public void setCopiedSelection(ISelection copiedSelection) {
        this.copiedSelection = copiedSelection;
    }

    public ArrayList<URI> getCopiedSelectionAsUriList() {
        ArrayList<URI> copiedTGObjects = new ArrayList<URI>();
        if (this.copiedSelection instanceof IStructuredSelection) {
            TextGridObject[] textGridObjects;
            IStructuredSelection structSel = (IStructuredSelection)this.copiedSelection;
            Object[] objects = structSel.toArray();
            TextGridObject[] textGridObjectArray = textGridObjects = (TextGridObject[])AdapterUtils.getAdapters((Object[])objects, TextGridObject.class, (boolean)false);
            int n = textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject tgo = textGridObjectArray[n2];
                copiedTGObjects.add(tgo.getURI());
                ++n2;
            }
            return copiedTGObjects;
        }
        return null;
    }

    public ArrayList<String> getCopiedSelectionAsStringList() {
        ArrayList<String> copiedTGObjects = new ArrayList<String>();
        if (this.copiedSelection instanceof IStructuredSelection) {
            TextGridObject[] textGridObjects;
            IStructuredSelection structSel = (IStructuredSelection)this.copiedSelection;
            Object[] objects = structSel.toArray();
            TextGridObject[] textGridObjectArray = textGridObjects = (TextGridObject[])AdapterUtils.getAdapters((Object[])objects, TextGridObject.class, (boolean)false);
            int n = textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject tgo = textGridObjectArray[n2];
                copiedTGObjects.add(tgo.getURI().toString());
                ++n2;
            }
            return copiedTGObjects;
        }
        return null;
    }

    public ArrayList<URI> getSelection() {
        return this.selection;
    }

    public void setSelection(ArrayList<URI> selection) {
        this.selection = selection;
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, "TextGridObjectTransfer", null));
        }
        return this.selection;
    }

    public long getSelectionSetTime() {
        return this.selectionSetTime;
    }

    public void setSelectionSetTime(long time) {
        this.selectionSetTime = time;
    }
}

