/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller;

import com.google.common.collect.HashBiMap;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.controller.Activator;
import info.textgrid.lab.linkeditor.controller.ILinkEditorListener;
import info.textgrid.lab.linkeditor.controller.Messages;
import info.textgrid.lab.linkeditor.controller.TEIDocParser;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEIDocFactory;
import info.textgrid.lab.linkeditor.controller.dialogs.SelectLinksobjectDialog;
import info.textgrid.lab.linkeditor.controller.dialogs.SelectNameLocationDialog;
import info.textgrid.lab.linkeditor.controller.utils.Pair;
import info.textgrid.lab.linkeditor.model.graphics.TGLayerManager;
import info.textgrid.lab.linkeditor.model.graphics.TGLine;
import info.textgrid.lab.linkeditor.model.graphics.TGPolygon;
import info.textgrid.lab.linkeditor.model.graphics.TGRectangle;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import info.textgrid.lab.linkeditor.model.links.ILink;
import info.textgrid.lab.linkeditor.model.links.LinksContainer;
import info.textgrid.lab.linkeditor.model.links.PolyLink;
import info.textgrid.lab.linkeditor.model.links.RectLink;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.locking.LockingService;
import info.textgrid.lab.ui.core.menus.OpenObjectService;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener3;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.jaxen.JaxenException;
import org.osgi.framework.Bundle;
import org.xml.sax.SAXException;

public class LinkEditorController
implements TextGridObject.ITextGridObjectListener,
IWorkbenchListener,
ISelectionListener,
IPartListener2,
IPerspectiveListener3,
ISelectionChangedListener,
IDocumentListener,
MouseListener {
    public static String LINK_EDITOR_TYPE = "text/linkeditorlinkedfile";
    public static String ANNOTATION_TYPE_SELECTED = "info.textgrid.lab.linkeditor.annotations.selected";
    public static String ANNOTATION_TYPE_UNSELECTED = "info.textgrid.lab.linkeditor.annotations.unselected";
    public static String XML_NS = "http://www.w3.org/XML/1998/namespace";
    private TextGridObject loaded_object = null;
    private TextGridObject selected_object = null;
    private String imageUri = "";
    private String textUri = "None";
    private TextGridProject selected_project = null;
    private String entered_title = "";
    private boolean changed_after_loading = false;
    private MessageBox msg_asking = null;
    private MessageBox msg_asking_2 = null;
    private MessageBox msg_info = null;
    private LinksContainer all_links = null;
    private List<ILinkEditorListener> listeners = null;
    private static LinkEditorController instance = null;
    private TGShape selectedShape = null;
    private List<TGShape> selectedShapes = Collections.synchronizedList(new ArrayList());
    private boolean showWarnings = true;
    private ITextEditor editor = null;
    private StyledText text = null;
    private IDocument doc = null;
    private IAnnotationModel annoModel = null;
    private String selectedText = null;
    private int selectedTextStart = -1;
    private int selectedTextLength = 0;
    public static String IMAGE_VIEW_ID = "edu.uky.mip.views.ImageView";
    private int openTabs = 1;
    private String focusedImageTabSecondaryId = "1";
    private boolean openInNewTab = false;
    private boolean openToolkit = true;
    private double lastSelectedDockingLineAngle = 0.0;
    private static final String defaultTGLayer = "0";
    private String currentLayer = "0";
    private static final int maxTGLayerNumber = 5;
    private HashBiMap<String, TGLayerManager> allLayerManager = HashBiMap.create();
    private final Map<String, String> imageTabsMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Point> imageInfoMap = Collections.synchronizedMap(new HashMap());
    private final Set<String> openXmlUris = Collections.synchronizedSet(new HashSet());
    private final Set<String> unsegmentedOpenXmlUris = Collections.synchronizedSet(new HashSet());
    private final Map<String, String> replacedRevisions = Collections.synchronizedMap(new HashMap());
    private Job readingTGOJob_addObject = null;
    private boolean isLoadingLinksObject = false;
    private Job readingTGOJob_readAnnotated = null;
    private String startAnchorId = "";
    private String endAnchorId = "";
    private boolean completeLoadNewProcess;
    private TextGridObject newTGObject = null;
    private TextGridObject object_save = null;
    private boolean save_done_successfully = true;
    private TextGridObject selected_object_dialog = null;
    private Job updateJob = null;
    private final Map<String, Point> startEndMap = Collections.synchronizedMap(new HashMap());
    private boolean linksInfoUpdated = false;
    private int oldCursorPos = 0;
    private boolean updateFlag = false;
    private boolean isReplacingText = false;
    private Set<String> saveDockingLinesUriList = Collections.synchronizedSet(new HashSet());
    private boolean textFileOpen = false;
    private boolean forceGettingEditor = false;
    private List<TGShape> allShapes = Collections.synchronizedList(new ArrayList());
    private Annotation selectedAnnotation = null;
    private TGShape.WRITING_MODE writingMode = TGShape.WRITING_MODE.NONE;
    private String localAnnotatedFilePath = "";
    private boolean saveNewFile = false;
    private volatile boolean workLocal = false;
    private String filePath = "";
    private boolean preShutdown = false;

    public static synchronized LinkEditorController getInstance() {
        if (instance == null) {
            instance = new LinkEditorController();
        }
        return instance;
    }

    private LinkEditorController() {
        this.all_links = new LinksContainer();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.msg_asking = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 452);
        this.msg_asking_2 = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 196);
        this.msg_info = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 34);
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this);
        Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener2)this);
        Workbench.getInstance().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
    }

    public void removeSelectedSelection() {
        this.notifyListeners(Event.REMOVE_SELECTED_SHAPES, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
    }

    void addLink(ILink link) {
        this.all_links.add(link);
    }

    void addResourceToLinkEditor(String uri_str, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            URI uri = new URI(uri_str);
            if (uri_str.startsWith("file")) {
                if (uri_str.endsWith(".xml")) {
                    this.openLocalXMLFile(this.getPathFromUri(uri));
                } else {
                    this.openLocalImageFile(this.getPathFromUri(uri));
                }
                return;
            }
            TextGridObject object = TextGridObject.getInstance((URI)uri, (boolean)false);
            if (object == null) {
                throw new IOException("Couldn't fetch the object using the URI: " + uri_str);
            }
            if (!object.isAccessible()) {
                throw new IOException("Access denied: The fetched object (" + uri_str + ") is not accessable!\n" + "To open this object you should have permission to read all used " + "xml- and image objects.");
            }
            this.openInNewTab = true;
            if (this.imageTabsMap.isEmpty()) {
                this.openTabs = 0;
            }
            if (object.getContentTypeID().contains("image")) {
                this.openToolkit = false;
                new UIJob("Opening a new image view tab..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                        try {
                            LinkEditorController linkEditorController = LinkEditorController.this;
                            int n = linkEditorController.openTabs + 1;
                            linkEditorController.openTabs = n;
                            page.showView(IMAGE_VIEW_ID, String.valueOf(n), 1);
                            return Status.OK_STATUS;
                        }
                        catch (PartInitException e) {
                            Activator.handleError(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                }.schedule();
            }
            this.readAddedTGObjectWaiting(object, monitor);
            if (!this.openInNewTab) {
                this.selected_object = null;
            }
            this.openToolkit = true;
            this.openInNewTab = false;
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e);
        }
    }

    public void addObjectToLinkEditor(final TextGridObject object, boolean doubleClicked, boolean openInTab) {
        block12: {
            try {
                if (doubleClicked && SelectLinksobjectDialog.openDialog(LinkEditorController.getInstance(), object)) {
                    if (this.selected_object_dialog != null) {
                        this.openAnnotatedObject(this.selected_object_dialog);
                    } else {
                        this.addObjectToLinkEditor(object, false, openInTab);
                    }
                    break block12;
                }
                this.openInNewTab = false;
                if (openInTab) {
                    this.openInNewTab = true;
                    if (this.imageTabsMap.isEmpty()) {
                        this.openTabs = 0;
                    }
                    if (object.getContentTypeID().contains("image")) {
                        String uri_str = object.getURI().toString();
                        try {
                            for (Map.Entry<String, String> entry : this.imageTabsMap.entrySet()) {
                                if (!entry.getValue().equals(uri_str)) continue;
                                String key = entry.getKey();
                                IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                                page.showView(IMAGE_VIEW_ID, key, 1);
                                this.openInNewTab = false;
                                return;
                            }
                            this.openToolkit = false;
                            IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                            page.showView(IMAGE_VIEW_ID, String.valueOf(++this.openTabs), 1);
                        }
                        catch (CoreException e) {
                            Activator.handleError(e);
                            this.openInNewTab = false;
                            return;
                        }
                    }
                }
                if (this.readingTGOJob_addObject != null) {
                    this.readingTGOJob_addObject.cancel();
                }
                this.readingTGOJob_addObject = new Job(NLS.bind((String)"Opening {0}.....", (Object)object.getTitle())){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        try {
                            monitor.beginTask(NLS.bind((String)"Fetching {0}.....", (Object)object.getTitle()), 100);
                            LinkEditorController.this.readAddedTGObject(object, monitor);
                            if (!LinkEditorController.this.openInNewTab) {
                                LinkEditorController.this.selected_object = null;
                            }
                            LinkEditorController.this.openToolkit = true;
                            LinkEditorController.this.openInNewTab = false;
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                        catch (CoreException e) {
                            Activator.handleError(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                };
                this.readingTGOJob_addObject.setUser(true);
                this.readingTGOJob_addObject.schedule();
            }
            catch (CoreException e1) {
                Activator.handleError(e1);
            }
        }
    }

    public void openAnnotatedObject(TextGridObject object) {
        try {
            this.loaded_object = object;
            this.readAnnotatedObject();
        }
        catch (ParserConfigurationException e) {
            Activator.handleError(e);
        }
        catch (SAXException e) {
            Activator.handleError(e);
        }
        catch (IOException e) {
            Activator.handleError(e);
        }
        catch (CoreException e) {
            Activator.handleError(e);
        }
        catch (javax.xml.parsers.FactoryConfigurationError e) {
            Activator.handleError(e);
        }
        catch (XMLStreamException e) {
            Activator.handleError(e);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e);
        }
    }

    private synchronized void loadTGOImage(TextGridObject tgObj, InputStream input, String uri, String title, String contentTypeId) {
        try {
            Image img_TGO = null;
            if ("image/tiff".equals(contentTypeId) || "image/tif".equals(contentTypeId)) {
                File temp = null;
                FileOutputStream out = null;
                try {
                    temp = File.createTempFile("tble_", ".tiff");
                    try {
                        out = new FileOutputStream(temp);
                        int read = 0;
                        byte[] bytes = new byte[1024];
                        while ((read = input.read(bytes)) != -1) {
                            ((OutputStream)out).write(bytes, 0, read);
                        }
                    }
                    finally {
                        if (out != null) {
                            out.flush();
                            ((OutputStream)out).close();
                        }
                    }
                    img_TGO = new Image((Device)PlatformUI.getWorkbench().getDisplay(), temp.getAbsolutePath());
                }
                finally {
                    if (input != null) {
                        input.close();
                    }
                    if (temp != null) {
                        temp.delete();
                    }
                }
            }
            try {
                img_TGO = new Image((Device)PlatformUI.getWorkbench().getDisplay(), input);
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            int imageWidth = img_TGO.getBounds().width;
            int imageHeight = img_TGO.getBounds().height;
            this.imageUri = uri;
            this.imageInfoMap.put(uri, new Point(imageWidth, imageHeight));
            if (this.imageTabsMap.isEmpty()) {
                this.openTabs = 1;
                this.openToolkit = false;
                Workbench.getInstance().getActiveWorkbenchWindow().getActivePage().showView(IMAGE_VIEW_ID, String.valueOf(this.openTabs), 1);
                this.openToolkit = true;
            }
            this.notifyListeners(Event.LOAD_IMAGE, new Pair<String, Image>(this.focusedImageTabSecondaryId, img_TGO));
            this.notifyListeners(Event.SET_IMAGE_URI, new Pair<String, String>(this.focusedImageTabSecondaryId, this.imageUri));
            this.notifyListeners(Event.SET_TITLE_LABEL, new Pair<String, String>(this.focusedImageTabSecondaryId, title));
            this.notifyListeners(Event.SET_TYPE_LABEL, new Pair<String, String>(this.focusedImageTabSecondaryId, contentTypeId));
            if (this.isLoadingLinksObject && this.loaded_object != null) {
                this.notifyListeners(Event.SET_LINKS_OBJECT_LABEL, new Pair<String, String>(this.focusedImageTabSecondaryId, "Object: " + this.loaded_object.getProjectInstance().getName() + "/" + this.loaded_object.getTitle()));
            } else if (this.isLoadingLinksObject && this.localAnnotatedFilePath != null && !"".equals(this.localAnnotatedFilePath)) {
                this.notifyListeners(Event.SET_LINKS_OBJECT_LABEL, new Pair<String, String>(this.focusedImageTabSecondaryId, "File: " + this.localAnnotatedFilePath));
            }
            this.notifyListeners(Event.SET_SELECTED_OBJECT, new Pair<String, TextGridObject>(this.focusedImageTabSecondaryId, tgObj));
            this.imageTabsMap.put(this.focusedImageTabSecondaryId, this.imageUri);
        }
        catch (CoreException e) {
            Activator.handleError(e, "An Error occured while loading an image.\n\n" + e.toString(), new Object[0]);
        }
        catch (SWTException e) {
            Activator.handleError(e, "Couldn't create the image from the inputStream...", new Object[0]);
        }
        catch (IOException e) {
            Activator.handleError(e, "An Error occured while loading an image.\n\n" + e.toString(), new Object[0]);
        }
    }

    public void testhOCR() {
        String focusedUri = this.imageTabsMap.get(this.focusedImageTabSecondaryId);
        Point widthHeight = this.imageInfoMap.get(focusedUri);
        System.err.println(String.valueOf(widthHeight.x) + "         " + widthHeight.y);
        Path path = new Path("test.xml");
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)path, null);
        InputStream in = null;
        try {
            try {
                url = FileLocator.resolve((URL)url);
                in = url.openStream();
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String s = null;
                String text = "";
                while ((s = reader.readLine()) != null) {
                    text = String.valueOf(text) + s + "\n";
                }
                Pattern p = Pattern.compile("<span.+?>");
                Matcher m = p.matcher(text);
                String ct = "";
                String[] coords = new String[4];
                while (m.find()) {
                    ct = m.group();
                    ct = ct.replaceAll(".+?bbox\\s", "").replaceAll("'>", "");
                    coords = ct.split(" ", 4);
                    int x0 = Integer.valueOf(coords[0]);
                    int y0 = Integer.valueOf(coords[1]);
                    int x1 = Integer.valueOf(coords[2]);
                    int y1 = Integer.valueOf(coords[3]);
                    TGRectangle shape = new TGRectangle(x0, Math.abs(widthHeight.y - y0), x1 - x0, Math.abs(y1 - y0), focusedUri);
                    this.notifyListeners(Event.ADD_SHAPE, new Pair<String, TGRectangle>(this.focusedImageTabSecondaryId, shape));
                }
            }
            catch (Exception e) {
                Activator.handleError(e);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        Activator.handleWarning(e2);
                    }
                }
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Activator.handleWarning(e);
                }
            }
        }
    }

    public void setImageTabClosed(String secondaryId) {
        this.imageTabsMap.remove(secondaryId);
    }

    private synchronized void loadTGOXML(IFileEditorInput input, TGContentType contentType, String uri, String fileName, TextGridObject tgo) {
        OpenObjectService.getInstance().openObject(tgo, 2, false);
    }

    private void readAddedTGObjectWaiting(final TextGridObject added_object, IProgressMonitor monitor) throws CoreException {
        if (added_object == null) {
            return;
        }
        IFile file = (IFile)added_object.getAdapter(IFile.class);
        final String uri = added_object.getURI().toString();
        final String contentTypeId = added_object.getContentTypeID();
        final String title = added_object.getTitle();
        if (contentTypeId.contains("image")) {
            if (!this.openInNewTab) {
                this.all_links.clear();
                this.selectedShape = null;
            }
            final InputStream input = file.getContents(true);
            UIJob openImgJob = new UIJob(NLS.bind((String)"Opening the image object {0}...", (Object)title)){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkEditorController.this.loadTGOImage(added_object, input, uri, title, contentTypeId);
                    if (!LinkEditorController.this.isLoadingLinksObject) {
                        LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                    }
                    return Status.OK_STATUS;
                }
            };
            openImgJob.setUser(true);
            openImgJob.schedule();
            try {
                openImgJob.join();
            }
            catch (InterruptedException e) {
                Activator.handleWarning(e, "Job interrupted!", new Object[0]);
            }
        } else {
            if (!this.openInNewTab) {
                this.all_links.clear();
                this.selectedTextStart = -1;
                this.selectedTextLength = 0;
            }
            TGContentType contentType = added_object.getContentType(false);
            FileEditorInput fileInput = new FileEditorInput(file);
            String fileName = file.getName();
            UIJob openingxmlJob = new UIJob(NLS.bind((String)"Opening the xml object {0}...", (Object)title), (IFileEditorInput)fileInput, contentType, uri, fileName, added_object){
                private final /* synthetic */ IFileEditorInput val$fileInput;
                private final /* synthetic */ TGContentType val$contentType;
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$fileName;
                private final /* synthetic */ TextGridObject val$added_object;
                {
                    this.val$fileInput = iFileEditorInput;
                    this.val$contentType = tGContentType;
                    this.val$uri = string;
                    this.val$fileName = string2;
                    this.val$added_object = textGridObject;
                    super($anonymous0);
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkEditorController.this.loadTGOXML(this.val$fileInput, this.val$contentType, this.val$uri, this.val$fileName, this.val$added_object);
                    return Status.OK_STATUS;
                }
            };
            openingxmlJob.setUser(false);
            openingxmlJob.schedule();
        }
    }

    private void readAddedTGObject(final TextGridObject added_object, IProgressMonitor monitor) throws CoreException {
        if (added_object == null) {
            return;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.worked(20);
        IFile file = (IFile)added_object.getAdapter(IFile.class);
        final String uri = added_object.getURI().toString();
        final String contentTypeId = added_object.getContentTypeID();
        monitor.worked(20);
        if (contentTypeId.contains("image")) {
            if (!this.openInNewTab) {
                this.all_links.clear();
                this.selectedShape = null;
            }
            final InputStream input = file.getContents(true);
            final String title = added_object.getTitle();
            new UIJob("Opening an image object..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkEditorController.this.loadTGOImage(added_object, input, uri, title, contentTypeId);
                    if (!LinkEditorController.this.isLoadingLinksObject) {
                        LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            if (!this.openInNewTab) {
                this.all_links.clear();
                this.selectedTextStart = -1;
                this.selectedTextLength = 0;
            }
            TGContentType contentType = added_object.getContentType(false);
            FileEditorInput fileInput = new FileEditorInput(file);
            String fileName = file.getName();
            new UIJob("Opening an xml object...", (IFileEditorInput)fileInput, contentType, uri, fileName, added_object){
                private final /* synthetic */ IFileEditorInput val$fileInput;
                private final /* synthetic */ TGContentType val$contentType;
                private final /* synthetic */ String val$uri;
                private final /* synthetic */ String val$fileName;
                private final /* synthetic */ TextGridObject val$added_object;
                {
                    this.val$fileInput = iFileEditorInput;
                    this.val$contentType = tGContentType;
                    this.val$uri = string;
                    this.val$fileName = string2;
                    this.val$added_object = textGridObject;
                    super($anonymous0);
                }

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkEditorController.this.loadTGOXML(this.val$fileInput, this.val$contentType, this.val$uri, this.val$fileName, this.val$added_object);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void reset(boolean ask) {
        if (ask && this.changed_after_loading && this.showWarnings) {
            this.msg_asking.setMessage("Do you want to save the current changes before reseting the Text-Image-Link Editor?");
            this.msg_asking.setText("Save current changes?");
            int result = this.msg_asking.open();
            if (result == 64) {
                this.saveAnnotatedObject(false, false, true);
            } else {
                if (result != 128) return;
                this.doRevertAllXMLEditorsToSaved();
                this.setChangedAfterLoading_AllImageViews(false);
            }
        } else if (ask) {
            this.msg_asking_2.setMessage("Do you really want to reset the Text-Image-Link Editor?");
            this.msg_asking_2.setText("Reset Text-Image-Link Editor?");
            int result = this.msg_asking_2.open();
            if (result != 64) {
                return;
            }
        }
        this.selected_object = null;
        this.notifyListeners(Event.REMOVE_ALL_SHAPES, new Pair<String, Object>("all", null));
        this.selectedShape = null;
        this.selectedTextStart = -1;
        this.selectedTextLength = 0;
        this.imageUri = "";
        this.textUri = "None";
        this.annoModel = null;
        this.text = null;
        this.doc = null;
        this.editor = null;
        this.setChangedAfterLoading_AllImageViews(false);
        this.closeAllXMLEditors(true);
        this.closeAllImageViews();
        this.changed_after_loading = false;
        this.workLocal = false;
        this.allLayerManager.clear();
        this.localAnnotatedFilePath = "";
        this.isReplacingText = false;
        this.object_save = null;
        this.newTGObject = null;
        this.saveNewFile = false;
        this.all_links.clear();
        this.selectedShapes.clear();
        this.allShapes.clear();
        this.imageInfoMap.clear();
        this.imageTabsMap.clear();
        this.startEndMap.clear();
        this.openXmlUris.clear();
        this.unsegmentedOpenXmlUris.clear();
        this.replacedRevisions.clear();
        this.linksInfoUpdated = false;
        this.updateFlag = false;
        System.err.println("reseted...");
    }

    private void readAnnotatedObject() throws ParserConfigurationException, SAXException, CoreException, XMLStreamException, FactoryConfigurationError, UnsupportedEncodingException, IOException, URISyntaxException {
        if (this.loaded_object == null) {
            return;
        }
        if (this.changed_after_loading && this.showWarnings) {
            this.msg_asking.setMessage(Messages.LinkEditorController_Mess_ChangedAfterLoading_Object);
            this.msg_asking.setText(Messages.LinkEditorController_Title_ChangedAfterLoading_Obj);
            int result = this.msg_asking.open();
            if (result == 64) {
                this.saveReadAnnotatedObject(false, false);
                return;
            }
            if (result == 128) {
                this.doRevertAllXMLEditorsToSaved();
                this.setChangedAfterLoading_AllImageViews(false);
            } else {
                return;
            }
        }
        if (this.readingTGOJob_readAnnotated != null) {
            this.readingTGOJob_readAnnotated.cancel();
        }
        this.readingTGOJob_readAnnotated = new Job(NLS.bind((String)"Opening {0}.....", (Object)this.loaded_object.getTitle())){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask(NLS.bind((String)"Opening {0}.....", (Object)LinkEditorController.this.loaded_object.getTitle()), 100);
                    IFile file = (IFile)LinkEditorController.this.loaded_object.getAdapter(IFile.class);
                    monitor.worked(10);
                    InputStream inputStream = file.getContents(true);
                    monitor.worked(60);
                    UIJob resetJob = new UIJob("Cleaning the screen..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            LinkEditorController.this.reset(false);
                            return Status.OK_STATUS;
                        }
                    };
                    resetJob.schedule();
                    try {
                        resetJob.join();
                    }
                    catch (InterruptedException e) {
                        Activator.handleError(e);
                    }
                    TEIDocParser parser = new TEIDocParser();
                    LinkEditorController.this.isLoadingLinksObject = true;
                    parser.parse(inputStream, monitor);
                    LinkEditorController.this.selected_object = LinkEditorController.this.loaded_object;
                    LinkEditorController.this.loaded_object = null;
                    LinkEditorController.this.workLocal = false;
                    LinkEditorController.this.isLoadingLinksObject = false;
                    LinkEditorController.this.linksInfoUpdated = false;
                    new UIJob("Finalizing the loading process..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (LinkEditorController.this.selectedShape != null) {
                                LinkEditorController.this.jumpToText(LinkEditorController.this.selectedShape, true);
                            }
                            LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                            LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                            new UIJob("Updating text segments..."){

                                public IStatus runInUIThread(IProgressMonitor arg0) {
                                    LinkEditorController.this.updateTextSegments();
                                    LinkEditorController.this.unsegmentedOpenXmlUris.remove(LinkEditorController.this.textUri);
                                    LinkEditorController.this.updateFlag = true;
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (JaxenException e) {
                    Activator.handleError(e);
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
                catch (XMLStreamException e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.readingTGOJob_readAnnotated.setUser(false);
        this.readingTGOJob_readAnnotated.schedule();
    }

    public void setFocusedTab(String tabSecondaryId) {
        if (tabSecondaryId.equals(this.focusedImageTabSecondaryId)) {
            return;
        }
        if (!this.isLoadingLinksObject) {
            this.notifyListeners(Event.CLOSE_TOOLKIT, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
        }
        this.focusedImageTabSecondaryId = tabSecondaryId;
        if (this.openToolkit && !this.isLoadingLinksObject) {
            this.notifyListeners(Event.OPEN_TOOLKIT, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
        }
    }

    public void setCountDiffLabel(int count) {
        this.notifyListeners(Event.SET_COUNT, new Pair<String, Boolean>("all", false));
        if (count > 0) {
            this.notifyListeners(Event.SET_COUNT, new Pair<String, Boolean>(this.focusedImageTabSecondaryId, true));
        }
    }

    public void setAngleLabel(boolean visible, double angle) {
        Pair<Boolean, Double> p = new Pair<Boolean, Double>(visible, angle);
        this.notifyListeners(Event.SET_ANGLE, new Pair<String, Pair<Boolean, Double>>(this.focusedImageTabSecondaryId, p));
    }

    public void setLayerLabel(boolean visible, String layer) {
        Pair<Boolean, String> p = new Pair<Boolean, String>(visible, layer);
        this.notifyListeners(Event.SET_LAYER, new Pair<String, Pair<Boolean, String>>(this.focusedImageTabSecondaryId, p));
    }

    public double getLastSelectedDockingLineAngle() {
        return this.lastSelectedDockingLineAngle;
    }

    public String getCurrentLayer() {
        return this.currentLayer;
    }

    public void setCurrentLayer(String currentLayer) {
        this.currentLayer = currentLayer;
    }

    public static String getDefaultLayer() {
        return defaultTGLayer;
    }

    public void setLastSelectedDockingLineAngle(double lastSelectedDockingLineAngle) {
        this.lastSelectedDockingLineAngle = lastSelectedDockingLineAngle;
    }

    public void setAddActionStatus(Object obj) {
        if (obj instanceof TGLine) {
            this.notifyListeners(Event.SET_VISIBILITY_OF_CREATELINK, new Pair<String, Boolean>(this.focusedImageTabSecondaryId, false));
        } else {
            this.notifyListeners(Event.SET_VISIBILITY_OF_CREATELINK, new Pair<String, Boolean>(this.focusedImageTabSecondaryId, true));
        }
    }

    public void setshowWarnings(boolean show) {
        this.showWarnings = show;
    }

    public boolean showWarnings() {
        return this.showWarnings;
    }

    private String generateId() {
        if (this.doc != null) {
            String text = this.doc.get();
            int id_nr = 1;
            while (text.matches("(?s).*id\\s*=\\s*\"a" + id_nr + "\".*")) {
                ++id_nr;
            }
            return "a" + id_nr;
        }
        return null;
    }

    private Pair<String, String> generateAnchorIds() {
        if (this.doc != null) {
            String text = this.doc.get();
            int id_nr1 = 1;
            while (text.matches("(?s).*id\\s*=\\s*\"a" + id_nr1 + "_start" + "\".*")) {
                ++id_nr1;
            }
            int i1 = 1;
            int i2 = 2;
            for (ILink l : this.all_links) {
                if (!this.textUri.equals(l.getTextUri())) continue;
                String s1 = l.getStartAnchorId();
                String s2 = l.getEndAnchorId();
                if (s1 != null && !"".equals(s1) && s1.matches("^.\\d+$")) {
                    i1 = Integer.parseInt(s1.substring(1));
                }
                if (s2 != null && !"".equals(s2) && s2.matches("^.\\d+$")) {
                    i2 = Integer.parseInt(s2.substring(1));
                }
                if (i1 >= id_nr1) {
                    id_nr1 = i1 + 1;
                }
                if (i2 < id_nr1) continue;
                id_nr1 = i2 + 1;
            }
            while (text.matches("(?s).*id\\s*=\\s*\"a" + id_nr1 + "_end" + "\".*")) {
                ++id_nr1;
            }
            this.startAnchorId = "a" + id_nr1 + "_start";
            this.endAnchorId = "a" + id_nr1 + "_end";
            return new Pair<String, String>(this.startAnchorId, this.endAnchorId);
        }
        return null;
    }

    private String annotateText(String text) throws RuntimeException {
        Pair<String, String> ids = this.generateAnchorIds();
        if (ids == null) {
            throw new RuntimeException("ids == null");
        }
        return "<anchor xml:id=\"" + ids.getValue1() + "\" />" + text + "<anchor xml:id=\"" + ids.getValue2() + "\" />";
    }

    public boolean addNewLink() throws RuntimeException {
        if (this.textFileOpen) {
            this.msg_info.setText("");
            this.msg_info.setMessage("To use this tool you should use XML-Text!");
            this.msg_info.open();
            return false;
        }
        if (this.selectedShape == null || this.selectedTextStart < 0 || this.selectedTextStart < 0 && this.selectedTextLength <= 0) {
            this.msg_info.setText("");
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_SelectShapeText);
            this.msg_info.open();
            return false;
        }
        if (this.textUri.startsWith("textgrid-newfile")) {
            this.msg_info.setText("");
            this.msg_info.setMessage("The current active xml-object is not persistent!\nPlease save it then try again.");
            this.msg_info.open();
            return false;
        }
        ElementImpl selectedNode = this.getSelectedXMLNode(this.selectedTextStart);
        boolean isNodeSelected = false;
        boolean idAvailable = false;
        String nodeId = null;
        boolean add = true;
        String annotatedText = null;
        if (selectedNode != null && !"".equals(selectedNode.getLocalName())) {
            if (selectedNode.hasAttribute("xml:id")) {
                nodeId = selectedNode.getAttribute("xml:id");
                idAvailable = true;
            } else {
                nodeId = this.generateId();
                if (nodeId == null) {
                    throw new RuntimeException("nodeId == null");
                }
            }
            isNodeSelected = true;
            this.startAnchorId = nodeId;
            this.endAnchorId = "";
        } else if (this.selectedTextLength <= 0) {
            this.msg_info.setText("");
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_SelectShapeText);
            this.msg_info.open();
            return false;
        }
        if (!isNodeSelected) {
            annotatedText = this.annotateText(this.selectedText);
        }
        for (ILink a : this.all_links) {
            TGShape s = a.getShape();
            if (s != null && s.equals((Object)this.selectedShape)) {
                if (this.showWarnings) {
                    this.msg_asking_2.setMessage(Messages.LinkEditorController_Mess_EditExistingLink);
                    this.msg_asking_2.setText(Messages.LinkEditorController_Title_EditExistingLink);
                    if (this.msg_asking_2.open() == 64) {
                        try {
                            if (isNodeSelected) {
                                if (!idAvailable) {
                                    selectedNode.setAttributeNS(XML_NS, "xml:id", this.startAnchorId);
                                    this.linksInfoUpdated = true;
                                }
                            } else {
                                this.isReplacingText = true;
                                this.doc.replace(this.selectedTextStart, this.selectedTextLength, annotatedText);
                                this.linksInfoUpdated = true;
                                this.isReplacingText = false;
                            }
                            if (!a.getStartAnchorId().equals(this.startAnchorId)) {
                                this.removeSegmentFromXMLEditor(a, true);
                            }
                            this.all_links.edit(a, this.startAnchorId, this.endAnchorId);
                        }
                        catch (BadLocationException e) {
                            Activator.handleError(e);
                            return false;
                        }
                    }
                    return false;
                }
                try {
                    if (isNodeSelected) {
                        if (!idAvailable) {
                            selectedNode.setAttributeNS(XML_NS, "xml:id", this.startAnchorId);
                            this.linksInfoUpdated = true;
                        }
                    } else {
                        this.isReplacingText = true;
                        this.doc.replace(this.selectedTextStart, this.selectedTextLength, annotatedText);
                        this.linksInfoUpdated = true;
                        this.isReplacingText = false;
                    }
                    this.removeSegmentFromXMLEditor(a, true);
                    this.all_links.edit(a, this.startAnchorId, this.endAnchorId);
                }
                catch (BadLocationException e) {
                    Activator.handleError(e);
                    return false;
                }
                System.out.println("link successfully edited");
                add = false;
                break;
            }
            if (!this.textUri.equals(a.getTextUri()) || !this.startAnchorId.equals(a.getStartAnchorId()) && !this.startAnchorId.equals(a.getEndAnchorId()) && ("".equals(this.endAnchorId) || !this.endAnchorId.equals(a.getStartAnchorId())) && ("".equals(this.endAnchorId) || !this.endAnchorId.equals(a.getEndAnchorId()))) continue;
            this.msg_info.setMessage("Selected xml-element is already linked with another shape!");
            this.msg_info.setText("XML-Element in use");
            this.msg_info.open();
            return false;
        }
        TGShape tShape = null;
        if (add && this.selectedShape != null) {
            tShape = this.selectedShape;
            if (this.selectedShape instanceof TGRectangle) {
                this.all_links.add((ILink)new RectLink((TGRectangle)this.selectedShape, this.startAnchorId, this.endAnchorId, this.textUri, true));
            } else if (this.selectedShape instanceof TGPolygon) {
                this.all_links.add((ILink)new PolyLink((TGPolygon)this.selectedShape, this.startAnchorId, this.endAnchorId, this.textUri, true));
            }
            try {
                if (isNodeSelected) {
                    if (!idAvailable) {
                        selectedNode.setAttributeNS(XML_NS, "xml:id", this.startAnchorId);
                    }
                } else {
                    this.isReplacingText = true;
                    this.doc.replace(this.selectedTextStart, this.selectedTextLength, annotatedText);
                    this.isReplacingText = false;
                    if (tShape != null) {
                        this.selectedShape = tShape;
                    }
                }
            }
            catch (BadLocationException e) {
                Activator.handleError(e);
                return false;
            }
        }
        this.notifyListeners(Event.LINKS_CHANGED, new Pair<String, TGShape>(this.focusedImageTabSecondaryId, this.selectedShape));
        this.setChangedAfterLoading(true);
        this.jumpToText(this.selectedShape, false);
        this.linksInfoUpdated = true;
        return true;
    }

    private boolean saveReadAnnotatedObject(final boolean saveAs, final boolean openLocal) {
        if (this.all_links.isEmpty()) {
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_CreateLinksFirst);
            this.msg_info.setText(Messages.LinkEditorController_Title_CreateLinksFirst);
            this.msg_info.open();
            return false;
        }
        Job savingOpeningTGOJob = new Job("Saving the object..."){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Saving the object...", 100);
                    TextGridObject temp_loaded_object = LinkEditorController.this.loaded_object;
                    if (LinkEditorController.this.workLocal) {
                        LinkEditorController.this.saveLocalAnnotatedFileImpl(saveAs, true, monitor);
                    } else {
                        LinkEditorController.this.saveAnnotatedObjectImpl(saveAs, false, true, monitor);
                    }
                    LinkEditorController.this.loaded_object = temp_loaded_object;
                    if (openLocal) {
                        InputStream inputStream = null;
                        try {
                            File file = new File(LinkEditorController.this.filePath);
                            if (file == null || !file.exists()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            monitor.worked(10);
                            inputStream = new FileInputStream(file);
                            monitor.worked(60);
                            UIJob resetJob = new UIJob("Cleaning the screen..."){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    LinkEditorController.this.reset(false);
                                    return Status.OK_STATUS;
                                }
                            };
                            resetJob.schedule();
                            try {
                                resetJob.join();
                            }
                            catch (InterruptedException e) {
                                Activator.handleError(e);
                            }
                            TEIDocParser parser = new TEIDocParser();
                            LinkEditorController.this.isLoadingLinksObject = true;
                            LinkEditorController.this.localAnnotatedFilePath = LinkEditorController.this.filePath;
                            parser.parse(inputStream, monitor);
                            LinkEditorController.this.workLocal = true;
                            LinkEditorController.this.linksInfoUpdated = false;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    if (LinkEditorController.this.loaded_object == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IFile file = (IFile)LinkEditorController.this.loaded_object.getAdapter(IFile.class);
                    monitor.worked(10);
                    InputStream inputStream = file.getContents(true);
                    monitor.worked(10);
                    UIJob resetJob = new UIJob("Cleaning the screen..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            LinkEditorController.this.reset(false);
                            return Status.OK_STATUS;
                        }
                    };
                    resetJob.schedule();
                    try {
                        resetJob.join();
                    }
                    catch (InterruptedException e) {
                        Activator.handleError(e);
                    }
                    TEIDocParser parser = new TEIDocParser();
                    LinkEditorController.this.isLoadingLinksObject = true;
                    parser.parse(inputStream, monitor);
                    LinkEditorController.this.selected_object = LinkEditorController.this.loaded_object;
                    LinkEditorController.this.loaded_object = null;
                    LinkEditorController.this.workLocal = false;
                    LinkEditorController.this.linksInfoUpdated = false;
                    LinkEditorController.this.isLoadingLinksObject = false;
                    monitor.worked(10);
                    new UIJob("Finalizing the loading process..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (LinkEditorController.this.selectedShape != null) {
                                LinkEditorController.this.jumpToText(LinkEditorController.this.selectedShape, true);
                            }
                            LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                            LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (XMLStreamException e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (javax.xml.parsers.FactoryConfigurationError e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (JaxenException e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                    return Status.CANCEL_STATUS;
                }
                catch (IOException e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        savingOpeningTGOJob.setUser(false);
        savingOpeningTGOJob.schedule();
        return true;
    }

    private boolean saveLocalAnnotatedFileImpl(final boolean saveAs, boolean inBackground, IProgressMonitor monitor) throws XMLStreamException, javax.xml.parsers.FactoryConfigurationError, IOException {
        File file;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ("".equals(this.localAnnotatedFilePath) || saveAs) {
            if (inBackground) {
                UIJob selectJob = new UIJob("Selecting file to save..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        FileDialog fileDlg = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
                        fileDlg.setText("Select file to save...");
                        fileDlg.setFilterExtensions(new String[]{"*.tgl"});
                        fileDlg.setFilterNames(new String[]{"Text-Image-Link file (*.tgl)"});
                        String filePath = fileDlg.open();
                        LinkEditorController.this.localAnnotatedFilePath = filePath;
                        if (!saveAs) {
                            LinkEditorController.this.saveNewFile = true;
                        }
                        if (LinkEditorController.this.localAnnotatedFilePath != null && !"".equals(LinkEditorController.this.localAnnotatedFilePath) && !LinkEditorController.this.localAnnotatedFilePath.endsWith(".tgl")) {
                            LinkEditorController linkEditorController = LinkEditorController.this;
                            linkEditorController.localAnnotatedFilePath = String.valueOf(linkEditorController.localAnnotatedFilePath) + ".tgl";
                        }
                        return Status.OK_STATUS;
                    }
                };
                selectJob.setUser(false);
                selectJob.schedule();
                try {
                    selectJob.join();
                }
                catch (Exception exception) {}
            } else {
                String filePath;
                FileDialog fileDlg = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
                fileDlg.setText("Open File to save...");
                fileDlg.setFilterExtensions(new String[]{"*.tgl"});
                fileDlg.setFilterNames(new String[]{"Text-Image-Link file (*.tgl)"});
                this.localAnnotatedFilePath = filePath = fileDlg.open();
                if (!saveAs) {
                    this.saveNewFile = true;
                }
                if (this.localAnnotatedFilePath != null && !"".equals(this.localAnnotatedFilePath) && !this.localAnnotatedFilePath.endsWith(".tgl")) {
                    this.localAnnotatedFilePath = String.valueOf(this.localAnnotatedFilePath) + ".tgl";
                }
            }
        }
        if (this.localAnnotatedFilePath == null || "".equals(this.localAnnotatedFilePath)) {
            return false;
        }
        TEIDocFactory teiFactory = new TEIDocFactory(this.all_links, inBackground);
        if (!this.saveDockingLinesUriList.isEmpty()) {
            List<TGLine> dockingLines = Collections.synchronizedList(new ArrayList());
            for (String uri : this.saveDockingLinesUriList) {
                for (TGShape s : this.updateShapesList(uri)) {
                    if (s.getType() != TGShape.TYPE.DOCKING_LINE) continue;
                    dockingLines.add((TGLine)s);
                }
            }
            teiFactory.addDockingLines(dockingLines);
        }
        if ((file = new File(this.localAnnotatedFilePath)) != null && !file.exists()) {
            file.createNewFile();
        }
        if (file != null) {
            teiFactory.createTeiDocument(file.getParent(), monitor);
            this.save_done_successfully = true;
            UIJob saveXmlJob = new UIJob("Saving open xml files..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!LinkEditorController.this.doSaveAllXMLEditors(monitor, false, false)) {
                        LinkEditorController.this.save_done_successfully = false;
                        throw new RuntimeException("Aborted: Couldn't save open xml-editors!");
                    }
                    return Status.OK_STATUS;
                }
            };
            saveXmlJob.schedule();
            try {
                saveXmlJob.join();
            }
            catch (InterruptedException e) {
                Activator.handleWarning(e);
            }
            if (!this.save_done_successfully) {
                return false;
            }
            this.save_done_successfully = teiFactory.makePersistent(file, monitor);
            if (!this.save_done_successfully) {
                return false;
            }
            new UIJob("Updating the image views..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (LinkEditorController.this.saveNewFile || saveAs) {
                        LinkEditorController.this.saveNewFile = false;
                        LinkEditorController.this.workLocal = true;
                        LinkEditorController.this.notifyListeners(Event.SET_LINKS_OBJECT_LABEL, new Pair<String, String>("all", "File: " + LinkEditorController.this.localAnnotatedFilePath));
                    }
                    LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        monitor.done();
        return true;
    }

    public void openXmlImageObjects(final TextGridObject toSaveIn, final ArrayList<TextGridObject> xmlImageObjects) {
        this.completeLoadNewProcess = true;
        new Job("Opening selected xml/image objects..."){

            protected IStatus run(IProgressMonitor monitor) {
                UIJob resJ = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        if (LinkEditorController.this.changed_after_loading && LinkEditorController.this.showWarnings) {
                            LinkEditorController.this.msg_asking.setMessage(Messages.LinkEditorController_Mess_ChangedAfterLoading_Object);
                            LinkEditorController.this.msg_asking.setText(Messages.LinkEditorController_Title_ChangedAfterLoading_Obj);
                            int result = LinkEditorController.this.msg_asking.open();
                            if (result == 64) {
                                LinkEditorController.this.saveAnnotatedObject(false, false, true);
                            } else if (result == 128) {
                                LinkEditorController.this.doRevertAllXMLEditorsToSaved();
                                LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                            } else {
                                LinkEditorController.this.completeLoadNewProcess = false;
                                return Status.CANCEL_STATUS;
                            }
                        }
                        LinkEditorController.this.reset(false);
                        return Status.OK_STATUS;
                    }
                };
                resJ.schedule();
                try {
                    resJ.join();
                }
                catch (InterruptedException e1) {
                    Activator.handleWarning(e1);
                }
                if (!LinkEditorController.this.completeLoadNewProcess) {
                    return Status.CANCEL_STATUS;
                }
                LinkEditorController.this.setNewSaveObject(toSaveIn);
                for (TextGridObject obj : xmlImageObjects) {
                    try {
                        LinkEditorController.this.addResourceToLinkEditor(obj.getURI().toString(), null);
                    }
                    catch (IOException e) {
                        Activator.handleError(e);
                    }
                }
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LinkEditorController.this.setChangedAfterLoading_AllImageViews(true);
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void setNewSaveObject(TextGridObject object) {
        this.newTGObject = object;
    }

    private boolean saveAnnotatedObjectImpl(final boolean saveAs, final boolean asNewRevision, boolean inBackgroundJob, IProgressMonitor monitor) throws UnsupportedEncodingException, XMLStreamException, javax.xml.parsers.FactoryConfigurationError {
        IFile file;
        boolean createdNewObjectFromNewWizard = false;
        if (this.workLocal) {
            return this.saveLocalAnnotatedFile(saveAs);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.newTGObject != null && this.newTGObject.isNew()) {
            this.selected_object = this.newTGObject;
            this.newTGObject = null;
            createdNewObjectFromNewWizard = true;
        }
        if (this.selected_object == null || saveAs) {
            this.selected_project = null;
            this.entered_title = null;
            if (inBackgroundJob) {
                UIJob selectJob = new UIJob("Selecting title and project..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SelectNameLocationDialog.openDialog(instance, LinkEditorController.this.selected_object == null ? false : saveAs);
                        return Status.OK_STATUS;
                    }
                };
                selectJob.setUser(false);
                selectJob.schedule();
                try {
                    selectJob.join();
                }
                catch (Exception e) {
                    Activator.handleWarning(e);
                }
            } else {
                SelectNameLocationDialog.openDialog(instance, this.selected_object == null ? false : saveAs);
            }
            if (this.selected_project == null || this.entered_title == null || this.entered_title.equals("")) {
                return false;
            }
            this.object_save = TextGridObject.getNewObjectInstance((TextGridProject)this.selected_project, (TGContentType)TGContentType.getContentType((String)LINK_EDITOR_TYPE), (String)this.entered_title);
            PersonType rightsHolder = RBACSession.getInstance().getPerson();
            this.object_save.setItemMetadata(rightsHolder);
        } else if (asNewRevision) {
            if (!SearchRequest.isTgoLatestRevision((String)this.selected_object.getURI().toString())) {
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save as new revision", (String)("The Object \"" + LinkEditorController.this.selected_object.toString() + "\" could not be saved as a revision, \nbecause there exists a successive one.\nSaving process cancelled."));
                        return Status.OK_STATUS;
                    }
                }.schedule();
                return false;
            }
            this.object_save = this.selected_object.prepareNewRevision(monitor);
        } else {
            this.object_save = this.selected_object;
        }
        try {
            String title = this.object_save.getTitle();
            if (title == null || "".equals(title) || "<no title>".equals(title)) {
                this.object_save.setTitle("New Text-Image-Link Object");
            }
        }
        catch (CoreException e1) {
            Activator.handleWarning(e1);
        }
        TEIDocFactory teiFactory = new TEIDocFactory(this.all_links, inBackgroundJob);
        if (!this.saveDockingLinesUriList.isEmpty()) {
            List<TGLine> dockingLines = Collections.synchronizedList(new ArrayList());
            for (String uri : this.saveDockingLinesUriList) {
                for (TGShape s : this.updateShapesList(uri)) {
                    if (s.getType() != TGShape.TYPE.DOCKING_LINE) continue;
                    dockingLines.add((TGLine)s);
                }
            }
            teiFactory.addDockingLines(dockingLines);
        }
        if ((file = (IFile)this.object_save.getAdapter(IFile.class)) != null) {
            teiFactory.createTeiDocument(null, monitor);
            this.save_done_successfully = true;
            this.replacedRevisions.clear();
            if (inBackgroundJob) {
                UIJob saveXmlJob = new UIJob("Saving all open xml files..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!LinkEditorController.this.doSaveAllXMLEditors(monitor, false, asNewRevision)) {
                            LinkEditorController.this.save_done_successfully = false;
                            throw new RuntimeException("Aborted: Couldn't save open xml-editors!");
                        }
                        return Status.OK_STATUS;
                    }
                };
                saveXmlJob.schedule();
                try {
                    saveXmlJob.join();
                }
                catch (InterruptedException e) {
                    Activator.handleWarning(e);
                }
            } else if (!this.doSaveAllXMLEditors(monitor, false, asNewRevision)) {
                this.save_done_successfully = false;
                throw new RuntimeException("Aborted: Couldn't save open xml-editors!");
            }
            if (!this.save_done_successfully) {
                return false;
            }
            if (!this.replacedRevisions.isEmpty()) {
                teiFactory.replaceUris(this.replacedRevisions);
                this.replacedRevisions.clear();
            }
            this.save_done_successfully = teiFactory.makePersistent(file, monitor);
            if (!this.save_done_successfully) {
                return false;
            }
            if (this.selected_object == null || createdNewObjectFromNewWizard || saveAs) {
                this.selected_object = this.loaded_object = this.object_save;
                new UIJob("Updating the image views..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LinkEditorController.this.setChangedAfterLoading(false);
                        LinkEditorController.this.notifyListeners(Event.CHANGES_SAVED, new Pair<String, Object>("all", null));
                        try {
                            LinkEditorController.this.notifyListeners(Event.SET_LINKS_OBJECT_LABEL, new Pair<String, String>("all", "Object: " + LinkEditorController.this.loaded_object.getProjectInstance().getName() + "/" + LinkEditorController.this.loaded_object.getTitle()));
                            LinkEditorController.this.loaded_object = null;
                        }
                        catch (CoreException e) {
                            Activator.handleError(e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            new UIJob("Updating the image view..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                    return Status.OK_STATUS;
                }
            }.schedule();
            if (asNewRevision) {
                new UIJob("Opening the new revision..."){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        LinkEditorController.this.openAnnotatedObject(LinkEditorController.this.object_save);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
        monitor.done();
        return true;
    }

    public boolean saveAnnotatedObject(final boolean saveAs, final boolean asNewRevision, boolean wait) {
        if (this.all_links.isEmpty()) {
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_CreateLinksFirst);
            this.msg_info.setText(Messages.LinkEditorController_Title_CreateLinksFirst);
            this.msg_info.open();
            return false;
        }
        if (!(saveAs || asNewRevision || this.isDirty())) {
            return false;
        }
        if ("".equals(RBACSession.getInstance().getSID(false)) || this.workLocal && !saveAs) {
            return this.saveLocalAnnotatedFile(saveAs);
        }
        try {
            if (this.preShutdown || wait) {
                return this.saveAnnotatedObjectImpl(saveAs, asNewRevision, false, null);
            }
            Job savingTGOJob = new Job("Saving the object..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Saving the object...", 100);
                    try {
                        if (LinkEditorController.this.saveAnnotatedObjectImpl(saveAs, asNewRevision, true, monitor)) {
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                    catch (XMLStreamException e) {
                        Activator.handleError(e);
                    }
                    catch (UnsupportedEncodingException e) {
                        Activator.handleError(e);
                    }
                    catch (javax.xml.parsers.FactoryConfigurationError e) {
                        Activator.handleError(e);
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            savingTGOJob.setUser(false);
            savingTGOJob.schedule();
            return savingTGOJob.getResult() == Status.OK_STATUS;
        }
        catch (XMLStreamException e) {
            Activator.handleError(e);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e);
        }
        catch (javax.xml.parsers.FactoryConfigurationError e) {
            Activator.handleError(e);
        }
        return false;
    }

    private void closeAllImageViews() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals(IMAGE_VIEW_ID)) {
                    page.hideView(ref);
                }
                ++n2;
            }
        }
    }

    private boolean closeAllXMLEditors(boolean save) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            boolean closed = page.closeAllEditors(save);
            if (closed) {
                this.doc = null;
                this.annoModel = null;
                this.editor = null;
            }
            return closed;
        }
        return false;
    }

    private boolean doSaveAllXMLEditors(IProgressMonitor monitor, boolean confirm, boolean asNewRevision) {
        IEditorReference[] editorRefs;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        boolean res = false;
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference eRef = iEditorReferenceArray[n2];
            IEditorPart part = eRef.getEditor(false);
            ITextEditor e = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
            if (e != null && e.isDirty() && e.getEditorInput().getName().toLowerCase().endsWith("xml")) {
                TextGridObject tgO = (TextGridObject)e.getEditorInput().getAdapter(TextGridObject.class);
                if (tgO != null && asNewRevision) {
                    if (!SearchRequest.isTgoLatestRevision((String)tgO.getURI().toString())) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save as new revision", (String)("The Object \"" + tgO.toString() + "\" could not be saved as a revision, \nbecause there exists a successive one.\nSaving process cancelled."));
                        return false;
                    }
                    TextGridObject newTgO = tgO.prepareNewRevision(monitor);
                    res = page.saveEditor((IEditorPart)e, confirm);
                    this.replacedRevisions.put(tgO.getURI().toString(), newTgO.getURI().toString());
                } else {
                    res = page.saveEditor((IEditorPart)e, confirm);
                }
                if (!res) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    private void doRevertAllXMLEditorsToSaved() {
        IEditorReference[] editorRefs;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference eRef = iEditorReferenceArray[n2];
            IEditorPart part = eRef.getEditor(false);
            ITextEditor e = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
            if (e != null && e.getEditorInput().getName().toLowerCase().endsWith("xml")) {
                e.doRevertToSaved();
            }
            ++n2;
        }
    }

    private void setChangedAfterLoading(boolean changed_after_loading) {
        this.changed_after_loading = changed_after_loading;
        this.notifyListeners(Event.UPDATE_IMAGE_VIEW_ON_CHANGES, new Pair<String, Boolean>(this.focusedImageTabSecondaryId, this.changed_after_loading));
    }

    private void setChangedAfterLoading_AllImageViews(boolean changed_after_loading) {
        this.changed_after_loading = changed_after_loading;
        this.notifyListeners(Event.UPDATE_IMAGE_VIEW_ON_CHANGES, new Pair<String, Boolean>("all", this.changed_after_loading));
    }

    public void setChangedAfterLoading(String imageUri, boolean changed_after_loading) {
        this.changed_after_loading = changed_after_loading;
        this.notifyListeners(Event.UPDATE_IMAGE_VIEW_ON_CHANGES, new Pair<String, Boolean>(imageUri, this.changed_after_loading));
    }

    public boolean isDirty() {
        return this.changed_after_loading;
    }

    public boolean areThereLinks() {
        return this.all_links.size() > 0;
    }

    public void updateDataFromSelectNameLocationDialog(TextGridProject selected_project, String entered_title) {
        this.selected_project = selected_project;
        this.entered_title = entered_title;
    }

    public void updateDataFromSelectLinkobjectDialog(TextGridObject selected_object) {
        this.selected_object_dialog = selected_object;
    }

    public void updateTextSegments() {
        try {
            for (ILink l : this.all_links) {
                if (!l.getTextUri().equals(this.textUri) || !l.isVisible()) continue;
                Point p = this.getSartEndForLink(l);
                if (p != null) {
                    if (!l.getShape().isLinked()) {
                        l.getShape().setLinked(true);
                        this.notifyListeners(Event.REDRAW, new Pair<String, Object>(l.getImageUri(), null));
                    }
                    if (l.getUnselectedAnnotation() != null) continue;
                    this.addUnselectedAnnotation(p.x, p.y, "", l);
                    continue;
                }
                l.getShape().setLinked(false);
                this.notifyListeners(Event.REDRAW, new Pair<String, Object>(l.getImageUri(), null));
            }
        }
        catch (ConcurrentModificationException e) {
            Activator.handleWarning(e);
        }
    }

    private void updateStartEndMap(boolean isBlocking) {
        if (this.doc == null) {
            return;
        }
        this.updateJob = new Job("Updating the database..."){

            protected IStatus run(IProgressMonitor arg0) {
                LinkEditorController.this.startEndMap.clear();
                for (ILink l : LinkEditorController.this.all_links) {
                    String startAnchorId = l.getStartAnchorId();
                    String endAnchorId = l.getEndAnchorId();
                    if (!"".equals(endAnchorId)) {
                        Point p_start = LinkEditorController.this.getNodeById(startAnchorId);
                        Point p_end = LinkEditorController.this.getNodeById(endAnchorId);
                        if (p_start == null || p_end == null) continue;
                        Point p = new Point(p_start.x, p_end.y);
                        LinkEditorController.this.startEndMap.put(l.getLink(), p);
                        continue;
                    }
                    Point p = LinkEditorController.this.getNodeById(startAnchorId);
                    if (p == null) continue;
                    LinkEditorController.this.startEndMap.put(l.getLink(), p);
                }
                return Status.OK_STATUS;
            }
        };
        this.updateJob.schedule();
        if (isBlocking) {
            try {
                this.updateJob.join();
            }
            catch (InterruptedException e) {
                Activator.handleWarning(e);
            }
        }
    }

    private Point getSartEndForLink(ILink l) {
        Point pFound;
        if (this.doc == null) {
            return null;
        }
        if (this.linksInfoUpdated) {
            this.updateStartEndMap(true);
            this.linksInfoUpdated = false;
        }
        if ((pFound = this.startEndMap.get(l.getLink())) != null) {
            return pFound;
        }
        String startAnchorId = l.getStartAnchorId();
        String endAnchorId = l.getEndAnchorId();
        if (!"".equals(endAnchorId)) {
            Point p_start = this.getNodeById(startAnchorId);
            Point p_end = this.getNodeById(endAnchorId);
            if (p_start != null && p_end != null) {
                Point p = new Point(p_start.x, p_end.y);
                this.startEndMap.put(l.getLink(), p);
                return p;
            }
        } else {
            Point p = this.getNodeById(startAnchorId);
            if (p != null) {
                this.startEndMap.put(l.getLink(), p);
                return p;
            }
        }
        return null;
    }

    String percentToRect(String rectPercent, int imageWidth, int imageHeight) {
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        String[] strA_Split = rectPercent.split(",");
        double help = 0.0;
        help = Double.valueOf(strA_Split[0].trim()) * (double)imageWidth / 100.0;
        rectPercent = String.valueOf(help) + ",";
        help = Double.valueOf(strA_Split[1].trim()) * (double)imageHeight / 100.0;
        rectPercent = String.valueOf(rectPercent) + help + ",";
        help = Double.valueOf(strA_Split[2].trim()) * (double)imageWidth / 100.0;
        rectPercent = String.valueOf(rectPercent) + (int)help + ",";
        help = Double.valueOf(strA_Split[3].trim()) * (double)imageHeight / 100.0;
        rectPercent = String.valueOf(rectPercent) + help;
        return rectPercent;
    }

    String percentToPoly(String str_polyPercent, int imageWidth, int imageHeight) {
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        String[] strA_Split = str_polyPercent.split(",");
        double help = 0.0;
        str_polyPercent = "";
        int i = 0;
        String[] stringArray = strA_Split;
        int n = strA_Split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (i % 2 == 0) {
                help = Double.valueOf(s.trim()) * (double)imageWidth / 100.0;
                str_polyPercent = String.valueOf(str_polyPercent) + help + ",";
            } else {
                help = Double.valueOf(s.trim()) * (double)imageHeight / 100.0;
                str_polyPercent = String.valueOf(str_polyPercent) + help + (i == strA_Split.length - 1 ? "" : ",");
            }
            ++i;
            ++n2;
        }
        return str_polyPercent;
    }

    String percentToDockingLine(String str_dockingLinePercent, int imageWidth, int imageHeight) {
        if (imageWidth == 0 || imageHeight == 0) {
            return null;
        }
        String[] strA_Split = str_dockingLinePercent.split(",");
        double help = 0.0;
        str_dockingLinePercent = "";
        int i = 0;
        String[] stringArray = strA_Split;
        int n = strA_Split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (i % 2 == 0) {
                help = Double.valueOf(s.trim()) * (double)imageWidth / 100.0;
                str_dockingLinePercent = String.valueOf(str_dockingLinePercent) + help + ",";
            } else {
                help = Double.valueOf(s.trim()) * (double)imageHeight / 100.0;
                str_dockingLinePercent = String.valueOf(str_dockingLinePercent) + help + (i == strA_Split.length - 1 ? "" : ",");
            }
            ++i;
            ++n2;
        }
        return str_dockingLinePercent;
    }

    public List<ILink> cloneAllLinks() {
        List<ILink> links = Collections.synchronizedList(new ArrayList());
        links.addAll(this.all_links.getList());
        return links;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean jumpToText(TGShape selectedShape, boolean jumpToShape) {
        if (this.editor == null) {
            return false;
        }
        try {
            Point p;
            ILink l;
            TGShape s;
            Iterator iter = this.all_links.iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while ((s = (l = (ILink)iter.next()).getShape()) == null || !s.equals((Object)selectedShape) || !l.isVisible());
            if (!l.getTextUri().equals(this.textUri)) {
                this.removeSelectedAnnotation();
                if (!this.bringXMLEditorToTop(l.getTextUri())) {
                    return false;
                }
            }
            if ((p = this.getSartEndForLink(l)) == null) return false;
            int start = p.x;
            int length = p.y - start;
            this.removeSelectedAnnotation();
            this.addUnselectedAnnotation(start, p.y, "", l);
            this.addSelectedAnnotation(start, p.y, "", l);
            this.editor.setHighlightRange(start, length, true);
            if (!jumpToShape) return true;
            this.notifyListeners(Event.JUMP_TO_SHAPE, new Pair<String, TGShape>(l.getImageUri(), selectedShape));
            return true;
        }
        catch (ConcurrentModificationException e) {
            Activator.handleWarning(e);
        }
        return false;
    }

    public boolean jumpToShape(int cursorPosition) {
        if (cursorPosition == this.oldCursorPos || this.selectedTextLength > 0) {
            return false;
        }
        int bestMatch = -1;
        ILink matchLink = null;
        try {
            for (ILink l : this.all_links) {
                Point p;
                if (!l.getTextUri().equals(this.textUri) || !l.isVisible() || (p = this.getSartEndForLink(l)) == null) continue;
                int start = p.x;
                int end = p.y;
                if (cursorPosition < start || cursorPosition >= end || bestMatch >= 0 && bestMatch >= start) continue;
                bestMatch = start;
                matchLink = l;
            }
        }
        catch (ConcurrentModificationException e) {
            Activator.handleWarning(e);
        }
        if (matchLink != null) {
            this.selectedShape = matchLink.getShape();
            if (this.selectedShape != null) {
                this.notifyListeners(Event.JUMP_TO_SHAPE, new Pair<String, TGShape>(matchLink.getImageUri(), this.selectedShape));
            }
            return true;
        }
        return false;
    }

    private boolean bringXMLEditorToTop(String xmlObjUri) {
        IEditorReference[] editorRefs;
        IEditorReference[] iEditorReferenceArray = editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editorRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference eRef = iEditorReferenceArray[n2];
            IEditorPart part = eRef.getEditor(false);
            ITextEditor e = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
            if (e != null && e.getEditorInput().getName().toLowerCase().endsWith("xml")) {
                TextGridObject tgO = (TextGridObject)e.getEditorInput().getAdapter(TextGridObject.class);
                if (tgO != null) {
                    String uri = tgO.getURI().toString();
                    if (xmlObjUri.equals(uri)) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(e.getEditorInput(), e.getEditorSite().getId());
                            return true;
                        }
                        catch (PartInitException e1) {
                            Activator.handleError(e1, "Couldn't bring the editor to foreground!", new Object[0]);
                            return false;
                        }
                    }
                } else {
                    FileStoreEditorInput fIn;
                    String uri;
                    IEditorInput eIn = e.getEditorInput();
                    if (eIn instanceof FileStoreEditorInput && xmlObjUri.equals(uri = (fIn = (FileStoreEditorInput)eIn).getURI().toString())) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(e.getEditorInput(), e.getEditorSite().getId());
                            return true;
                        }
                        catch (PartInitException e1) {
                            Activator.handleError(e1, "Couldn't bring the editor to foreground!", new Object[0]);
                            return false;
                        }
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    @Deprecated
    private boolean bringImageViewToTop(String imageObjUri) {
        for (Map.Entry<String, String> entry : this.imageTabsMap.entrySet()) {
            if (!entry.getValue().equals(imageObjUri)) continue;
            String key = entry.getKey();
            IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
            try {
                page.showView(IMAGE_VIEW_ID, key, 1);
                return true;
            }
            catch (PartInitException e) {
                Activator.handleError(e, "Couldn't bring the image view to top!", new Object[0]);
                return false;
            }
        }
        return false;
    }

    public void setSelectedShape(TGShape shape) {
        this.selectedShape = shape;
    }

    public TGShape getSelectedShape() {
        return this.selectedShape;
    }

    public void addSelectedShape(TGShape shape) {
        this.selectedShapes.add(shape);
    }

    public void clearSelectedShapes() {
        this.selectedShapes.clear();
    }

    public void deselectAllSelectedShapes() {
        this.notifyListeners(Event.DESELECT_SHAPE, new Pair<String, Object>("all", null));
    }

    public void updateLink(TGShape oldShape, TGShape newShape) {
        int i = 0;
        while (i < this.all_links.size()) {
            ILink l = this.all_links.get(i);
            TGShape s = l.getShape();
            if (s != null && s.equals((Object)oldShape)) {
                if (s instanceof TGRectangle) {
                    RectLink newLink = new RectLink((TGRectangle)newShape, l.getStartAnchorId(), l.getEndAnchorId(), l.getTextUri(), l.isVisible());
                    newLink.getShape().setWritingMode(newShape.getWritingMode());
                    this.all_links.remove(i);
                    this.startEndMap.remove(l.getLink());
                    this.all_links.add(i, (ILink)newLink);
                } else if (s instanceof TGPolygon) {
                    PolyLink newLink = new PolyLink((TGPolygon)newShape, l.getStartAnchorId(), l.getEndAnchorId(), l.getTextUri(), l.isVisible());
                    newLink.getShape().setWritingMode(newShape.getWritingMode());
                    this.all_links.remove(i);
                    this.startEndMap.remove(l.getLink());
                    this.all_links.add(i, (ILink)newLink);
                }
                this.setChangedAfterLoading(true);
                break;
            }
            ++i;
        }
    }

    public void updateLink(TGShape shape) {
        ILink linkInShape = shape.getAssocLink();
        boolean found = false;
        int i = 0;
        while (i < this.all_links.size()) {
            ILink l = this.all_links.get(i);
            if (l.equalsExceptShape(linkInShape)) {
                RectLink newLink = null;
                if (shape instanceof TGRectangle) {
                    newLink = new RectLink((TGRectangle)shape, l.getStartAnchorId(), l.getEndAnchorId(), l.getTextUri(), l.isVisible());
                    newLink.getShape().setWritingMode(shape.getWritingMode());
                    this.all_links.remove(i);
                    this.all_links.add(i, (ILink)newLink);
                } else if (shape instanceof TGPolygon) {
                    newLink = new PolyLink((TGPolygon)shape, l.getStartAnchorId(), l.getEndAnchorId(), l.getTextUri(), l.isVisible());
                    newLink.getShape().setWritingMode(shape.getWritingMode());
                    this.all_links.remove(i);
                    this.all_links.add(i, (ILink)newLink);
                }
                this.selectedShape = shape;
                found = true;
                this.setChangedAfterLoading(true);
                break;
            }
            ++i;
        }
        shape.setLinked(found);
        this.linksInfoUpdated = true;
    }

    private boolean removeSegmentFromXMLEditor(ILink l, boolean removeText) {
        Point p;
        if (!this.textUri.equals(l.getTextUri())) {
            this.bringXMLEditorToTop(l.getTextUri());
        }
        if ((p = this.getSartEndForLink(l)) != null) {
            int start = p.x;
            int end = p.y;
            try {
                if (removeText && !"".equals(l.getEndAnchorId())) {
                    String t = this.doc.get(start, end - start);
                    t = t.replaceAll("(?s)<anchor[^<>]*?\\s+xml:id\\s*=\\s*\"(" + l.getStartAnchorId() + "|" + l.getEndAnchorId() + ")\"[^<>]*?/>", "");
                    this.isReplacingText = true;
                    this.doc.replace(start, end - start, t);
                    this.isReplacingText = false;
                }
            }
            catch (BadLocationException e) {
                Activator.handleError(e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void removeAllLinks(String imageUri) {
        if (this.all_links.isEmpty()) {
            return;
        }
        Iterator iter = this.all_links.iterator();
        while (iter.hasNext()) {
            ILink l = (ILink)iter.next();
            if (!l.getImageUri().equals(imageUri)) continue;
            this.removeSegmentFromXMLEditor(l, true);
            iter.remove();
        }
        this.removeAllAnnotations();
        this.linksInfoUpdated = true;
        this.setChangedAfterLoading(true);
        this.notifyListeners(Event.LINKS_CHANGED, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
    }

    public void removeLinkByShape(TGShape shape) {
        for (ILink l : this.all_links) {
            TGShape s = l.getShape();
            if (s == null || !s.equals((Object)shape)) continue;
            if (!this.textUri.equals(l.getTextUri())) {
                this.bringXMLEditorToTop(l.getTextUri());
            }
            this.removeAnnotation(l);
            this.removeSegmentFromXMLEditor(l, true);
            this.all_links.remove(l);
            this.removeAnnotation(l);
            this.linksInfoUpdated = true;
            this.setChangedAfterLoading(true);
            this.notifyListeners(Event.LINKS_CHANGED, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
            break;
        }
    }

    public void removeSelectedLink() {
        if (this.selectedShape == null) {
            this.msg_info.setText("");
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_NoSelectedShape);
            this.msg_info.open();
            return;
        }
        for (ILink l : this.all_links) {
            TGShape s = l.getShape();
            if (s == null || !s.equals((Object)this.selectedShape)) continue;
            if (!this.textUri.equals(l.getTextUri())) {
                this.bringXMLEditorToTop(l.getTextUri());
            }
            this.removeAnnotation(l);
            if (this.showWarnings) {
                this.msg_asking_2.setMessage(Messages.LinkEditorController_Mess_DeleteSelectedLink_1);
                this.msg_asking_2.setText(Messages.LinkEditorController_Mess_DeleteSelectedLink_2);
                if (this.msg_asking_2.open() != 64) continue;
                this.removeSegmentFromXMLEditor(l, true);
                this.all_links.remove(l);
                this.linksInfoUpdated = true;
                this.setChangedAfterLoading(true);
                this.notifyListeners(Event.LINKS_CHANGED, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
                this.notifyListeners(Event.REMOVE_SHAPE, new Pair<String, TGShape>(this.focusedImageTabSecondaryId, s));
                break;
            }
            this.removeSegmentFromXMLEditor(l, true);
            this.all_links.remove(l);
            this.linksInfoUpdated = true;
            this.setChangedAfterLoading(true);
            this.notifyListeners(Event.LINKS_CHANGED, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
            this.notifyListeners(Event.REMOVE_SHAPE, new Pair<String, TGShape>(this.focusedImageTabSecondaryId, s));
            break;
        }
    }

    public void unlinkSelectedLinks() {
        boolean asked = false;
        if (this.selectedShape == null) {
            this.msg_info.setText("");
            this.msg_info.setMessage(Messages.LinkEditorController_Mess_NoSelectedShape);
            this.msg_info.open();
            return;
        }
        Iterator iter = this.all_links.iterator();
        while (iter.hasNext()) {
            ILink l = (ILink)iter.next();
            TGShape s = l.getShape();
            if (s == null) continue;
            if (this.selectedShapes.isEmpty() && s.equals((Object)this.selectedShape)) {
                if (!this.textUri.equals(l.getTextUri())) {
                    this.bringXMLEditorToTop(l.getTextUri());
                }
                if (this.showWarnings) {
                    this.msg_asking_2.setText("Unlink selected link");
                    this.msg_asking_2.setMessage("Do you really want to unlink the selected link?");
                    if (this.msg_asking_2.open() != 64) continue;
                    iter.remove();
                    this.removeAnnotation(l);
                    this.removeSegmentFromXMLEditor(l, true);
                    l.getShape().setLinked(false);
                    break;
                }
                iter.remove();
                this.removeAnnotation(l);
                this.removeSegmentFromXMLEditor(l, true);
                l.getShape().setLinked(false);
                break;
            }
            if (this.selectedShapes.isEmpty() || !this.selectedShapes.contains(s)) continue;
            if (!asked && this.showWarnings) {
                asked = true;
                this.msg_asking_2.setText("Unlink selected links");
                this.msg_asking_2.setMessage("Do you really want to unlink the selected links?");
                if (this.msg_asking_2.open() != 64) {
                    return;
                }
            }
            if (!this.textUri.equals(l.getTextUri())) {
                this.bringXMLEditorToTop(l.getTextUri());
            }
            iter.remove();
            l.getShape().setLinked(false);
            this.removeAnnotation(l);
            this.removeSegmentFromXMLEditor(l, true);
        }
        this.linksInfoUpdated = true;
        this.setChangedAfterLoading(true);
        this.notifyListeners(Event.REDRAW, new Pair<String, Object>(this.focusedImageTabSecondaryId, null));
    }

    public void saveThenClearLinks() {
        if (this.changed_after_loading && this.showWarnings) {
            this.msg_asking_2.setMessage(Messages.LinkEditorController_Mess_SaveCurrentChanges_1);
            this.msg_asking_2.setText(Messages.LinkEditorController_Mess_SaveCurrentChanges_2);
            if (this.msg_asking_2.open() == 64) {
                this.saveAnnotatedObject(false, false, true);
            }
        }
        this.all_links.clear();
        this.setChangedAfterLoading_AllImageViews(false);
    }

    public void addListener(ILinkEditorListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ILinkEditorListener listener) {
        return this.listeners.remove(listener);
    }

    public void notifyListeners(Event event, Pair<String, ?> pair) {
        try {
            for (ILinkEditorListener l : this.listeners) {
                l.update(event, pair);
            }
        }
        catch (ConcurrentModificationException e) {
            Activator.handleWarning(e);
        }
    }

    public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
        if (object != null && object == this.selected_object && event == TextGridObject.ITextGridObjectListener.Event.DELETED) {
            this.loaded_object = null;
            this.selected_object = null;
            this.changed_after_loading = true;
            this.notifyListeners(Event.UPDATE_IMAGE_VIEW_ON_CHANGES, new Pair<String, Boolean>("all", this.changed_after_loading));
        }
    }

    public void chooseFont(StyledText text) {
        FontDialog fontdlg = new FontDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        fontdlg.setText("FontDialog");
        FontData selectedFont = fontdlg.open();
        Font font = null;
        Color color = null;
        if (selectedFont != null) {
            font = new Font((Device)PlatformUI.getWorkbench().getDisplay(), fontdlg.getFontList());
            text.setFont(font);
            color = new Color((Device)PlatformUI.getWorkbench().getDisplay(), fontdlg.getRGB());
            text.setForeground(color);
        }
    }

    public void setWritingMode(TGShape shape, TGShape.WRITING_MODE writingMode) {
        if (shape == null) {
            return;
        }
        TGRectangle newShape = null;
        if (shape instanceof TGRectangle) {
            newShape = new TGRectangle(((TGRectangle)shape).getRectangle(), shape.getImageUri());
        } else if (shape instanceof TGPolygon) {
            newShape = new TGPolygon(((TGPolygon)shape).getPoints(), shape.getImageUri());
        }
        newShape.setWritingMode(writingMode);
        newShape.setRotationValue(shape.getRotationValue());
        newShape.setLayerValues(new Integer(shape.getLayer()).intValue(), shape.getLayerName(), shape.getLayerRGB());
        this.updateLink(shape, (TGShape)newShape);
    }

    TGShape.WRITING_MODE getWritingModeFromString(String mode) {
        if (mode == null || "".equals(mode) || mode.equals("none")) {
            return TGShape.WRITING_MODE.NONE;
        }
        if (mode.equals("lr")) {
            return TGShape.WRITING_MODE.LR;
        }
        if (mode.equals("lr-tb")) {
            return TGShape.WRITING_MODE.LR_TB;
        }
        if (mode.equals("rl")) {
            return TGShape.WRITING_MODE.RL;
        }
        if (mode.equals("rl-tb")) {
            return TGShape.WRITING_MODE.RL_TB;
        }
        if (mode.equals("tb")) {
            return TGShape.WRITING_MODE.TB;
        }
        if (mode.equals("tb-rl")) {
            return TGShape.WRITING_MODE.TB_RL;
        }
        return TGShape.WRITING_MODE.NONE;
    }

    public String getRevisionedUri(String uri, boolean isImageUri) {
        if (isImageUri) {
            for (String s : this.imageInfoMap.keySet()) {
                if (!s.contains(".") || !s.split("\\.")[0].equals(uri)) continue;
                return s;
            }
        } else {
            for (String s : this.openXmlUris) {
                if (!s.contains(".") || !s.split("\\.")[0].equals(uri)) continue;
                return s;
            }
        }
        return String.valueOf(uri) + ".0";
    }

    public Point getImageWidthHeight(String imageUri) {
        return this.imageInfoMap.get(imageUri);
    }

    public void saveAllDockingLines(String imageUri) {
        this.saveDockingLinesUriList.add(imageUri);
        this.setChangedAfterLoading(true);
        this.saveAnnotatedObject(false, false, false);
    }

    public void removeAllDockingLineTags(String imageUri) {
        this.saveDockingLinesUriList.remove(imageUri);
        this.setChangedAfterLoading(imageUri, true);
    }

    void addTosaveDockingLinesUriList(String imageUri) {
        this.saveDockingLinesUriList.add(imageUri);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ITextSelection selection = (ITextSelection)event.getSelection();
        this.selectedText = selection.getText();
        this.selectedTextStart = selection.getOffset();
        this.selectedTextLength = this.selectedText.length() > 0 ? selection.getLength() : 0;
        this.jumpToShape(this.selectedTextStart);
        this.oldCursorPos = this.selectedTextStart;
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.isReplacingText) {
            this.linksInfoUpdated = true;
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void mouseUp(MouseEvent e) {
        int cursorPos;
        this.selectedTextStart = cursorPos = this.text.getSelection().x;
        this.jumpToShape(cursorPos);
        this.oldCursorPos = cursorPos;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String sel;
        Object obj;
        Object[] objs;
        if (part != null && part instanceof IEditorPart) {
            IEditorPart ePart = (IEditorPart)part;
            if (ePart == null) {
                Activator.handleError(new Exception("No editor open!"));
            } else {
                if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective")) {
                    return;
                }
                ITextEditor tempEditor = this.editor;
                this.editor = (ITextEditor)AdapterUtils.getAdapter((Object)ePart, ITextEditor.class);
                if (this.editor != null) {
                    if (this.editor.getEditorInput().getName().toLowerCase().endsWith("xml")) {
                        this.textFileOpen = false;
                        TextGridObject objFromXMLEditor = (TextGridObject)this.editor.getEditorInput().getAdapter(TextGridObject.class);
                        if (objFromXMLEditor != null) {
                            this.textUri = objFromXMLEditor.getURI().toString();
                        } else {
                            IEditorInput eIn = this.editor.getEditorInput();
                            if (eIn instanceof FileStoreEditorInput) {
                                FileStoreEditorInput fIn = (FileStoreEditorInput)eIn;
                                this.textUri = fIn.getURI().toString();
                            }
                        }
                        if (this.forceGettingEditor || !this.editor.equals(tempEditor)) {
                            if (this.annoModel != null) {
                                this.removeSelectedAnnotation();
                            }
                            this.editor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
                            this.editor.getEditorSite().getPage().addPartListener((IPartListener2)this);
                            IDocumentProvider dp = this.editor.getDocumentProvider();
                            this.doc = dp.getDocument((Object)this.editor.getEditorInput());
                            this.doc.addDocumentListener((IDocumentListener)this);
                            try {
                                StructuredTextViewer viewer = ((StructuredTextEditor)this.editor).getTextViewer();
                                this.annoModel = viewer.getAnnotationModel();
                                this.text = viewer.getTextWidget();
                                this.text.addMouseListener((MouseListener)this);
                                if (this.updateFlag && this.unsegmentedOpenXmlUris.contains(this.textUri)) {
                                    this.updateTextSegments();
                                    this.unsegmentedOpenXmlUris.remove(this.textUri);
                                }
                            }
                            catch (ClassCastException e) {
                                Activator.handleError(e);
                            }
                        }
                    } else {
                        this.textFileOpen = true;
                    }
                }
            }
        } else if (part instanceof ILinkEditorListener && selection instanceof IStructuredSelection && (objs = ((IStructuredSelection)selection).toArray()).length > 1 && (obj = objs[1]) != null && obj instanceof String && (sel = (String)obj).contains("image")) {
            this.imageUri = sel;
        }
    }

    private ElementImpl getSelectedXMLNode(int position) {
        if (this.doc == null) {
            return null;
        }
        IStructuredModel model = null;
        try {
            IndexedRegion region;
            model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)this.doc);
            if (model == null) {
                this.forceGettingEditor = true;
                this.selectionChanged((IWorkbenchPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor(), null);
                this.forceGettingEditor = false;
                model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)this.doc);
                if (model == null) {
                    return null;
                }
            }
            if ((region = model.getIndexedRegion(position)) != null && region instanceof ElementImpl) {
                ElementImpl elem;
                ElementImpl elementImpl = elem = (ElementImpl)region;
                return elementImpl;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Point getNodeById(String id) {
        model = null;
        model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)this.doc);
        var7_4 = regions = model.getStructuredDocument().getStructuredDocumentRegions();
        var6_5 = regions.length;
        var5_6 = 0;
        while (true) {
            r = var7_4[var5_6];
            position = r.getStartOffset();
            region = model.getIndexedRegion(position);
            if (region != null && region instanceof ElementImpl && (attrId = (elem = (ElementImpl)region).getAttribute("xml:id")) != null && attrId.equals(id)) {
                var13_12 = new Point(elem.getStartOffset(), elem.getEndOffset());
                return var13_12;
            }
            ++var5_6;
            return var5_6;
        }
lbl17:
        // 1 sources

        return null;
        finally {
            if (var5_6 < var6_5) ** continue;
            ** continue;
        }
    }

    private List<TGShape> updateShapesList(String imageUri) {
        this.allShapes.clear();
        this.notifyListeners(Event.UPDATE_SHAPES_LIST, new Pair<String, List<TGShape>>(imageUri, this.allShapes));
        return this.allShapes;
    }

    public void updateRotationValue(TGShape shape) {
        if (shape == null) {
            return;
        }
        TGRectangle newShape = null;
        if (shape instanceof TGRectangle) {
            newShape = new TGRectangle(((TGRectangle)shape).getRectangle(), shape.getImageUri());
        } else if (shape instanceof TGPolygon) {
            newShape = new TGPolygon(((TGPolygon)shape).getPoints(), shape.getImageUri());
        }
        newShape.setRotationValue(shape.getRotationValue());
        newShape.setWritingMode(shape.getWritingMode());
        newShape.setLayerValues(new Integer(shape.getLayer()).intValue(), shape.getLayerName(), shape.getLayerRGB());
        this.updateLink(shape, (TGShape)newShape);
    }

    public void updateLayerValues(TGShape shape) {
        if (shape == null) {
            return;
        }
        TGRectangle newShape = null;
        if (shape instanceof TGRectangle) {
            newShape = new TGRectangle(((TGRectangle)shape).getRectangle(), shape.getImageUri());
        } else if (shape instanceof TGPolygon) {
            newShape = new TGPolygon(((TGPolygon)shape).getPoints(), shape.getImageUri());
        }
        newShape.setRotationValue(shape.getRotationValue());
        newShape.setWritingMode(shape.getWritingMode());
        newShape.setLayerValues(new Integer(shape.getLayer()).intValue(), shape.getLayerName(), shape.getLayerRGB());
        this.updateLink(shape, (TGShape)newShape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedAnnotation(int start, int end, String text, ILink link) {
        if (this.annoModel == null) {
            return;
        }
        Position position = new Position(start, end - start);
        Annotation annotation = new Annotation(ANNOTATION_TYPE_SELECTED, false, "Selected Link " + text);
        IAnnotationModel iAnnotationModel = this.annoModel;
        synchronized (iAnnotationModel) {
            this.annoModel.addAnnotation(annotation, position);
            this.selectedAnnotation = annotation;
            link.setSelectedAnnotation(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnselectedAnnotation(int start, int end, String text, ILink link) {
        if (this.annoModel == null) {
            return;
        }
        Position position = new Position(start, end - start);
        Annotation annotation = new Annotation(ANNOTATION_TYPE_UNSELECTED, false, "Image-Link-Editor Link " + text);
        Annotation oldUnselected = link.getUnselectedAnnotation();
        IAnnotationModel iAnnotationModel = this.annoModel;
        synchronized (iAnnotationModel) {
            if (oldUnselected != null) {
                this.annoModel.removeAnnotation(oldUnselected);
            }
            this.annoModel.addAnnotation(annotation, position);
            link.setUnselectedAnnotation(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotation(ILink link) {
        Annotation annoUnselected;
        if (link == null || this.annoModel == null) {
            return;
        }
        Annotation annoSelected = link.getSelectedAnnotation();
        if (annoSelected != null) {
            IAnnotationModel iAnnotationModel = this.annoModel;
            synchronized (iAnnotationModel) {
                this.annoModel.removeAnnotation(annoSelected);
            }
        }
        if ((annoUnselected = link.getUnselectedAnnotation()) != null) {
            IAnnotationModel iAnnotationModel = this.annoModel;
            synchronized (iAnnotationModel) {
                this.annoModel.removeAnnotation(annoUnselected);
            }
        }
        link.setSelectedAnnotation(null);
        link.setUnselectedAnnotation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSelectedAnnotation() {
        if (this.annoModel == null) {
            return;
        }
        if (this.selectedAnnotation != null) {
            IAnnotationModel iAnnotationModel = this.annoModel;
            synchronized (iAnnotationModel) {
                this.annoModel.removeAnnotation(this.selectedAnnotation);
                this.selectedAnnotation = null;
            }
        } else {
            Iterator it = this.annoModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation anno = (Annotation)it.next();
                String type = anno.getType();
                if (type == null || !type.equals(ANNOTATION_TYPE_SELECTED)) continue;
                IAnnotationModel iAnnotationModel = this.annoModel;
                synchronized (iAnnotationModel) {
                    this.annoModel.removeAnnotation(anno);
                    this.selectedAnnotation = null;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeAllUnselectedAnnotations() {
        if (this.annoModel == null) {
            return;
        }
        Iterator it = this.annoModel.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation anno = (Annotation)it.next();
            String type = anno.getType();
            if (type == null || !type.equals(ANNOTATION_TYPE_UNSELECTED)) continue;
            IAnnotationModel iAnnotationModel = this.annoModel;
            synchronized (iAnnotationModel) {
                this.annoModel.removeAnnotation(anno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void removeAllAnnotations() {
        if (this.annoModel == null) {
            return;
        }
        Iterator it = this.annoModel.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation anno = (Annotation)it.next();
            IAnnotationModel iAnnotationModel = this.annoModel;
            synchronized (iAnnotationModel) {
                this.annoModel.removeAnnotation(anno);
            }
        }
        this.selectedAnnotation = null;
    }

    public TGShape.WRITING_MODE getDefaultWritingMode(String imageUri) {
        this.notifyListeners(Event.GET_DEFAULT_WRITING_MODE, new Pair<String, Object>(imageUri, null));
        return this.writingMode;
    }

    public void setDefaultWritingMode(String imageUri, TGShape.WRITING_MODE writingMode) {
        this.notifyListeners(Event.SET_DEFAULT_WRITING_MODE, new Pair<String, TGShape.WRITING_MODE>(imageUri, writingMode));
    }

    public void setWritingModeFromImageView(TGShape.WRITING_MODE writingMode) {
        this.writingMode = writingMode;
    }

    public void partActivated(IWorkbenchPartReference arg0) {
    }

    public void partBroughtToTop(IWorkbenchPartReference arg0) {
    }

    public void partClosed(IWorkbenchPartReference arg0) {
        IEditorReference[] eRefs;
        IViewReference[] refs;
        ITextEditor e;
        IEvaluationService evalService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        evalService.requestEvaluation("info.textgrid.lab.linkeditor.rcp_linkeditor.testers.ActivateOperations");
        evalService.requestEvaluation("info.textgrid.lab.linkeditor.rcp_linkeditor.testers.ActivateReset");
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            if (workbenchPage == null || !workbenchPage.getPerspective().getId().equals("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective")) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
        if (arg0 != null && arg0 instanceof IEditorReference && (e = (ITextEditor)AdapterUtils.getAdapter((Object)((IEditorReference)arg0).getEditor(false), ITextEditor.class)) != null && e.equals(this.editor)) {
            this.doc = null;
            this.annoModel = null;
            this.editor = null;
        }
        int image_parts = 0;
        int editor_parts = 0;
        IViewReference[] iViewReferenceArray = refs = workbenchPage.getViewReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference r = iViewReferenceArray[n2];
            if (r.getId().equals(IMAGE_VIEW_ID)) {
                ++image_parts;
            }
            ++n2;
        }
        IEditorReference[] iEditorReferenceArray = eRefs = workbenchPage.getEditorReferences();
        int n3 = eRefs.length;
        n = 0;
        while (n < n3) {
            IEditorReference r = iEditorReferenceArray[n];
            try {
                if (r.getEditorInput().getName().toLowerCase().endsWith("xml")) {
                    ++editor_parts;
                }
            }
            catch (PartInitException e2) {
                Activator.handleError(e2);
            }
            ++n;
        }
        if (image_parts + editor_parts == 0) {
            this.reset(false);
        }
    }

    public void partDeactivated(IWorkbenchPartReference arg0) {
    }

    public void partHidden(IWorkbenchPartReference arg0) {
    }

    public void partInputChanged(IWorkbenchPartReference arg0) {
    }

    public void partOpened(IWorkbenchPartReference arg0) {
        IEvaluationService evalService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evalService != null) {
            evalService.requestEvaluation("info.textgrid.lab.linkeditor.rcp_linkeditor.testers.ActivateOperations");
            evalService.requestEvaluation("info.textgrid.lab.linkeditor.rcp_linkeditor.testers.ActivateReset");
        }
    }

    public void partVisible(IWorkbenchPartReference arg0) {
    }

    public void perspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if (perspective.getId().equals("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective")) {
            this.reset(false);
        }
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (perspective.getId().equals("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective") && changeId.equals("reset")) {
            this.reset(false);
        }
    }

    public boolean saveLocalAnnotatedFile(final boolean saveAs) {
        Job savingTGOJob = new Job("Saving the object..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Saving the object...", 100);
                    LinkEditorController.this.saveLocalAnnotatedFileImpl(saveAs, true, monitor);
                    return Status.OK_STATUS;
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (javax.xml.parsers.FactoryConfigurationError e) {
                    Activator.handleError(e);
                }
                catch (XMLStreamException e) {
                    Activator.handleError(e);
                }
                catch (IOException e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        savingTGOJob.setUser(false);
        savingTGOJob.schedule();
        return savingTGOJob.getResult() == Status.OK_STATUS;
    }

    private String getPathFromUri(URI uri) {
        return new File(uri).getAbsolutePath();
    }

    public void openLocalFile() {
        try {
            if (!this.workLocal) {
                RBACSession.getInstance();
                RBACSession.neverAsk((boolean)true);
            }
            if (!PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective().getId().equals("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective")) {
                PlatformUI.getWorkbench().showPerspective("info.textgrid.lab.linkeditor.rcp_linkeditor.perspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
            FileDialog fileDlg = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
            fileDlg.setText("Open File...");
            fileDlg.setFilterExtensions(new String[]{"*.xml;*.jpg;*.jpeg;*.png;*.tiff;*.tif;*.tgl", "*.xml", "*.jpg", "*.jpeg", "*.png", "*.tiff", "*.tif", "*.tgl"});
            fileDlg.setFilterNames(new String[]{"All proper types", "XML file (*.xml)", "JPG file (*.jpg)", "JPEG file (*.jpeg)", "PNG file (*.png)", "TIFF file (*.tiff)", "TIFF file (*.tif)", "Text-Image-Link file (*.tgl)"});
            final String filePath = fileDlg.open();
            if (filePath != null && !"".equals(filePath)) {
                System.err.println(filePath);
                File file = new File(filePath);
                if (!file.exists() || !file.isFile()) {
                    return;
                }
                if (filePath.toLowerCase().endsWith("xml")) {
                    new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            LinkEditorController.this.openLocalXMLFile(filePath);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                } else if (filePath.toLowerCase().endsWith("tgl")) {
                    this.openLocalAnnotatedFile(filePath, file.getParent());
                } else if (filePath.toLowerCase().matches(".+\\.(jpg|jpeg|png|tiff|tif)$")) {
                    new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            LinkEditorController.this.openLocalImageFile(filePath);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        }
        catch (WorkbenchException e) {
            Activator.handleError(e);
        }
    }

    private void openLocalXMLFile(final String filePath) {
        UIJob openJob = new UIJob("Opening the xml file(s)..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(filePath));
                LinkEditorController.this.textUri = fileStore.toURI().toString();
                if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                        return Status.OK_STATUS;
                    }
                    catch (PartInitException e) {
                        Activator.handleError(e);
                    }
                }
                return Status.CANCEL_STATUS;
            }
        };
        openJob.setUser(false);
        openJob.schedule();
    }

    private void openLocalImageFile(final String filePath) {
        UIJob openJob = new UIJob("Opening the image file(s)..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                InputStream input = null;
                try {
                    if (LinkEditorController.this.imageTabsMap.isEmpty()) {
                        LinkEditorController.this.openTabs = 0;
                    }
                    File file = new File(filePath);
                    String fileUri = file.toURI().toString();
                    input = new FileInputStream(file);
                    for (Map.Entry entry : LinkEditorController.this.imageTabsMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(fileUri)) continue;
                        String key = (String)entry.getKey();
                        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                        page.showView(IMAGE_VIEW_ID, key, 1);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    LinkEditorController.this.openToolkit = false;
                    IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                    LinkEditorController linkEditorController = LinkEditorController.this;
                    int n = linkEditorController.openTabs + 1;
                    linkEditorController.openTabs = n;
                    page.showView(IMAGE_VIEW_ID, String.valueOf(n), 1);
                    String name = file.getName();
                    String[] sp = name.split("\\.");
                    String ext = sp.length > 0 ? "/" + sp[sp.length - 1] : "";
                    LinkEditorController.this.loadTGOImage(null, input, fileUri, name, "image" + ext);
                    if (!LinkEditorController.this.isLoadingLinksObject) {
                        LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                    }
                    LinkEditorController.this.openToolkit = true;
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
                catch (FileNotFoundException e) {
                    Activator.handleError(e);
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            Activator.handleWarning(e, "Couldn't close the input stream!", new Object[0]);
                        }
                    }
                }
                return Status.CANCEL_STATUS;
            }
        };
        openJob.setUser(false);
        openJob.schedule();
        try {
            openJob.join();
        }
        catch (InterruptedException e) {
            Activator.handleWarning(e, "Job interrupted!", new Object[0]);
        }
    }

    private void openLocalAnnotatedFile(final String filePath, final String parentPath) {
        if (filePath == null || "".equals(filePath)) {
            return;
        }
        this.filePath = filePath;
        if (this.changed_after_loading && this.showWarnings) {
            this.msg_asking.setMessage(Messages.LinkEditorController_Mess_ChangedAfterLoading_Object);
            this.msg_asking.setText(Messages.LinkEditorController_Title_ChangedAfterLoading_Obj);
            int result = this.msg_asking.open();
            if (result == 64) {
                this.saveReadAnnotatedObject(false, true);
                return;
            }
            if (result == 128) {
                this.doRevertAllXMLEditorsToSaved();
                this.setChangedAfterLoading_AllImageViews(false);
            } else {
                return;
            }
        }
        if (this.readingTGOJob_readAnnotated != null) {
            this.readingTGOJob_readAnnotated.cancel();
        }
        this.readingTGOJob_readAnnotated = new Job(NLS.bind((String)"Opening {0}.....", (Object)filePath)){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                InputStream inputStream = null;
                try {
                    monitor.beginTask(NLS.bind((String)"Opening {0}.....", (Object)filePath), 100);
                    File file = new File(filePath);
                    if (file == null || !file.exists()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    monitor.worked(10);
                    inputStream = new FileInputStream(file);
                    monitor.worked(60);
                    UIJob resetJob = new UIJob("Cleaning the screen..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            LinkEditorController.this.reset(false);
                            return Status.OK_STATUS;
                        }
                    };
                    resetJob.schedule();
                    try {
                        resetJob.join();
                    }
                    catch (InterruptedException e) {
                        Activator.handleError(e);
                    }
                    TEIDocParser parser = new TEIDocParser();
                    LinkEditorController.this.isLoadingLinksObject = true;
                    LinkEditorController.this.localAnnotatedFilePath = filePath;
                    parser.setParentPath(parentPath);
                    parser.parse(inputStream, monitor);
                    LinkEditorController.this.workLocal = true;
                    LinkEditorController.this.isLoadingLinksObject = false;
                    LinkEditorController.this.linksInfoUpdated = false;
                    new UIJob("Finalizing the loading process..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (LinkEditorController.this.selectedShape != null) {
                                LinkEditorController.this.jumpToText(LinkEditorController.this.selectedShape, true);
                            }
                            LinkEditorController.this.notifyListeners(Event.FINALIZE_LOADING, new Pair<String, Object>(LinkEditorController.this.focusedImageTabSecondaryId, null));
                            LinkEditorController.this.setChangedAfterLoading_AllImageViews(false);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.done();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (JaxenException e) {
                    Activator.handleError(e);
                }
                catch (XMLStreamException e) {
                    Activator.handleError(e);
                }
                catch (FileNotFoundException e) {
                    Activator.handleError(e);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            Activator.handleWarning(e, "Couldn't close the input stream!", new Object[0]);
                        }
                    }
                }
                return Status.CANCEL_STATUS;
            }
        };
        this.readingTGOJob_readAnnotated.setUser(false);
        this.readingTGOJob_readAnnotated.schedule();
    }

    public TGLayerManager getLayerManagerFromMap(String ImageUri) {
        TGLayerManager layerManag = null;
        try {
            layerManag = (TGLayerManager)this.allLayerManager.get((Object)ImageUri);
        }
        catch (Exception e) {
            Activator.handleError(e);
        }
        return layerManag;
    }

    public static int getMaxtglayernumber() {
        return 5;
    }

    public void addLayerManagerToMap(String ImageUri) {
        TGLayerManager tgLM = new TGLayerManager(ImageUri);
        try {
            this.allLayerManager.put((Object)ImageUri, (Object)tgLM);
        }
        catch (Exception e) {
            Activator.handleError(e);
        }
    }

    public void addLayerManagerToMap(TGLayerManager tgLM) {
        try {
            this.allLayerManager.put((Object)tgLM.getImageUri(), (Object)tgLM);
        }
        catch (Exception e) {
            Activator.handleError(e);
        }
    }

    public void setLinkVisiblityByShape(TGShape shape, boolean visible) {
        for (ILink l : this.all_links) {
            Point p;
            TGShape s = l.getShape();
            if (s == null || !s.equals((Object)shape)) continue;
            if (!visible) {
                this.removeAnnotation(l);
            } else if (l.getUnselectedAnnotation() == null && l.getTextUri().equals(this.textUri) && (p = this.getSartEndForLink(l)) != null) {
                this.addUnselectedAnnotation(p.x, p.y, "", l);
            }
            l.setVisible(visible);
            break;
        }
    }

    public void setAllLinksVisible() {
        for (ILink l : this.all_links) {
            l.setVisible(true);
        }
        this.updateTextSegments();
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        this.preShutdown = true;
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public void doSave() {
        this.saveAnnotatedObject(false, false, false);
    }

    public void doSaveAs() {
        this.saveAnnotatedObject(true, false, false);
    }

    public void doSaveNewRevision() {
        this.saveAnnotatedObject(false, true, false);
    }

    public void doLockTglObject() {
        LockingService lockService = LockingService.getInstance();
        if (lockService.lockObject(this.loaded_object, true)) {
            this.loaded_object.setOpenAsReadOnly(true);
            System.out.println("tgl-Object has been locked.");
        }
    }

    public void doUnlockTglObject() {
        LockingService lockService = LockingService.getInstance();
        if (lockService.objectIsLocked(this.loaded_object)) {
            lockService.unlockObject(this.loaded_object);
            System.out.println("tgl-Object has been unlocked.");
        }
    }

    public static void main(String[] args) {
        String text2 = "<anchor xml:id=\"a1\"> </anchor>Ludwig<anchor xml:id=\"a2\" />";
        String pattern_s = "(?s)<anchor[^<>]*?\\s+xml:id\\s*=\\s*\"a1\"[^<>]*?/>.*?<anchor[^<>]*?\\s+xml:id\\s*=\\s*\"a2\"[^<>]*?/>";
        System.err.println(text2.matches(pattern_s));
    }

    public static enum Event {
        LOAD_TEXT,
        LOAD_IMAGE,
        ADD_LINK,
        ADD_LINK_LOADING,
        JUMP_TO_SHAPE,
        LINKS_CHANGED,
        REMOVE_SHAPE,
        SET_TITLE_LABEL,
        SET_TYPE_LABEL,
        SET_COUNT,
        SET_ANGLE,
        SET_LAYER,
        SET_IMAGEVIEW_INVISIBLE,
        UPDATE_IMAGE_IN_CONTROLLER,
        CHANGES_SAVED,
        FINALIZE_LOADING,
        SET_DEFAULT_WRITING_MODE,
        GET_DEFAULT_WRITING_MODE,
        SET_VISIBILITY_OF_CREATELINK,
        ADD_DOCKING_LINE,
        UPDATE_IMAGE_VIEW_ON_CHANGES,
        REMOVE_ALL_SHAPES,
        UPDATE_SHAPES_LIST,
        ADD_SHAPE,
        SELECT_SHAPE,
        OPEN_TOOLKIT,
        CLOSE_TOOLKIT,
        SET_SELECTED_OBJECT,
        SET_IMAGE_URI,
        UPDATE_LOADED_IMAGE,
        SET_LINKS_OBJECT_LABEL,
        DESELECT_SHAPE,
        REDRAW,
        REMOVE_SELECTED_SHAPES;

    }
}

