/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.adapter;

import com.google.common.base.Joiner;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.search.ui.adapter.AggregationAdapter;
import info.textgrid.lab.search.ui.adapter.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class AggregationAdapterFactory
implements IAdapterFactory {
    private static final TGContentType AGGREGATION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.aggregation+xml");
    private static final TGContentType EDITION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.edition+tg.aggregation+xml");
    private static final TGContentType COLLECTION_CONTENT_TYPE = TGContentType.getContentType((String)"text/tg.collection+tg.aggregation+xml");
    private static final Class<?>[] ADAPTER_LIST = new Class[]{AggregationAdapter.class, IDeferredWorkbenchAdapter.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType.isAssignableFrom(AggregationAdapter.class) && adaptableObject instanceof TGObjectReference) {
            Assert.isNotNull((Object)AGGREGATION_CONTENT_TYPE, (String)(String.valueOf(Messages.AggregationAdapterFactory_EM_NoContentType) + Joiner.on((String)", ").join((Object[])TGContentType.getContentTypes((boolean)false))));
            Assert.isLegal((adaptableObject != null ? 1 : 0) != 0, (String)Messages.AggregationAdapterFactory_EM_Null);
            try {
                TextGridObject tgo = (TextGridObject)AdapterUtils.getAdapter((Object)adaptableObject, TextGridObject.class);
                if (AGGREGATION_CONTENT_TYPE.equals(tgo.getContentType(true))) {
                    return new AggregationAdapter(tgo);
                }
                if (EDITION_CONTENT_TYPE.equals(tgo.getContentType(true))) {
                    return new AggregationAdapter(tgo);
                }
                if (COLLECTION_CONTENT_TYPE.equals(tgo.getContentType(true))) {
                    return new AggregationAdapter(tgo);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core");
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

