/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.core.swtutils.ExclusiveSelection;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.xmleditor.dialogs.Messages;
import java.net.URI;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class SetAdaptorDialog
extends TitleAreaDialog {
    private TextGridObjectTableViewer adaptorViewer;
    private TextGridObject[] textGridObjects;
    private boolean forceMakePersistant = false;
    private Button makePersistentButton;

    public SetAdaptorDialog(Shell parentShell, boolean forceMakePersistant, TextGridObject ... textGridObjects) {
        super(parentShell);
        this.forceMakePersistant = forceMakePersistant;
        this.textGridObjects = textGridObjects;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(dialogArea);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 400).applyTo((Control)dialogArea);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, "info.textgrid.lab.xmleditor.mpeditor.SetAdaptorDialog");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.xmleditor.mpeditor.SetAdaptorDialog");
        this.createTargetObjectsArea(dialogArea);
        this.createMakePersistentCheckbox(dialogArea);
        this.createAdaptorSelectionArea(dialogArea);
        this.setTitle(Messages.SetAdaptorDialog_DlgTitle);
        this.setMessage(Messages.SetAdaptorDialog_DlgMessage);
        if (this.getShell() != null) {
            this.getShell().setText(Messages.SetAdaptorDialog_ShellTitle);
        }
        return dialogArea;
    }

    private void createAdaptorSelectionArea(Composite dialogArea) {
        Label adaptorInfo = new Label(dialogArea, 64);
        adaptorInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        adaptorInfo.setText(Messages.SetAdaptorDialog_AdapterInfo);
        this.adaptorViewer = new TextGridObjectTableViewer(dialogArea, 65540);
        this.adaptorViewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        final Button noAdaptor = new Button(dialogArea, 16);
        noAdaptor.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        noAdaptor.setText(Messages.SetAdaptorDialog_6);
        ExclusiveSelection.on((Control[])new Control[]{noAdaptor, this.adaptorViewer.getTable()});
        this.adaptorViewer.getDefaultContentProvider().addDoneListener(new DeferredListContentProvider.IDoneListener(){

            public void loadDone(Viewer viewer) {
                if (SetAdaptorDialog.this.textGridObjects.length >= 1 && SetAdaptorDialog.this.textGridObjects[0] != null) {
                    try {
                        URI currentAdaptor = SetAdaptorDialog.this.textGridObjects[0].getAdaptor();
                        if (currentAdaptor == null) {
                            noAdaptor.setSelection(true);
                        } else {
                            SetAdaptorDialog.this.adaptorViewer.setSelection((ISelection)new StructuredSelection((Object)TextGridObject.getInstance((URI)currentAdaptor, (boolean)false)), true);
                        }
                    }
                    catch (CrudServiceException e) {
                        StatusManager.getManager().handle((CoreException)((Object)e), "info.textgrid.lab.xmleditor.mpeditor");
                    }
                }
            }
        });
        this.adaptorViewer.queryMetadata(Messages.SetAdaptorDialog_7);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.adaptorViewer.getControl());
    }

    private void createMakePersistentCheckbox(Composite dialogArea) {
        this.makePersistentButton = new Button(dialogArea, 32);
        this.makePersistentButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.makePersistentButton.setText(Messages.SetAdaptorDialog_8);
        this.makePersistentButton.setToolTipText(String.valueOf(Messages.SetAdaptorDialog_9) + Messages.SetAdaptorDialog_10 + Messages.SetAdaptorDialog_11 + Messages.SetAdaptorDialog_12);
        if (this.forceMakePersistant) {
            this.makePersistentButton.setSelection(true);
            this.makePersistentButton.setEnabled(false);
        }
    }

    private void createTargetObjectsArea(Composite dialogArea) {
        Label targetInfo = new Label(dialogArea, 64);
        targetInfo.setLayoutData((Object)new GridData(4, 4, true, false));
        targetInfo.setText(MessageFormat.format(Messages.SetAdaptorDialog_13, this.textGridObjects.length));
        TextGridObjectTableViewer targetObjects = new TextGridObjectTableViewer(dialogArea, 32768);
        targetObjects.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(targetObjects.getControl());
        targetObjects.setContentProvider((IContentProvider)new ArrayContentProvider());
        targetObjects.setInput((Object)this.textGridObjects);
        targetObjects.getTable().setEnabled(false);
    }

    protected void okPressed() {
        final boolean makePersistant = this.makePersistentButton.getSelection();
        ISelection selection = this.adaptorViewer.getSelection();
        final TextGridObject adaptor = selection.isEmpty() ? null : (TextGridObject)((IStructuredSelection)selection).getFirstElement();
        Job setAdaptors = new Job(Messages.SetAdaptorDialog_14){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(SetAdaptorDialog.this.textGridObjects.length * 10));
                TextGridObject[] textGridObjectArray = SetAdaptorDialog.this.textGridObjects;
                int n = textGridObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextGridObject textGridObject = textGridObjectArray[n2];
                    try {
                        if (adaptor != null) {
                            textGridObject.setAdaptor(adaptor.getURI());
                        } else {
                            textGridObject.clearAdaptor();
                        }
                        progress.worked(1);
                        if (makePersistant) {
                            textGridObject.makeMetadataPersistent((IProgressMonitor)progress.newChild(9));
                        } else {
                            progress.worked(9);
                        }
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 3);
                    }
                    ++n2;
                }
                progress.done();
                return Status.OK_STATUS;
            }
        };
        setAdaptors.setUser(true);
        setAdaptors.schedule();
        super.okPressed();
    }
}

