/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.invoker.Factory;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.SingletonFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJAXWSMethodInvoker
extends FactoryInvoker {
    public AbstractJAXWSMethodInvoker(Object bean) {
        super(new SingletonFactory(bean));
    }

    public AbstractJAXWSMethodInvoker(Factory factory) {
        super(factory);
    }

    protected SOAPFaultException findSoapFaultException(Throwable ex) {
        if (ex instanceof SOAPFaultException) {
            return (SOAPFaultException)ex;
        }
        if (ex.getCause() != null) {
            return this.findSoapFaultException(ex.getCause());
        }
        return null;
    }

    @Override
    protected Fault createFault(Throwable ex, Method m, List<Object> params, boolean checked) {
        SOAPFaultException sfe = this.findSoapFaultException(ex);
        if (sfe != null) {
            SoapFault fault = new SoapFault(sfe.getFault().getFaultString(), ex, sfe.getFault().getFaultCodeAsQName());
            fault.setRole(sfe.getFault().getFaultActor());
            if (sfe.getFault().hasDetail()) {
                fault.setDetail((Element)sfe.getFault().getDetail());
            }
            return fault;
        }
        return super.createFault(ex, m, params, checked);
    }

    protected Map<String, Object> removeHandlerProperties(WrappedMessageContext ctx) {
        Map scopes = CastUtils.cast((Map)ctx.get(WrappedMessageContext.SCOPES));
        HashMap<String, Object> handlerScopedStuff = new HashMap<String, Object>();
        if (scopes != null) {
            for (Map.Entry scope : scopes.entrySet()) {
                if (scope.getValue() != MessageContext.Scope.HANDLER) continue;
                handlerScopedStuff.put((String)scope.getKey(), ctx.get(scope.getKey()));
            }
            for (String key : handlerScopedStuff.keySet()) {
                ctx.remove(key);
            }
        }
        return handlerScopedStuff;
    }

    protected void addHandlerProperties(WrappedMessageContext ctx, Map<String, Object> handlerScopedStuff) {
        for (Map.Entry<String, Object> key : handlerScopedStuff.entrySet()) {
            ctx.put(key.getKey(), key.getValue(), MessageContext.Scope.HANDLER);
        }
    }

    private Message createResponseMessage(Exchange exchange) {
        if (exchange == null) {
            return null;
        }
        Message m = exchange.getOutMessage();
        if (m == null && !exchange.isOneWay()) {
            Endpoint ep = exchange.get(Endpoint.class);
            m = new MessageImpl();
            m.setExchange(exchange);
            m = ep.getBinding().createMessage(m);
            exchange.setOutMessage(m);
        }
        return m;
    }

    protected void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        SoapMessage sm;
        List list;
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty() && (sm = (SoapMessage)this.createResponseMessage(exchange)) != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                sm.getHeaders().add((Header)iter.next());
            }
        }
        if (exchange.getOutMessage() != null) {
            Map dataHandlers;
            Map heads;
            Message out = exchange.getOutMessage();
            if (out.containsKey(Message.PROTOCOL_HEADERS) && (heads = CastUtils.cast((Map)exchange.getOutMessage().get(Message.PROTOCOL_HEADERS))).containsKey("Content-Type")) {
                List ct = (List)heads.get("Content-Type");
                exchange.getOutMessage().put("Content-Type", ct.get(0));
                heads.remove("Content-Type");
            }
            if ((dataHandlers = CastUtils.cast((Map)out.get("javax.xml.ws.binding.attachments.outbound"))) != null && !dataHandlers.isEmpty()) {
                Collection<Attachment> attachments = out.getAttachments();
                if (attachments == null) {
                    attachments = new ArrayList<Attachment>();
                    out.setAttachments(attachments);
                }
                for (Map.Entry entry : dataHandlers.entrySet()) {
                    AttachmentImpl att = new AttachmentImpl((String)entry.getKey(), (DataHandler)entry.getValue());
                    attachments.add(att);
                }
            }
            out.remove("javax.xml.ws.binding.attachments.outbound");
        }
    }

    protected void updateHeader(Exchange exchange, MessageContext ctx) {
        SoapMessage sm;
        List list;
        if (ctx.containsKey((Object)Header.HEADER_LIST) && ctx.get((Object)Header.HEADER_LIST) instanceof List && (list = (List)ctx.get((Object)Header.HEADER_LIST)) != null && !list.isEmpty() && (sm = (SoapMessage)this.createResponseMessage(exchange)) != null) {
            for (Header header : list) {
                if (header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd") || header.getName().getNamespaceURI().equals("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd")) continue;
                sm.getHeaders().add(header);
            }
        }
    }
}

