/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.dictionarylinkeditor.views;

import com.swtdesigner.SWTResourceManager;
import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.dictionarylinkeditor.LinkRoot;
import info.textgrid.lab.dictionarylinkeditor.WBLemma;
import info.textgrid.lab.dictionarylinkeditor.WBLink;
import info.textgrid.lab.dictionarylinkeditor.WBLinkGroup;
import info.textgrid.lab.dictionarylinkeditor.views.WBLinkEditingSupport;
import info.textgrid.lab.dictionarysearch.Activator;
import info.textgrid.lab.dictionarysearch.client.Wbb_WebService_Impl;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.text.Collator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DictionaryLinkEditor
extends ViewPart {
    public static final String WBL_AUTHZ_PROJECT = "TGPR188";
    public static final String WBL_EDITOR = "Bearbeiter";
    public static final String WBL_ADMIN = "Administrator";
    public static final boolean DEBUG_OUTPUT = false;
    public static String whoIsLoggedIn = "";
    private TableViewer viewer;
    private WBLemma sourceLemma;
    private Action action1;
    private Action action2;
    private boolean targetState = false;
    private boolean showHistory = false;
    private LinkRoot linkRoot;
    private Wbb_WebService_Impl wbservice = null;
    public static String[] semanticRelations;
    public static String[] etymRelations;
    private Composite topBar;
    private Composite bottomBar;
    private Label sourceLabel;
    private Label sourceWBLabel;
    private Label topHint;
    private Label toggleHistoryLabel;
    private Label finishLabel;
    private Label finishLabel2;
    private int failedToWrite = 0;
    private static Image CHECKED;
    private static Image UNCHECKED;
    private static Image IMMUTABLE;
    private static Image NEWLINK;
    private static Image MANUALLINK;
    private static Image COMPUTEDLINK;
    public static final int MANUALORCOMPUTEDAPPROVEDID = 0;
    private static Image BOOKLINK;
    public static final int BOOKAPPROVEDID = 1;
    private static Image EDITORLINK;
    public static final int EDITORAPPROVEDID = 2;
    private static Image ADMINLINK;
    public static final int ADMINAPPROVEDID = 3;
    private static Image DOUBTLINK;
    public static final int DOUBTAPPROVEDID = 9;
    private static Image DELETEDLINK;
    private Button setButton;
    private Button doubtButton;
    private Button historyButton;
    private Button finishButton;
    private Button cancelButton;
    private Button deleteButton;
    private boolean enableButtons = false;
    private AuthBrowser.ISIDChangedListener sidChangedListener;
    private SelectionListener disableSelectionListener;
    private Group group;

    public DictionaryLinkEditor() {
        try {
            CHECKED = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/checked.gif"), null))).createImage();
            UNCHECKED = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/unchecked.gif"), null))).createImage();
            IMMUTABLE = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/grey.gif"), null))).createImage();
            NEWLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/new.png"), null))).createImage();
            MANUALLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/manual.png"), null))).createImage();
            COMPUTEDLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/computed.png"), null))).createImage();
            BOOKLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/book.png"), null))).createImage();
            EDITORLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/editor.png"), null))).createImage();
            ADMINLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/admin.png"), null))).createImage();
            DOUBTLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/doubt.png"), null))).createImage();
            DELETEDLINK = ImageDescriptor.createFromURL((URL)FileLocator.toFileURL((URL)FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("icons/deleted.png"), null))).createImage();
        }
        catch (IOException e1) {
            Activator.handleProblem(4, e1, "Could not find icons", new Object[0]);
        }
        try {
            this.wbservice = new Wbb_WebService_Impl();
        }
        catch (Exception e) {
            Activator.handleProblem(4, e, "Could not initialize webservice for wbb", new Object[0]);
        }
        Document semdocument = null;
        Document etymdocument = null;
        try {
            String semenclosure = this.wbservice.getWbb_WebServiceSoap().wbb_getAllSemanticRelations();
            String etymenclosure = this.wbservice.getWbb_WebServiceSoap().wbb_getAllEtymRelations();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            semdocument = parser.parse(new InputSource(new StringReader(semenclosure)));
            etymdocument = parser.parse(new InputSource(new StringReader(etymenclosure)));
        }
        catch (RemoteException e) {
            Activator.handleProblem(4, e, "Could not retrieve relation names from Wbb", new Object[0]);
        }
        catch (SAXException e) {
            Activator.handleProblem(4, e, "Could not parse result from wbb", new Object[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            Activator.handleProblem(4, e, "Could not build parser", new Object[0]);
        }
        NodeList semrelationNodeList = semdocument.getElementsByTagName("relation");
        int semrelationNumber = semrelationNodeList.getLength();
        semanticRelations = new String[semrelationNumber];
        int i = 0;
        while (i < semrelationNumber) {
            String relName;
            Element r = (Element)semrelationNodeList.item(i);
            String id = r.getAttribute("id");
            Integer idInteger = new Integer(id);
            if (i != idInteger) {
                System.err.println("Warning: Relation Ids do not start with 0 (found Id " + idInteger + " at index " + i);
            }
            DictionaryLinkEditor.semanticRelations[i] = relName = r.getFirstChild().getNodeValue();
            ++i;
        }
        NodeList etymrelationNodeList = etymdocument.getElementsByTagName("relation");
        int etymrelationNumber = etymrelationNodeList.getLength();
        etymRelations = new String[etymrelationNumber];
        int i2 = 0;
        while (i2 < etymrelationNumber) {
            String relName;
            Element r = (Element)etymrelationNodeList.item(i2);
            String id = r.getAttribute("id");
            Integer idInteger = new Integer(id);
            if (i2 != idInteger) {
                System.err.println("Warning: Relation Ids do not start with 0 (found Id " + idInteger + " at index " + i2);
            }
            DictionaryLinkEditor.etymRelations[i2] = relName = r.getFirstChild().getNodeValue();
            ++i2;
        }
    }

    public void createPartControl(Composite parent) {
        this.findOutWhoIsLoggedIn(RBACSession.getInstance().getSID(false));
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            public void sidChanged(String newSID, String newEPPN) {
                DictionaryLinkEditor.this.findOutWhoIsLoggedIn(newSID);
                if (DictionaryLinkEditor.this.linkRoot != null) {
                    DictionaryLinkEditor.this.linkRoot.retrieveLinks();
                    DictionaryLinkEditor.this.linkRoot.toggleHistory(DictionaryLinkEditor.this.showHistory);
                    DictionaryLinkEditor.this.setButtonsEnabled(DictionaryLinkEditor.this.enableButtons);
                }
            }
        };
        AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        this.linkRoot = new LinkRoot();
        Composite c = new Composite(parent, 4);
        GridData cGD = new GridData();
        cGD.horizontalAlignment = 4;
        cGD.grabExcessVerticalSpace = true;
        cGD.grabExcessHorizontalSpace = true;
        cGD.heightHint = 100;
        cGD.widthHint = 400;
        cGD.verticalAlignment = 4;
        c.setLayout((Layout)new GridLayout(1, false));
        this.topBar = new Composite(c, 4);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 6;
        this.topBar.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)this.topBar);
        Label sourceLabelTitle = new Label(this.topBar, 0);
        sourceLabelTitle.setText("Source Lemma");
        this.sourceLabel = new Label(this.topBar, 2048);
        this.sourceLabel.setToolTipText("");
        this.sourceLabel.setBackground(SWTResourceManager.getColor(1));
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData[] fdatab = defaultFont.getFontData();
        int i = 0;
        while (i < fdatab.length) {
            fdatab[i].setStyle(1);
            ++i;
        }
        this.sourceLabel.setFont(new Font(null, fdatab));
        this.sourceLabel.setText("");
        this.sourceWBLabel = new Label(this.topBar, 0);
        this.sourceWBLabel.setFont(SWTResourceManager.getFont("Tahoma", 8, 1));
        this.sourceWBLabel.setBackground(SWTResourceManager.getColor(1));
        this.sourceWBLabel.setToolTipText("");
        this.sourceWBLabel.setText("");
        this.topHint = new Label(this.topBar, 0);
        this.topHint.setForeground(SWTResourceManager.getColor(9));
        this.topHint.setText("");
        this.group = new Group(this.topBar, 16);
        GridLayout gridLayout_1 = new GridLayout(3, false);
        gridLayout_1.verticalSpacing = 1;
        gridLayout_1.marginWidth = 1;
        gridLayout_1.marginHeight = 1;
        gridLayout_1.horizontalSpacing = 1;
        this.group.setLayout((Layout)gridLayout_1);
        GridData gridData = new GridData(0x1000000, 0x1000000, true, true, 1, 1);
        gridData.heightHint = 25;
        gridData.widthHint = 238;
        this.group.setLayoutData((Object)gridData);
        this.historyButton = new Button((Composite)this.group, 2);
        gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData.heightHint = 16;
        this.historyButton.setLayoutData((Object)gridData);
        this.historyButton.setToolTipText("You can show/hide the change history, if available.");
        this.historyButton.setText("Show/Hide");
        new Label((Composite)this.group, 0);
        this.toggleHistoryLabel = new Label((Composite)this.group, 0);
        this.toggleHistoryLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.toggleHistoryLabel.setText("history of changes");
        this.historyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DictionaryLinkEditor.this.showHistory) {
                    DictionaryLinkEditor.this.showHistory = false;
                    DictionaryLinkEditor.this.linkRoot.toggleHistory(false);
                } else {
                    DictionaryLinkEditor.this.showHistory = true;
                    DictionaryLinkEditor.this.linkRoot.toggleHistory(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer = new TableViewer(c, 66306);
        this.viewer.getTable();
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.disableSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.viewer.getTable().deselectAll();
            }
        };
        this.viewer.getTable().addSelectionListener(this.disableSelectionListener);
        TableViewerColumn tcChecked = new TableViewerColumn(this.viewer, 0);
        TableColumn tableColumn = tcChecked.getColumn();
        tableColumn.setAlignment(0x1000000);
        tcChecked.getColumn().setText("Selected");
        tcChecked.getColumn().setToolTipText("Select links to delete, approve or mark them as doubtful.\r\nWhen the box is\r\n\tgrey, you do not have the rights to modify these links.");
        tcChecked.getColumn().setWidth(55);
        tcChecked.setEditingSupport((EditingSupport)new WBLinkEditingSupport((ColumnViewer)this.viewer, 0));
        TableViewerColumn tcAppr = new TableViewerColumn(this.viewer, 0);
        TableColumn tableColumn_1 = tcAppr.getColumn();
        tableColumn_1.setAlignment(0x1000000);
        tcAppr.getColumn().setText("Status");
        tcAppr.getColumn().setToolTipText("Status of this Link. Will be:\r\n\t(X)\tRED when it is deleted,\r\n\t(+)\tBLUE when manually added but unsaved yet,\r\n\t(LIGHT GREY)\tfor untouched links:\r\n\t(C)\tomputed when calculated,\r\n\t(B)\took when inferred from printed dictionaries,\r\n\t(M)\tanually when manually added by other means,\r\n\t(E)\tLIGHT GREEN when approved by an Editor,\r\n\t(A)\tDARK GREEN when approved by an Administrator, and\r\n\t(?)\tYELLOW when marked as doubtful");
        tcAppr.getColumn().setWidth(45);
        TableViewerColumn tcDesc = new TableViewerColumn(this.viewer, 0);
        tcDesc.getColumn().setText("Target Lemma");
        tcDesc.getColumn().setWidth(120);
        TableViewerColumn tcStart = new TableViewerColumn(this.viewer, 0);
        tcStart.getColumn().setText("Dictionary");
        tcStart.getColumn().setWidth(60);
        TableViewerColumn tcStat = new TableViewerColumn(this.viewer, 0);
        tcStat.getColumn().setText("Status");
        tcStat.getColumn().setWidth(125);
        TableViewerColumn tcSemRel = new TableViewerColumn(this.viewer, 0);
        tcSemRel.getColumn().setText("Semantic");
        tcSemRel.getColumn().setWidth(90);
        tcSemRel.setEditingSupport((EditingSupport)new WBLinkEditingSupport((ColumnViewer)this.viewer, 5));
        TableViewerColumn tcEtymRel = new TableViewerColumn(this.viewer, 0);
        tcEtymRel.getColumn().setText("Etymological");
        tcEtymRel.getColumn().setWidth(90);
        tcEtymRel.setEditingSupport((EditingSupport)new WBLinkEditingSupport((ColumnViewer)this.viewer, 6));
        TableViewerColumn tcEdi = new TableViewerColumn(this.viewer, 0);
        tcEdi.getColumn().setText("Editor");
        tcEdi.getColumn().setWidth(120);
        TableViewerColumn tcCom = new TableViewerColumn(this.viewer, 0);
        tcCom.getColumn().setText("Comment");
        tcCom.getColumn().setWidth(400);
        tcCom.setEditingSupport((EditingSupport)new WBLinkEditingSupport((ColumnViewer)this.viewer, 8));
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameTimeSorter());
        this.viewer.setInput((Object)this.linkRoot.getList());
        GridData vGD = new GridData();
        vGD.horizontalAlignment = 4;
        vGD.grabExcessVerticalSpace = true;
        vGD.grabExcessHorizontalSpace = true;
        vGD.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)vGD);
        this.bottomBar = new Composite(c, 4);
        this.bottomBar.setLayout((Layout)new GridLayout(8, false));
        GridDataFactory.fillDefaults().applyTo((Control)this.bottomBar);
        this.cancelButton = new Button(this.bottomBar, 8);
        this.cancelButton.setText("Cancel changes");
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.targetState = false;
                DictionaryLinkEditor.this.setLemma(DictionaryLinkEditor.this.sourceLemma);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deleteButton = new Button(this.bottomBar, 8);
        this.deleteButton.setText("Delete selected links");
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.deleteSelectedLinks();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setButton = new Button(this.bottomBar, 8);
        this.setButton.setText("Set/Approve selected links");
        this.setButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.setSelectedLinks();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.doubtButton = new Button(this.bottomBar, 8);
        this.doubtButton.setText("Mark selected links doubtful");
        this.doubtButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.doubtSelectedLinks();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.finishButton = new Button(this.bottomBar, 8);
        this.finishButton.setText("Finish");
        this.finishButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DictionaryLinkEditor.this.makeBlank();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.finishLabel = new Label(this.bottomBar, 0);
        this.finishLabel.setText("");
        this.finishLabel2 = new Label(this.bottomBar, 2048);
        this.finishLabel2.setBackground(SWTResourceManager.getColor(1));
        this.finishLabel2.setText("");
        this.finishLabel2.setFont(SWTResourceManager.getFont("Tahoma", 8, 1));
        new Label(this.bottomBar, 0);
        this.setButtonsEnabled(this.enableButtons);
    }

    private void setSelectedLinks() {
        int i = 0;
        for (WBLink oneLink : this.linkRoot.getList()) {
            if (!oneLink.isTouched()) continue;
            ++i;
            oneLink.setDeleted(false);
            if (whoIsLoggedIn.equals(WBL_ADMIN)) {
                this.makePermanent(oneLink, 3, false);
                continue;
            }
            this.makePermanent(oneLink, 2, true);
        }
        this.postWrite(i);
    }

    private void deleteSelectedLinks() {
        int i = 0;
        for (WBLink oneLink : this.linkRoot.getList()) {
            if (!oneLink.isTouched() || oneLink.isDeleted() || "9999".equals(oneLink.getTimestamp())) continue;
            ++i;
            oneLink.setDeleted(true);
            oneLink.setSemanticRelationID(-1);
            oneLink.setEtymRelationID(-1);
            if (whoIsLoggedIn.equals(WBL_ADMIN)) {
                this.makePermanent(oneLink, 3, false);
                continue;
            }
            if (oneLink.getQualityID() >= 5) {
                this.makePermanent(oneLink, 2, false);
                continue;
            }
            if (oneLink.getQualityID() >= 1 && oneLink.getQualityID() <= 3) {
                oneLink.setDeleted(false);
                this.makePermanent(oneLink, 9, true);
                continue;
            }
            this.makePermanent(oneLink, 2, true);
        }
        this.postWrite(i);
    }

    private void doubtSelectedLinks() {
        int i = 0;
        for (WBLink oneLink : this.linkRoot.getList()) {
            if (!oneLink.isTouched()) continue;
            ++i;
            this.makePermanent(oneLink, 9, true);
        }
        this.postWrite(i);
    }

    private void makePermanent(WBLink l, int approve, boolean editable) {
        boolean success = false;
        String sessionId = RBACSession.getInstance().getSID(true);
        String encodedComment = "";
        try {
            encodedComment = URLEncoder.encode(l.getComment(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        try {
            String response = this.wbservice.getWbb_WebServiceSoap().wbb_setLink(l.getSourceLemma().getID(), l.getSourceLemma().getWbShortName(), l.getTargetLemma().getID(), l.getTargetLemma().getWbShortName(), RBACSession.getInstance().getEPPN(), Integer.toString(l.getQualityID()), encodedComment, Integer.toString(l.getSemanticRelationID()), Integer.toString(l.getEtymRelationID()), sessionId, Integer.toString(approve), l.isDeleted() ? "1" : "0", editable ? "1" : "0");
            if ("false".equals(response)) {
                ++this.failedToWrite;
            } else {
                success = true;
            }
        }
        catch (RemoteException e) {
            Activator.handleProblem(4, e, "Could not write this link to wbb", new Object[0]);
            ++this.failedToWrite;
        }
        if (success) {
            this.linkRoot.removeFromUnprocessedList(l);
        }
    }

    private void postWrite(int numLinksWantedToWrite) {
        if (this.failedToWrite > 0) {
            this.showMessage("Could not write " + this.failedToWrite + " links to the database (out of " + numLinksWantedToWrite + ").");
        }
        this.failedToWrite = 0;
        this.linkRoot.retrieveLinks();
        this.linkRoot.toggleHistory(this.showHistory);
    }

    private void makeBlank() {
        this.targetState = false;
        this.sourceLabel.setText("<please select>");
        this.sourceLabel.setToolTipText("Select <source Lemma (Link)> from the \"Dictionary Search Results\"-View.");
        this.sourceWBLabel.setText("");
        this.topHint.setText("");
        this.topBar.pack();
        this.finishLabel.setText("");
        this.finishLabel2.setText("");
        this.bottomBar.pack();
        this.sourceLemma = null;
        this.linkRoot.setSourceLemma(null);
        this.cancelButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.setButton.setEnabled(false);
        this.doubtButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.historyButton.setEnabled(false);
        this.toggleHistoryLabel.setEnabled(false);
    }

    public void setLemma(WBLemma wbLemma) {
        this.setButtonsEnabledIfOk();
        if (this.targetState) {
            if (this.sourceLemma.getID().equals(wbLemma.getID())) {
                this.showMessage("Cannot make a link that points back to the source lemma.");
                return;
            }
            if (WBLinkGroup.isInRegistry(this.sourceLemma.getID(), wbLemma.getID())) {
                this.showMessage("This link is already present, please edit the existing one(s) instead of adding a new one.");
                return;
            }
            WBLink addedLink = this.linkRoot.addNewLink(wbLemma);
            this.viewer.reveal((Object)addedLink);
        } else {
            this.sourceLemma = wbLemma;
            this.linkRoot.setSourceLemma(wbLemma);
            this.linkRoot.toggleHistory(this.showHistory);
            this.sourceLabel.setText("  " + wbLemma.getName() + "  ");
            this.sourceWBLabel.setText(" " + wbLemma.getWbShortName() + " ");
            this.sourceWBLabel.setForeground(wbLemma.getWbFgColor());
            this.topHint.setText("<add new target lemmas or modify existing ones>");
            this.topHint.setToolTipText("Add target lemmas by clicking on their @ or -- sign, or edit existing ones here");
            this.topBar.pack();
            this.finishLabel.setText("editing");
            this.finishLabel2.setText("  " + wbLemma.getName() + "  ");
            this.bottomBar.pack();
            this.targetState = true;
        }
    }

    private void setButtonsEnabledIfOk() {
        this.sourceLabel.setToolTipText("");
        this.finishButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
        if (this.enableButtons) {
            this.deleteButton.setEnabled(true);
            this.setButton.setEnabled(true);
            this.doubtButton.setEnabled(true);
            this.historyButton.setEnabled(true);
            this.toggleHistoryLabel.setEnabled(true);
        }
    }

    public void setTargetState(boolean wantTargetState) {
        this.targetState = wantTargetState;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DictionaryLinkEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                DictionaryLinkEditor.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                DictionaryLinkEditor.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Dictionary Link Editor", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private String findOutWhoIsLoggedIn(String sid) {
        if (!"".equals(sid)) {
            if (TextGridProject.checkForRole((String)WBL_AUTHZ_PROJECT, (String)WBL_ADMIN)) {
                whoIsLoggedIn = WBL_ADMIN;
                this.enableButtons = true;
            } else if (TextGridProject.checkForRole((String)WBL_AUTHZ_PROJECT, (String)WBL_EDITOR)) {
                whoIsLoggedIn = WBL_EDITOR;
                this.enableButtons = true;
            } else {
                whoIsLoggedIn = "";
                this.enableButtons = false;
            }
        } else {
            whoIsLoggedIn = "";
            this.enableButtons = false;
        }
        return whoIsLoggedIn;
    }

    private void setButtonsEnabled(boolean enableButtons) {
        if (!this.finishButton.isEnabled()) {
            this.setButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.doubtButton.setEnabled(false);
            this.historyButton.setEnabled(false);
            this.toggleHistoryLabel.setEnabled(false);
        } else {
            this.setButton.setEnabled(enableButtons);
            this.deleteButton.setEnabled(enableButtons);
            this.doubtButton.setEnabled(enableButtons);
            this.historyButton.setEnabled(enableButtons);
            this.toggleHistoryLabel.setEnabled(enableButtons);
        }
        this.bottomBar.pack();
    }

    public synchronized void dispose() {
        if (this.sidChangedListener != null) {
            AuthBrowser.removeSIDChangedListener((AuthBrowser.ISIDChangedListener)this.sidChangedListener);
        }
        if (this.disableSelectionListener != null && !this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().removeSelectionListener(this.disableSelectionListener);
        }
        super.dispose();
    }

    class NameTimeSorter
    extends ViewerSorter {
        Collator col = Collator.getInstance();

        NameTimeSorter() {
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            WBLink wbl1 = (WBLink)o1;
            WBLink wbl2 = (WBLink)o2;
            int level1 = this.col.compare(wbl1.getTargetLemma().getName(), wbl2.getTargetLemma().getName());
            if (level1 != 0) {
                return level1;
            }
            int level2 = this.col.compare(wbl1.getTargetLemma().getWbShortName(), wbl2.getTargetLemma().getWbShortName());
            if (level2 != 0) {
                return level2;
            }
            return wbl1.getTimestamp().compareTo(wbl2.getTimestamp());
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            WBLink wbl = (WBLink)obj;
            if (index == 0) {
                return null;
            }
            if (index == 1) {
                return null;
            }
            if (index == 2) {
                return wbl.getTargetLemma().getName();
            }
            if (index == 3) {
                return wbl.getTargetLemma().getWbShortName();
            }
            if (index == 4) {
                return wbl.getQualityStringFromID();
            }
            if (index == 5) {
                if (wbl.getSemanticRelationID() == -1) {
                    return "<none>";
                }
                if (wbl.getSemanticRelationID() >= 0 && wbl.getSemanticRelationID() < semanticRelations.length) {
                    return semanticRelations[wbl.getSemanticRelationID()];
                }
                return "<unknown>";
            }
            if (index == 6) {
                if (wbl.getEtymRelationID() == -1) {
                    return "<none>";
                }
                if (wbl.getEtymRelationID() >= 0 && wbl.getEtymRelationID() < etymRelations.length) {
                    return etymRelations[wbl.getEtymRelationID()];
                }
                return "<unknown>";
            }
            if (index == 7) {
                return wbl.getEditor();
            }
            if (index == 8) {
                return wbl.getComment();
            }
            return "extra column " + index;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                WBLink wbl = (WBLink)obj;
                if (wbl.immutable(whoIsLoggedIn)) {
                    return IMMUTABLE;
                }
                if (wbl.isTouched()) {
                    return CHECKED;
                }
                return UNCHECKED;
            }
            if (index == 1) {
                WBLink wbl = (WBLink)obj;
                if (wbl.isDeleted()) {
                    return DELETEDLINK;
                }
                if (wbl.isManuallyAdded()) {
                    return NEWLINK;
                }
                switch (wbl.getApproved()) {
                    case 0: {
                        if (wbl.getQualityID() == 4) {
                            return MANUALLINK;
                        }
                        return COMPUTEDLINK;
                    }
                    case 1: {
                        return BOOKLINK;
                    }
                    case 2: {
                        return EDITORLINK;
                    }
                    case 3: {
                        return ADMINLINK;
                    }
                    case 9: {
                        return DOUBTLINK;
                    }
                }
                return null;
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

