/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import com.google.common.collect.Lists;
import info.textgrid._import.ImportObject;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.ui.Messages;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class OverwriteDialog
extends MessageDialog {
    private final OverwriteEntry[] entries;

    protected OverwriteDialog(Shell parentShell, OverwriteEntry[] entries) {
        super(parentShell, Messages.OverwriteDialog_Title, null, Messages.OverwriteDialog_DialogMessage, 3, new String[]{Messages.OverwriteDialog_CancelButton, Messages.OverwriteDialog_OverwriteButton}, 1);
        this.entries = entries;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        TableViewer viewer = new TableViewer(parent, 65536);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn objectColumn = new TableViewerColumn(viewer, 16384);
        objectColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof OverwriteEntry) {
                    try {
                        return ((OverwriteEntry)element).entry.getObject().getContentType(false).getImage(true);
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof OverwriteEntry) {
                    try {
                        return ((OverwriteEntry)element).entry.getObject().getTitle();
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
                    }
                }
                return super.getText(element);
            }
        });
        objectColumn.getColumn().setText(Messages.OverwriteDialog_TGOColumnTitle);
        objectColumn.getColumn().setWidth(137);
        TableViewerColumn fileColumn = new TableViewerColumn(viewer, 16384);
        fileColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof OverwriteEntry) {
                    if (((OverwriteEntry)element).fileExists) {
                        return ((OverwriteEntry)element).file.getPath();
                    }
                    return "";
                }
                return super.getText(element);
            }
        });
        fileColumn.getColumn().setMoveable(true);
        fileColumn.getColumn().setText(Messages.OverwriteDialog_ExistingFileColumnTitle);
        fileColumn.getColumn().setWidth(150);
        TableViewerColumn metaColumn = new TableViewerColumn(viewer, 16384);
        metaColumn.getColumn().setMoveable(true);
        metaColumn.getColumn().setText(Messages.OverwriteDialog_ExistingMetaColumnTitle);
        metaColumn.getColumn().setWidth(150);
        metaColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof OverwriteEntry) {
                    if (((OverwriteEntry)element).metaExists) {
                        return ((OverwriteEntry)element).metaFile.getPath();
                    }
                    return "";
                }
                return super.getText(element);
            }
        });
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setInput((Object)this.entries);
        return viewer.getControl();
    }

    public static boolean mayContinue(ImportModel model, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.OverwriteDialog_CheckingProgressMessage, (int)(model.getImportObject().size() + 1));
        final ArrayList entries = Lists.newArrayList();
        for (ImportObject object : model.getImportObject()) {
            if (progress.isCanceled()) {
                return false;
            }
            OverwriteEntry entry = new OverwriteEntry(model, (ImportEntry)object);
            if (entry.somethingExists()) {
                entries.add(entry);
            }
            progress.worked(1);
        }
        if (entries.size() == 0) {
            return true;
        }
        UIJob uiJob = new UIJob(Messages.OverwriteDialog_11){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                OverwriteDialog dialog = new OverwriteDialog(null, entries.toArray(new OverwriteEntry[0]));
                dialog.setBlockOnOpen(true);
                int result = dialog.open();
                if (result == 1) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
        try {
            uiJob.join();
            return uiJob.getResult().isOK();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static class OverwriteEntry {
        public final ImportEntry entry;
        public final boolean fileExists;
        public final boolean metaExists;
        public final File metaFile;
        public final File file;

        public OverwriteEntry(ImportModel model, ImportEntry object) {
            this.entry = object;
            this.file = model.resolve(this.entry.getLocalFile());
            this.fileExists = this.file.exists();
            this.metaFile = model.resolve(this.entry.getLocalMetadataFile());
            this.metaExists = this.metaFile.exists();
        }

        public boolean somethingExists() {
            return this.fileExists || this.metaExists;
        }
    }
}

