/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CryptoCoverageUtil {
    private CryptoCoverageUtil() {
    }

    public static void reconcileEncryptedSignedRefs(Collection<WSDataRef> signedRefs, Collection<WSDataRef> encryptedRefs) {
        LinkedList<WSDataRef> encryptedSignedRefs = new LinkedList<WSDataRef>();
        for (WSDataRef encryptedRef : encryptedRefs) {
            for (WSDataRef signedRef : signedRefs) {
                if (!CryptoCoverageUtil.isSignedEncryptionRef(encryptedRef, signedRef)) continue;
                WSDataRef encryptedSignedRef = new WSDataRef();
                encryptedSignedRef.setWsuId(signedRef.getWsuId());
                encryptedSignedRef.setContent(false);
                encryptedSignedRef.setName(encryptedRef.getName());
                encryptedSignedRef.setProtectedElement(encryptedRef.getProtectedElement());
                encryptedSignedRef.setXpath(encryptedRef.getXpath());
                encryptedSignedRefs.add(encryptedSignedRef);
            }
        }
        signedRefs.addAll(encryptedSignedRefs);
    }

    public static void checkBodyCoverage(Element soapBody, Collection<WSDataRef> refs, CoverageType type, CoverageScope scope) throws WSSecurityException {
        if (!CryptoCoverageUtil.matchElement(refs, type, scope, soapBody)) {
            throw new WSSecurityException("The " + CryptoCoverageUtil.getCoverageTypeString(type) + " does not cover the required elements (soap:Body).");
        }
    }

    public static void checkHeaderCoverage(Element soapHeader, Collection<WSDataRef> refs, String namespace, String name, CoverageType type, CoverageScope scope) throws WSSecurityException {
        List<Element> elements = name == null ? DOMUtils.getChildrenWithNamespace(soapHeader, namespace) : DOMUtils.getChildrenWithName(soapHeader, namespace, name);
        for (Element el : elements) {
            if (CryptoCoverageUtil.matchElement(refs, type, scope, el)) continue;
            throw new WSSecurityException("The " + CryptoCoverageUtil.getCoverageTypeString(type) + " does not cover the required elements ({" + namespace + "}" + name + ").");
        }
    }

    public static void checkCoverage(Element soapEnvelope, Collection<WSDataRef> refs, Map<String, String> namespaces, String xPath, CoverageType type, CoverageScope scope) throws WSSecurityException {
        CryptoCoverageUtil.checkCoverage(soapEnvelope, refs, namespaces, Arrays.asList(xPath), type, scope);
    }

    public static void checkCoverage(Element soapEnvelope, Collection<WSDataRef> refs, Map<String, String> namespaces, Collection<String> xPaths, CoverageType type, CoverageScope scope) throws WSSecurityException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (namespaces != null) {
            xpath.setNamespaceContext(new MapNamespaceContext(namespaces));
        }
        for (String xpathString : xPaths) {
            NodeList list;
            try {
                list = (NodeList)xpath.evaluate(xpathString, soapEnvelope, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new WSSecurityException(0);
            }
            if (list.getLength() == 0) continue;
            for (int x = 0; x < list.getLength(); ++x) {
                Element el = (Element)list.item(x);
                boolean instanceMatched = CryptoCoverageUtil.matchElement(refs, type, scope, el);
                if (instanceMatched) continue;
                throw new WSSecurityException("The " + CryptoCoverageUtil.getCoverageTypeString(type) + " does not cover the required elements (" + xpathString + ").");
            }
        }
    }

    private static boolean isSignedEncryptionRef(WSDataRef encryptedRef, WSDataRef signedRef) {
        if (!"http://www.w3.org/2001/04/xmlenc#".equals(signedRef.getProtectedElement().getNamespaceURI())) {
            return false;
        }
        if (signedRef.getWsuId().equals(encryptedRef.getWsuId()) || signedRef.getWsuId().equals("#" + encryptedRef.getWsuId())) {
            return true;
        }
        String wsuId = signedRef.getProtectedElement().getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        return signedRef.getWsuId().equals(wsuId) || signedRef.getWsuId().equals("#" + wsuId);
    }

    private static boolean matchElement(Collection<WSDataRef> refs, CoverageType type, CoverageScope scope, Element el) {
        String id;
        boolean content;
        switch (scope) {
            case CONTENT: {
                content = true;
                break;
            }
            default: {
                content = false;
            }
        }
        Attr idAttr = el.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (idAttr == null) {
            idAttr = el.getAttributeNode("Id");
        }
        String string = id = idAttr == null ? null : idAttr.getValue();
        if (id != null && id.charAt(0) == '#') {
            id = id.substring(1);
        }
        for (WSDataRef r : refs) {
            if (r.getProtectedElement() != el || r.isContent() != content) continue;
            return true;
        }
        return false;
    }

    private static String getCoverageTypeString(CoverageType type) {
        String typeString;
        switch (type) {
            case SIGNED: {
                typeString = "signature";
                break;
            }
            case ENCRYPTED: {
                typeString = "encryption";
                break;
            }
            default: {
                typeString = "crpytography";
            }
        }
        return typeString;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoverageScope {
        CONTENT,
        ELEMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CoverageType {
        ENCRYPTED,
        SIGNED;

    }
}

