/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor.views;

import info.textgrid.lab.core.browserfix.TextGridLabBrowser;
import info.textgrid.lab.xmleditor.mpeditor.views.Messages;
import java.text.MessageFormat;
import net.sf.vex.dom.linked.LinkedNode;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentModelView
extends ViewPart
implements ISelectionListener {
    private Browser currentElementDoc;
    private MarkupTagInfoProvider infoProvider = new MarkupTagInfoProvider();
    private static final String fgStyleSheet = "/* Font definitions */\nbody, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {font-family: sans-serif; font-size: 9pt }\npre\t\t\t\t{ font-family: monospace; font-size: 9pt }\n\n/* Margins */\nbody\t     { overflow: auto; margin-top: 0; margin-bottom: 4; margin-left: 3; margin-right: 0 }\nh1           { margin-top: 5; margin-bottom: 1 }\t\nh2           { margin-top: 25; margin-bottom: 3 }\nh3           { margin-top: 20; margin-bottom: 3 }\nh4           { margin-top: 20; margin-bottom: 3 }\nh5           { margin-top: 0; margin-bottom: 0 }\np            { margin-top: 10px; margin-bottom: 10px }\npre\t         { margin-left: 6 }\nul\t         { margin-top: 0; margin-bottom: 10 }\nli\t         { margin-top: 0; margin-bottom: 0 } \nli p\t     { margin-top: 0; margin-bottom: 0 } \nol\t         { margin-top: 0; margin-bottom: 10 }\ndl\t         { margin-top: 0; margin-bottom: 10 }\ndt\t         { margin-top: 0; margin-bottom: 0; font-weight: bold }\ndd\t         { margin-top: 0; margin-bottom: 0 }\n\n/* Styles and colors */\na:link\t     { color: #0000FF }\na:hover\t     { color: #000080 }\na:visited    { text-decoration: underline }\nh4           { font-style: italic }\nstrong\t     { font-weight: bold }\nem\t         { font-style: italic }\nvar\t         { font-style: italic }\nth\t         { font-weight: bold }\np.spec       { font-size: 7pt; color: gray; border-top: inset 2pt; }\n";

    public void createPartControl(Composite parent) {
        this.currentElementDoc = TextGridLabBrowser.createBrowser((Composite)parent);
        this.setInfoText(Messages.ContentModelView_SelectSomething);
        GridDataFactory.fillDefaults().applyTo((Control)this.currentElementDoc);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    private void setInfoText(String fragment) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>");
        sb.append(Messages.ContentModelView_ContentModel);
        sb.append("</title><style type=\"text/css\">");
        sb.append(fgStyleSheet);
        sb.append("</style></head><body>");
        sb.append(fragment);
        sb.append("</body></html>");
        this.currentElementDoc.setText(sb.toString());
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection sel;
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty()) {
            ModelQuery modelQuery;
            Node node;
            if (sel.getFirstElement() instanceof LinkedNode) {
                LinkedNode linkedNode = (LinkedNode)sel.getFirstElement();
                node = linkedNode.getDomNode();
            } else if (sel.getFirstElement() instanceof Node) {
                node = (Node)sel.getFirstElement();
            } else {
                return;
            }
            if (node.getNodeType() != 1 && node.getParentNode() != null) {
                node = node.getParentNode();
            }
            if ((modelQuery = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument())) != null) {
                CMElementDeclaration declaration = modelQuery.getCMElementDeclaration((Element)node);
                String info = this.infoProvider.getInfo((CMNode)declaration);
                Object spec = modelQuery.getCorrespondingCMDocument(node).getProperty("spec");
                this.setInfoText(MessageFormat.format("{0}\n\n<p class=\"spec\" style=\"font-size: 5pt;\">{1}</p>\n", info, spec));
                System.err.println(MessageFormat.format("CMDocument: {0}, spec: {1}", modelQuery.getCorrespondingCMDocument(node).getProperty("CMDocument"), spec));
            }
        }
    }
}

