/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.model.graphics;

import info.textgrid.lab.linkeditor.model.links.ILink;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.eclipse.swt.graphics.RGB;

public abstract class TGShape {
    protected WRITING_MODE direction = WRITING_MODE.NONE;
    protected int layer = 0;
    protected String layerName = "\u2013";
    protected RGB layerRGB = new RGB(255, 255, 255);
    protected boolean isVisible = true;
    protected double rotate = 0.0;
    private boolean isLinked = false;
    protected String imageUri = "";
    protected ILink assocLink = null;

    public ILink getAssocLink() {
        return this.assocLink;
    }

    public void setAssocLink(ILink assocLink) {
        this.assocLink = assocLink;
    }

    public abstract boolean contains(int var1, int var2);

    public abstract boolean equals(Object var1);

    public abstract boolean isCompletedShape();

    public abstract void move(int var1, int var2);

    public abstract void resize(int var1, int var2, int var3);

    public abstract TGShape clone();

    public void setLinked(boolean linkFlag) {
        this.isLinked = linkFlag;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setWritingMode(WRITING_MODE writing_mode) {
        this.direction = writing_mode;
    }

    public WRITING_MODE getWritingMode() {
        return this.direction;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public String getLayer() {
        return new Integer(this.layer).toString();
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public RGB getLayerRGB() {
        return this.layerRGB;
    }

    public void setLayerRGB(RGB layerRGB) {
        this.layerRGB = layerRGB;
    }

    public void setLayerValues(int layNumber, String layName, RGB layRGB) {
        if (layNumber == 0) {
            layName = "\u2013";
            layRGB = new RGB(255, 255, 255);
        }
        this.setLayer(layNumber);
        this.setLayerName(layName);
        this.setLayerRGB(layRGB);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public double getRotationValue() {
        return this.rotate;
    }

    public void setRotationValue(double angle) {
        this.rotate = angle;
    }

    public void setImageUri(String uri) {
        this.imageUri = uri;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public abstract TYPE getType();

    public abstract OMElement createOMElement(OMFactory var1, OMElement var2, OMNamespace var3, int var4, int var5);

    public static enum TYPE {
        RECT,
        POLY,
        DOCKING_LINE;

    }

    public static enum WRITING_MODE {
        NONE{

            public String toString() {
                return "none";
            }
        }
        ,
        LR{

            public String toString() {
                return "lr";
            }
        }
        ,
        LR_TB{

            public String toString() {
                return "lr-tb";
            }
        }
        ,
        RL{

            public String toString() {
                return "rl";
            }
        }
        ,
        RL_TB{

            public String toString() {
                return "rl-tb";
            }
        }
        ,
        TB{

            public String toString() {
                return "tb";
            }
        }
        ,
        TB_RL{

            public String toString() {
                return "tb-rl";
            }
        };

    }
}

