/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.conf.client;

import info.textgrid.lab.conf.ConfPlugin;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocalProxySelector
extends ProxySelector {
    ProxySelector defsel = null;
    HashMap<SocketAddress, InnerProxy> proxies = new HashMap();

    LocalProxySelector(ProxySelector def) {
        this.defsel = def;
        String host = ConfPlugin.getDefault().getPreferenceStore().getString("proxy_connection_http");
        int port = ConfPlugin.getDefault().getPreferenceStore().getInt("proxy_connection_port");
        if (!host.equals("") && port != 0) {
            InnerProxy i = new InnerProxy(new InetSocketAddress(host, port));
            this.proxies.put(i.address(), i);
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String protocol = uri.getScheme();
        if ("http".equalsIgnoreCase(protocol) || "https".equalsIgnoreCase(protocol)) {
            ArrayList<Proxy> l = new ArrayList<Proxy>();
            for (InnerProxy p : this.proxies.values()) {
                l.add(p.toProxy());
            }
            return l;
        }
        ArrayList<Proxy> l = new ArrayList<Proxy>();
        l.add(Proxy.NO_PROXY);
        return l;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (uri == null || sa == null || ioe == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    class InnerProxy {
        Proxy proxy;
        SocketAddress addr;
        int failedCount = 0;

        InnerProxy(InetSocketAddress a) {
            this.addr = a;
            this.proxy = new Proxy(Proxy.Type.HTTP, a);
        }

        SocketAddress address() {
            return this.addr;
        }

        Proxy toProxy() {
            return this.proxy;
        }

        int failed() {
            return ++this.failedCount;
        }
    }
}

