/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.elements;

import com.logabit.xlayout.XLayout;
import info.textgrid.lab.core.metadataeditor.elements.IControl;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableComposite;
import info.textgrid.lab.core.metadataeditor.elements.IRepresentableControl;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.dom4j.Element;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class MoreControlElement
implements IRepresentableComposite {
    private Section sec = null;
    private ScrolledForm form = null;
    private FormToolkit toolkit = null;
    private String id = null;
    private Composite sectionClient = null;
    private Element dataElement = null;
    private XLayout xlayout = null;
    private ArrayList<IControl> controls = new ArrayList();

    public MoreControlElement(String id, ScrolledForm f, Control section, Element element, FormToolkit tk, XLayout layout) {
        this.id = id;
        this.sec = (Section)section;
        this.form = f;
        this.toolkit = tk;
        this.dataElement = element;
        this.xlayout = layout;
        this.sec.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                MoreControlElement.this.xlayout.setModified(true);
                MoreControlElement.this.form.reflow(true);
            }
        });
        this.sectionClient = this.toolkit.createComposite((Composite)this.sec, 2052);
        this.sectionClient.setBackground(this.sec.getBackground());
        this.sectionClient.setLayout((Layout)new GridLayout(1, true));
        this.sec.setClient((Control)this.sectionClient);
    }

    public Composite getBody() {
        return this.sectionClient;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void addControlElement(IControl elem) {
        this.controls.add(elem);
    }

    @Override
    public void createOMElement(OMFactory omFactory, OMElement parent, OMNamespace ns, boolean asAttribute) {
        if (this.sec.isExpanded()) {
            for (IControl con : this.controls) {
                con.createOMElement(omFactory, parent, ns, asAttribute);
            }
        }
    }

    @Override
    public boolean setOMElement(OMElement root, boolean tg) {
        boolean found = false;
        for (IControl con : this.controls) {
            found |= con.setOMElement(root, tg);
        }
        if ((this.sec.getExpansionStyle() & 2) != 0) {
            if (found) {
                this.sec.setExpanded(true);
            } else {
                this.sec.setExpanded(false);
            }
        }
        return found;
    }

    @Override
    public void dispose() {
        for (IControl c : this.controls) {
            c.dispose();
        }
        if (this.sec != null && !this.sec.isDisposed()) {
            this.sec.dispose();
        }
    }

    @Override
    public boolean validate() {
        if (!this.sec.isExpanded()) {
            return true;
        }
        boolean valid = true;
        for (IControl c : this.getControls()) {
            valid &= c.validate();
        }
        return valid;
    }

    @Override
    public List<Control> getSWTControls() {
        ArrayList<Control> controls = new ArrayList<Control>();
        for (IControl con : this.controls) {
            if (con instanceof IRepresentableControl) {
                controls.add(((IRepresentableControl)con).getSWTControl());
                continue;
            }
            if (!(con instanceof IRepresentableComposite)) continue;
            controls.addAll(((IRepresentableComposite)con).getSWTControls());
        }
        return controls;
    }

    @Override
    public List<IControl> getControls() {
        return this.controls;
    }

    @Override
    public IRepresentableComposite getUnit() {
        return this;
    }

    @Override
    public void clear() {
        for (IControl c : this.controls) {
            c.clear();
        }
    }

    @Override
    public void setExpanded(boolean expand) {
        if (this.sec != null) {
            this.sec.setExpanded(expand);
        }
    }

    @Override
    public boolean isExpanded() {
        if (this.sec != null) {
            return this.sec.isExpanded();
        }
        return false;
    }
}

