/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator.filters;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.navigator.filters.Messages;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ImageOnly
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TextGridObject) {
            try {
                if (((TextGridObject)element).getContentTypeID().contains("aggregation")) {
                    return true;
                }
            }
            catch (CoreException e1) {
                Activator.handleError((Throwable)e1, (String)Messages.ImageOnly_EM_CouldNotGetContentType, (Object[])new Object[]{element});
            }
            String uri = ((TextGridObject)element).getURI().toString();
            String[] segs = uri.split("\\:");
            String format = "";
            if (segs.length > 4) {
                try {
                    format = URLDecoder.decode(segs[4], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError((Throwable)e, (String)"Encoding Exception on object {0}.", (Object[])new Object[]{element});
                }
                if (format.contains("image") || format.contains("image")) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

