/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class AttributeDefaultSection
extends AbstractSection {
    private final String IMPLIED = "#IMPLIED";
    private final String REQUIRED = "#REQUIRED";
    private final String FIXED = "#FIXED";
    private CCombo usageCombo;
    private String[] usageComboValues = new String[]{"#IMPLIED", "#REQUIRED", "#FIXED", DTDPropertiesMessages._UI_DEFAULT};
    private Text defaultValueText;
    private CLabel defaultValueLabel;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel usageLabel = this.getWidgetFactory().createCLabel(composite, DTDPropertiesMessages._UI_LABEL_USAGE);
        Point p = usageLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        usageLabel.setLayoutData((Object)data);
        this.usageCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment((Control)usageLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)usageLabel, 0, 0x1000000);
        this.usageCombo.setLayoutData((Object)data);
        this.usageCombo.addSelectionListener((SelectionListener)this);
        this.usageCombo.setItems(this.usageComboValues);
        this.defaultValueLabel = this.getWidgetFactory().createCLabel(composite, DTDPropertiesMessages._UI_LABEL_DEFAULT_VALUE);
        p = this.defaultValueLabel.computeSize(-1, -1, false);
        labelWidth = Math.max(p.x, 98);
        data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)usageLabel, 4);
        this.defaultValueLabel.setLayoutData((Object)data);
        this.defaultValueText = this.getWidgetFactory().createText(composite, "");
        data = new FormData();
        data.left = new FormAttachment((Control)this.defaultValueLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.defaultValueLabel, 0, 0x1000000);
        this.defaultValueText.setLayoutData((Object)data);
        this.defaultValueText.addListener(24, (Listener)this);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (input != null && input instanceof Attribute) {
            String kind = ((Attribute)input).getDefaultKind();
            if ("".equals(kind)) {
                this.usageCombo.setText(DTDPropertiesMessages._UI_DEFAULT);
            } else {
                this.usageCombo.setText(kind);
            }
            if ("".equals(kind) || "#FIXED".equals(kind)) {
                this.defaultValueLabel.setVisible(true);
                this.defaultValueText.setVisible(true);
                this.defaultValueText.setEnabled(true);
                this.defaultValueText.setText(((Attribute)input).getDefaultValue());
            } else {
                this.defaultValueText.setText("");
                this.defaultValueLabel.setVisible(false);
                this.defaultValueText.setVisible(false);
                this.defaultValueText.setEnabled(false);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        Object input;
        if (e.widget == this.usageCombo && (input = this.getInput()) instanceof Attribute) {
            String usage = this.usageCombo.getText();
            Attribute attribute = (Attribute)input;
            if (usage.equals(DTDPropertiesMessages._UI_DEFAULT)) {
                attribute.setDefaultKind("");
            } else {
                attribute.setDefaultKind(usage);
            }
            if (DTDPropertiesMessages._UI_DEFAULT.equals(usage) || "#FIXED".equals(usage)) {
                this.defaultValueLabel.setVisible(true);
                this.defaultValueText.setVisible(true);
                this.defaultValueText.setEnabled(true);
            } else {
                this.defaultValueLabel.setVisible(false);
                this.defaultValueText.setVisible(false);
                this.defaultValueText.setEnabled(false);
            }
        }
    }

    public void doHandleEvent(Event event) {
        Object input = this.getInput();
        if (input instanceof Attribute && event.widget == this.defaultValueText) {
            String newValue = this.defaultValueText.getText();
            ((Attribute)input).setDefaultValue(newValue, this.usageCombo.getText().equals("#FIXED"));
        }
    }
}

