package info.textgrid.lab.authn;

import java.text.MessageFormat;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.middleware.confclient.ConfservClientConstants;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.statushandlers.StatusManager;

/**
 * Displays the Browser that does the actual remote authentication. Notifys all
 * SIDListeners with Username (eduPersonPrincipalName) and Session ID. It evaluates a small
 * javascript command on the resulting page and returns the result.
 * 
 * @author martin
 * 
 */
public class AuthBrowser extends Composite {
	private Browser authbrowser;
	private String rbacsid = ""; //$NON-NLS-1$
	private static ListenerList sidChangedListeners = new ListenerList();
	private String webAuth;

	public AuthBrowser(Composite parent) {
		super(parent, SWT.FILL);

		GridData parentGD = new GridData();
		parentGD.horizontalAlignment = GridData.FILL;
		parentGD.grabExcessVerticalSpace = true;
		parentGD.grabExcessHorizontalSpace = true;
		parentGD.heightHint = 500;
		parentGD.widthHint = 860;
		parentGD.verticalAlignment = GridData.FILL;

		parent.setLayoutData(parentGD);

		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		GridDataFactory labelsFactory = GridDataFactory.createFrom(gridData);

//		try {
		try {
			authbrowser = new Browser(parent, SWT.NONE); // *not* SWT.WEBKIT @since 3.7
		} catch (SWTError e) {
			StatusManager.getManager().handle(new Status(IStatus.WARNING, Activator.PLUGIN_ID, "Failed to instantiate Mozilla based browser (no XULrunner?), trying default instead ...")); //$NON-NLS-1$
			authbrowser = new Browser(parent, SWT.NONE);
		}
//		authbrowser = TextGridLabBrowser.createBrowser(parent);
		labelsFactory.applyTo(authbrowser);
//		} catch (SWTError e) {
//			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
//					"Could not instantiate Browser for Authentication!", e);
//			Activator.getDefault().getLog().log(status);
//			return;
//		}
		setLayout(new GridLayout());

		authbrowser.addProgressListener(new ProgressListener() {
			public void changed(ProgressEvent event) {
			}

			public void completed(ProgressEvent event) {
				rbacsid = (String)authbrowser.evaluate("if (document.getElementsByName('ePPNplusSID').length==1) {return document.getElementsByName('ePPNplusSID')[0].getAttribute('content');} else {return 'reset';}"); //$NON-NLS-1$
				
				if (rbacsid == "" || rbacsid=="reset") { //$NON-NLS-1$ //$NON-NLS-2$
					return;
				} else {
					String[] ePPNplusSID = rbacsid.split("\\|"); //$NON-NLS-1$
					if (ePPNplusSID.length != 2) {
						//System.out.println("Found not a good SessionID, '"
						//		+ rbacsid + "'");
						return;
					}
					RBACSession.setSID(ePPNplusSID[1]);
					RBACSession.setEPPN(ePPNplusSID[0]);
					IStatus status = new Status(
							IStatus.OK,
							Activator.PLUGIN_ID,
							NLS
									.bind(
											Messages.AuthBrowser_AuthenticatedAs,
											ePPNplusSID[0]));
					Activator.getDefault().getLog().log(status);
					notifySIDListeners(ePPNplusSID[1], ePPNplusSID[0]);
				}
			}
		});
		try {
			ConfClient confClient = ConfClient.getInstance();
			webAuth = confClient.getValue(ConfservClientConstants.AUTHZ);
			// System.out.println("WebAuth: authenticate at " + webAuth);
			IStatus status = new Status(IStatus.OK, Activator.PLUGIN_ID,
					MessageFormat.format(Messages.AuthBrowser_AuthAt,
							webAuth));
			Activator.getDefault().getLog().log(status);
			authbrowser.setUrl(webAuth);
		} catch (OfflineException e) {
			OnlineStatus.netAccessFailed(
					Messages.AuthBrowser_CouldNotContactConfserv, e);
		}
	}

	
	public interface ISIDChangedListener {
		public void sidChanged(final String newSID, final String newEPPN);
	}

	public static void addSIDChangedListener(ISIDChangedListener listener) {
		sidChangedListeners.add(listener);
	}

	public static void removeSIDChangedListener(ISIDChangedListener listener) {
		// TODO check if that really works...
		sidChangedListeners.remove(listener);
	}

	protected static void notifySIDListeners(final String newSID,
			final String newEPPN) {
		for (Object listener : sidChangedListeners.getListeners()) {
			((ISIDChangedListener) listener).sidChanged(newSID, newEPPN);
		}
	}

	/**
	 * This is for programs that modify an existing session (e.g. activate a
	 * role)
	 */
	public static void sessionChanged() {
		notifySIDListeners(RBACSession.getInstance().getSID(false), RBACSession
				.getInstance().getEPPN());
	}

	public Browser getAuthBrowser() {
		return authbrowser;
	}

	public void resetAuthBrowser() {
		authbrowser.setUrl(webAuth);
	}

	public String getRbacSid() {
		return rbacsid;
	}

	@Override
	public void dispose() {
		authbrowser.dispose();
		super.dispose();
	}

}
