/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.EntryLink;
import info.textgrid.lab.workflow.IncomingLink;
import info.textgrid.lab.workflow.OutgoingLink;
import info.textgrid.lab.workflow.servicedescription.Configparameter;
import info.textgrid.lab.workflow.servicedescription.Examplevalue;
import info.textgrid.lab.workflow.servicedescription.Input;
import info.textgrid.lab.workflow.servicedescription.Output;
import info.textgrid.lab.workflow.servicedescription.Service;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXB;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Element;

public class ChainEntry {
    private Service service;
    private HashMap<String, ArrayList<Examplevalue>> selectedValues;
    private HashMap<String, Integer> numberOfInstances;
    private URI myURI;
    private int myID;
    private HashMap<Input, IncomingLink> incomingLinks;
    private HashMap<Output, OutgoingLink> outgoingLinks;
    public static final String NEW_FROM_STRING_ID = "new_from_String";
    public static final String NEW_FROM_URI_ID = "new_from_URI";
    private static final String NEW_FROM_STRING_DISPLAY = "New from String...";
    private static final String NEW_FROM_URI_DISPLAY = "New from TextGrid URI...";

    public ChainEntry(TextGridObject serviceTGO) {
        this.myURI = serviceTGO.getURI();
        IFile sf = (IFile)serviceTGO.getAdapter(IFile.class);
        try {
            this.service = (Service)JAXB.unmarshal((InputStream)sf.getContents(true), Service.class);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            try {
                Activator.handleProblem(4, e, "Object {0} is no valid service description", serviceTGO.getTitle());
            }
            catch (CoreException coreException) {}
            return;
        }
        this.selectedValues = new HashMap();
        this.numberOfInstances = new HashMap();
        List<Configparameter> cpList = this.service.getConfigparameters().getConfigparameter();
        for (Configparameter cp : cpList) {
            this.numberOfInstances.put(cp.getParam(), 1);
            Examplevalue ex1 = new Examplevalue();
            ex1.setDefault(false);
            ex1.setId(NEW_FROM_STRING_ID);
            ex1.setInline(true);
            ex1.setName(NEW_FROM_STRING_DISPLAY);
            ex1.getContent().add("Possible Value for " + cp.getName() + " (the Parameter '" + cp.getParam() + "')");
            cp.getExamplevalue().add(ex1);
            Examplevalue ex2 = new Examplevalue();
            ex2.setDefault(false);
            ex2.setId(NEW_FROM_URI_ID);
            ex2.setInline(false);
            ex2.setName(NEW_FROM_URI_DISPLAY);
            ex2.getContent().add("THIS:IS:A:TEXTGRID:URI");
            cp.getExamplevalue().add(ex2);
        }
        this.clearLinks();
    }

    public void setDefaultParams() {
        List<Configparameter> cpList = this.service.getConfigparameters().getConfigparameter();
        block0: for (Configparameter cp : cpList) {
            for (Examplevalue ex : cp.getExamplevalue()) {
                if (!ex.isDefault()) continue;
                ArrayList<Examplevalue> val = new ArrayList<Examplevalue>();
                val.add(ex);
                this.selectedValues.put(cp.getParam(), val);
                continue block0;
            }
        }
    }

    public void deleteExampleValue(String param, int position) {
        for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(param)) continue;
            this.selectedValues.get(param).remove(position);
            this.numberOfInstances.put(param, this.numberOfInstances.get(param) - 1);
        }
    }

    public void addDefaultExampleValue(String param) {
        block0: for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(param)) continue;
            for (Examplevalue ex : cp.getExamplevalue()) {
                if (!ex.isDefault()) continue;
                this.selectedValues.get(param).add(ex);
                this.numberOfInstances.put(param, this.numberOfInstances.get(param) + 1);
                break block0;
            }
        }
    }

    public void selectExampleValue(String param, Examplevalue selectEx, int position) {
        for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(param)) continue;
            this.selectedValues.get(param).set(position, selectEx);
        }
    }

    public List<Examplevalue> getAllAvailableExampleValues(String param) {
        for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(param)) continue;
            return cp.getExamplevalue();
        }
        return null;
    }

    public boolean setConfigParam(String configParam, String valueID) {
        for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(configParam)) continue;
            if (valueID.equals(NEW_FROM_STRING_ID) || valueID.equals(NEW_FROM_URI_ID)) {
                return false;
            }
            if (!this.selectedValues.containsKey(configParam)) {
                this.selectedValues.put(configParam, new ArrayList());
                this.numberOfInstances.put(configParam, 1);
            }
            for (Examplevalue ex : cp.getExamplevalue()) {
                if (!valueID.equals(ex.getId())) continue;
                this.selectedValues.get(configParam).add(ex);
                this.numberOfInstances.put(configParam, this.numberOfInstances.get(configParam) + 1);
                return true;
            }
        }
        return false;
    }

    public boolean needsB64encoding(String configParam) {
        for (Configparameter cp : this.service.getConfigparameters().getConfigparameter()) {
            if (!cp.getParam().equals(configParam)) continue;
            return cp.isNeedsB64Encoding();
        }
        return false;
    }

    public ArrayList<Examplevalue> getChosenConfigParamExampleValues(String configParam) {
        return this.selectedValues.get(configParam);
    }

    public void setNewConfigValue(String param, boolean inline, int position, String contents) {
        for (Configparameter cp : this.getConfigParameters()) {
            if (!cp.getParam().equals(param)) continue;
            Examplevalue previous = this.selectedValues.get(param).get(position);
            if (previous.getId().equals(NEW_FROM_STRING_ID) || previous.getId().equals(NEW_FROM_URI_ID)) {
                previous.getContent().clear();
                previous.getContent().add(contents);
                continue;
            }
            if (inline) {
                Examplevalue ex1 = new Examplevalue();
                ex1.setDefault(false);
                ex1.setId(NEW_FROM_STRING_ID);
                ex1.setInline(true);
                ex1.setName(NEW_FROM_STRING_DISPLAY + position);
                ex1.getContent().add(contents);
                cp.getExamplevalue().add(ex1);
                this.selectedValues.get(param).set(position, ex1);
                continue;
            }
            Examplevalue ex2 = new Examplevalue();
            ex2.setDefault(false);
            ex2.setId(NEW_FROM_URI_ID);
            ex2.setInline(false);
            ex2.setName(NEW_FROM_URI_DISPLAY + position);
            ex2.getContent().add(contents);
            cp.getExamplevalue().add(ex2);
            this.selectedValues.get(param).set(position, ex2);
        }
    }

    public void appendNewConfigValue(String param, boolean inline, String content) {
        int counter;
        if (!this.selectedValues.containsKey(param)) {
            this.selectedValues.put(param, new ArrayList());
            counter = 1;
        } else {
            counter = this.numberOfInstances.get(param) + 1;
        }
        this.numberOfInstances.put(param, counter);
        for (Configparameter cp : this.getConfigParameters()) {
            if (!cp.getParam().equals(param)) continue;
            if (inline) {
                Examplevalue ex1 = new Examplevalue();
                ex1.setDefault(false);
                ex1.setId(NEW_FROM_STRING_ID);
                ex1.setInline(true);
                ex1.setName(NEW_FROM_STRING_DISPLAY + counter);
                ex1.getContent().add(content);
                cp.getExamplevalue().add(ex1);
                this.selectedValues.get(param).add(ex1);
                continue;
            }
            Examplevalue ex2 = new Examplevalue();
            ex2.setDefault(false);
            ex2.setId(NEW_FROM_URI_ID);
            ex2.setInline(false);
            ex2.setName(NEW_FROM_URI_DISPLAY + counter);
            ex2.getContent().add(content);
            cp.getExamplevalue().add(ex2);
            this.selectedValues.get(param).add(ex2);
        }
    }

    public URI getTGOURI() {
        return this.myURI;
    }

    public void setID(int id) {
        this.myID = id;
    }

    public int getID() {
        return this.myID;
    }

    public String getName() {
        return this.service.getDescriptivedata().getName();
    }

    public String getOperationName() {
        return this.service.getTechnicaldata().getOperation();
    }

    public String getURL() {
        return this.service.getTechnicaldata().getDescriptionlocation().getUri();
    }

    public String toString() {
        return this.getName();
    }

    public List<Input> getInputs() {
        return this.service.getInputs().getInput();
    }

    public List<Output> getOutputs() {
        return this.service.getOutputs().getOutput();
    }

    public List<Configparameter> getConfigParameters() {
        return this.service.getConfigparameters().getConfigparameter();
    }

    public boolean existsIncomingLink(Input i) {
        return this.incomingLinks.containsKey(i);
    }

    public boolean existsOutgoingLink(Output o) {
        return this.outgoingLinks.containsKey(o);
    }

    public boolean addIncomingLink(EntryLink el, String iD) {
        if (this.equals(el.getTo())) {
            if (this.incomingLinks.containsKey(el.getToPort())) {
                EntryLink tmplink = new EntryLink(this.incomingLinks.get(el.getToPort()).getFrom(), this.incomingLinks.get(el.getToPort()).getFromPort(), this, el.getToPort());
                return el.equals(tmplink);
            }
            this.incomingLinks.put(el.getToPort(), new IncomingLink(el.getFrom(), el.getFromPort(), iD));
            return true;
        }
        return false;
    }

    public HashMap<Input, IncomingLink> getIncomingLinks() {
        return this.incomingLinks;
    }

    public boolean addOutgoingLink(EntryLink el, String iD) {
        if (this.equals(el.getFrom())) {
            if (this.outgoingLinks.containsKey(el.getFromPort())) {
                EntryLink tmplink = new EntryLink(this, el.getFromPort(), this.outgoingLinks.get(el.getFromPort()).getTo(), this.outgoingLinks.get(el.getFromPort()).getToPort());
                return el.equals(tmplink);
            }
            this.outgoingLinks.put(el.getFromPort(), new OutgoingLink(el.getTo(), el.getToPort(), iD));
            return true;
        }
        return false;
    }

    public HashMap<Output, OutgoingLink> getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public void clearLinks() {
        this.incomingLinks = new HashMap();
        this.outgoingLinks = new HashMap();
    }

    public static String anyToString(List<Object> contents) {
        StringBuilder sb = new StringBuilder();
        for (Object o : contents) {
            if (o instanceof String) {
                sb.append((String)o);
                continue;
            }
            if (o instanceof Element) {
                StringWriter sw = new StringWriter();
                OutputFormat format = new OutputFormat();
                format.setOmitXMLDeclaration(true);
                XMLSerializer serial = new XMLSerializer((Writer)sw, format);
                try {
                    serial.serialize((Element)o);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                sb.append(sw);
                continue;
            }
            sb.append("[" + o.getClass() + "]" + o.toString() + "\n");
        }
        return sb.toString();
    }

    public String getTns() {
        if (!this.service.getTechnicaldata().getTargetnamespace().isUsetns()) {
            return null;
        }
        return this.service.getTechnicaldata().getTargetnamespace().getUri();
    }

    public int getNumberOfParamInstances(String param) {
        return this.numberOfInstances.get(param);
    }

    public String getType() {
        return this.service.getTechnicaldata().getType();
    }

    public String getDescription() {
        return this.service.getDescriptivedata().getDescription();
    }
}

