/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.AbstractResource;
import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ITextGridModelConstants;
import info.textgrid.lab.core.model.ITextGridPermission;
import info.textgrid.lab.core.model.IncompleteMetadataException;
import info.textgrid.lab.core.model.IndexedWorkspaceJob;
import info.textgrid.lab.core.model.ModelAdaptorFactory;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.SchedulingException;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.lab.core.model.util.ModelUtil;
import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.core.swtutils.CoreExceptionStatus;
import info.textgrid.lab.core.tgauthclient.TgAuthClientUtilities;
import info.textgrid.lab.core.tgcrud.client.CrudClientUtilities;
import info.textgrid.lab.log.logsession;
import info.textgrid.middleware.tgsearch.client.SearchClient;
import info.textgrid.namespaces.metadata.agent._2010.AgentRoleType;
import info.textgrid.namespaces.metadata.agent._2010.AgentType;
import info.textgrid.namespaces.metadata.agent._2010.PersonType;
import info.textgrid.namespaces.metadata.core._2010.AuthorityType;
import info.textgrid.namespaces.metadata.core._2010.CollectionType;
import info.textgrid.namespaces.metadata.core._2010.EditionType;
import info.textgrid.namespaces.metadata.core._2010.GeneratedType;
import info.textgrid.namespaces.metadata.core._2010.GenericType;
import info.textgrid.namespaces.metadata.core._2010.ItemType;
import info.textgrid.namespaces.metadata.core._2010.MetadataContainerType;
import info.textgrid.namespaces.metadata.core._2010.ObjectFactory;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.metadata.core._2010.ProvidedType;
import info.textgrid.namespaces.metadata.core._2010.RelationType;
import info.textgrid.namespaces.metadata.core._2010.SourceType;
import info.textgrid.namespaces.metadata.core._2010.WorkType;
import info.textgrid.namespaces.metadata.script._2010.FormOfNotationType;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import info.textgrid.namespaces.middleware.tgauth.PublishRequest;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.AuthFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.IoFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.MetadataParseFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.ObjectNotFoundFault;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TGCrudService;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.UpdateConflictFault;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.Holder;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class TextGridObject
extends AbstractResource
implements ITextGridPermission,
ITextGridModelConstants {
    private ObjectType metadata;
    public static final String MOVE_TGOBJECT = "MOVE_TGOBJECT";
    private static final AuthBrowser.ISIDChangedListener sidChangedListener = new AuthBrowser.ISIDChangedListener(){

        public void sidChanged(String newSID, String newEPPN) {
            for (TextGridObject object : registry.values()) {
                object.resetPermissionCache();
            }
        }
    };
    public static final String TEXTGRID_METADATA_NAMESPACE = "http://textgrid.info/namespaces/metadata/core/2010";
    @Deprecated
    public static final QName CLIENT_NAME;
    @Deprecated
    public static final String TEXTGRID_DATERANGE_NAMESPACE = "http://textgrid.info/namespaces/metadata/dateRange/2008-02-18";
    public static String CUSTOM_NAMESPACE;
    public static final QName METADATA_ROOT_NAME;
    private static final Calendar LAST_MODIFIED_NOT_AVAILABLE;
    public static final String NO_TITLE = "<no title>";
    private static Map<URI, TextGridObject> registry;
    private static Map<URI, URI> latestRegistry;
    private static Map<URI, TextGridObject> handleRegistry;
    private URI uri = null;
    private Calendar lastModified;
    private Calendar created;
    private long size = -1L;
    private String project = null;
    private String title = null;
    private volatile int permissions = -1;
    private boolean complete = false;
    private boolean submittable = false;
    private URI efsUri;
    private boolean deleted = false;
    private boolean metadataDirty = false;
    private String contentTypeID;
    private byte[] initialContent = null;
    private boolean openAsReadOnly = false;
    private boolean isTitleEmpty = false;
    private boolean isIdnoTypeEmpty = false;
    private TextGridObject preparedNewVersion;
    private TextGridObject preparedNewRevision;
    private String revisionURI = "";
    private boolean accessible = true;
    private URI preparedURI;
    private static ListenerList listeners;

    static {
        AuthBrowser.addSIDChangedListener((AuthBrowser.ISIDChangedListener)sidChangedListener);
        CLIENT_NAME = new QName(TEXTGRID_METADATA_NAMESPACE, "client");
        CUSTOM_NAMESPACE = "http://textgrid.info/custom-namespace/2009-01-01";
        METADATA_ROOT_NAME = new QName("objectType");
        LAST_MODIFIED_NOT_AVAILABLE = Calendar.getInstance();
        LAST_MODIFIED_NOT_AVAILABLE.setTimeInMillis(0L);
        registry = new ConcurrentHashMap<URI, TextGridObject>();
        latestRegistry = new ConcurrentHashMap<URI, URI>();
        handleRegistry = new ConcurrentHashMap<URI, TextGridObject>();
        listeners = new ListenerList();
    }

    public String toString() {
        if (this.title != null && this.getURI() != null) {
            return String.valueOf(this.title) + " (" + this.getURI().toString() + ")";
        }
        if (this.getURI() != null) {
            return this.getURI().toString();
        }
        return super.toString();
    }

    public void setTitleEmpty(boolean empty) {
        this.isTitleEmpty = empty;
    }

    private boolean isTitleEmpty() {
        return this.isTitleEmpty;
    }

    public void setIdnoTypeEmpty(boolean empty) {
        this.isIdnoTypeEmpty = empty;
    }

    private boolean isIdnoTypeEmpty() {
        return this.isIdnoTypeEmpty;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isMetadataDirty() {
        return this.metadataDirty;
    }

    public void setMetadataDirty(boolean dirty) {
        this.metadataDirty = dirty;
    }

    protected synchronized void invalidateCache() {
        this.lastModified = null;
        this.size = -1L;
        if (!this.isNew()) {
            this.project = null;
        }
        this.title = null;
        this.permissions = -1;
        this.submittable = this.checkMetadataSubmittable();
        this.contentTypeID = null;
    }

    @Deprecated
    private boolean checkMetadataSubmittable() {
        return !this.isTitleEmpty() && !this.isIdnoTypeEmpty();
    }

    protected TextGridObject(URI uri, boolean readMetadata) throws CrudServiceException {
        TextGridObject.assertURIValidForTGO(uri);
        this.setURI(uri);
        this.efsUri = TextGridObject.computeEFSURI(uri);
        if (readMetadata) {
            this.doReadMetadata();
        } else {
            this.setComplete(false);
        }
    }

    private void doReadMetadata() throws CrudServiceException {
        MetadataContainerType metadataContainer;
        if (this.isNew()) {
            this.setComplete(true);
            return;
        }
        String sid = RBACSession.getInstance().getSID(false);
        String loggingParam = logsession.getInstance().getloginfo();
        ModelUtil.checkNonUIThread("Tried to read metadata for {0} from an UI thread.", this);
        TGCrudService stub = CrudClientUtilities.getCrudServiceStub();
        try {
            try {
                if (Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/reads")) {
                    StatusManager.getManager().handle((IStatus)new Status(1, "info.textgrid.lab.core.model", NLS.bind((String)"Called readMetadata on {0}", (Object)this), (Throwable)new Exception()));
                }
                metadataContainer = stub.readMetadata(sid, loggingParam, this.getURI().toString());
            }
            catch (AuthFault e) {
                String sessionId = RBACSession.getInstance().getSID(true);
                if ("".equals(sessionId)) {
                    throw e;
                }
                metadataContainer = stub.readMetadata(sessionId, loggingParam, this.getURI().toString());
            }
        }
        catch (AuthFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (IoFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (MetadataParseFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (ObjectNotFoundFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        ObjectType metadata = metadataContainer.getObject();
        this.internalSetMetadata(metadata, false);
        this.setComplete(true);
        this.setAccessible(true);
        this.register();
        this.refreshWorkspaceIfNeccessary();
    }

    public boolean isNew() {
        String scheme = this.getURI().getScheme();
        return "textgrid-newfile".equals(scheme);
    }

    protected TextGridObject(ObjectType metadata) throws CoreException {
        String uriString = "";
        try {
            try {
                this.setURI(new URI(metadata.getGeneric().getGenerated().getTextgridUri().getValue()));
                TextGridObject.assertURIValidForTGO(this.getURI());
            }
            catch (AssertionFailedException e) {
                throw new IllegalArgumentException("Could not extract an URI from the given metadata object " + metadata.toString(), e);
            }
            this.efsUri = TextGridObject.computeEFSURI(this.getURI());
            this.internalSetMetadata(metadata, false);
        }
        catch (URISyntaxException e) {
            throw new CoreException(Activator.handleError(e, "The URI {0} in the given metadata is not an URI.", uriString));
        }
        this.register();
    }

    protected TextGridObject(String project, String format) {
        Assert.isLegal((project != null && project.length() > 0 ? 1 : 0) != 0, (String)"The project ID must be a non-empty string");
        ObjectFactory objectFactory = new ObjectFactory();
        this.metadata = objectFactory.createObjectType();
        GenericType generic = objectFactory.createGenericType();
        this.metadata.setGeneric(generic);
        ProvidedType provided = objectFactory.createProvidedType();
        generic.setProvided(provided);
        provided.setFormat(format);
        this.project = project;
        this.setComplete(true);
        try {
            IPath path = new Path("/").append(project).append("Unnamed-".concat(UUID.randomUUID().toString()));
            this.setURI(new URI("textgrid-newfile", path.toPortableString(), null));
            this.efsUri = TextGridObject.computeEFSURI(this.getURI());
        }
        catch (URISyntaxException e) {
            Activator.handleError(e, "Subtle URI creation error for new object. Please file a bug report.", new Object[0]);
        }
    }

    public synchronized void setMetadata(ObjectType metadata) {
        this.internalSetMetadata(metadata, true);
    }

    public synchronized void setMetadataXML(OMElement metadataXML) {
        this.setMetadata(TextGridObject.toObjectType(metadataXML));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalSetMetadata(ObjectType metadata, boolean markDirty) {
        String newURI;
        Assert.isNotNull((Object)metadata, (String)"setMetadateXML does not accept a null argument.");
        String string = newURI = metadata.getGeneric().getGenerated() == null ? null : metadata.getGeneric().getGenerated().getTextgridUri().getValue();
        if (newURI != null && !"".equals(newURI) && this.getURI() != null && !this.getURI().toString().equals(newURI.trim())) {
            this.setURI(URI.create(newURI));
        }
        this.metadata = metadata;
        if (this.getHandle() != null) {
            Map<URI, TextGridObject> map = handleRegistry;
            synchronized (map) {
                handleRegistry.put(this.getHandle(), this);
            }
        }
        this.invalidateCache();
        this.setMetadataDirty(markDirty);
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
    }

    private URI getHandle() {
        List pids;
        if (this.metadata.getGeneric().getGenerated() != null && (pids = this.metadata.getGeneric().getGenerated().getPid()) != null) {
            for (GeneratedType.Pid pid : pids) {
                if (!pid.getPidType().equals("handle")) continue;
                return URI.create(pid.getValue());
            }
        }
        return null;
    }

    public void refreshWorkspaceIfNeccessary() {
        try {
            final IFile file = ModelAdaptorFactory.getFileFor(this, false);
            if (file != null && file.exists() && !file.isSynchronized(0)) {
                ISchedulingRule rule;
                ISchedulingRule refreshRule = file.getWorkspace().getRuleFactory().refreshRule((IResource)file);
                WorkspaceJob refreshJob = new WorkspaceJob(NLS.bind((String)"Refreshing {0} ...", (Object)file)){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        file.refreshLocal(0, monitor);
                        Activator.handleProblem(1, null, "Refreshed workspace link {0} due to modifications of the remote copy.", file);
                        return Status.OK_STATUS;
                    }
                };
                Job currentJob = Job.getJobManager().currentJob();
                ISchedulingRule iSchedulingRule = rule = currentJob == null ? null : currentJob.getRule();
                if (rule != null && refreshRule.isConflicting(rule)) {
                    refreshJob.setRule(refreshRule);
                    refreshJob.schedule();
                } else {
                    try {
                        refreshJob.runInWorkspace(null);
                    }
                    catch (CoreException e) {
                        Activator.handleError(e, "Failed to refresh {0}", file);
                    }
                }
            }
        }
        catch (SchedulingException e) {
            Activator.handleProblem(2, e, "Could not try to refresh the workspace representation of {0} due to scheduling issues.", this);
        }
    }

    public synchronized void makeMetadataPersistent(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Saving metadata for {0} ...", (Object)this), (int)100);
        if (!this.isSubmittable() || !this.isComplete() || this.isTitleEmpty() || this.isIdnoTypeEmpty()) {
            TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_INCOMPLETE, this);
            Status status = new Status(4, "info.textgrid.lab.core.model", "Incomplete metadata cannot be made persistent.", null);
            throw new IncompleteMetadataException((IStatus)status);
        }
        ObjectType metadataToSubmit = this.getMetadata();
        try {
            if (this.isNew()) {
                IFile file = (IFile)this.getAdapter(IFile.class);
                file.setContents(null, 1, null);
            } else {
                ModelUtil.checkNonUIThread("Tried to make {0}'s metadata persistent from an UI thread.", this);
                this.assertPermission(4, "Access denied: You are not allowed to update {0} or its metadata.", this);
                Activator.logServiceCall("Calling TGcrud#updateMetadata({0}, {1}, {2}, ...)", RBACSession.getInstance().getSID(false), logsession.getInstance().getLogEndpoint(), this);
                Holder metadataHolder = new Holder();
                metadataHolder.value = new ObjectFactory().createMetadataContainerType();
                ((MetadataContainerType)metadataHolder.value).setObject(metadataToSubmit);
                TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
                crudServiceStub.updateMetadata(RBACSession.getInstance().getSID(false), logsession.getInstance().getLogEndpoint(), metadataHolder);
                this.internalSetMetadata(((MetadataContainerType)metadataHolder.value).getObject(), false);
                this.setComplete(true);
                IFile file = (IFile)this.getAdapter(IFile.class);
                if (file != null) {
                    file.refreshLocal(0, (IProgressMonitor)progress.newChild(5));
                }
                TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_SAVED, this);
            }
        }
        catch (OfflineException e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (AuthFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (IoFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (MetadataParseFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (ObjectNotFoundFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
        catch (UpdateConflictFault e) {
            throw new CrudServiceException(e, this.getURI());
        }
    }

    @Deprecated
    public synchronized void makeMetadataPersistent() throws CoreException {
        this.makeMetadataPersistent(null);
    }

    public synchronized ObjectType getMetadata() throws CrudServiceException {
        this.reloadMetadata(false);
        return TextGridObject.deepCopy(this.metadata);
    }

    public synchronized ObjectType getMetadataForReading() throws CrudServiceException {
        this.reloadMetadata(false);
        return this.metadata;
    }

    @Deprecated
    public synchronized OMElement getMetadataXML() throws CrudServiceException {
        try {
            return StringToOM.getOMElement(this.serialize());
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Internal error: Can't parse our own metadata.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Internal error: Can't parse our own metadata.", e);
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException("Internal error: Can't parse our own metadata.", e);
        }
    }

    public static ObjectType deepCopy(ObjectType in) {
        ObjectType result;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream objectStream = new ObjectOutputStream(baos);
            objectStream.writeObject(in);
            objectStream.close();
            baos.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            result = (ObjectType)objectInputStream.readObject();
        }
        catch (IOException e) {
            throw new DeepCopyException(in, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new DeepCopyException(in, (Throwable)e);
        }
        return result;
    }

    public synchronized void loadMetadata(InputStream source) throws CoreException {
        ObjectType newMetadata = (ObjectType)JAXB.unmarshal((InputStream)source, ObjectType.class);
        ObjectType oldMetadata = this.getMetadata();
        newMetadata.getGeneric().setGenerated(oldMetadata.getGeneric().getGenerated());
        this.setMetadata(newMetadata);
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isAccessible() {
        return this.accessible;
    }

    protected void setAccessible(boolean accessible) {
        this.accessible = accessible;
    }

    public boolean isSubmittable() {
        return this.submittable;
    }

    protected void setSubmittable(boolean submittable) {
        this.submittable = submittable;
    }

    public void reloadMetadata(boolean force) throws CrudServiceException {
        if (force || !this.complete) {
            if (this.isAccessible()) {
                if (Activator.isDebugging("info.textgrid.lab.core.model/debug/incomplete")) {
                    System.out.println(MessageFormat.format("reloadMetadata will reload metadata: force = {0}, complete = {1} ({2})", force, this.complete, this));
                    if (Activator.isDebugging("info.textgrid.lab.core.model/debug/incomplete/verbose")) {
                        StackTraceElement[] stackTrace = new Exception().getStackTrace();
                        System.out.println("  " + stackTrace[1]);
                        System.out.println("  " + stackTrace[2]);
                    }
                }
                this.doReadMetadata();
            } else if (Activator.isDebugging("info.textgrid.lab.core.model/debug/incomplete")) {
                System.out.println(MessageFormat.format("prevented reloadMetadata since resource is not accessible: force = {0}, complete = {1} ({2})", force, this.complete, this));
            }
        }
    }

    @Deprecated
    public static TextGridObject getInstance(OMElement element, boolean isComplete) throws CoreException {
        ByteArrayInputStream xml = null;
        try {
            xml = new ByteArrayInputStream(element.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        ObjectType objectType = (ObjectType)JAXB.unmarshal(xml, ObjectType.class);
        return TextGridObject.getInstance(objectType, isComplete, false);
    }

    public static TextGridObject getInstance(ObjectType metadata, boolean complete, boolean setMetadata) throws CoreException {
        Object rawResult = null;
        try {
            URI givenURI = new URI(metadata.getGeneric().getGenerated().getTextgridUri().getValue());
            TextGridObject object = TextGridObject.getRegisteredTGO(givenURI);
            if (object == null) {
                object = new TextGridObject(metadata);
                object.setComplete(complete);
            } else if (complete && !object.isComplete() && !object.isMetadataDirty()) {
                object.internalSetMetadata(metadata, false);
                object.setComplete(complete);
            }
            if (Activator.isDebugging("info.textgrid.lab.core.model/debug/incomplete")) {
                System.out.println(MessageFormat.format("TGO.getInstance(OMElement, complete={0}) => {1}", complete, object));
                if (Activator.isDebugging("info.textgrid.lab.core.model/debug/incomplete/verbose")) {
                    System.out.println("  " + metadata.toString());
                }
            }
            return object;
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Error retrieving uri from {0}", rawResult), (Throwable)e));
        }
    }

    public static synchronized TextGridObject getInstance(URI uri, boolean readMetadata) throws CrudServiceException {
        if (uri != null) {
            if ("textgrid-efs".equals(uri.getScheme())) {
                uri = TextGridObject.computeTextGridURI(uri);
            } else if ("hdl".equals(uri.getScheme())) {
                try {
                    return TextGridObject.getInstanceByHandle(uri, readMetadata);
                }
                catch (FileNotFoundException e) {
                    throw new CrudServiceException(e, uri);
                }
                catch (CrudServiceException e) {
                    throw e;
                }
                catch (CoreException e) {
                    throw new CrudServiceException(e, uri);
                }
            }
        }
        TextGridObject.assertURIValidForTGO(uri);
        TextGridObject object = TextGridObject.getRegisteredTGO(uri);
        if (object == null) {
            object = new TextGridObject(uri, readMetadata);
            registry.put(uri, object);
        }
        return object;
    }

    protected static synchronized TextGridObject getInstanceByHandle(URI handle, boolean readMetadata) throws FileNotFoundException, CoreException {
        TextGridObject object = handleRegistry.get(handle);
        if (object != null) {
            return object;
        }
        try {
            SearchClient client = new SearchClient(ConfClient.getInstance().getValue("tgsearch-public"));
            client.setTarget("metadata");
            Response response = client.query("pid:" + handle);
            List result = response.getResult();
            if (result.size() < 1) {
                throw new FileNotFoundException(NLS.bind((String)"The object with the handle {0} has not been found. Maybe it is not in TextGrid?", (Object)handle));
            }
            if (result.size() > 1) {
                StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.core.model", NLS.bind((String)"For the handle {0}, more than one object has been found: {1}. The first one will be returned, but this indicates an invalid argument or an inconsistency in the repository.", (Object)handle, (Object)result)));
            }
            return TextGridObject.getInstance(((ResultType)result.get(0)).getObject(), true, true);
        }
        catch (OfflineException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static synchronized TextGridObject getInstanceOffline(URI uri) {
        try {
            return TextGridObject.getInstance(uri, false);
        }
        catch (CrudServiceException e) {
            throw new RuntimeException("Internal Error: TextGridObject.getInstance(URI, false) threw a CrudServiceException, although it is not allowed to. Please file a bug report.", (Throwable)((Object)e));
        }
    }

    private static void assertURIValidForTGO(URI uri) {
        Assert.isNotNull((Object)uri, (String)"A TextGridObject's URI may not be null.");
        Assert.isTrue(("textgrid".equals(uri.getScheme()) || "textgrid-newfile".equals(uri.getScheme()) ? 1 : 0) != 0, (String)MessageFormat.format("A TextGridObject''s URI ({3}) must have the scheme {0} or {1}, not {2}", "textgrid", "textgrid-newfile", uri.getScheme(), uri));
        Assert.isTrue((uri.getSchemeSpecificPart() != null && uri.getSchemeSpecificPart().length() > 0 ? 1 : 0) != 0, (String)"A TextGridObject's URI must contain a scheme specific part.");
    }

    @Deprecated
    public static synchronized TextGridObject getNewObjectInstance(String project, String format) {
        TextGridObject newObject = new TextGridObject(project, format);
        TextGridProjectFile.setBasicMetadataToNewObject(project, TextGridProjectFile.getTypeFromFormat(format), newObject);
        registry.put(newObject.getURI(), newObject);
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.CREATED_TEMPORARY, newObject);
        return newObject;
    }

    public static TextGridObject getNewObjectInstance(TextGridProject project, TGContentType contentType) {
        Assert.isNotNull((Object)project, (String)"Each object must live in a project.");
        Assert.isNotNull((Object)contentType, (String)"Each object must have a content type.");
        return TextGridObject.getNewObjectInstance(project.getId(), contentType.getId());
    }

    public static void addDefaultMetaDataXML(TextGridObject object, String title) {
        try {
            ObjectFactory factory = new ObjectFactory();
            ObjectType objectType = object.getMetadata();
            if (objectType.getCustom() == null) {
                objectType.setCustom(factory.createObjectTypeCustom());
            }
            if (objectType.getRelations() == null) {
                objectType.setRelations(factory.createRelationType());
            }
            objectType.getGeneric().getProvided().getTitle().add(title);
            object.metadata = objectType;
        }
        catch (CrudServiceException e) {
            Activator.handleError((Throwable)((Object)e), "Error in TextGridObject.addDefaultMetaDataXML()", new Object[0]);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e, "Error in TextGridObject.addDefaultMetaDataXML()", new Object[0]);
        }
    }

    private static ObjectType toObjectType(OMElement element) {
        try {
            return (ObjectType)JAXB.unmarshal((InputStream)new ByteArrayInputStream(element.toString().getBytes("UTF-8")), ObjectType.class);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e, "Error in TextGridObject.toObjectType()", new Object[0]);
            return null;
        }
    }

    public static TextGridObject getNewObjectInstance(TextGridProject project, TGContentType contentType, String title) {
        TextGridObject object = TextGridObject.getNewObjectInstance(project, contentType);
        TextGridObject.addDefaultMetaDataXML(object, title);
        return object;
    }

    public Calendar getLastModified() throws CoreException {
        GeneratedType generated;
        if (this.lastModified == null && (generated = this.metadata.getGeneric().getGenerated()) != null) {
            this.lastModified = generated.getLastModified().toGregorianCalendar();
        }
        if (this.lastModified == null) {
            this.lastModified = LAST_MODIFIED_NOT_AVAILABLE;
        }
        return this.lastModified;
    }

    public Calendar getCreated() throws CoreException {
        GeneratedType generated;
        if (this.created == null && (generated = this.metadata.getGeneric().getGenerated()) != null) {
            this.created = generated.getCreated().toGregorianCalendar();
        }
        return this.created;
    }

    public synchronized long getSize() throws CoreException {
        GeneratedType generated;
        if (this.size < 0L && (generated = this.getMetadataForReading().getGeneric().getGenerated()) != null) {
            this.size = generated.getExtent().longValue();
        }
        return this.size;
    }

    public synchronized String serialize() throws DataBindingException {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this.metadata, (Writer)writer);
        return writer.toString();
    }

    public synchronized String getProject() throws CoreException {
        if (this.project == null || "".equals(this.project)) {
            this.project = this.getMetadataForReading().getGeneric().getGenerated().getProject().getId();
        }
        return this.project;
    }

    public synchronized String getDataContributor() throws CoreException {
        return this.getMetadata().getGeneric().getGenerated().getDataContributor();
    }

    public synchronized String getCrudWarning() throws CoreException {
        String warnings = "";
        try {
            for (GeneratedType.Warning warning : this.getMetadataForReading().getGeneric().getGenerated().getWarning()) {
                if (!warnings.equals("")) {
                    warnings = String.valueOf(warnings) + "\n";
                }
                warnings = String.valueOf(warnings) + warning.getValue();
            }
        }
        catch (Exception exception) {}
        return warnings;
    }

    public TextGridProject getProjectInstance() throws CoreException {
        try {
            return TextGridProject.getProjectInstance(this.getProject());
        }
        catch (RemoteException e) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format("An error occurred while retrieving the project (ID {0}) for {1}: {2}", this.getProject(), this, e.getMessage())));
        }
        catch (ProjectDoesNotExistException projectDoesNotExistException) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format("The project with the ID {1}, referenced in the metadata for {0}, does not exist. This is a major problem in the metadata.", this, this.getProject())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentTypeID() throws CoreException {
        TextGridObject textGridObject = this;
        synchronized (textGridObject) {
            if (this.contentTypeID == null || "".equals(this.contentTypeID)) {
                this.contentTypeID = this.getMetadataForReading().getGeneric().getProvided().getFormat();
            }
            return this.contentTypeID;
        }
    }

    public String getNameCandidate() throws CoreException {
        if ("textgrid-newfile".equalsIgnoreCase(this.getURI().getScheme())) {
            return new Path(this.getURI().getPath()).lastSegment().toString();
        }
        String title = this.getTitle();
        return title.replace('/', '-');
    }

    public String getURIBasedName() throws CoreException {
        String localFileName = this.getURI().toASCIIString();
        localFileName = String.valueOf(this.getNameCandidate()) + "." + localFileName.substring(this.getURI().getScheme().length() + 1);
        localFileName = localFileName.replaceAll("[%:/\\*?\"<>|]", "_");
        TGContentType contentType = this.getContentType(false);
        if (contentType != null) {
            localFileName = String.valueOf(localFileName) + "." + contentType.getExtension();
        }
        return localFileName;
    }

    public synchronized String getTitle() throws CoreException {
        if ((this.title == null || "".equals(this.title)) && this.metadata != null && this.metadata.getGeneric() != null && this.metadata.getGeneric().getProvided() != null) {
            List titles = this.metadata.getGeneric().getProvided().getTitle();
            if (titles != null && titles.size() > 0) {
                this.title = (String)titles.get(0);
            } else {
                return NO_TITLE;
            }
        }
        return this.title;
    }

    public synchronized void setTitle(String value) {
        List titles = this.metadata.getGeneric().getProvided().getTitle();
        if (titles.size() == 0) {
            titles.add(value);
        } else {
            titles.set(0, value);
        }
        this.title = value;
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
    }

    public synchronized List<String> getAuthors() throws CoreException {
        Function<AgentType, String> agentToString = new Function<AgentType, String>(){

            public String apply(AgentType agent) {
                return agent.getValue();
            }
        };
        Predicate<AgentType> authorsOnly = new Predicate<AgentType>(){

            public boolean apply(AgentType input) {
                return input.getRole().equals((Object)AgentRoleType.AUTHOR);
            }
        };
        Iterable authors = null;
        if (this.metadata.getItem() != null) {
            authors = ImmutableList.of((Object)MessageFormat.format("{0} (data contributor)", this.isNew() ? RBACSession.getInstance().getPerson().getValue() : this.getDataContributor()));
        } else if (this.metadata.getEdition() != null) {
            authors = Iterables.transform((Iterable)Iterables.filter((Iterable)this.metadata.getEdition().getAgent(), (Predicate)authorsOnly), (Function)agentToString);
        } else if (this.metadata.getWork() != null) {
            authors = Iterables.transform((Iterable)Iterables.filter((Iterable)this.metadata.getWork().getAgent(), (Predicate)authorsOnly), (Function)agentToString);
        }
        if (authors != null) {
            return ImmutableList.copyOf(authors);
        }
        if (this.metadata.getGeneric().getGenerated() != null) {
            return ImmutableList.of((Object)this.metadata.getGeneric().getGenerated().getDataContributor());
        }
        return ImmutableList.of((Object)"(you)");
    }

    public synchronized URI getURI() {
        return this.uri;
    }

    private synchronized void setURI(URI uri) {
        if (this.uri != null && this.uri.getScheme().equals("textgrid") && !uri.getSchemeSpecificPart().startsWith(uri.getSchemeSpecificPart())) {
            throw new IllegalArgumentException(NLS.bind((String)"Tried to change {0}''s URI to {1} -- this is forbidden.", (Object)this.uri, (Object)uri));
        }
        this.uri = uri;
    }

    public String getLatestURI() {
        try {
            return this.getURI().toString().split("\\.")[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public String getRevisionNumber() {
        try {
            return this.getURI().toString().split("\\.")[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public URI getEFSURI() {
        return this.efsUri;
    }

    public URI getPreparedURI() {
        if (this.isNew()) {
            return this.preparedURI;
        }
        return this.getURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fetchURIs(Iterable<TextGridObject> newObjects, IProgressMonitor monitor) throws CoreException {
        List uris;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Retrieving URIs", (int)9);
        LinkedList objects = Lists.newLinkedList();
        int number = 0;
        for (TextGridObject object : newObjects) {
            if (!object.isNew() || object.getPreparedURI() != null) continue;
            objects.add(object);
            ++number;
        }
        progress.worked(1);
        if (number == 0) {
            progress.done();
            return;
        }
        TGCrudService crudServiceStub = CrudClientUtilities.getCrudServiceStub();
        progress.worked(2);
        try {
            uris = crudServiceStub.getUri(RBACSession.getInstance().getSID(false), logsession.getInstance().getloginfo(), ((TextGridObject)objects.get(0)).getProject(), number);
        }
        catch (AuthFault e) {
            throw new CrudServiceException(e, null);
        }
        catch (IoFault e) {
            throw new CrudServiceException(e, null);
        }
        catch (ObjectNotFoundFault e) {
            throw new CrudServiceException(e, null);
        }
        progress.worked(5);
        Class<TextGridObject> clazz = TextGridObject.class;
        synchronized (TextGridObject.class) {
            Iterator iterator = uris.iterator();
            for (TextGridObject object : objects) {
                object.preparedURI = URI.create((String)iterator.next());
                registry.put(object.preparedURI, object);
            }
            // ** MonitorExit[var7_10] (shouldn't be in output)
            progress.worked(1);
            progress.done();
            return;
        }
    }

    public synchronized void move(ObjectType newMetadata) throws CoreException {
        Assert.isNotNull((Object)newMetadata, (String)"move does not accept a null argument.");
        final IFile file = (IFile)this.getAdapter(IFile.class);
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Could not find IFile for {0}, Please file a bug report.", (Object)this)));
        }
        final URI oldURI = this.getURI();
        try {
            URI newURI = new URI(newMetadata.getGeneric().getGenerated().getTextgridUri().getValue());
            TextGridObject.assertURIValidForTGO(newURI);
            this.setURI(newURI);
            this.efsUri = TextGridObject.computeEFSURI(newURI);
            registry.put(this.getURI(), this);
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Could not extract URI from the new metadata block: \n{0}\n ... for the object with the temporary uri {1}", (Object)newMetadata, (Object)this.getURI()), (Throwable)e));
        }
        final IFile destination = ModelAdaptorFactory.getFileFor(this, true);
        this.internalSetMetadata(newMetadata, false);
        this.setComplete(true);
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule moveJobRule = MultiRule.combine((ISchedulingRule)ruleFactory.moveRule((IResource)file, (IResource)destination), (ISchedulingRule)ruleFactory.createRule((IResource)destination));
        IndexedWorkspaceJob moveJob = new IndexedWorkspaceJob(NLS.bind((String)"Moving {0} to final destination", (Object)this)){

            @Override
            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || ((Object)((Object)this)).equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)100);
                    progress.worked(10);
                    TextGridObject.this.invalidateCache();
                    progress.worked(10);
                    if (TextGridObject.this.getURI().equals(oldURI)) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    try {
                        if (Activator.getDefault().isDebugging()) {
                            System.out.println("TextGridObject#move from " + oldURI + " to " + TextGridObject.this.getURI());
                        }
                        registry.remove(oldURI);
                        progress.worked(10);
                        file.createLink(TextGridObject.this.efsUri, 256, (IProgressMonitor)progress.newChild(35));
                        if (destination.exists()) {
                            destination.delete(1, (IProgressMonitor)progress.newChild(5));
                        } else {
                            progress.worked(5);
                        }
                        file.move(destination.getFullPath(), 33, (IProgressMonitor)progress.newChild(30));
                    }
                    catch (CoreException e) {
                        CoreExceptionStatus coreExceptionStatus = new CoreExceptionStatus("info.textgrid.lab.core.model", e);
                        return coreExceptionStatus;
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        moveJob.setFamilyName(MOVE_TGOBJECT);
        moveJob.setRule(moveJobRule);
        moveJob.schedule();
    }

    public static URI computeEFSURI(URI textGridURI) {
        URI efs_uri = null;
        if ("textgrid".equals(textGridURI.getScheme())) {
            String efs_uri_string = "textgrid-efs://localhost/" + textGridURI.toString();
            try {
                efs_uri = new URI(efs_uri_string);
            }
            catch (URISyntaxException e) {
                Activator.handleError(e, "Subtle EFS URI creation error. Please file a bug report.", new Object[0]);
            }
        } else {
            efs_uri = textGridURI;
        }
        return efs_uri;
    }

    public static URI computeTextGridURI(URI efsURI) {
        URI textgrid_uri = null;
        if (efsURI == null) {
            return null;
        }
        if ("textgrid-efs".equals(efsURI.getScheme())) {
            String fragment;
            String uri_string = efsURI.getRawPath();
            String query = efsURI.getRawQuery();
            if (query != null) {
                uri_string = String.valueOf(uri_string) + "?" + query;
            }
            if ((fragment = efsURI.getRawFragment()) != null) {
                uri_string = String.valueOf(uri_string) + "#" + fragment;
            }
            uri_string = uri_string.replaceFirst("^/*", "");
            try {
                textgrid_uri = new URI(uri_string);
            }
            catch (URISyntaxException e) {
                Activator.handleError(e, "Subtle TextGrid URI creation error. Please file a bug report.", new Object[0]);
            }
        } else {
            textgrid_uri = efsURI;
        }
        return textgrid_uri;
    }

    public void joinWorkspaceJobs(IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IJobManager workspaceJobManager = WorkspaceJob.getJobManager();
        workspaceJobManager.join((Object)this, monitor);
    }

    public void delete(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)"Deleting {0}", (Object)this), (int)100);
        IFile file = (IFile)this.getAdapter(IFile.class);
        progress.worked(25);
        if (progress.isCanceled()) {
            return;
        }
        if (file != null) {
            file.delete(true, (IProgressMonitor)progress.newChild(25));
        } else {
            progress.worked(25);
        }
        IFileStore fileStore = EFS.getStore((URI)this.getEFSURI());
        progress.worked(10);
        if (progress.isCanceled()) {
            return;
        }
        if (fileStore != null) {
            fileStore.delete(0, (IProgressMonitor)progress.newChild(40));
        } else {
            progress.worked(40);
        }
        this.deleted = true;
        TextGridProject p = this.getProjectInstance();
        String pfUri = p.getProjectfile();
        if (pfUri != null && !pfUri.equals("") && pfUri.equals(this.getURI().toString())) {
            try {
                p.unsetProjectFile();
                System.err.println("unsetProjectFile() called");
            }
            catch (OfflineException e) {
                Activator.handleError(e, "Error TextGridObject.delete()", new Object[0]);
            }
            catch (RemoteException e) {
                Activator.handleError(e, "Error TextGridObject.delete()", new Object[0]);
            }
            catch (AuthenticationFault e) {
                Activator.handleError(e, "Error TextGridObject.delete()", new Object[0]);
            }
        }
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.DELETED, this);
    }

    public static void addListener(ITextGridObjectListener listener) {
        listeners.add((Object)listener);
    }

    public static void removeListener(ITextGridObjectListener listener) {
        listeners.remove((Object)listener);
    }

    public static void notifyListeners(final ITextGridObjectListener.Event event, final TextGridObject textGridObject) {
        UIJob job = new UIJob("Notifying TextGridObject listeners"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Object[] objectArray = listeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ITextGridObjectListener)listener).textGridObjectChanged(event, textGridObject);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public TGContentType getContentType(boolean exact) throws CoreException {
        if (exact) {
            return TGContentType.getContentType(this.getContentTypeID());
        }
        return TGContentType.findMatchingContentType(this.getContentTypeID());
    }

    @Deprecated
    public TGContentType getContentType() throws CoreException {
        return this.getContentType(true);
    }

    public void setInitialContent(byte[] initialContents) throws IllegalStateException {
        if (!this.isNew() && initialContents != null) {
            throw new IllegalStateException("Cannot set initial contents for objects that have been materalized.");
        }
        this.initialContent = initialContents;
    }

    public void setInitialContent(InputStream contentStream, IProgressMonitor monitor) throws IOException {
        int bytesRead;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)-1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = contentStream.read(buffer)) > -1 && !progress.isCanceled()) {
            baos.write(buffer, 0, bytesRead);
        }
        this.setInitialContent(baos.toByteArray());
    }

    public byte[] getInitialContent() {
        return this.initialContent;
    }

    public synchronized void setSchema(URI uri) {
        this.getRelations().setHasSchema(uri.toString());
    }

    private RelationType getRelations() {
        RelationType relations = this.metadata.getRelations();
        if (relations == null) {
            relations = new ObjectFactory().createRelationType();
            this.metadata.setRelations(relations);
        }
        return relations;
    }

    public synchronized void setAdaptor(URI uri) {
        this.getRelations().setHasAdaptor(uri.toString());
    }

    @Deprecated
    public synchronized void setPreviousVersion(URI uri) {
        this.getRelations().setIsDerivedFrom(uri.toString());
    }

    @Deprecated
    public synchronized void clearPreviousVersion() {
        this.getRelations().setIsDerivedFrom(null);
    }

    @Deprecated
    public synchronized TextGridObject getPreviousVersion() {
        String isVersionOf = this.getRelations().getIsDerivedFrom();
        if (isVersionOf != null && isVersionOf != "") {
            return TextGridObject.getInstanceOffline(URI.create(isVersionOf));
        }
        return null;
    }

    public synchronized URI getAdaptor() throws CrudServiceException {
        String adaptorProperty = this.getRelations().getHasAdaptor();
        if (adaptorProperty == null) {
            return null;
        }
        return URI.create(this.getRelations().getHasAdaptor());
    }

    public synchronized void clearAdaptor() throws CrudServiceException {
        this.getRelations().setHasAdaptor(null);
    }

    public URI getSchemaURI() throws CrudServiceException {
        String schema = this.getRelations().getHasSchema();
        if (schema != null) {
            return URI.create(schema);
        }
        return null;
    }

    public void deleteSchema() {
        this.getRelations().setHasSchema(null);
    }

    protected static IPath makeLocalPath(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath workspaceLocation = root.getLocation();
        if (workspaceLocation.isPrefixOf(path)) {
            path = path.removeFirstSegments(workspaceLocation.segmentCount()).makeAbsolute();
            path = path.setDevice(null);
        }
        return path;
    }

    public File toLocalFile(IProgressMonitor monitor, boolean reload) throws CoreException {
        IFileStore store = EFS.getStore((URI)this.getEFSURI());
        return store.toLocalFile(4096, monitor);
    }

    protected static void createRecursively(IContainer folder) throws CoreException {
        if (folder.exists()) {
            return;
        }
        IContainer parent = folder.getParent();
        if (!parent.exists()) {
            TextGridObject.createRecursively(parent);
        }
        try {
            switch (folder.getType()) {
                case 2: {
                    ((IFolder)folder).create(true, true, null);
                    break;
                }
                case 4: {
                    ((IProject)folder).create(null);
                    ((IProject)folder).open(null);
                }
            }
        }
        catch (ResourceException resourceException) {}
    }

    @Override
    public synchronized int getPermissions() throws CoreException {
        if (this.permissions >= 0) {
            return this.permissions;
        }
        if (this.permissions != -2) {
            GeneratedType generated = this.metadata.getGeneric().getGenerated();
            if (generated != null) {
                String permissionString = generated.getPermissions();
                if (permissionString != null) {
                    Scanner scanner = new Scanner(permissionString);
                    this.permissions = 0;
                    while (scanner.hasNext()) {
                        String permission = scanner.next();
                        this.permissions |= TextGridObject.getNumericPermission(permission);
                    }
                } else {
                    this.permissions = -1;
                }
            } else {
                this.permissions = -1;
            }
        }
        if (this.permissions <= 0) {
            if (this.isNew()) {
                this.permissions = 1;
                if (this.getProjectInstance().hasPermissions(2)) {
                    this.permissions |= 4;
                }
            } else {
                this.permissions = this.retrievePermissions(this.getURI().toString());
            }
        }
        return this.permissions;
    }

    protected void resetPermissionCache() {
        this.permissions = -2;
    }

    public void publish() throws CoreException {
        try {
            this.assertPermission(16, "Access denied: You are not allowed to publish {0}.", this);
            PortTgextra stub = TgAuthClientUtilities.getTgAuthServiceStub();
            PublishRequest request = new PublishRequest();
            request.setAuth(RBACSession.getInstance().getSID(true));
            request.setLog(logsession.getInstance().getloginfo());
            request.setResource(this.getURI().toASCIIString());
            stub.publish(request);
        }
        catch (AuthenticationFault e) {
            throw new CoreException((IStatus)new Status(4, "info.textgrid.lab.core.model", MessageFormat.format("Access denied: You are not allowed to publish {0}.", this), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPublic() throws CoreException {
        TextGridObject textGridObject = this;
        synchronized (textGridObject) {
            try {
                if (this.getMetadataForReading().getGeneric().getGenerated().getAvailability().equals("public")) {
                    return true;
                }
            }
            catch (NullPointerException nullPointerException) {
                return false;
            }
            return false;
        }
    }

    public synchronized void setContentType(TGContentType contentType) {
        this.contentTypeID = contentType.getId();
        this.metadata.getGeneric().getProvided().setFormat(this.contentTypeID);
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
    }

    public void setProject(TextGridProject target) throws IllegalStateException {
        if (!this.isNew()) {
            throw new IllegalStateException(NLS.bind((String)"Cannot change the project for {0} to {1} because the object has already been saved to the Repository.", (Object)this, (Object)target));
        }
        this.project = target.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register() {
        Class<TextGridObject> clazz = TextGridObject.class;
        synchronized (TextGridObject.class) {
            registry.put(this.getURI(), this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized TextGridObject prepareNewVersion(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            progress.worked(1);
            ObjectType objectType = this.getMetadata();
            objectType.getGeneric().setGenerated(null);
            TextGridObject newVersion = TextGridObject.getNewObjectInstance(this.getProject(), this.getContentTypeID());
            progress.worked(1);
            newVersion.setMetadata(objectType);
            progress.worked(2);
            newVersion.setPreviousVersion(this.getURI());
            this.preparedNewVersion = newVersion;
            progress.worked(1);
            newVersion.getAdapter(IFile.class);
            progress.worked(5);
            return this.preparedNewVersion;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.core.model");
            return null;
        }
    }

    public synchronized void cancelNewVersion() {
        this.preparedNewVersion = null;
    }

    public synchronized TextGridObject getPreparedNewVersion() {
        return this.preparedNewVersion;
    }

    public synchronized TextGridObject prepareNewRevision(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            progress.worked(1);
            ObjectType objectType = this.getMetadata();
            objectType.getGeneric().setGenerated(null);
            TextGridObject newRevision = TextGridObject.getNewObjectInstance(this.getProject(), this.getContentTypeID());
            progress.worked(1);
            newRevision.setMetadata(objectType);
            progress.worked(2);
            newRevision.setRevisionURI(this.getURI().toString());
            this.preparedNewRevision = newRevision;
            progress.worked(1);
            newRevision.getAdapter(IFile.class);
            progress.worked(5);
            return this.preparedNewRevision;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.core.model");
            return null;
        }
    }

    public synchronized void cancelNewRevision() {
        this.preparedNewRevision = null;
    }

    public synchronized TextGridObject getPreparedNewRevision() {
        return this.preparedNewRevision;
    }

    public synchronized void setRevisionURI(String revisionURI) {
        this.revisionURI = revisionURI;
    }

    public synchronized String getRevisionURI() {
        return this.revisionURI;
    }

    public synchronized void setEditionMetadata(String isEditionOf, AgentType agent, SourceType source, FormOfNotationType formOfNotation, EditionType.License license) {
        try {
            ObjectType objectType = this.getMetadata();
            objectType.setItem(null);
            objectType.setWork(null);
            objectType.setCollection(null);
            ObjectFactory objectFactory = new ObjectFactory();
            EditionType editionType = objectFactory.createEditionType();
            objectType.setEdition(editionType);
            if (isEditionOf != null) {
                objectType.getEdition().setIsEditionOf(isEditionOf);
            }
            if (agent != null) {
                objectType.getEdition().getAgent().add(agent);
            }
            if (source != null) {
                objectType.getEdition().getSource().add(source);
            }
            if (formOfNotation != null) {
                objectType.getEdition().getFormOfNotation().add(formOfNotation);
            }
            if (license != null) {
                objectType.getEdition().setLicense(license);
            }
            this.metadata = objectType;
            TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
        }
        catch (CrudServiceException e) {
            new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Error while preparing the metadata set for an edition.", (Object)((Object)e)));
        }
    }

    public synchronized void setCollectionMetadata(PersonType collector, String abstract_var, String collectionDescription, AuthorityType spartial, AuthorityType temporal, AuthorityType subject) {
        try {
            ObjectType objectType = this.getMetadata();
            objectType.setItem(null);
            objectType.setWork(null);
            objectType.setEdition(null);
            ObjectFactory objectFactory = new ObjectFactory();
            CollectionType collectionType = objectFactory.createCollectionType();
            objectType.setCollection(collectionType);
            if (collector != null) {
                objectType.getCollection().getCollector().add(collector);
            }
            if (abstract_var != null) {
                objectType.getCollection().setAbstract(abstract_var);
            }
            if (collectionDescription != null) {
                objectType.getCollection().getCollectionDescription().add(collectionDescription);
            }
            if (spartial != null) {
                objectType.getCollection().getSpatial().add(spartial);
            }
            if (temporal != null) {
                objectType.getCollection().getTemporal().add(temporal);
            }
            if (subject != null) {
                objectType.getCollection().getTemporal().add(subject);
            }
            this.metadata = objectType;
            TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
        }
        catch (CrudServiceException e) {
            new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Error while preparing the metadata set for a collection.", (Object)((Object)e)));
        }
    }

    public synchronized void setItemMetadata(PersonType rightsHolder) {
        try {
            ObjectType objectType = this.getMetadata();
            objectType.setCollection(null);
            objectType.setWork(null);
            objectType.setEdition(null);
            ObjectFactory objectFactory = new ObjectFactory();
            ItemType itemType = objectFactory.createItemType();
            objectType.setItem(itemType);
            if (rightsHolder != null) {
                objectType.getItem().getRightsHolder().add(rightsHolder);
            }
            this.metadata = objectType;
            TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
        }
        catch (CrudServiceException e) {
            new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Error while preparing the metadata set for an item.", (Object)((Object)e)));
        }
    }

    public synchronized void setWorkMetadata(AgentType agent) {
        try {
            ObjectType objectType = this.getMetadata();
            objectType.setItem(null);
            objectType.setCollection(null);
            objectType.setEdition(null);
            ObjectFactory objectFactory = new ObjectFactory();
            WorkType workType = objectFactory.createWorkType();
            objectType.setWork(workType);
            if (agent != null) {
                objectType.getWork().getAgent().add(agent);
            }
            this.metadata = objectType;
            TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED, this);
        }
        catch (CrudServiceException e) {
            new Status(4, "info.textgrid.lab.core.model", NLS.bind((String)"Error while preparing the metadata set for a work.", (Object)((Object)e)));
        }
    }

    public static void addLatestRegistryItem(URI latest, URI uri) {
        latestRegistry.put(latest, uri);
    }

    public static void removeLatestRegistryItem(URI latest) {
        latestRegistry.remove(latest);
    }

    private static synchronized TextGridObject getRegisteredTGO(URI uri) {
        URI concretUri = null;
        if (!uri.toString().contains(".")) {
            concretUri = latestRegistry.get(uri);
            if (concretUri != null) {
                return registry.get(concretUri);
            }
            return registry.get(uri);
        }
        return registry.get(uri);
    }

    public void notifyMetadataEditor() {
        TextGridObject.notifyListeners(ITextGridObjectListener.Event.METADATA_CHANGED_FROM_OUTSIDE, this);
    }

    public void setOpenAsReadOnly(boolean value) {
        this.openAsReadOnly = value;
    }

    public boolean isToOpenAsReadOnly() {
        return this.openAsReadOnly;
    }

    protected static class DeepCopyException
    extends RuntimeException {
        private static final long serialVersionUID = 2755746487109125338L;

        public DeepCopyException(ObjectType objectType, Throwable cause) {
            super(DeepCopyException.formatMessage(objectType, cause), cause);
        }

        private static String formatMessage(ObjectType objectType, Throwable cause) {
            return MessageFormat.format("An internal error ({2}) occurred creating a deep copy of the metadata record {0}: {1}", objectType, cause.getLocalizedMessage(), cause.getClass().getSimpleName());
        }
    }

    public static interface ITextGridObjectListener {
        public void textGridObjectChanged(Event var1, TextGridObject var2);

        public static enum Event {
            DELETED,
            CREATED_TEMPORARY,
            CREATED,
            METADATA_CHANGED,
            METADATA_CHANGED_FROM_OUTSIDE,
            SAVED,
            METADATA_SAVED,
            METADATA_INCOMPLETE;

        }
    }
}

