/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.conf;

import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import java.net.URI;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConfservPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    StringFieldEditor endpointEditor;
    BooleanFieldEditor proxyRadio;
    StringFieldEditor proxyString;
    IntegerFieldEditor portString;
    Composite compositeProxy;
    boolean shouldRestart = false;
    private static final IContentProposal[] ENDPOINTS = new IContentProposal[]{new EndpointProposal(URI.create("https://textgridlab.org/1.0/confserv"), "Default Endpoint"), new EndpointProposal(URI.create("https://textgridlab.org/dev/confserv/"), "Development System (ws4)")};

    public ConfservPrefPage() {
    }

    public ConfservPrefPage(int style) {
        super(style);
    }

    public ConfservPrefPage(String title, int style) {
        super(title, style);
    }

    public ConfservPrefPage(String title, ImageDescriptor image, int style) {
        super(title, image, style);
    }

    protected void createFieldEditors() {
        this.createEndpointFieldEditor();
        this.createCompressedTransferFieldEditor();
        this.createProxyFieldEditor();
    }

    private void createCompressedTransferFieldEditor() {
        Composite transferComposite = this.getFieldEditorParent();
        GridLayout transferGridlayout = new GridLayout();
        transferGridlayout.numColumns = 3;
        transferComposite.setLayout((Layout)transferGridlayout);
        BooleanFieldEditor comTrans = new BooleanFieldEditor("compressedTransfer", "Use Compressed Data Transfer", transferComposite);
        this.addField((FieldEditor)comTrans);
    }

    private void createEndpointFieldEditor() {
        Composite endpointFieldParent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        endpointFieldParent.setLayout((Layout)gridLayout);
        this.endpointEditor = new StringFieldEditor("endpoint", "Configuration Service URI", endpointFieldParent);
        this.endpointEditor.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.endpointEditor);
        IContentProposalProvider proposalProvider = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                return ENDPOINTS;
            }
        };
        Text textControl = this.endpointEditor.getTextControl(endpointFieldParent);
        ControllableContentProposalAdapter proposals = new ControllableContentProposalAdapter((Control)textControl, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null);
        proposals.setFilterStyle(2);
        proposals.setProposalAcceptanceStyle(2);
        Label restartInfo = new Label(endpointFieldParent, 64);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        restartInfo.setLayoutData((Object)layoutData);
        restartInfo.setText("After a change of the configuration service URI a restart of the lab is required.");
        Label modifiedInfo = new Label(endpointFieldParent, 64);
        GridData layoutData2 = new GridData(4, 0x1000000, true, false);
        layoutData2.horizontalSpan = 2;
        layoutData2.widthHint = 400;
        modifiedInfo.setLayoutData((Object)layoutData2);
        try {
            String usedEndpoint = ConfClient.getInstance().getEndpoint();
            String configuredEndpoint = this.getPreferenceStore().getString("endpoint");
            if (!usedEndpoint.equals(configuredEndpoint)) {
                modifiedInfo.setText(NLS.bind((String)"The lab currently uses the instance at {0} until the next restart. After the next restart, the value configured using this preference page (by default {1}) will be used. You can always restart the lab using File \u2192 Restart.", (Object)usedEndpoint, (Object)configuredEndpoint));
                ControlDecoration modifiedWarning = new ControlDecoration((Control)modifiedInfo, 131072);
                modifiedWarning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            }
        }
        catch (OfflineException offlineException) {
            modifiedInfo.setText("The lab is currently offline and thus does not use any endpoint.");
        }
    }

    private void createProxyFieldEditor() {
        Composite proxyComposite = this.getFieldEditorParent();
        proxyComposite.setLayout((Layout)new GridLayout());
        GridData proxyLayout = new GridData(4, 0x1000000, true, true);
        Group proxyGroup = new Group(proxyComposite, 0);
        proxyGroup.setText("HTTP Proxy Settings");
        proxyGroup.setLayoutData((Object)proxyLayout);
        this.proxyRadio = new BooleanFieldEditor("proxy_connection", "use proxy", (Composite)proxyGroup);
        this.addField((FieldEditor)this.proxyRadio);
        GridData proxyFieldLayout = new GridData(4, 0x1000000, true, false);
        proxyFieldLayout.horizontalIndent = 25;
        this.compositeProxy = new Composite((Composite)proxyGroup, 4);
        this.compositeProxy.setLayoutData((Object)proxyFieldLayout);
        this.proxyString = new StringFieldEditor("proxy_connection_http", "Proxy:", this.compositeProxy);
        this.portString = new IntegerFieldEditor("proxy_connection_port", "Port:", this.compositeProxy);
        this.addField((FieldEditor)this.proxyString);
        this.addField((FieldEditor)this.portString);
        if (!this.getPreferenceStore().getBoolean("proxy_connection")) {
            this.proxyString.setEnabled(false, this.compositeProxy);
            this.portString.setEnabled(false, this.compositeProxy);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value") && this.proxyRadio != null && this.proxyString != null) {
            if (!this.proxyRadio.getBooleanValue()) {
                this.proxyString.setEnabled(false, this.compositeProxy);
                this.portString.setEnabled(false, this.compositeProxy);
            } else {
                this.proxyString.setEnabled(true, this.compositeProxy);
                this.portString.setEnabled(true, this.compositeProxy);
            }
        }
    }

    public void init(IWorkbench workbench) {
        this.setDescription("Configure basic TextGridLab settings like the URL of the configuration service (which will be used to retrieve all other service adresses).");
        this.setPreferenceStore(ConfPlugin.getDefault().getPreferenceStore());
        this.initialize();
    }

    protected void performApply() {
        this.shouldRestart = this.restartCheck();
        super.performApply();
        if (this.shouldRestart) {
            this.restartDialog();
        }
    }

    public boolean performOk() {
        boolean ok;
        if (!this.shouldRestart) {
            this.shouldRestart = this.restartCheck();
        }
        if ((ok = super.performOk()) && this.shouldRestart) {
            this.restartDialog();
        }
        ConfClient.setProxySelector();
        return ok;
    }

    private boolean restartCheck() {
        return !this.endpointEditor.getStringValue().equals(this.endpointEditor.getPreferenceStore().getString("endpoint"));
    }

    private void restartDialog() {
        if (MessageDialog.openConfirm(null, (String)"TextGridLab restart required", (String)"A change of the TextGrid configuration service URI requires a restart of the TextGridLab. Would you like to restart the lab now? Otherwise you'll work on with the old instance until you restart the Lab via File / Restart.")) {
            PlatformUI.getWorkbench().restart();
        }
    }

    private final class ControllableContentProposalAdapter
    extends ContentProposalAdapter {
        private ControllableContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
        }

        public void openProposalPopup() {
            super.openProposalPopup();
        }
    }

    private static class EndpointProposal
    implements IContentProposal {
        private final URI uri;
        private final String description;

        public EndpointProposal(URI uri, String description) {
            this.uri = uri;
            this.description = description;
        }

        public String getContent() {
            return this.uri.toString();
        }

        public int getCursorPosition() {
            return this.uri.getScheme().length() + this.uri.getHost().length() + 3;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return String.valueOf(this.description) + " (" + this.uri.toString() + ")";
        }
    }
}

