/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import info.textgrid.lab.xmleditor.mpeditor.MPXmlEditorPart;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import net.sf.vex.dom.linked.LinkedDocument;
import net.sf.vex.editor.VexEditorPage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class DebugDocumentHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor != null && editor instanceof MPXmlEditorPart) {
            VexEditorPage vex = ((MPXmlEditorPart)editor).getWysiwymEditor();
            if (vex == null) {
                return null;
            }
            FileDialog dialog = new FileDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), 8192);
            dialog.setText(Messages.DebugDocumentHandler_SaveWYSIWYMDebug);
            dialog.setFileName(editor.getEditorInput().getName().concat(".txt"));
            dialog.setFilterExtensions(new String[]{"*.txt"});
            dialog.setFilterNames(new String[]{Messages.DebugDocumentHandler_TextFiles});
            String fileName = dialog.open();
            LinkedDocument document = vex.getDoc();
            if (fileName != null) {
                try {
                    PrintStream printStream = new PrintStream(fileName);
                    document.printModelCheckReport(printStream);
                    document.printDocument(printStream);
                    printStream.close();
                }
                catch (FileNotFoundException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.xmleditor.mpeditor", NLS.bind((String)Messages.DebugDocumentHandler_FailedToSaveDebuggingOutput, (Object)fileName, (Object)e.getLocalizedMessage()), (Throwable)e), 3);
                }
            } else {
                document.printModelCheckReport(System.out);
            }
        }
        return null;
    }
}

