/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.metadataeditor.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.metadataeditor.utils.Messages;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.middleware.tgsearch.client.SearchClient;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.EntryType;
import info.textgrid.namespaces.middleware.tgsearch.PathGroupType;
import info.textgrid.namespaces.middleware.tgsearch.PathResponse;
import info.textgrid.namespaces.middleware.tgsearch.PathType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEIHeaderGenerator
extends Job {
    private final TextGridObject rootObject;
    private final boolean toClipboard;
    private final boolean toEditor;
    private static final QName OBJECTS = new QName("http://textgrid.info/namespaces/metadata/core/2010", "objects");
    private String header;

    public TEIHeaderGenerator(TextGridObject object, boolean toClipboard) {
        super(NLS.bind((String)Messages.TEIHeaderGenerator_generatingHeader, (Object)object));
        this.rootObject = object;
        this.toEditor = this.toClipboard = toClipboard;
    }

    public TEIHeaderGenerator(TextGridObject object, boolean toClipboard, boolean toEditor) {
        super(NLS.bind((String)Messages.TEIHeaderGenerator_generatingHeader, (Object)object));
        this.rootObject = object;
        this.toClipboard = toClipboard;
        this.toEditor = toEditor;
    }

    public static String generate(TextGridObject rootObject, IProgressMonitor monitor) throws IOException, CrudServiceException, XMLStreamException, TransformerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.TEIHeaderGenerator_generatingHeader, (Object)rootObject), (int)100);
        StreamSource mdSource = TEIHeaderGenerator.getAllMetadataSource(rootObject, (IProgressMonitor)progress.newChild(70));
        InputStream xslStream = FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("resources").append("md2tei.xsl"), (boolean)false);
        StreamSource xslSource = new StreamSource(xslStream);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(resultStream);
            progress.worked(10);
            transformer.transform(mdSource, result);
            String tei = resultStream.toString("UTF-8");
            progress.worked(20);
            return tei;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
    }

    private static StreamSource getAllMetadataSource(TextGridObject rootObject, IProgressMonitor monitor) throws OfflineException, XMLStreamException, CrudServiceException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.TEIHeaderGenerator_fetchingMetadata, (Object)rootObject), (int)50);
        ArrayList uris = Lists.newArrayList();
        if (!rootObject.isNew()) {
            SearchClient searchClient = new SearchClient(ConfClient.getInstance().getValue("tgsearch"));
            searchClient.setSid(RBACSession.getInstance().getSID(false));
            PathResponse response = searchClient.getPath(rootObject.getURI().toASCIIString());
            progress.worked(10);
            for (PathGroupType group : response.getPathGroup()) {
                for (PathType path : group.getPath()) {
                    for (EntryType entry : path.getEntry()) {
                        uris.add(URI.create(entry.getTextgridUri().trim()));
                    }
                }
            }
        } else {
            progress.worked(10);
        }
        uris.add(rootObject.getURI());
        Collections.reverse(uris);
        progress.worked(5);
        progress.setWorkRemaining(10 * uris.size() + 10);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            XMLEventWriter xml = XMLOutputFactory.newInstance().createXMLEventWriter(baos, "UTF-8");
            XMLEventFactory events = XMLEventFactory.newInstance();
            xml.setDefaultNamespace("http://textgrid.info/namespaces/metadata/core/2010");
            xml.add(events.createStartDocument());
            xml.add(events.createStartElement(OBJECTS, null, (Iterator<? extends Namespace>)ImmutableList.of((Object)events.createNamespace("http://textgrid.info/namespaces/metadata/core/2010")).iterator()));
            progress.worked(5);
            for (URI uri : uris) {
                TextGridObject object = TextGridObject.getInstance((URI)uri, (boolean)true);
                ObjectType metadata = object.getMetadataForReading();
                progress.worked(7);
                try {
                    Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ObjectType.class}).createMarshaller();
                    marshaller.setProperty("jaxb.fragment", (Object)true);
                    marshaller.marshal((Object)metadata, xml);
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                progress.worked(3);
            }
            xml.add(events.createEndDocument());
            xml.close();
            StreamSource mdSource = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
            progress.worked(5);
            return mdSource;
        }
        catch (FactoryConfigurationError e1) {
            throw new IllegalStateException(e1);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.header = TEIHeaderGenerator.generate(this.rootObject, monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.toClipboard || this.toEditor) {
                UIJob uiJob = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (TEIHeaderGenerator.this.toClipboard) {
                            Clipboard clipboard = new Clipboard(this.getDisplay());
                            clipboard.setContents(new Object[]{TEIHeaderGenerator.this.getHeader()}, new Transfer[]{TextTransfer.getInstance()});
                        }
                        if (TEIHeaderGenerator.this.toEditor) {
                            TEIHeaderGenerator.this.toEditor();
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setSystem(true);
                uiJob.schedule();
            }
            return Status.OK_STATUS;
        }
        catch (CrudServiceException e) {
            return new Status(4, "info.textgrid.lab.core.metadataeditor", NLS.bind((String)Messages.TEIHeaderGenerator_readMetadata_failed, (Object)this.rootObject, (Object)e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            return new Status(4, "info.textgrid.lab.core.metadataeditor", NLS.bind((String)Messages.TEIHeaderGenerator_generateHeader_failed, (Object)this.rootObject, (Object)e.getLocalizedMessage()));
        }
        catch (XMLStreamException e) {
            return new Status(4, "info.textgrid.lab.core.metadataeditor", NLS.bind((String)Messages.TEIHeaderGenerator_generateHeader_failed, (Object)this.rootObject, (Object)e.getLocalizedMessage()));
        }
        catch (TransformerException e) {
            return new Status(4, "info.textgrid.lab.core.metadataeditor", NLS.bind((String)Messages.TEIHeaderGenerator_generateHeader_failed, (Object)this.rootObject, (Object)e.getLocalizedMessage()));
        }
    }

    public TextGridObject getRootObject() {
        return this.rootObject;
    }

    public String getHeader() {
        return this.header;
    }

    public void toEditor() {
        IStructuredModel model;
        IDocument document = TEIHeaderGenerator.getEditorDocument(this.rootObject);
        if (document instanceof IStructuredDocument && (model = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)document)) != null) {
            try {
                IndexedRegion rootRegion = model.getIndexedRegion(0);
                Node node = (Node)AdapterUtils.getAdapter((Object)rootRegion, Node.class);
                if (node == null) {
                    return;
                }
                try {
                    Document doc = node.getOwnerDocument();
                    NodeList teiHeaderElements = doc.getElementsByTagName("teiHeader");
                    if (teiHeaderElements.getLength() > 0) {
                        Element header = (Element)teiHeaderElements.item(0);
                        IndexedRegion headerRegion = (IndexedRegion)AdapterUtils.getAdapter((Object)header, IndexedRegion.class);
                        document.replace(headerRegion.getStartOffset(), headerRegion.getEndOffset() - headerRegion.getStartOffset(), this.getHeader());
                    }
                }
                catch (BadLocationException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.metadataeditor", Messages.TEIHeaderGenerator_replaceHeaderError, (Throwable)e));
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }

    private static IDocument getEditorDocument(TextGridObject object) {
        IEditorInput input = (IEditorInput)AdapterUtils.getAdapter((Object)object, IEditorInput.class);
        if (input == null) {
            return null;
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor(input);
        ISourceViewer sourceViewer = (ISourceViewer)AdapterUtils.getAdapter((Object)editor, ISourceViewer.class);
        if (sourceViewer == null) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        return document;
    }
}

