/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow.views;

import info.textgrid.lab.workflow.MetadataTransformer;
import info.textgrid.lab.workflow.views.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MetadataTransformerDialogue
extends TrayDialog {
    MetadataTransformerDialogue thisDialog;
    Group frame;
    MetadataTransformer transformer;
    ArrayList<Label> labels = new ArrayList();
    ArrayList<Text> values = new ArrayList();

    protected MetadataTransformerDialogue(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    public MetadataTransformerDialogue(Shell parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
        this.thisDialog = this;
    }

    protected void initialize(Composite parent) {
    }

    protected void destroy() {
        this.thisDialog.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1) {
            this.destroy();
        }
        if (buttonId == 16) {
            this.readAndStoreParams();
            this.destroy();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        c.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        c.setLayout((Layout)glp);
        this.frame = new Group(c, 0);
        GridData gdf = new GridData(4, 4, true, true);
        gdf.widthHint = 500;
        gdf.heightHint = 300;
        this.frame.setLayoutData((Object)gdf);
        GridLayout glpf = new GridLayout(2, false);
        this.frame.setLayout((Layout)glpf);
        this.frame.setText(MessageFormat.format(Messages.MetadataTransformerDialogue_EditMetadataForText, this.transformer.getOutput().getFromPort().getName()));
        for (String key : this.transformer.getParams().keySet()) {
            Label keyLabel = new Label((Composite)this.frame, 0);
            keyLabel.setText(key);
            this.labels.add(keyLabel);
            Text valueText = new Text((Composite)this.frame, 2052);
            GridData gdValueText = new GridData(4, 2, true, false);
            valueText.setLayoutData((Object)gdValueText);
            String value = this.transformer.getParams().get(key);
            valueText.setText(value == null ? "" : value);
            this.values.add(valueText);
        }
        return c;
    }

    private void readAndStoreParams() {
        Iterator<Text> valueTexts = this.values.iterator();
        for (Label l : this.labels) {
            Text t = valueTexts.next();
            String v = t.getText();
            if (v.length() < 1 || v.matches("\\s+")) {
                v = null;
            }
            this.transformer.getParams().put(l.getText(), v);
        }
    }

    public void setContents(MetadataTransformer mdt) {
        this.transformer = mdt;
    }
}

