/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.menus;

import com.google.common.base.Predicate;
import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.TGContentType;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class NewObjectMenu
extends ContributionItem {
    public NewObjectMenu() {
    }

    public NewObjectMenu(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        final ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
        TGContentType[] contentTypes = TGContentType.getContentTypes((Predicate)new Predicate<TGContentType>(){

            public boolean apply(TGContentType input) {
                return input.isCreatable() && !input.isInternal();
            }
        });
        Arrays.sort(contentTypes, new CTComparator());
        TGContentType[] tGContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            final TGContentType contentType = tGContentTypeArray[n2];
            if (!contentType.getId().contains("aggregation") && !contentType.getId().contains("text/tg.work+xml")) {
                MenuItem item = new MenuItem(menu, 0, index);
                item.setText(contentType.getDescription());
                item.setImage(contentType.getImage(false));
                Listener listener = new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.type) {
                            case 13: {
                                Command command = commandService.getCommand("info.textgrid.lab.ui.core.addobject");
                                try {
                                    IParameter parameter = command.getParameter("info.textgrid.lab.ui.core.addobject.contenttype");
                                    Parameterization parm = new Parameterization(parameter, contentType.getId());
                                    ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
                                    try {
                                        handlerService.executeCommand(parmCommand, null);
                                    }
                                    catch (ExecutionException e) {
                                        Activator.handleError((Throwable)e);
                                    }
                                    catch (NotEnabledException e) {
                                        Activator.handleError((Throwable)e);
                                    }
                                    catch (NotHandledException e) {
                                        Activator.handleError((Throwable)e);
                                    }
                                    break;
                                }
                                catch (NotDefinedException e) {
                                    Activator.handleError((Throwable)e);
                                }
                            }
                        }
                    }
                };
                item.addListener(13, listener);
            }
            ++n2;
        }
    }

    class CTComparator
    implements Comparator<TGContentType> {
        CTComparator() {
        }

        @Override
        public int compare(TGContentType o1, TGContentType o2) {
            return o2.getDescription().compareTo(o1.getDescription());
        }
    }
}

