/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.templateeditor.wizard;

import info.textgrid.lab.core.metadataeditor.MetaDataView;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.ProjectDoesNotExistException;
import info.textgrid.lab.core.model.ProjectFileException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectFile;
import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.templateeditor.Activator;
import info.textgrid.lab.templateeditor.config.ConfigCreator;
import info.textgrid.lab.templateeditor.config.ConfigCustomElement;
import info.textgrid.lab.templateeditor.utils.AdvancedControlElement;
import info.textgrid.lab.templateeditor.utils.RepeatItemsGroup;
import info.textgrid.lab.templateeditor.xsdcreator.XSDElement;
import info.textgrid.lab.templateeditor.xsdcreator.XSDSchema;
import info.textgrid.lab.templateeditor.xulmapping.TemplateElement;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.AppData;
import info.textgrid.namespaces.metadata.projectfile._2008_11_27.TgProjectFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WizardUtils {
    private TextGridProject project = null;
    private TextGridProjectFile projectFile = null;
    private ArrayList<ConfigCustomElement> custom_elements = null;
    private XSDSchema custom_schema = null;
    private String custom_xul = "";
    private int index = 1;

    void setProject(TextGridProject project) {
        try {
            this.project = TextGridProject.getProjectInstance((String)project.getId());
            this.projectFile = null;
            this.custom_elements = null;
            this.custom_schema = null;
            this.readConfig();
        }
        catch (RemoteException e) {
            Activator.handleError(e);
        }
        catch (CrudServiceException e) {
            Activator.handleError(e);
        }
        catch (ProjectDoesNotExistException e) {
            Activator.handleError(e);
        }
    }

    private void readConfig() {
        if (this.project == null) {
            return;
        }
        Job read_job = new Job("Reading the projectfile..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("Fetching the projectfile data...", -1);
                WizardUtils.this.projectFile = new TextGridProjectFile(WizardUtils.this.project);
                try {
                    OMElement config;
                    TgProjectFile projectFileData = WizardUtils.this.projectFile.getProjectFileData(false, true, monitor);
                    OMElement[] appDataChildren = TextGridProjectFile.extractAppDataChildren((TgProjectFile)projectFileData);
                    OMElement metaSection = null;
                    if (appDataChildren != null && appDataChildren.length > 0) {
                        OMElement[] oMElementArray = appDataChildren;
                        int n = appDataChildren.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OMElement child = oMElementArray[n2];
                            if (child.getQName().equals(TextGridProjectFile.metadataSectionQName)) {
                                metaSection = child;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (metaSection != null && (config = metaSection.getFirstChildWithName(ConfigCreator.templateConfQname)) != null) {
                        System.out.println(config);
                        WizardUtils.this.custom_elements = ConfigCreator.getConfigCustomElements(config);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Activator.handleError(e, "Couldn't read the configuration from the project-file.", new Object[0]);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        read_job.schedule();
        try {
            read_job.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    ArrayList<ConfigCustomElement> getLastSavedCustomElements() {
        return this.custom_elements;
    }

    void createAndSaveData(LinkedList<RepeatItemsGroup> groups) {
        ConfigCreator conf = ConfigCreator.getInstance();
        if (groups != null) {
            this.createCustom(groups);
        }
        OMElement schema = this.custom_schema != null ? this.custom_schema.createSchema() : null;
        OMElement config = conf.createConfig();
        System.out.println(this.custom_xul);
        System.out.println(schema);
        System.out.println(config);
        try {
            OMElement xul_om = StringToOM.getOMElement((String)this.custom_xul);
            this.addMetadataPartToProjectFile(xul_om, schema, config);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e, "Couldn't set the data into the projectfile!", new Object[0]);
        }
        catch (XMLStreamException e) {
            Activator.handleError(e, "Couldn't set the data into the projectfile!", new Object[0]);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e, "Couldn't set the data into the projectfile!", new Object[0]);
        }
    }

    private void addMetadataPartToProjectFile(final OMElement xul, final OMElement schema, final OMElement config) {
        if (this.projectFile == null) {
            return;
        }
        Job saveJob = new Job("Saving into the project-file..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Iterator childElements;
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("Saving into the project-file...", 100);
                    monitor.worked(10);
                    TgProjectFile projectFileData = WizardUtils.this.projectFile.getProjectFileData(true, true, monitor);
                    OMFactory omFactory = OMAbstractFactory.getOMFactory();
                    OMElement appDataOM = TextGridProjectFile.extractAppDataXML((TgProjectFile)projectFileData);
                    monitor.worked(40);
                    OMElement metaDataOM = omFactory.createOMElement(TextGridProjectFile.metadataSectionQName);
                    if (xul != null) {
                        metaDataOM.addChild((OMNode)xul);
                    }
                    if (schema != null) {
                        metaDataOM.addChild((OMNode)schema);
                    }
                    if (config != null) {
                        metaDataOM.addChild((OMNode)config);
                    }
                    metaDataOM.addAttribute(TextGridProjectFile.descriptionChanged);
                    monitor.worked(10);
                    LinkedList<Element> newAppData = new LinkedList<Element>();
                    Iterator iterator = childElements = appDataOM == null ? null : appDataOM.getChildElements();
                    if (childElements != null) {
                        while (childElements.hasNext()) {
                            OMElement next = (OMElement)childElements.next();
                            if (metaDataOM.getLocalName().equals(next.getLocalName())) continue;
                            newAppData.add(WizardUtils.toDOM(next));
                        }
                    }
                    newAppData.add(WizardUtils.toDOM(metaDataOM));
                    if (projectFileData.getAppData() == null) {
                        projectFileData.setAppData(new AppData());
                    } else {
                        projectFileData.getAppData().getAny().clear();
                    }
                    projectFileData.getAppData().getAny().addAll(newAppData);
                    WizardUtils.this.projectFile.saveProjectFileData(projectFileData, monitor);
                    new UIJob("Updating the metadata view..."){

                        public IStatus runInUIThread(IProgressMonitor arg0) {
                            MetaDataView metadataView = (MetaDataView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.core.metadataeditor.view");
                            if (metadataView != null) {
                                try {
                                    metadataView.reloadProjectFile(WizardUtils.this.project);
                                }
                                catch (CoreException e) {
                                    Activator.handleWarning(e);
                                    return Status.CANCEL_STATUS;
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.done();
                }
                catch (ProjectFileException e) {
                    Activator.handleError(e, "Couldn't write in the project-file.\nMaybe you don't have the right to edit the project file!", new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                catch (CrudServiceException e) {
                    Activator.handleError(e, "Couldn't write in the project-file.\nMaybe you don't have the right to edit the project file!", new Object[0]);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        saveJob.setUser(true);
        saveJob.schedule();
    }

    private void createCustom(LinkedList<RepeatItemsGroup> groups) {
        this.custom_schema = new XSDSchema(TextGridObject.CUSTOM_NAMESPACE);
        ConfigCreator conf = ConfigCreator.getInstance();
        this.createCustomHead();
        for (RepeatItemsGroup g : groups) {
            String name = "";
            String type = "";
            boolean repeatable = false;
            boolean required = false;
            for (AdvancedControlElement c : g.getAdvancedControls()) {
                Button b;
                if (c.getName().equals("name") && c.getControl() instanceof Text) {
                    Text t = (Text)c.getControl();
                    if (t == null) continue;
                    name = t.getText();
                    continue;
                }
                if (c.getName().equals("type") && c.getControl() instanceof Combo) {
                    Combo com = (Combo)c.getControl();
                    if (com == null) continue;
                    type = com.getText();
                    continue;
                }
                if (c.getName().equals("repeatable") && c.getControl() instanceof Button) {
                    b = (Button)c.getControl();
                    if (b == null) continue;
                    repeatable = b.getSelection();
                    continue;
                }
                if (!c.getName().equals("required") || !(c.getControl() instanceof Button) || (b = (Button)c.getControl()) == null) continue;
                required = b.getSelection();
            }
            this.createCustomMember(name, type, repeatable, required);
            this.custom_schema.addElement(new XSDElement(name, type, "1", repeatable ? "unbounded" : "1"));
            conf.addConfigElement(new ConfigCustomElement(name, type, repeatable, required));
        }
        this.createCustomEnd();
    }

    private void createCustomHead() {
        this.custom_xul = "<tr xmlns:ct=\"http://logabit.com/xlayout/controls/1.0\" xmlns:tg=\"http://textgrid.de/xlayout/controls\"> <td width=\"100%\"> <tg:custom id=\"cstmSection\"> <table>";
    }

    private void createCustomEnd() {
        this.custom_xul = String.valueOf(this.custom_xul) + "</table> </tg:custom> </td> </tr>";
    }

    private void createCustomMember(String name, String type, boolean repeatable, Boolean required) {
        IPath path = new Path(TemplateElement.XLAYOUT_DIR).append(repeatable ? "CustomTextRepeatable.txt" : "CustomText.txt");
        URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)path, null);
        InputStream in = null;
        try {
            try {
                url = FileLocator.resolve((URL)url);
                in = url.openStream();
                BufferedReader reader = null;
                reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                String s = null;
                while ((s = reader.readLine()) != null) {
                    this.custom_xul = String.valueOf(this.custom_xul) + s.replace("$name$", name).replace("$id$", "cstmItem_" + name + "_" + this.index).replace("$type$", type).replace("$required$", required.toString()).replace("$optional$", new Boolean(required == false).toString());
                }
                ++this.index;
            }
            catch (Exception e) {
                Activator.handleError(e);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        Activator.handleWarning(e2);
                    }
                }
                return;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    Activator.handleWarning(e);
                }
            }
        }
    }

    public static void main(String[] args) {
        SchemaFactory f = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        f.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
            }
        });
        try {
            StreamSource ss = new StreamSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xs:element name=\"nr\" type=\"xs:integer\"></xs:element></xs:schema>".getBytes("UTF-8")));
            StreamSource ss2 = new StreamSource(new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?><nr>124</nr>".getBytes("UTF-8")));
            Schema s = f.newSchema(ss);
            Validator v = s.newValidator();
            v.validate(ss2);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Element toDOM(OMElement element) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            element.serialize((OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(bais).getDocumentElement();
        }
        catch (XMLStreamException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Internal error in data model conversion.", e);
        }
    }
}

