/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.dialogs;

import com.google.common.base.Predicate;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.model.TextGridProjectRoot;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.ui.core.Messages;
import info.textgrid.lab.ui.core.dialogs.INewObjectPreparator;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizard;
import info.textgrid.lab.ui.core.dialogs.ITextGridWizardPage;
import info.textgrid.lab.ui.core.dialogs.NewObjectWizard;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;

public class NewTGOPage
extends WizardPage
implements ISelectionChangedListener,
ITextGridWizardPage {
    private TextGridObject textGridObject = null;
    @Deprecated
    private static final String CT_TIFF = "image/tiff";
    @Deprecated
    private static final String CT_JPG = "image/jpeg";
    private ComboViewer typeViewer;
    private TableViewer projectViewer;
    private TextGridProject currentProject;
    private TGContentType currentContentType;
    private TextGridProject project;
    private TGContentType contentType;
    private Label projectDescLabel;
    private NewObjectWizard wizard;
    private Job checkPermissionJob = null;

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.tryInitializeTGO();
        }
    }

    public TextGridObject getTextGridObject() {
        if (this.textGridObject == null && this.isPageComplete()) {
            this.tryInitializeTGO();
        }
        return this.textGridObject;
    }

    private void tryInitializeTGO() {
        if (this.textGridObject == null) {
            this.textGridObject = this.createTextGridObject();
        }
    }

    public TextGridProject getProject() {
        return this.project;
    }

    public TGContentType getContentType() {
        return this.contentType;
    }

    protected NewTGOPage() {
        this(null, null);
    }

    public NewTGOPage(TextGridProject project, TGContentType contentType) {
        super(Messages.NewTGOPage_pageTitle, Messages.NewTGOPage_pageDescription, null);
        this.currentProject = project;
        this.currentContentType = contentType;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)control);
        Label intro = new Label(control, 64);
        intro.setLayoutData((Object)new GridData(4, 128, true, false));
        intro.setText(Messages.NewTGOPage_UI_Intro);
        this.setMessage(Messages.NewTGOPage_metadataHint);
        this.createProjectGroup(control);
        this.createTypeGroup(control);
    }

    private void createProjectGroup(Composite control) {
        Group projectGroup = new Group(control, 16);
        projectGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        projectGroup.setLayout((Layout)new GridLayout(1, true));
        projectGroup.setText(Messages.NewTGOPage_project);
        Label newProjectLink = new Label((Composite)projectGroup, 64);
        newProjectLink.setLayoutData((Object)new GridData(4, 128, true, false));
        newProjectLink.setText(Messages.NewTGOPage_Label_ProjectLink);
        this.projectViewer = new TableViewer((Composite)projectGroup, 2820);
        GridData projectTreeData = new GridData(4, 4, true, true);
        projectTreeData.heightHint = 200;
        this.projectViewer.getTable().setLayoutData((Object)projectTreeData);
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new TGODefaultLabelProvider(true));
        final UpdatingDeferredListContentProvider contentProvider = new UpdatingDeferredListContentProvider();
        this.projectViewer.setContentProvider((IContentProvider)contentProvider);
        this.projectViewer.setSorter(new ViewerSorter());
        this.projectViewer.setInput((Object)TextGridProjectRoot.getInstance((TextGridProjectRoot.LEVELS)TextGridProjectRoot.LEVELS.EDITOR));
        this.projectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.currentProject != null) {
            contentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

                public void loadDone(Viewer viewer) {
                    NewTGOPage.this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)NewTGOPage.this.currentProject), true);
                    contentProvider.removeDoneListener((DeferredListContentProvider.IDoneListener)this);
                }
            });
        }
        this.projectDescLabel = new Label((Composite)projectGroup, 64);
        GridData projectDescData = new GridData(4, 4, true, false);
        projectDescData.heightHint = 48;
        this.projectDescLabel.setLayoutData((Object)projectDescData);
    }

    private void createTypeGroup(Composite control) {
        Group typeGroup = new Group(control, 0);
        typeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        typeGroup.setLayout((Layout)new GridLayout(1, false));
        typeGroup.setText(Messages.NewTGOPage_type);
        Combo typeControl = new Combo((Composite)typeGroup, 12);
        typeControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeViewer = new ComboViewer(typeControl);
        this.typeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof TGContentType) {
                    TGContentType contentType = (TGContentType)element;
                    return contentType.getImage(false);
                }
                return super.getImage(element);
            }
        });
        this.typeViewer.setInput((Object)TGContentType.getContentTypes((Predicate)new Predicate<TGContentType>(){

            public boolean apply(TGContentType input) {
                return input.isCreatable() && !input.isInternal();
            }
        }));
        this.typeViewer.setSorter(new ViewerSorter());
        TGContentType defaultContentType = this.currentContentType != null ? this.currentContentType : TGContentType.getContentType((String)"text/xml");
        if (defaultContentType == null && TGContentType.getContentTypes((boolean)true).length > 0) {
            defaultContentType = TGContentType.getContentTypes((boolean)true)[0];
        }
        if (defaultContentType != null) {
            this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)defaultContentType));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.projectViewer) {
            Object selectedObject = NewTGOPage.extractSelectedObject(event);
            if (selectedObject instanceof TextGridProject) {
                this.project = (TextGridProject)selectedObject;
                this.projectDescLabel.setText(NLS.bind((String)"{0} ({1})", (Object)this.project.getDescription(), (Object)this.project.getId()));
                this.setMessage(Messages.NewTGOPage_metadataHint);
                this.checkCreatePermission(this.project);
            } else {
                this.project = null;
                this.projectDescLabel.setText("");
            }
        } else if (event.getSelectionProvider() == this.typeViewer) {
            this.contentType = (TGContentType)NewTGOPage.extractSelectedObject(event);
        }
        StringBuilder msg = new StringBuilder();
        boolean complete = true;
        if (this.project == null) {
            complete = false;
            msg.append(Messages.NewTGOPage_selectProjectError);
        }
        if (this.contentType == null) {
            complete = false;
            msg.append(Messages.NewTGOPage_selectTypeError);
        }
        if (complete) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(msg.toString());
        }
        this.setPageComplete(complete);
    }

    protected void checkCreatePermission(final TextGridProject project) {
        if (this.checkPermissionJob != null) {
            this.checkPermissionJob.cancel();
        }
        this.checkPermissionJob = new Job(MessageFormat.format(Messages.NewTGOPage_UI_CheckPermission, project)){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    String warning = null;
                    if (!project.hasPermissions(2)) {
                        warning = project.hasPermissions(32) ? MessageFormat.format(Messages.NewTGOPage_UI_DelegateWarning, project) : MessageFormat.format(Messages.NewTGOPage_UI_ElseWarning, project);
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (warning != null) {
                        final String message = warning;
                        new UIJob(Messages.NewTGOPage_JobName){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                NewTGOPage.this.setMessage(message, 2);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        this.checkPermissionJob.setSystem(true);
        this.checkPermissionJob.schedule();
    }

    protected static Object extractSelectedObject(SelectionChangedEvent event) {
        if (event.getSelection() instanceof IStructuredSelection) {
            return ((IStructuredSelection)event.getSelection()).getFirstElement();
        }
        return null;
    }

    @Override
    public void finishPage() {
        if (this.wizard.getTextGridObject() == null) {
            this.wizard.setTextGridObject(this.createTextGridObject());
            this.typeViewer.getControl().setEnabled(false);
            this.projectViewer.getControl().setEnabled(false);
            this.setMessage(Messages.NewTGOPage_UI_ObjectCreated);
        }
    }

    private TextGridObject createTextGridObject() {
        INewObjectPreparator preparator;
        TextGridObject object = TextGridObject.getNewObjectInstance((TextGridProject)this.getProject(), (TGContentType)this.getContentType());
        if (this.wizard.getTypeSpecificAspects() != null && (preparator = this.wizard.getTypeSpecificAspects().getPreparator()) != null) {
            preparator.initializeObject(object);
        }
        return object;
    }

    @Override
    public void init(ITextGridWizard wizard, INewObjectPreparator preparator) {
        if (!(wizard instanceof NewObjectWizard)) {
            throw new IllegalArgumentException("NewTGOPage may only be used with the NewObjectWizard.");
        }
        this.wizard = (NewObjectWizard)wizard;
    }

    @Override
    public void loadObject(TextGridObject textGridObject) {
    }
}

