/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.workflow;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.workflow.Activator;
import info.textgrid.lab.workflow.EntryLink;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MetadataTransformer {
    private EntryLink output;
    private EntryLink fromInput;
    private TextGridObject stylesheet;
    private HashMap<String, String> params;
    public static final String DEFAULT_STYLESHEET_KEY = "DefaultMetaDataTransformationTextGridURI";
    public static String DEFAULT_STYLESHEET_URI;

    public MetadataTransformer() {
        String defautlMdtURIstring;
        block8: {
            defautlMdtURIstring = null;
            try {
                try {
                    ConfClient confClient = ConfClient.getInstance();
                    defautlMdtURIstring = confClient.getValue(DEFAULT_STYLESHEET_KEY);
                }
                catch (OfflineException e) {
                    OnlineStatus.netAccessFailed((String)"Workflow: Could not find TextGridObject URI for default metadata transformation Stylesheet!", (Throwable)e);
                    if (defautlMdtURIstring == null || defautlMdtURIstring.equals("")) {
                        defautlMdtURIstring = "textgrid:hk2t";
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (defautlMdtURIstring == null || defautlMdtURIstring.equals("")) {
                    defautlMdtURIstring = "textgrid:hk2t";
                }
                throw throwable;
            }
            if (defautlMdtURIstring == null || defautlMdtURIstring.equals("")) {
                defautlMdtURIstring = "textgrid:hk2t";
            }
        }
        this.setStylesheet(defautlMdtURIstring);
        DEFAULT_STYLESHEET_URI = defautlMdtURIstring;
    }

    public void setDefaultParams() {
        if (this.output == null) {
            return;
        }
        if (this.stylesheet.getURI().toString().equals(String.valueOf(DEFAULT_STYLESHEET_URI) + "." + this.stylesheet.getRevisionNumber())) {
            if (this.params.get("format.exact") == null) {
                this.params.put("format.exact", this.output.getFromPort().getMimetypes());
            }
            if (this.params.get("title.exact") == null && this.params.get("title.prepend") == null && this.params.get("title.append") == null) {
                this.params.put("title.append", " (" + this.output.getFromPort().getName() + ")");
            }
        }
    }

    public void setStylesheet(String URIstring) {
        this.params = new HashMap();
        try {
            this.stylesheet = TextGridObject.getInstance((URI)URI.create(URIstring), (boolean)false);
        }
        catch (CrudServiceException e) {
            e.printStackTrace();
        }
        OMElement xslOM = this.readTGO(this.stylesheet);
        Iterator paramIterator = xslOM.getChildrenWithName(new QName("http://www.w3.org/1999/XSL/Transform", "param"));
        while (paramIterator.hasNext()) {
            OMElement paramOM = (OMElement)paramIterator.next();
            String name = paramOM.getAttributeValue(new QName(null, "name"));
            this.params.put(name, null);
        }
    }

    public TextGridObject getStylesheet() {
        return this.stylesheet;
    }

    public HashMap<String, String> getParams() {
        return this.params;
    }

    public EntryLink getOutput() {
        return this.output;
    }

    public void setOutput(EntryLink output) {
        this.output = output;
    }

    public EntryLink getFromInput() {
        return this.fromInput;
    }

    public void setFromInput(EntryLink fromInput) {
        this.fromInput = fromInput;
    }

    public OMElement readTGO(TextGridObject tgo) {
        OMElement result = null;
        IFile wffile = (IFile)tgo.getAdapter(IFile.class);
        InputStream wfstream = null;
        try {
            wfstream = wffile.getContents();
        }
        catch (CoreException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "Could not read this stylesheet's contents", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        StAXOMBuilder builder = null;
        try {
            builder = new StAXOMBuilder(wfstream);
            result = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            Status status = new Status(4, "info.textgrid.lab.workflow", "Could not read thsi stylesheet's contents", (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }
}

