/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.EnablementIdentifierEvent;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementIdentifier;
import org.eclipse.wst.common.frameworks.internal.enablement.IEnablementManager;
import org.eclipse.wst.common.frameworks.internal.ui.UIEnablementManager;

class UIEnablementIdentifier
extends EnablementIdentifier
implements IIdentifierListener {
    private IIdentifier activityIdentifier;

    public UIEnablementIdentifier(String id, IProject project) {
        super(id, project);
        IActivityManager manager = this.getActivityManager();
        if (manager != null) {
            this.activityIdentifier = this.getActivityManager().getIdentifier(id);
            this.activityIdentifier.addIdentifierListener((IIdentifierListener)this);
        }
    }

    public void identifierChanged(IdentifierEvent identifierEvent) {
        boolean enabledChanged = this.resetEnabled();
        EnablementIdentifierEvent evt = new EnablementIdentifierEvent((IEnablementIdentifier)this, false, enabledChanged);
        this.fireIdentifierChanged(evt);
    }

    protected IActivityManager getActivityManager() {
        return ((UIEnablementManager)IEnablementManager.INSTANCE).getActivityManager();
    }

    protected boolean getNewEnabled() {
        IIdentifier identifier = this.getActivityIdentifier();
        if (identifier != null) {
            return identifier.isEnabled() && super.getNewEnabled();
        }
        return false;
    }

    protected IIdentifier getActivityIdentifier() {
        IActivityManager manager;
        if (this.activityIdentifier == null && (manager = this.getActivityManager()) != null) {
            this.activityIdentifier = this.getActivityManager().getIdentifier(this.getId());
            this.activityIdentifier.addIdentifierListener((IIdentifierListener)this);
        }
        return this.activityIdentifier;
    }
}

