/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.tartarus.snowball.SnowballProgram;

public class SnowballFilter
extends TokenFilter {
    private SnowballProgram stemmer;
    private TermAttribute termAtt;

    public SnowballFilter(TokenStream input, SnowballProgram stemmer) {
        super(input);
        this.stemmer = stemmer;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public SnowballFilter(TokenStream in, String name) {
        super(in);
        try {
            Class<?> stemClass = Class.forName("org.tartarus.snowball.ext." + name + "Stemmer");
            this.stemmer = (SnowballProgram)stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String originalTerm = this.termAtt.term();
            this.stemmer.setCurrent(originalTerm);
            this.stemmer.stem();
            String finalTerm = this.stemmer.getCurrent();
            if (!originalTerm.equals(finalTerm)) {
                this.termAtt.setTermBuffer(finalTerm);
            }
            return true;
        }
        return false;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }
}

