/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator.filters;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.navigator.filters.Messages;
import java.util.ArrayList;

public class ContentTypeFilterData {
    private String name;
    private String format;
    private ArrayList<ContentTypeFilterData> children = new ArrayList();
    private static ContentTypeFilterData instance;

    private ContentTypeFilterData(String name, String format, boolean isRoot, boolean init) {
        this.name = name;
        this.format = format;
        if (isRoot) {
            this.add(new ContentTypeFilterData(Messages.ContentTypeFilterData_ContentTypes, "", false, true));
        } else if (init) {
            TGContentType[] tGContentTypeArray = TGContentType.getContentTypes((boolean)false);
            int n = tGContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TGContentType ct = tGContentTypeArray[n2];
                this.add(new ContentTypeFilterData(ct.getDescription(), ct.getId(), false, false));
                ++n2;
            }
        }
    }

    public static synchronized ContentTypeFilterData getInstance() {
        if (instance == null) {
            instance = new ContentTypeFilterData("Root", "", true, true);
        }
        return instance;
    }

    public String toString() {
        String format = "";
        if (!this.format.equals("")) {
            format = " (" + this.format + ")";
        }
        return String.valueOf(this.name) + format;
    }

    public String getFormat() {
        return this.format;
    }

    public void add(ContentTypeFilterData child) {
        this.children.add(child);
    }

    public static int getChildCount() {
        return instance.getChildren()[0].getChildren().length + 1;
    }

    public ContentTypeFilterData[] getChildren() {
        return this.children.toArray(new ContentTypeFilterData[0]);
    }

    public static ContentTypeFilterData getItem(String format) {
        ContentTypeFilterData[] contentTypeFilterDataArray = instance.getChildren()[0].getChildren();
        int n = contentTypeFilterDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContentTypeFilterData item = contentTypeFilterDataArray[n2];
            if (item.format.equals(format)) {
                return item;
            }
            ++n2;
        }
        return null;
    }
}

