/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.efs.tgcrud;

import info.textgrid.lab.core.efs.tgcrud.Activator;
import info.textgrid.lab.core.swtutils.LogUtil;
import java.io.IOException;
import java.io.InputStream;

public class LoggingInputStream
extends InputStream {
    private final InputStream delegate;
    private final LogUtil log;
    private boolean trace = false;

    public LoggingInputStream(InputStream delegate, LogUtil log) {
        this.delegate = delegate;
        this.log = log;
        this.trace = Activator.isDebugging("info.textgrid.lab.core.efs.tgcrud/debug/streams");
    }

    @Override
    public int read() throws IOException {
        try {
            int i = this.delegate.read();
            if (this.trace) {
                this.log.trace("Read one byte", new Object[0]);
            }
            return i;
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            int available = this.delegate.available();
            if (this.trace) {
                this.log.trace("Queried availability ({0})", new Object[]{available});
            }
            return available;
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.delegate.close();
            if (this.trace) {
                this.log.trace("Closing stream.", new Object[0]);
            }
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.delegate.read(b, off, len);
            if (this.trace) {
                this.log.trace("Read {0} of {1} bytes.", new Object[]{read, len});
            }
            return read;
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int read = this.delegate.read(b);
            if (this.trace) {
                this.log.trace("Read {0} bytes.", new Object[]{read});
            }
            return read;
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.delegate.reset();
            if (this.trace) {
                this.log.trace("Reset stream.", new Object[0]);
            }
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.delegate.skip(n);
        }
        catch (IOException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.logError((Throwable)e);
            throw e;
        }
    }
}

