/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.FileBackedOutputStream;
import info.textgrid._import.ImportObject;
import info.textgrid._import.ImportSpec;
import info.textgrid._import.ObjectFactory;
import info.textgrid._import.RevisionPolicy;
import info.textgrid._import.RevisionPolicyType;
import info.textgrid._import.RewriteMethod;
import info.textgrid._import.XmlConfiguration;
import info.textgrid.lab.core.importexport.model.AbstractExportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.AbstractImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.ImportExportStatus;
import info.textgrid.lab.core.importexport.model.Messages;
import info.textgrid.lab.core.importexport.model.ModelObjectFactory;
import info.textgrid.lab.core.importexport.model.RewriteSetup;
import info.textgrid.lab.core.importexport.ui.OverwriteDialog;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.namespaces.metadata.core._2010.MetadataContainerType;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.linkrewriter.ConfigurableXMLRewriter;
import info.textgrid.utils.linkrewriter.ImportMapping;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

@XmlRootElement(name="importSpec")
public class ImportModel
extends ImportSpec {
    private final ListenerList listeners = new ListenerList();
    private TextGridProject targetProject;
    private IPath root;
    private final List<ImportEntry> children = Collections.synchronizedList(new ArrayList());
    private List<RewriteSetup> availableSetups;
    private boolean importAsNewRevisions;
    private MultiStatus lastResult;
    private List<ImportObject> nonSynchronizedImportObjects;
    private Set<File> files = null;

    public TextGridProject getTargetProject() {
        return this.targetProject;
    }

    public Set<File> getFiles() {
        if (this.files == null) {
            HashSet result = Sets.newHashSetWithExpectedSize((int)this.importObject.size());
            for (ImportObject object : this.importObject) {
                try {
                    result.add(((ImportEntry)object).getLocalFile().getCanonicalFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.files = result;
        }
        return this.files;
    }

    public ImportModel() {
        this.importObject = Collections.synchronizedList(new ArrayList());
        if (this.revisionPolicy == null) {
            this.revisionPolicy = new RevisionPolicy();
            this.revisionPolicy.setImport(RevisionPolicyType.LATEST);
        }
    }

    public List<ImportEntry> getChildren() {
        return this.children;
    }

    public static ImportModel load(Source source) throws JAXBException {
        URI uri;
        File modelFile;
        Unmarshaller unmarshaller = ImportModel.createUnmarshaller();
        JAXBElement element = unmarshaller.unmarshal(source, ImportSpec.class);
        ImportModel model = (ImportModel)((Object)element.getValue());
        if (source.getSystemId() != null && (modelFile = new File(uri = URI.create(source.getSystemId()))).exists() && !modelFile.isDirectory()) {
            model.setRoot((IPath)new Path(modelFile.getParentFile().getAbsolutePath()));
        }
        model.sanitize();
        return model;
    }

    public static Unmarshaller createUnmarshaller() throws DataBindingException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            try {
                unmarshaller.setProperty("com.sun.xml.bind.ObjectFactory", (Object)new ModelObjectFactory());
            }
            catch (PropertyException propertyException) {
                unmarshaller.setProperty("com.sun.xml.internal.bind.ObjectFactory", (Object)new ModelObjectFactory());
            }
            return unmarshaller;
        }
        catch (JAXBException e) {
            throw new DataBindingException(Messages.ImportModel_Failed_To_Create_Unmarshaller, (Throwable)e);
        }
    }

    public void save(Result result) {
        this.sanitize();
        JAXB.marshal((Object)new JAXBElement(new QName("http://textgrid.info/import", "importSpec"), ImportSpec.class, (Object)this), (Result)result);
    }

    public ImportEntry addFile(File file, IProgressMonitor monitor, ISpecialImportEntrySupplier supplier) {
        return this.addFile(file, true, monitor, supplier);
    }

    protected ImportEntry addFile(File file, boolean global, IProgressMonitor monitor, ISpecialImportEntrySupplier supplier) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ImportModel_Adding, (Object)file), (int)100);
        try {
            final File canonicalFile = file.getCanonicalFile();
            ImportEntry duplicate = (ImportEntry)this.findEntry((Predicate<? super ImportObject>)new Predicate<ImportObject>(){

                public boolean apply(ImportObject o) {
                    try {
                        return canonicalFile.equals(((ImportEntry)o).getFile().getCanonicalFile());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            });
            return duplicate;
        }
        catch (NoSuchElementException noSuchElementException) {
            System.out.println("Didn't find a duplicate for " + file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String name = file.getName();
        String ext = name.substring(name.lastIndexOf(46) + 1);
        if ("meta".equalsIgnoreCase(ext)) {
            ObjectType readMetadata = ImportModel.readMetadata(file);
            progress.worked(25);
            if (readMetadata != null) {
                final File candidate = new File(FilenameUtils.removeExtension((String)file.getPath()));
                try {
                    ImportEntry importEntry = (ImportEntry)((Object)Iterables.find(this.getImportObject(), (Predicate)new Predicate<ImportObject>(){

                        public boolean apply(ImportObject importObject) {
                            return candidate.equals(new File(importObject.getLocalData()));
                        }
                    }));
                    progress.worked(10);
                    progress.done();
                    return importEntry;
                }
                catch (NoSuchElementException noSuchElementException) {
                    progress.subTask(NLS.bind((String)Messages.ImportModel_Object_instead_of_Metadata, (Object)file, (Object)candidate));
                    return this.addFile(candidate, global, (IProgressMonitor)progress, null);
                }
            }
        }
        ImportEntry importEntry = new ImportEntry(file, this.targetProject, supplier, this, (IProgressMonitor)progress);
        importEntry.getObject();
        this.updateRootPath(file);
        progress.worked(10);
        progress.worked(20);
        List<IImportEntryConfigurator> configurators = AbstractImportEntryConfigurator.getConfigurators();
        progress.setWorkRemaining(100 * configurators.size());
        for (IImportEntryConfigurator configurator : configurators) {
            configurator.configureImport(importEntry, (IProgressMonitor)progress.newChild(100));
        }
        try {
            if ("".equals(importEntry.getObject().getTitle())) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", MessageFormat.format("The import object {0}'s object, {1}, has an empty title.", new Object[]{importEntry, importEntry.getObject()}), (Throwable)new IllegalStateException()));
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
        }
        this.files = null;
        this.getImportObject().add(importEntry);
        if (global) {
            this.children.add(importEntry);
        }
        progress.done();
        return importEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportObject findEntry(Predicate<? super ImportObject> predicate) throws NoSuchElementException {
        List<ImportObject> list;
        List<ImportObject> list2 = list = this.getImportObject();
        synchronized (list2) {
            return (ImportObject)Iterables.find(list, predicate);
        }
    }

    public synchronized List<ImportObject> getImportObject() {
        if (this.nonSynchronizedImportObjects == null) {
            this.nonSynchronizedImportObjects = this.importObject;
            this.importObject = Collections.synchronizedList(this.nonSynchronizedImportObjects);
        }
        return this.importObject;
    }

    boolean mayOverwriteMetadata(final ImportEntry importEntry, final URI existingURI) {
        UIJob askJob = new UIJob(Messages.ImportModel_Confirm_Dialog){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                MessageDialog dialog = new MessageDialog(null, NLS.bind((String)Messages.ImportModel_Adding_x, (Object)importEntry.getLocalData()), null, NLS.bind((String)Messages.ImportModel_dirty_metadata_on_import, (Object)importEntry.getLocalData(), (Object)existingURI), 5, new String[]{Messages.ImportModel_Overwrite, Messages.ImportModel_Cancel}, 0);
                int result = dialog.open();
                return result == 0 ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        askJob.setSystem(true);
        askJob.schedule();
        try {
            askJob.join();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return askJob.getResult().isOK();
    }

    /*
     * Unable to fully structure code
     */
    protected ImportEntry addObject(final TGObjectReference objectReference, boolean global, File parentFile, IProgressMonitor monitor) {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ImportModel_Adding, (Object)objectReference), (int)100);
        try {
            duplicate = (ImportEntry)this.findEntry((Predicate<? super ImportObject>)new Predicate<ImportObject>(){

                public boolean apply(ImportObject o) {
                    ImportEntry entry = (ImportEntry)o;
                    return entry.getObjectRef().getRefUri().equals(objectReference.getRefUri()) || entry.getObject().getURI().equals(objectReference.getTgo().getURI());
                }
            });
            return duplicate;
        }
        catch (NoSuchElementException v0) {
            entry = new ImportEntry();
            entry.setModel(this);
            entry.setObjectRef(objectReference);
            progress.worked(10);
            try {
                uriPart = objectReference.getTgo().getURI().getSchemeSpecificPart();
                contentType = objectReference.getTgo().getContentType(false);
                extension = contentType.getExtension();
                progress.worked(20);
                fileName = String.valueOf(uriPart) + "." + extension;
                file = new File(parentFile, fileName);
                entry.setFile(file);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.core.importexport");
            }
            configurators = AbstractExportEntryConfigurator.getConfigurators();
            progress.setWorkRemaining(50 * configurators.size() + 5);
            ** for (configurator : configurators)
        }
lbl-1000:
        // 1 sources

        {
            configurator.configureExport(entry, (IProgressMonitor)progress.newChild(50));
            continue;
        }
lbl27:
        // 1 sources

        this.getImportObject().add(entry);
        if (global) {
            this.children.add(entry);
        }
        progress.done();
        return entry;
    }

    private void updateRootPath(File file) {
        IPath newRoot;
        Path path = new Path(file.getAbsolutePath());
        IPath iPath = newRoot = this.root == null ? path.removeLastSegments(1) : this.root;
        if (newRoot != null) {
            while (!newRoot.isPrefixOf((IPath)path)) {
                newRoot = newRoot.removeLastSegments(1);
            }
        }
        this.setRoot(newRoot);
    }

    public void setRoot(IPath root) {
        IPath oldRoot = this.root;
        this.root = root;
        if (root != null && !root.equals((Object)oldRoot) || oldRoot != null) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object rawListener = objectArray[n2];
                ModelListener listener = (ModelListener)rawListener;
                listener.rootChanged(this, oldRoot);
                ++n2;
            }
        }
    }

    static ObjectType readMetadata(File metaFile) {
        if (metaFile.exists()) {
            ObjectType metadata = (ObjectType)JAXB.unmarshal((File)metaFile, ObjectType.class);
            if (metadata.getGeneric() != null) {
                return metadata;
            }
            MetadataContainerType container = (MetadataContainerType)JAXB.unmarshal((File)metaFile, MetadataContainerType.class);
            if (container.getObject() != null && container.getObject().getGeneric() != null) {
                return container.getObject();
            }
        }
        return null;
    }

    static ObjectType clearGenerated(ObjectType metadata) {
        if (metadata != null && metadata.getGeneric() != null) {
            metadata.getGeneric().setGenerated(null);
        }
        return metadata;
    }

    public void setTargetProject(TextGridProject project) {
        this.targetProject = project;
    }

    private IStatus rewriteMetadata(ImportEntry entry, ImportMapping mapping, IProgressMonitor monitor) {
        ConfigurableXMLRewriter rewriter = new ConfigurableXMLRewriter(mapping, false);
        rewriter.configure(URI.create("internal:textgrid#metadata"));
        try {
            TextGridObject textGridObject = entry.getObject();
            String serialized = textGridObject.serialize();
            byte[] bytes = serialized.getBytes("UTF-8");
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
            IPath parentPath = new Path(entry.getLocalData()).removeLastSegments(1);
            if (parentPath.segmentCount() > 0) {
                rewriter.setBase(URI.create(parentPath.addTrailingSeparator().toString()));
            }
            rewriter.rewrite((InputStream)bais, (OutputStream)baos);
            StringReader reader = new StringReader(baos.toString("UTF-8"));
            ObjectType newMetadata = (ObjectType)JAXB.unmarshal((Reader)reader, ObjectType.class);
            textGridObject.setMetadata(newMetadata);
        }
        catch (Exception e) {
            return new Status(2, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Rewriting_Metadata, (Object)entry.getLocalData()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus doImport(TextGridProject project, IProgressMonitor monitor) throws IllegalStateException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ImportModel_Importing, (int)(20 + this.getImportObject().size() * 100));
        MultiStatus result = new MultiStatus("info.textgrid.lab.core.importexport", 0, Messages.ImportModel_Import_Complete, null);
        ImportMapping mapping = new ImportMapping((ImportSpec)this);
        try {
            TextGridObject.fetchURIs((Iterable)Iterables.transform((Iterable)Iterables.filter(this.getImportObject(), (Predicate)new Predicate<ImportObject>(){

                public boolean apply(ImportObject input) {
                    return !((ImportEntry)input).isNewRevisionImport();
                }
            }), (Function)new Function<ImportObject, TextGridObject>(){

                public TextGridObject apply(ImportObject arg0) {
                    return ((ImportEntry)arg0).getObject();
                }
            }), (IProgressMonitor)progress.newChild(20));
        }
        catch (CoreException e) {
            result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", Messages.ImportModel_Error_fetching_URIs, (Throwable)e));
        }
        catch (WebServiceException e) {
            result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", Messages.ImportModel_Error_fetching_URIs, (Throwable)e));
        }
        for (ImportObject importObject : this.getImportObject()) {
            ImportEntry entry = (ImportEntry)importObject;
            progress.subTask(NLS.bind((String)Messages.ImportModel_Importing_x, (Object)entry.getLocalData()));
            TextGridObject textGridObject = entry.getObject();
            try {
                if (entry.isNewRevisionImport()) {
                    TextGridObject newRevision = entry.getExistingObject().prepareNewRevision((IProgressMonitor)progress.newChild(5));
                    ObjectType metadata = textGridObject.getMetadata();
                    metadata.getGeneric().setGenerated(newRevision.getMetadataForReading().getGeneric().getGenerated());
                    newRevision.setMetadata(metadata);
                    textGridObject = newRevision;
                } else {
                    progress.worked(5);
                }
                textGridObject.setProject(project);
                InputStream inputStream = ImportModel.openInputStream(result, mapping, importObject, entry);
                IFile textGridFile = (IFile)AdapterUtils.getAdapterChecked((Object)textGridObject, IFile.class);
                progress.worked(10);
                IStatus metadataStatus = this.rewriteMetadata(entry, mapping, (IProgressMonitor)progress.newChild(10));
                if (!metadataStatus.isOK()) {
                    result.add(metadataStatus);
                }
                textGridFile.setContents(inputStream, 1, (IProgressMonitor)progress.newChild(80));
                importObject.setTextgridUri(textGridObject.getURI().toString());
                result.add((IStatus)new ImportExportStatus(0, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Imported_x_to_y, (Object)importObject.getLocalData(), (Object)textGridObject), null));
            }
            catch (FileNotFoundException e) {
                result.add((IStatus)new ImportExportStatus(4, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Error_x_while_y, (Object)importObject.getLocalData(), (Object)e), e));
            }
            catch (AdapterUtils.AdapterNotFoundException e) {
                result.add((IStatus)new ImportExportStatus(4, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Error_x_while_y, (Object)importObject.getLocalData(), (Object)((Object)e)), e));
            }
            catch (CoreException e) {
                result.add((IStatus)new ImportExportStatus(4, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Error_x_while_y, (Object)importObject.getLocalData(), (Object)((Object)e)), e));
            }
            catch (IOException e) {
                result.add((IStatus)new ImportExportStatus(4, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Error_x_while_y, (Object)importObject.getLocalData(), (Object)e), e));
            }
            catch (RuntimeException e) {
                result.add((IStatus)new ImportExportStatus(4, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_Error_x_while_y, (Object)importObject.getLocalData(), (Object)e), e));
            }
        }
        this.lastResult = result;
        StatusManager.getManager().handle((IStatus)result);
        return result;
    }

    private static InputStream openInputStream(MultiStatus result, ImportMapping mapping, ImportObject importObject, ImportEntry entry) throws IOException, FileNotFoundException {
        InputStream inputStream = null;
        if (importObject.getRewriteMethod().equals((Object)RewriteMethod.XML)) {
            FileBackedOutputStream cache = new FileBackedOutputStream(0x100000);
            try {
                try {
                    InputStream localFileStream = entry.getSupplier() != null ? entry.getSupplier().getInputStream() : new FileInputStream(entry.getLocalFile());
                    ConfigurableXMLRewriter rewriter = new ConfigurableXMLRewriter(mapping, false);
                    rewriter.configure(new URI(entry.getRewriteConfig()));
                    IPath parentPath = new Path(entry.getLocalData()).removeLastSegments(1);
                    if (parentPath.segmentCount() > 0) {
                        rewriter.setBase(URI.create(parentPath.addTrailingSeparator().toString()));
                    }
                    rewriter.recordMissingReferences();
                    try {
                        rewriter.rewrite(localFileStream, (OutputStream)cache);
                        Set missingReferences = rewriter.getMissingReferences();
                        if (missingReferences != null) {
                            System.err.println("Missing references: " + Joiner.on((String)", ").join((Iterable)missingReferences));
                        }
                        inputStream = (InputStream)cache.getSupplier().getInput();
                    }
                    catch (XMLStreamException e) {
                        result.add((IStatus)new ImportExportStatus(2, entry, ImportExportStatus.Operation.IMPORT, NLS.bind((String)Messages.ImportModel_XML_Error_Rewriting_Import, (Object)importObject.getLocalData(), (Object)e.getLocalizedMessage()), e));
                    }
                }
                finally {
                    cache.close();
                }
            }
            catch (FileNotFoundException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Importing_x, (Object)importObject.getLocalData(), (Object)e)));
            }
            catch (IllegalArgumentException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Importing_x, (Object)importObject.getLocalData(), (Object)e)));
            }
            catch (URISyntaxException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Importing_x, (Object)importObject.getLocalData(), (Object)e)));
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Importing_x, (Object)importObject.getLocalData(), (Object)e)));
            }
            catch (Throwable e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Importing_x, (Object)importObject.getLocalData(), (Object)e)));
            }
        }
        if (inputStream == null) {
            inputStream = entry.getSupplier() != null ? entry.getSupplier().getInputStream() : new FileInputStream(entry.getLocalFile());
        }
        return inputStream;
    }

    public IStatus doExport(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ImportModel_Exporting_x_objects, (Object)this.getImportObject().size()), (int)(this.getImportObject().size() * 100 + 20));
        if (!OverwriteDialog.mayContinue(this, (IProgressMonitor)progress.newChild(10))) {
            return Status.CANCEL_STATUS;
        }
        MultiStatus result = new MultiStatus("info.textgrid.lab.core.importexport", 0, Messages.ImportModel_Export_complete, null);
        ImportMapping mapping = new ImportMapping((ImportSpec)this);
        ConfigurableXMLRewriter metadataRewriter = new ConfigurableXMLRewriter(mapping, true);
        metadataRewriter.configure(RewriteSetup.of(RewriteMethod.XML, "internal:textgrid#metadata").getConfiguration());
        progress.worked(10);
        for (ImportObject importObject : this.getImportObject()) {
            ImportEntry entry = (ImportEntry)importObject;
            progress.subTask(NLS.bind((String)Messages.ImportModel_Exporting_x_to_y, (Object)entry.getObjectRef(), (Object)entry.getLocalFile()));
            File localFile = this.resolve(entry.getLocalFile());
            File parent = localFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            progress.worked(10);
            try {
                IFile remoteFile = (IFile)AdapterUtils.getAdapterChecked((Object)entry.getObjectRef(), IFile.class);
                progress.worked(10);
                InputStream remoteContents = remoteFile.getContents();
                FileOutputStream localContents = new FileOutputStream(localFile);
                progress.worked(10);
                if (RewriteMethod.XML.equals((Object)entry.getRewriteMethod())) {
                    ConfigurableXMLRewriter rewriter = new ConfigurableXMLRewriter(mapping, true);
                    rewriter.configure(entry.getRewriteSetup().getConfiguration());
                    IPath parentPath = new Path(entry.getLocalData()).removeLastSegments(1);
                    if (parentPath.segmentCount() > 0) {
                        rewriter.setBase(URI.create(parentPath.addTrailingSeparator().toString()));
                    }
                    rewriter.rewrite(remoteContents, (OutputStream)localContents);
                    localContents.close();
                    remoteContents.close();
                    progress.worked(50);
                } else {
                    ReadableByteChannel remoteChannel = Channels.newChannel(remoteContents);
                    localContents.getChannel().transferFrom(remoteChannel, 0L, Long.MAX_VALUE);
                    localContents.close();
                    remoteContents.close();
                    result.add((IStatus)new ImportExportStatus(0, entry, ImportExportStatus.Operation.EXPORT, NLS.bind((String)Messages.ImportModel_ExportContentsSuccess, (Object)entry.getObject(), (Object)localFile), null));
                    progress.worked(50);
                }
            }
            catch (AdapterUtils.AdapterNotFoundException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting, (Object)entry.getObject()), (Throwable)e));
            }
            catch (CoreException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting, (Object)entry.getObject()), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting, (Object)entry.getObject()), (Throwable)e));
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting, (Object)entry.getObject()), (Throwable)e));
            }
            catch (XMLStreamException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_XML_Error_Rewriting_Export, (Object)entry.getObject(), (Object)e.getLocalizedMessage()), (Throwable)e));
            }
            try {
                String metadata = entry.getObject().serialize();
                progress.worked(10);
                ByteArrayInputStream metadataInput = new ByteArrayInputStream(metadata.getBytes("UTF-8"));
                File localMetadataFile = this.resolve(entry.getLocalMetadataFile());
                FileOutputStream metadataOutput = new FileOutputStream(localMetadataFile);
                metadataRewriter.rewrite((InputStream)metadataInput, (OutputStream)metadataOutput);
                progress.worked(20);
                metadataOutput.close();
                result.add((IStatus)new ImportExportStatus(0, entry, ImportExportStatus.Operation.EXPORT, NLS.bind((String)Messages.ImportModel_ExportMetadataSucess, (Object)entry.getObject(), (Object)localMetadataFile), null));
            }
            catch (UnsupportedEncodingException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting_Metadata, (Object)entry.getObjectRef()), (Throwable)e));
            }
            catch (FileNotFoundException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting_Metadata, (Object)entry.getObjectRef()), (Throwable)e));
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting_Metadata, (Object)entry.getObjectRef()), (Throwable)e));
            }
            catch (XMLStreamException e) {
                result.add((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_Error_Exporting_Metadata, (Object)entry.getObjectRef()), (Throwable)e));
            }
        }
        return result;
    }

    public File resolve(File localFile) {
        if (this.getRoot() == null || localFile.isAbsolute()) {
            return localFile;
        }
        return this.getRoot().append(localFile.getPath()).toFile();
    }

    public List<RewriteSetup> getAvailableSetups() {
        if (this.availableSetups == null) {
            this.availableSetups = Lists.newArrayList();
            for (XmlConfiguration config : this.getXmlConfiguration()) {
                try {
                    this.availableSetups.add(new RewriteSetup(new URI(null, null, config.getId()), config));
                }
                catch (URISyntaxException uRISyntaxException) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportModel_invalid_fragment, (Object)config.getId())));
                }
            }
            this.availableSetups.addAll(RewriteSetup.getInternal().values());
        }
        return this.availableSetups;
    }

    public IPath getRoot() {
        return this.root;
    }

    public void addListener(ModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ImportEntry addObject(TGObjectReference object, IProgressMonitor monitor) {
        return this.addObject(object, true, null, monitor);
    }

    public void setImportAsNewRevisions(boolean reImport) {
        this.importAsNewRevisions = reImport;
    }

    public boolean isImportAsNewRevisions() {
        return this.importAsNewRevisions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(TreePath path) {
        this.getImportObject().remove(path.getLastSegment());
        TreePath parentPath = path.getParentPath();
        if (parentPath != null && parentPath.getLastSegment() != null) {
            Object parent = parentPath.getLastSegment();
            if (parent instanceof ImportEntry) {
                ((ImportEntry)((Object)parent)).getChildren().remove(path.getLastSegment());
                return;
            } else {
                if (parent != this) throw new IllegalArgumentException(MessageFormat.format("What is _this_: {0}? It should be a treePath from the model ...", path));
                this.getChildren().remove(path.getLastSegment());
            }
            return;
        } else {
            this.getChildren().remove(path.getLastSegment());
        }
    }

    public ImportEntry addFile(File file, IProgressMonitor monitor) {
        return this.addFile(file, monitor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void sanitize() {
        boolean fillChildren = this.getChildren().isEmpty();
        List<ImportObject> list = this.getImportObject();
        synchronized (list) {
            for (ImportObject object : this.getImportObject()) {
                ImportEntry entry = (ImportEntry)object;
                entry.setModel(this);
                if (fillChildren) {
                    this.children.add(entry);
                }
                entry.sanitize();
            }
        }
    }

    public void initializeLoadedModelForImport(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(this.getImportObject().size() * 10);
        for (ImportObject io : this.getImportObject()) {
            ((ImportEntry)io).initializeLoadedEntryForImport((IProgressMonitor)progress.newChild(10));
        }
        progress.done();
    }

    public boolean importAsNewRevision() {
        return this.importAsNewRevisions;
    }

    public Set<String> getReimportProjectIDs() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (ImportObject object : this.importObject) {
            ImportEntry entry = (ImportEntry)object;
            if (!entry.isReimport()) continue;
            result.add(entry.getExistingProjectID());
        }
        return result;
    }

    public static interface ModelListener {
        public void rootChanged(ImportModel var1, IPath var2);
    }
}

