/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.handlers;

import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.log.logsession;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.handlers.Messages;
import info.textgrid.namespaces.middleware.tgauth.AuthenticationFault;
import info.textgrid.namespaces.middleware.tgauth.BooleanResponse;
import info.textgrid.namespaces.middleware.tgauth.DeleteProjectRequest;
import info.textgrid.namespaces.middleware.tgauth.GetNumberOfResourcesRequest;
import info.textgrid.namespaces.middleware.tgauth.GetNumberOfResourcesResponse;
import info.textgrid.namespaces.middleware.tgauth.NotEmptyFault;
import info.textgrid.namespaces.middleware.tgauth.PortTgextra;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DeleteEmptyProjectDialog
extends TrayDialog {
    Map<TextGridProject, Boolean> projectsDelete = new HashMap<TextGridProject, Boolean>();
    Map<TextGridProject, String> projectsMessage = new HashMap<TextGridProject, String>();
    Button okButton;
    boolean okEnabled = false;
    PortTgextra stub = null;
    Job currentJob;
    TableViewer tableViewer;
    Label statusLabel;

    public DeleteEmptyProjectDialog(Shell shell, Object[] obj) {
        super(shell);
        this.initialise(obj);
    }

    public DeleteEmptyProjectDialog(IShellProvider parentShell, Object[] obj) {
        super(parentShell);
        this.initialise(obj);
    }

    protected void initialise(Object[] obj) {
        int i = 0;
        while (i < obj.length) {
            if (obj[i] instanceof TextGridProject) {
                this.projectsDelete.put((TextGridProject)obj[i], false);
            }
            ++i;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true).setFocus();
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        OnlineStatus.isOnlineWithNotification((String)Messages.DeleteEmptyProjectDialog_EM_NotOnline);
        this.okButton.setEnabled(false);
    }

    protected void okPressed() {
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1) {
            if (this.currentJob != null) {
                this.currentJob.cancel();
            }
            this.close();
        } else if (buttonId == 0) {
            DeleteProjectRequest request = new DeleteProjectRequest();
            request.setAuth(RBACSession.getInstance().getSID(true));
            request.setLog(logsession.getInstance().getloginfo());
            boolean deleted = true;
            TextGridProject currentProject = null;
            for (TextGridProject p : this.projectsDelete.keySet()) {
                if (!this.projectsDelete.get(p).booleanValue()) continue;
                request.setProject(p.getId());
                currentProject = p;
                try {
                    BooleanResponse br = this.stub.deleteProject(request);
                    deleted = br.isResult();
                }
                catch (AuthenticationFault e) {
                    Activator.handleError(e, Messages.DeleteEmptyProjectDialog_EM_NotAllowed, this.projectsDelete);
                    deleted = false;
                }
                catch (NotEmptyFault e) {
                    Activator.handleError(e, Messages.DeleteEmptyProjectDialog_EM_NotEmpty, this.projectsDelete);
                    deleted = false;
                }
            }
            if (!deleted) {
                MessageDialog.open((int)1, null, (String)NLS.bind((String)Messages.DeleteEmptyProjectDialog_DeletingFailed, (Object)currentProject.getName()), (String)NLS.bind((String)Messages.DeleteEmptyProjectDialog_CouldNotDelete, (Object)currentProject.getName()), (int)0);
            } else {
                AuthBrowser.sessionChanged();
            }
            this.close();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Group g = new Group(parent, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        this.tableViewer = new TableViewer((Composite)g, 2560);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DeleteTableContentProvider());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setSorter(new ViewerSorter());
        this.tableViewer.setInput(this.projectsDelete.keySet());
        GridData gd = new GridData(4, 4, false, false);
        gd.heightHint = 100;
        gd.widthHint = 500;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.statusLabel = new Label((Composite)g, 0);
        this.statusLabel.setText(Messages.DeleteEmptyProjectDialog_CheckPermissionsWait);
        this.getShell().setText(Messages.DeleteEmptyProjectDialog_DeletePermanently);
        this.launchCheckJob(this.projectsDelete);
        return g;
    }

    private void launchCheckJob(final Map<TextGridProject, Boolean> projectMap) {
        this.currentJob = new Job(Messages.DeleteEmptyProjectDialog_CheckPermissions){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.DeleteEmptyProjectDialog_CheckPermissions, -1);
                DeleteEmptyProjectDialog.this.stub = TextGridProject.ensureStubIsLoaded();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                boolean projectToDelete = false;
                for (final TextGridProject project : projectMap.keySet()) {
                    boolean canDelete = true;
                    String whyNot = "";
                    if (!project.iAmLeader()) {
                        canDelete = false;
                        whyNot = NLS.bind((String)Messages.DeleteEmptyProjectDialog_NotPermitted, (Object)TextGridProject.findLabelForRBACRole((String)"Projektleiter"));
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (canDelete) {
                        GetNumberOfResourcesRequest gnr = new GetNumberOfResourcesRequest();
                        gnr.setAuth(RBACSession.getInstance().getSID(false));
                        gnr.setLog(logsession.getInstance().getloginfo());
                        gnr.setProject(project.getId());
                        GetNumberOfResourcesResponse number = new GetNumberOfResourcesResponse();
                        number = DeleteEmptyProjectDialog.this.stub.getNumberOfResources(gnr);
                        if (number.getPublicresources() > 0) {
                            canDelete = false;
                            whyNot = Messages.DeleteEmptyProjectDialog_PublishedResources;
                        } else if (number.getAllresources() > 0) {
                            canDelete = false;
                            whyNot = NLS.bind((String)Messages.DeleteEmptyProjectDialog_ContainsResources, (Object)number.getAllresources());
                        }
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled() || DeleteEmptyProjectDialog.this.tableViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (canDelete) {
                        DeleteEmptyProjectDialog.this.projectsDelete.put(project, true);
                        DeleteEmptyProjectDialog.this.projectsMessage.put(project, Messages.DeleteEmptyProjectDialog_OperationPermitted);
                        projectToDelete = true;
                    } else {
                        DeleteEmptyProjectDialog.this.projectsMessage.put(project, whyNot);
                    }
                    DeleteEmptyProjectDialog.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).DeleteEmptyProjectDialog.this.tableViewer.refresh((Object)project);
                            (this).DeleteEmptyProjectDialog.this.tableViewer.reveal((Object)project);
                        }
                    });
                }
                final boolean delete = projectToDelete;
                DeleteEmptyProjectDialog.this.tableViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (delete) {
                            (this).DeleteEmptyProjectDialog.this.okButton.setEnabled(true);
                        }
                        (this).DeleteEmptyProjectDialog.this.statusLabel.setText(Messages.DeleteEmptyProjectDialog_3);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.currentJob.setPriority(30);
        this.currentJob.schedule();
    }

    class DeleteTableContentProvider
    extends LabelProvider {
        DeleteTableContentProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof TextGridProject) {
                if (DeleteEmptyProjectDialog.this.projectsDelete.get(element).booleanValue()) {
                    return Activator.getDefault().getImageRegistry().getDescriptor("complete").createImage();
                }
                return Activator.getDefault().getImageRegistry().getDescriptor("forbidden_object").createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof TextGridProject && DeleteEmptyProjectDialog.this.projectsMessage.get(element) != null) {
                return String.valueOf(element.toString()) + Messages.DeleteEmptyProjectDialog_0 + DeleteEmptyProjectDialog.this.projectsMessage.get(element);
            }
            return element.toString();
        }
    }
}

